/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.controller;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmPeopleWorkPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmPeopleWorkQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmPeopleWorkService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmPeopleWorkVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/crm"})
public class CrmPeopleWorkController {
    private static final Logger log = LoggerFactory.getLogger(CrmPeopleWorkController.class);
    private final CrmPeopleWorkService service;

    @PostMapping(value={"/peopleWork"})
    public TwOutputUtil insertOrUpdate(CrmPeopleWorkPayload payload) {
        return TwOutputUtil.ok((Object)this.service.insertOrUpdate(payload));
    }

    @GetMapping(value={"/peopleWork/{key}"})
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        CrmPeopleWorkVO prdFileVO = this.service.queryByKey(key);
        return TwOutputUtil.ok((Object)prdFileVO);
    }

    @GetMapping(value={"/peopleWork/list"})
    public TwOutputUtil queryList(Long peopleId) {
        CrmPeopleWorkQuery query = new CrmPeopleWorkQuery();
        query.setPeopleId(peopleId);
        List vos = this.service.queryList(query);
        return TwOutputUtil.ok((Object)vos);
    }

    @DeleteMapping(value={"/peopleWork/deleteSoft"})
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.service.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    public CrmPeopleWorkController(CrmPeopleWorkService service) {
        this.service = service;
    }
}

