/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.QBaseModel;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmPotentialCustomerPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpenseaOptionQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmPotentialCustomerQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpenseaOptionVO;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOpenseaDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmPotentialCustomerDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmOpenseaDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmPotentialCustomerDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmPotentialCustomerRepo;
import com.elitesland.tw.tw5.server.prd.prj.entity.PrjProjectDO;
import com.elitesland.tw.tw5.server.prd.prj.entity.QPrjProjectDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class CrmPotentialCustomerDAO {
    private final CrmPotentialCustomerRepo repo;
    private final JPAQueryFactory jpaQueryFactory;
    private final QCrmPotentialCustomerDO qdo = QCrmPotentialCustomerDO.crmPotentialCustomerDO;
    private final EntityManager em;
    private final QCrmOpenseaDO qCrmOpenseaDO = QCrmOpenseaDO.crmOpenseaDO;
    private final QPrjProjectDO qPrjProjectDO = QPrjProjectDO.prjProjectDO;

    public CrmPotentialCustomerDO save(CrmPotentialCustomerDO ado) {
        return (CrmPotentialCustomerDO)((Object)this.repo.save((Object)ado));
    }

    public List<CrmPotentialCustomerDO> saveAll(List<CrmPotentialCustomerDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchInsert(List<CrmPotentialCustomerDO> dos) {
        for (CrmPotentialCustomerDO entity : dos) {
            this.em.persist((Object)entity);
        }
        this.em.flush();
        this.em.clear();
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchUpdate(List<CrmPotentialCustomerDO> dos) {
        for (CrmPotentialCustomerDO entity : dos) {
            this.em.merge((Object)entity);
        }
        this.em.flush();
        this.em.clear();
    }

    public Specification<CrmPotentialCustomerDO> getSpec(CrmPotentialCustomerQuery query) {
        Specification & Serializable querySpecifi = (Specification & Serializable)(root, criteriaQuery, cb) -> {
            CriteriaBuilder.In in;
            Path path;
            String[] split;
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            Join openseaJoin = root.join("opensea", JoinType.LEFT);
            if (!ObjectUtils.isEmpty((Object)query.getOpenseaId()) && query.getOpenseaId() != 0L) {
                predicates.add(cb.equal(openseaJoin.get("id").as(String.class), (Object)query.getOpenseaId()));
            }
            if (!StringUtils.isEmpty((CharSequence)query.getOpenseaIds())) {
                split = query.getOpenseaIds().split(",");
                path = openseaJoin.get("id");
                in = cb.in((javax.persistence.criteria.Expression)path);
                for (int i = 0; i < split.length; ++i) {
                    in.value((Object)Long.valueOf(split[i]));
                }
                predicates.add(cb.and(new Predicate[]{in}));
            }
            if (!StringUtils.isEmpty((CharSequence)query.getTagIds())) {
                split = query.getTagIds().split(",");
                Predicate[] predicatesArray = new Predicate[split.length];
                for (int i = 0; i < split.length; ++i) {
                    predicatesArray[i] = cb.like(root.get("tagIds").as(String.class), SqlUtil.toSqlLikeString((String)split[i]));
                }
                predicates.add(cb.or(predicatesArray));
            }
            if (!StringUtils.isEmpty((CharSequence)query.getCustomerName())) {
                predicates.add(cb.like(root.get("customerName").as(String.class), SqlUtil.toSqlLikeString((String)query.getCustomerName())));
            }
            if (!StringUtils.isEmpty((CharSequence)query.getCustomerNameEqual())) {
                predicates.add(cb.equal(root.get("customerName").as(String.class), (Object)query.getCustomerNameEqual()));
            }
            if (!StringUtils.isEmpty((CharSequence)query.getDemandProduct())) {
                predicates.add(cb.equal(root.get("demandProduct").as(String.class), (Object)query.getDemandProduct()));
            }
            if (!StringUtils.isEmpty((CharSequence)query.getCustomerContacts())) {
                predicates.add(cb.like(root.get("customerContacts").as(String.class), SqlUtil.toSqlLikeString((String)query.getCustomerContacts())));
            }
            if (!StringUtils.isEmpty((CharSequence)query.getCustomerGrade())) {
                predicates.add(cb.equal(root.get("customerGrade").as(String.class), (Object)query.getCustomerGrade()));
            }
            if (!StringUtils.isEmpty((CharSequence)query.getCustomerIndustry())) {
                predicates.add(cb.equal(root.get("customerIndustry").as(String.class), (Object)query.getCustomerIndustry()));
            }
            Join marketJoin = root.join("market", JoinType.LEFT);
            if (!ObjectUtils.isEmpty((Object)query.getMarketId())) {
                predicates.add(cb.equal(marketJoin.get("id").as(String.class), (Object)query.getMarketId()));
            }
            if (!StringUtils.isEmpty((CharSequence)query.getCustomerPhone())) {
                predicates.add(cb.like(root.get("customerPhone").as(String.class), SqlUtil.toSqlLikeString((String)query.getCustomerPhone())));
            }
            if (!StringUtils.isEmpty((CharSequence)query.getCustomerStatus())) {
                predicates.add(cb.equal(root.get("customerStatus").as(String.class), (Object)query.getCustomerStatus()));
            }
            if (!ObjectUtils.isEmpty((Object)query.getCreateTimeStart())) {
                predicates.add(cb.greaterThanOrEqualTo(root.get("createTime").as(LocalDateTime.class), (Comparable)query.getCreateTimeStart()));
            }
            if (!ObjectUtils.isEmpty((Object)query.getCreateTimeEnd())) {
                predicates.add(cb.lessThanOrEqualTo(root.get("createTime").as(LocalDateTime.class), (Comparable)query.getCreateTimeEnd()));
            }
            if (!StringUtils.isEmpty((CharSequence)query.getCustomerLocationCityName())) {
                predicates.add(cb.like(root.get("customerLocationCityName").as(String.class), SqlUtil.toSqlLikeString((String)query.getCustomerLocationCityName())));
            }
            if (!StringUtils.isEmpty((CharSequence)query.getArea())) {
                predicates.add(cb.like(root.get("customerLocationCityName").as(String.class), SqlUtil.toSqlLikeString((String)query.getArea())));
            }
            if (!StringUtils.isEmpty((CharSequence)query.getMarketChannel())) {
                predicates.add(cb.equal(root.get("marketChannel").as(String.class), (Object)query.getMarketChannel()));
            }
            if (!StringUtils.isEmpty((CharSequence)query.getCustomerEmail())) {
                predicates.add(cb.like(root.get("customerEmail").as(String.class), SqlUtil.toSqlLikeString((String)query.getCustomerEmail())));
            }
            if (!StringUtils.isEmpty((CharSequence)query.getCustRegion())) {
                predicates.add(cb.equal(root.get("custRegion").as(String.class), (Object)query.getCustRegion()));
            }
            if (!ObjectUtils.isEmpty((Object[])query.getPotentialCustomerIds())) {
                path = root.get("id");
                in = cb.in((javax.persistence.criteria.Expression)path);
                for (Long id : query.getPotentialCustomerIds()) {
                    in.value((Object)id);
                }
                predicates.add(cb.and(new Predicate[]{in}));
            }
            if (!ObjectUtils.isEmpty((Object)query.getPotentialCustomerIdsForFollow())) {
                path = root.get("id");
                in = cb.in((javax.persistence.criteria.Expression)path);
                for (Long id : query.getPotentialCustomerIdsForFollow()) {
                    in.value((Object)id);
                }
                predicates.add(cb.and(new Predicate[]{in}));
            }
            criteriaQuery.distinct(true);
            return cb.and(predicates.toArray(new Predicate[predicates.size()]));
        };
        return querySpecifi;
    }

    public List<CrmPotentialCustomerDO> findAll(Specification<CrmPotentialCustomerDO> spec) {
        return this.repo.findAll(spec);
    }

    public Page<CrmPotentialCustomerDO> findAll(Specification<CrmPotentialCustomerDO> spec, Pageable pageable) {
        pageable = PageUtil.defaultSort((Pageable)pageable);
        return this.repo.findAll(spec, pageable);
    }

    public long countAll(Specification<CrmPotentialCustomerDO> spec) {
        return this.repo.count(spec);
    }

    public CrmPotentialCustomerDO queryById(Long id) {
        return this.repo.findById(id).orElse(null);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateProvinceCityDistrict(CrmPotentialCustomerPayload payload) {
        this.jpaQueryFactory.update((EntityPath)this.qdo).set((com.querydsl.core.types.Path)this.qdo.customerLocationProvince, (Object)payload.getCustomerLocationProvince()).set((com.querydsl.core.types.Path)this.qdo.customerLocationProvinceName, (Object)payload.getCustomerLocationProvinceName()).set((com.querydsl.core.types.Path)this.qdo.customerLocationCity, (Object)payload.getCustomerLocationCity()).set((com.querydsl.core.types.Path)this.qdo.customerLocationCityName, (Object)payload.getCustomerLocationCityName()).set((com.querydsl.core.types.Path)this.qdo.customerLocationDistrict, (Object)payload.getCustomerLocationDistrict()).set((com.querydsl.core.types.Path)this.qdo.customerLocationDistrictName, (Object)payload.getCustomerLocationDistrictName()).where(new com.querydsl.core.types.Predicate[]{this.qdo.id.eq((Object)payload.getId())}).execute();
    }

    public void updateByKeyDynamic(CrmPotentialCustomerPayload payload) {
        CrmPotentialCustomerDO pCustomer = this.repo.findById(payload.getId()).orElse(null);
        if (pCustomer != null) {
            List nullFields;
            if (payload.getCustomerStatus() != null) {
                pCustomer.setCustomerStatus(payload.getCustomerStatus());
            }
            if (payload.getTransferReason() != null) {
                pCustomer.setTransferReason(payload.getTransferReason());
            }
            if (payload.getRemark() != null) {
                pCustomer.setRemark(payload.getRemark());
            }
            if (payload.getCustomerName() != null) {
                pCustomer.setCustomerName(payload.getCustomerName());
            }
            if (payload.getCustomerGrade() != null) {
                pCustomer.setCustomerGrade(payload.getCustomerGrade());
            }
            if (payload.getCustomerIndustry() != null) {
                pCustomer.setCustomerIndustry(payload.getCustomerIndustry());
            }
            if (payload.getCustomerContacts() != null) {
                pCustomer.setCustomerContacts(payload.getCustomerContacts());
            }
            if (payload.getCustomerPhone() != null) {
                pCustomer.setCustomerPhone(payload.getCustomerPhone());
            }
            if (payload.getCustomerEmail() != null) {
                pCustomer.setCustomerEmail(payload.getCustomerEmail());
            }
            if (payload.getCustomerLocationProvince() != null) {
                pCustomer.setCustomerLocationProvince(payload.getCustomerLocationProvince());
            }
            if (payload.getCustomerLocationCity() != null) {
                pCustomer.setCustomerLocationCity(payload.getCustomerLocationCity());
                pCustomer.setCustomerLocationProvinceName(null);
            }
            if (payload.getCustomerLocationDistrict() != null) {
                pCustomer.setCustomerLocationDistrict(payload.getCustomerLocationDistrict());
            }
            if (payload.getCustomerLocationDetail() != null) {
                pCustomer.setCustomerLocationDetail(payload.getCustomerLocationDetail());
            }
            if (payload.getCustomerLocationProvinceName() != null) {
                pCustomer.setCustomerLocationProvinceName(payload.getCustomerLocationProvinceName());
            }
            if (payload.getCustomerLocationCityName() != null) {
                pCustomer.setCustomerLocationCityName(payload.getCustomerLocationCityName());
            }
            if (payload.getCustomerLocationDistrictName() != null) {
                pCustomer.setCustomerLocationDistrictName(payload.getCustomerLocationDistrictName());
            }
            if (payload.getTagIds() != null) {
                pCustomer.setTagIds(payload.getTagIds());
            }
            if (payload.getDemandProduct() != null) {
                pCustomer.setDemandProduct(payload.getDemandProduct());
            }
            if (payload.getMarketId() != null) {
                PrjProjectDO market = new PrjProjectDO();
                market.setId(payload.getMarketId());
                pCustomer.setMarket(market);
            }
            if (payload.getOpenseaId() != null) {
                CrmOpenseaDO opensea = new CrmOpenseaDO();
                opensea.setId(payload.getOpenseaId());
                pCustomer.setOpensea(opensea);
            }
            if (payload.getCustRegion() != null) {
                pCustomer.setCustRegion(payload.getCustRegion());
            }
            if (payload.getMarketChannel() != null) {
                pCustomer.setMarketChannel(payload.getMarketChannel());
            }
            if (payload.getContactsDepartment() != null) {
                pCustomer.setContactsDepartment(payload.getContactsDepartment());
            }
            if (payload.getContactsPosition() != null) {
                pCustomer.setContactsPosition(payload.getContactsPosition());
            }
            if ((nullFields = payload.getNullFields()) == null || nullFields.size() > 0) {
                // empty if block
            }
            this.repo.save((Object)pCustomer);
        }
    }

    public List<CrmPotentialCustomerDO> queryByOpenseaId(Long openseaId) {
        return this.repo.findByOpensea_Id(openseaId);
    }

    public long deleteSoft(Long[] keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new com.querydsl.core.types.Predicate[]{this.qdo.id.in((Object[])keys)});
        return update.execute();
    }

    public void updateCustomerGrade(List<Long> potentialCustomerIds, String grade) {
        this.repo.updateCustomerGrade(potentialCustomerIds, grade);
    }

    public CrmPotentialCustomerDO findById(Long id) {
        return this.repo.findById(id).orElse(null);
    }

    public PagingVO<CrmOpenseaOptionVO> repeatPaging(CrmOpenseaOptionQuery query) {
        JPAQuery<CrmOpenseaOptionVO> jpaQuery = this.getJpaQueryRepeatPagingSelect();
        jpaQuery.where(this.checkRepeatWhere(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        if (!StringUtils.isEmpty((CharSequence)query.getOption())) {
            String[] optionArr = query.getOption().split(",");
            block14: for (int i = 0; i < optionArr.length; ++i) {
                switch (optionArr[i]) {
                    case "customerName": {
                        jpaQuery.where((com.querydsl.core.types.Predicate)this.qdo.customerName.isNotNull().and((com.querydsl.core.types.Predicate)this.qdo.customerName.ne((Object)"")));
                        jpaQuery.groupBy((Expression)this.qdo.customerName);
                        continue block14;
                    }
                    case "customerContacts": {
                        jpaQuery.where((com.querydsl.core.types.Predicate)this.qdo.customerContacts.isNotNull().and((com.querydsl.core.types.Predicate)this.qdo.customerContacts.ne((Object)"")));
                        jpaQuery.groupBy((Expression)this.qdo.customerContacts);
                        continue block14;
                    }
                    case "contactsPhone": {
                        jpaQuery.where((com.querydsl.core.types.Predicate)this.qdo.customerPhone.isNotNull().and((com.querydsl.core.types.Predicate)this.qdo.customerPhone.ne((Object)"")));
                        jpaQuery.groupBy((Expression)this.qdo.customerPhone);
                        continue block14;
                    }
                    case "demandProduct": {
                        jpaQuery.where((com.querydsl.core.types.Predicate)this.qdo.demandProduct.isNotNull().and((com.querydsl.core.types.Predicate)this.qdo.demandProduct.ne((Object)"")));
                        jpaQuery.groupBy((Expression)this.qdo.demandProduct);
                        continue block14;
                    }
                    case "projectName": {
                        jpaQuery.where((com.querydsl.core.types.Predicate)this.qdo.market.projectName.isNotNull().and((com.querydsl.core.types.Predicate)this.qdo.market.projectName.ne((Object)"")));
                        jpaQuery.groupBy((Expression)this.qdo.market.projectName);
                        continue block14;
                    }
                }
            }
        } else {
            jpaQuery.groupBy(this.qdo.id);
        }
        jpaQuery.having((com.querydsl.core.types.Predicate)this.qdo.count().gt((Number)1));
        List fetch = jpaQuery.fetch();
        if (fetch == null || fetch.size() == 0) {
            return PagingVO.empty();
        }
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total((long)fetch.size()).build();
    }

    public PagingVO<CrmOpenseaOptionVO> repeatDeatilPaging(CrmOpenseaOptionQuery query) {
        long total = this.repeatDetailPagingCount(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<CrmOpenseaOptionVO> jpaQuery = this.repeatDetailPagingJpaQuerySelect();
        jpaQuery.where(this.checkRepeatWhere(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    private JPAQuery<CrmOpenseaOptionVO> getJpaQueryRepeatPagingSelect() {
        return (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CrmOpenseaOptionVO.class, (Expression[])new Expression[]{this.qdo.count().as("count"), this.qdo.id, this.qdo.customerNo, this.qdo.customerStatus, this.qdo.customerLocationDetail, this.qdo.createTime, this.qdo.createUserId, this.qdo.creator, this.qdo.customerPhone.as("contactsPhone"), this.qdo.customerGrade, this.qdo.customerContacts, this.qdo.customerName, this.qdo.customerEmail, this.qdo.demandProduct, this.qPrjProjectDO.projectName, this.qCrmOpenseaDO.openseaName})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qCrmOpenseaDO)).on((com.querydsl.core.types.Predicate)this.qdo.opensea.id.eq(this.qCrmOpenseaDO.id))).leftJoin((EntityPath)this.qPrjProjectDO)).on((com.querydsl.core.types.Predicate)this.qdo.market.id.eq((Expression)this.qPrjProjectDO.id));
    }

    public com.querydsl.core.types.Predicate checkRepeatWhere(CrmOpenseaOptionQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getContactsPhone())) {
            list.add(this.qdo.customerPhone.eq((Object)query.getContactsPhone()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustomerContacts())) {
            list.add(this.qdo.customerContacts.eq((Object)query.getCustomerContacts()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustomerName())) {
            list.add(this.qdo.customerName.eq((Object)query.getCustomerName()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDemandProduct())) {
            list.add(this.qdo.demandProduct.eq((Object)query.getDemandProduct()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjectName())) {
            list.add(this.qdo.market.projectName.eq((Object)query.getProjectName()));
        }
        return ExpressionUtils.allOf(list);
    }

    private JPAQuery<CrmOpenseaOptionVO> repeatDetailPagingJpaQuerySelect() {
        return (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CrmOpenseaOptionVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.customerNo, this.qdo.customerStatus, this.qdo.customerLocationDetail, this.qdo.createTime, this.qdo.createUserId, this.qdo.creator, this.qdo.customerPhone.as("contactsPhone"), this.qdo.customerGrade, this.qdo.customerContacts, this.qdo.customerName, this.qdo.customerEmail, this.qdo.demandProduct, this.qPrjProjectDO.projectName, this.qCrmOpenseaDO.openseaName})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qCrmOpenseaDO)).on((com.querydsl.core.types.Predicate)this.qdo.opensea.id.eq(this.qCrmOpenseaDO.id))).leftJoin((EntityPath)this.qPrjProjectDO)).on((com.querydsl.core.types.Predicate)this.qdo.market.id.eq((Expression)this.qPrjProjectDO.id));
    }

    public long repeatDetailPagingCount(CrmOpenseaOptionQuery query) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qCrmOpenseaDO)).on((com.querydsl.core.types.Predicate)this.qdo.opensea.id.eq(this.qCrmOpenseaDO.id))).leftJoin((EntityPath)this.qPrjProjectDO)).on((com.querydsl.core.types.Predicate)this.qdo.market.id.eq((Expression)this.qPrjProjectDO.id));
        jpaQuery.where(this.checkRepeatWhere(query));
        SqlUtil.handleCommonJpaQuery((JPAQuery)jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    public CrmPotentialCustomerDAO(CrmPotentialCustomerRepo repo, JPAQueryFactory jpaQueryFactory, EntityManager em) {
        this.repo = repo;
        this.jpaQueryFactory = jpaQueryFactory;
        this.em = em;
    }
}

