/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.service;

import com.elitescloud.cloudt.common.base.BaseModel;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOperationPlanTempDetailPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOperationPlanTempDetailQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOperationPlanTempDetailService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOperationPlanTempDetailVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmOperationPlanTempDetailConvert;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOperationPlanTempDetailDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOperationPlanTempDetailRepo;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Root;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class CrmOperationPlanTempDetailServiceImpl
implements CrmOperationPlanTempDetailService {
    private static final Logger log = LoggerFactory.getLogger(CrmOperationPlanTempDetailServiceImpl.class);
    private final CrmOperationPlanTempDetailRepo repo;
    private final PrdSystemLogService logService;

    @Transactional(rollbackFor={Exception.class})
    public CrmOperationPlanTempDetailVO insert(CrmOperationPlanTempDetailPayload payload) {
        this.setDefaultValue(payload);
        CrmOperationPlanTempDetailDO entityDo = CrmOperationPlanTempDetailConvert.INSTANCE.toDo(payload);
        this.repo.save((Object)entityDo);
        return CrmOperationPlanTempDetailConvert.INSTANCE.toVo(entityDo);
    }

    private void setDefaultValue(CrmOperationPlanTempDetailPayload payload) {
        if (!StringUtils.hasText((String)payload.getPriority())) {
            payload.setPriority("10");
        }
        if (!StringUtils.hasText((String)payload.getStatus())) {
            payload.setStatus("PLAN");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public CrmOperationPlanTempDetailVO update(CrmOperationPlanTempDetailPayload payload) {
        CrmOperationPlanTempDetailDO entity = this.repo.findById(payload.getId()).orElseGet(CrmOperationPlanTempDetailDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        CrmOperationPlanTempDetailDO entityDo = CrmOperationPlanTempDetailConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return CrmOperationPlanTempDetailConvert.INSTANCE.toVo((CrmOperationPlanTempDetailDO)((Object)this.repo.save((Object)entity)));
    }

    public CrmOperationPlanTempDetailVO queryByKey(Long key) {
        CrmOperationPlanTempDetailDO entity = this.repo.findById(key).orElseGet(CrmOperationPlanTempDetailDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        CrmOperationPlanTempDetailVO crmCustomerOperationVO = CrmOperationPlanTempDetailConvert.INSTANCE.toVo(entity);
        return crmCustomerOperationVO;
    }

    public List<CrmOperationPlanTempDetailVO> queryList(CrmOperationPlanTempDetailQuery query) {
        OrderItem orderItem = OrderItem.desc((String)"createTime");
        query.defaultOrder(orderItem);
        return CrmOperationPlanTempDetailConvert.INSTANCE.toVoList(this.repo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate((Root)root, (Object)query, (CriteriaBuilder)criteriaBuilder)));
    }

    public PagingVO<CrmOperationPlanTempDetailVO> paging(CrmOperationPlanTempDetailQuery query) {
        OrderItem orderItem = OrderItem.desc((String)"createTime");
        query.defaultOrder(orderItem);
        Page page = this.repo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate((Root)root, (Object)query, (CriteriaBuilder)criteriaBuilder), (Pageable)query.getPageRequest());
        return PageUtil.toPageVo((Page)page.map(CrmOperationPlanTempDetailConvert.INSTANCE::toVo));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.repo.findById(id);
                if (!optional.isEmpty()) {
                    CrmOperationPlanTempDetailDO entity = (CrmOperationPlanTempDetailDO)((Object)((Object)optional.get()));
                    entity.setDeleteFlag(1);
                    this.repo.save((Object)entity);
                }
            });
        }
    }

    public void deleteSoftByTempId(Long tempId) {
        CrmOperationPlanTempDetailQuery query = new CrmOperationPlanTempDetailQuery();
        query.setTempId(tempId);
        List planTempDetailDOList = this.repo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate((Root)root, (Object)query, (CriteriaBuilder)criteriaBuilder));
        List<Long> keys = planTempDetailDOList.stream().map(BaseModel::getId).collect(Collectors.toList());
        this.deleteSoft(keys);
    }

    public void saveAll(List<CrmOperationPlanTempDetailPayload> detailList) {
        detailList.forEach(crmOperationPlanTempDetailPayload -> this.insert((CrmOperationPlanTempDetailPayload)crmOperationPlanTempDetailPayload));
    }

    public CrmOperationPlanTempDetailServiceImpl(CrmOperationPlanTempDetailRepo repo, PrdSystemLogService logService) {
        this.repo = repo;
        this.logService = logService;
    }
}

