/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.service;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityAnalyzePayload;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityAnalyzeService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityAnalyzeVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.service.TransferUtilServiceImpl;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemLogEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmOpportunityAnalyzeConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunityAnalyzeDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunityDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOpportunityAnalyzeDO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CrmOpportunityAnalyzeServiceImpl
implements CrmOpportunityAnalyzeService {
    private static final Logger log = LoggerFactory.getLogger(CrmOpportunityAnalyzeServiceImpl.class);
    private final CacheUtil cacheUtil;
    private final CrmOpportunityAnalyzeDAO dao;
    private final PrdSystemLogService logService;
    private final TransferUtilServiceImpl transferUtilService;
    private final HttpUtil httpUtil;
    private final CrmOpportunityDAO opportunityDAO;
    private final PrdOrgEmployeeDAO employeeDAO;
    @Value(value="${tw4.opportunity.analyze_operation}")
    private String analyze_operation;
    @Value(value="${tw4.opportunity.analyze_del}")
    private String analyze_del;

    @Transactional
    public CrmOpportunityAnalyzeVO insert(CrmOpportunityAnalyzePayload payload) {
        if (payload.getOppoIdV4() != null) {
            payload.setOppoId(this.opportunityDAO.getIdByV4(payload.getOppoIdV4()));
        }
        if (payload.getAnalyzeIdV4() != null) {
            payload.setId(this.dao.getIdByV4(payload.getAnalyzeIdV4()));
        }
        if (payload.getManageUserIdV4() != null) {
            payload.setManageUserId(this.employeeDAO.getUserIdByV4(payload.getManageUserIdV4()));
        }
        CrmOpportunityAnalyzeDO ado = CrmOpportunityAnalyzeConvert.INSTANCE.toDo(payload);
        this.dao.save(ado);
        this.logService.saveNewLog(payload.getOppoId(), PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.ADD.getDesc() + "\u6848\u60c5\u5206\u6790");
        return CrmOpportunityAnalyzeConvert.INSTANCE.toVo(ado);
    }

    @Transactional
    public Long update(CrmOpportunityAnalyzePayload payload) {
        if (payload.getOppoIdV4() != null) {
            payload.setOppoId(this.opportunityDAO.getIdByV4(payload.getOppoIdV4()));
        }
        if (payload.getAnalyzeIdV4() != null) {
            payload.setId(this.dao.getIdByV4(payload.getAnalyzeIdV4()));
        }
        if (payload.getManageUserIdV4() != null) {
            payload.setManageUserId(this.employeeDAO.getUserIdByV4(payload.getManageUserIdV4()));
        }
        CrmOpportunityAnalyzeDO ado = CrmOpportunityAnalyzeConvert.INSTANCE.toDo(payload);
        this.dao.save(ado);
        this.logService.saveNewLog(payload.getOppoId(), PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.UPDATE.getDesc() + "\u6848\u60c5\u5206\u6790");
        return 0L;
    }

    public List<CrmOpportunityAnalyzeVO> queryList(Long oppoId) {
        return this.dao.queryList(oppoId);
    }

    @Transactional
    public boolean deleteSoft(Long oppoId, List<Long> keys) {
        this.dao.deleteSoft(keys);
        this.logService.saveNewLog(oppoId, PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.DELETE.getDesc() + "\u6848\u60c5\u5206\u6790");
        return true;
    }

    public CrmOpportunityAnalyzeServiceImpl(CacheUtil cacheUtil, CrmOpportunityAnalyzeDAO dao, PrdSystemLogService logService, TransferUtilServiceImpl transferUtilService, HttpUtil httpUtil, CrmOpportunityDAO opportunityDAO, PrdOrgEmployeeDAO employeeDAO) {
        this.cacheUtil = cacheUtil;
        this.dao = dao;
        this.logService = logService;
        this.transferUtilService = transferUtilService;
        this.httpUtil = httpUtil;
        this.opportunityDAO = opportunityDAO;
        this.employeeDAO = employeeDAO;
    }
}

