/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.service;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunitySalesPayload;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunitySalesService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunitySalesVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.service.TransferUtilServiceImpl;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemLogEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmOpportunitySalesConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunityDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunitySalesDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOpportunitySalesDO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CrmOpportunitySalesServiceImpl
implements CrmOpportunitySalesService {
    private static final Logger log = LoggerFactory.getLogger(CrmOpportunitySalesServiceImpl.class);
    private final CacheUtil cacheUtil;
    private final CrmOpportunitySalesDAO dao;
    private final CrmOpportunityDAO opportunityDAO;
    private final PrdSystemLogService logService;
    private final TransferUtilServiceImpl transferUtilService;
    private final HttpUtil httpUtil;
    @Value(value="${tw4.opportunity.sales_operation}")
    private String sales_operation;
    @Value(value="${tw4.opportunity.sales_del}")
    private String sales_del;

    @Transactional
    public CrmOpportunitySalesVO insert(CrmOpportunitySalesPayload payload) {
        if (payload.getOppoIdV4() != null) {
            payload.setOppoId(this.opportunityDAO.getIdByV4(payload.getOppoIdV4()));
        }
        if (payload.getSalesIdV4() != null) {
            payload.setId(this.dao.getIdByV4(payload.getSalesIdV4()));
        }
        CrmOpportunitySalesDO ado = CrmOpportunitySalesConvert.INSTANCE.toDo(payload);
        this.dao.save(ado);
        this.logService.saveNewLog(payload.getOppoId(), PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.ADD.getDesc() + "\u9500\u552e\u6e05\u5355");
        return CrmOpportunitySalesConvert.INSTANCE.toVo(ado);
    }

    @Transactional
    public Long update(CrmOpportunitySalesPayload payload) {
        if (payload.getOppoIdV4() != null) {
            payload.setOppoId(this.opportunityDAO.getIdByV4(payload.getOppoIdV4()));
        }
        if (payload.getSalesIdV4() != null) {
            payload.setId(this.dao.getIdByV4(payload.getSalesIdV4()));
        }
        CrmOpportunitySalesDO ado = CrmOpportunitySalesConvert.INSTANCE.toDo(payload);
        this.dao.save(ado);
        this.logService.saveNewLog(payload.getOppoId(), PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.UPDATE.getDesc() + "\u9500\u552e\u6e05\u5355");
        return 0L;
    }

    public List<CrmOpportunitySalesVO> queryList(Long oppoId) {
        return this.dao.queryList(oppoId);
    }

    @Transactional
    public boolean deleteSoft(Long oppoId, List<Long> keys) {
        this.dao.deleteSoft(keys);
        this.logService.saveNewLog(oppoId, PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.DELETE.getDesc() + "\u9500\u552e\u6e05\u5355");
        return true;
    }

    public CrmOpportunitySalesServiceImpl(CacheUtil cacheUtil, CrmOpportunitySalesDAO dao, CrmOpportunityDAO opportunityDAO, PrdSystemLogService logService, TransferUtilServiceImpl transferUtilService, HttpUtil httpUtil) {
        this.cacheUtil = cacheUtil;
        this.dao = dao;
        this.opportunityDAO = opportunityDAO;
        this.logService = logService;
        this.transferUtilService = transferUtilService;
        this.httpUtil = httpUtil;
    }
}

