/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.act.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmActDynamicDO;
import com.elitesland.tw.tw5crm.api.act.payload.CrmActDynamicPayload;
import com.elitesland.tw.tw5crm.api.act.query.CrmActDynamicQuery;
import com.elitesland.tw.tw5crm.api.act.service.CrmActDynamicService;
import com.elitesland.tw.tw5crm.api.act.vo.CrmActDynamicVO;
import com.elitesland.tw.tw5crm.server.act.convert.CrmActDynamicConvert;
import com.elitesland.tw.tw5crm.server.act.dao.CrmActDynamicDAO;
import com.elitesland.tw.tw5crm.server.act.repo.CrmActDynamicRepo;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class CrmActDynamicServiceImpl
extends BaseServiceImpl
implements CrmActDynamicService {
    private static final Logger log = LoggerFactory.getLogger(CrmActDynamicServiceImpl.class);
    private final CrmActDynamicRepo crmActDynamicRepo;
    private final CrmActDynamicDAO crmActDynamicDAO;

    public PagingVO<CrmActDynamicVO> queryPaging(CrmActDynamicQuery query) {
        return this.crmActDynamicDAO.queryPaging(query);
    }

    public List<CrmActDynamicVO> queryListDynamic(CrmActDynamicQuery query) {
        return this.crmActDynamicDAO.queryListDynamic(query);
    }

    public CrmActDynamicVO queryByKey(Long key) {
        CrmActDynamicDO entity = this.crmActDynamicRepo.findById(key).orElseGet(CrmActDynamicDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        CrmActDynamicVO vo = CrmActDynamicConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public CrmActDynamicVO insert(CrmActDynamicPayload payload) {
        CrmActDynamicDO entityDo = CrmActDynamicConvert.INSTANCE.toDo(payload);
        return CrmActDynamicConvert.INSTANCE.toVo((CrmActDynamicDO)((Object)this.crmActDynamicRepo.save((Object)entityDo)));
    }

    @Transactional(rollbackFor={Exception.class})
    public CrmActDynamicVO update(CrmActDynamicPayload payload) {
        CrmActDynamicDO entity = this.crmActDynamicRepo.findById(payload.getId()).orElseGet(CrmActDynamicDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        CrmActDynamicDO entityDo = CrmActDynamicConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return CrmActDynamicConvert.INSTANCE.toVo((CrmActDynamicDO)((Object)this.crmActDynamicRepo.save((Object)entity)));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(CrmActDynamicPayload payload) {
        CrmActDynamicDO entity = this.crmActDynamicRepo.findById(payload.getId()).orElseGet(CrmActDynamicDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.crmActDynamicDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.crmActDynamicRepo.findById(id);
                if (!optional.isEmpty()) {
                    CrmActDynamicDO entity = (CrmActDynamicDO)((Object)((Object)optional.get()));
                    entity.setDeleteFlag(1);
                    this.crmActDynamicRepo.save((Object)entity);
                }
            });
        }
    }

    public CrmActDynamicServiceImpl(CrmActDynamicRepo crmActDynamicRepo, CrmActDynamicDAO crmActDynamicDAO) {
        this.crmActDynamicRepo = crmActDynamicRepo;
        this.crmActDynamicDAO = crmActDynamicDAO;
    }
}

