/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.act.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmActReportDO;
import com.elitesland.tw.tw5crm.api.act.payload.CrmActReportPayload;
import com.elitesland.tw.tw5crm.api.act.query.CrmActReportQuery;
import com.elitesland.tw.tw5crm.api.act.service.CrmActReportService;
import com.elitesland.tw.tw5crm.api.act.vo.CrmActReportVO;
import com.elitesland.tw.tw5crm.server.act.convert.CrmActReportConvert;
import com.elitesland.tw.tw5crm.server.act.dao.CrmActReportDAO;
import com.elitesland.tw.tw5crm.server.act.repo.CrmActReportRepo;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class CrmActReportServiceImpl
extends BaseServiceImpl
implements CrmActReportService {
    private static final Logger log = LoggerFactory.getLogger(CrmActReportServiceImpl.class);
    private final CrmActReportRepo crmActReportRepo;
    private final CrmActReportDAO crmActReportDAO;

    public PagingVO<CrmActReportVO> queryPaging(CrmActReportQuery query) {
        return this.crmActReportDAO.queryPaging(query);
    }

    public List<CrmActReportVO> queryListDynamic(CrmActReportQuery query) {
        return this.crmActReportDAO.queryListDynamic(query);
    }

    public CrmActReportVO queryByKey(Long key) {
        CrmActReportDO entity = this.crmActReportRepo.findById(key).orElseGet(CrmActReportDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        CrmActReportVO vo = CrmActReportConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public CrmActReportVO insert(CrmActReportPayload payload) {
        CrmActReportDO entityDo = CrmActReportConvert.INSTANCE.toDo(payload);
        return CrmActReportConvert.INSTANCE.toVo((CrmActReportDO)((Object)this.crmActReportRepo.save((Object)entityDo)));
    }

    @Transactional(rollbackFor={Exception.class})
    public CrmActReportVO update(CrmActReportPayload payload) {
        CrmActReportDO entity = this.crmActReportRepo.findById(payload.getId()).orElseGet(CrmActReportDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        CrmActReportDO entityDo = CrmActReportConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return CrmActReportConvert.INSTANCE.toVo((CrmActReportDO)((Object)this.crmActReportRepo.save((Object)entity)));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(CrmActReportPayload payload) {
        CrmActReportDO entity = this.crmActReportRepo.findById(payload.getId()).orElseGet(CrmActReportDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.crmActReportDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.crmActReportRepo.findById(id);
                if (!optional.isEmpty()) {
                    CrmActReportDO entity = (CrmActReportDO)((Object)((Object)optional.get()));
                    entity.setDeleteFlag(1);
                    this.crmActReportRepo.save((Object)entity);
                }
            });
        }
    }

    public CrmActReportServiceImpl(CrmActReportRepo crmActReportRepo, CrmActReportDAO crmActReportDAO) {
        this.crmActReportRepo = crmActReportRepo;
        this.crmActReportDAO = crmActReportDAO;
    }
}

