/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.bid.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5crm.api.bid.payload.BidReviewRecordsPayload;
import com.elitesland.tw.tw5crm.api.bid.query.BidReviewRecordsQuery;
import com.elitesland.tw.tw5crm.api.bid.service.BidReviewRecordsService;
import com.elitesland.tw.tw5crm.api.bid.service.BidService;
import com.elitesland.tw.tw5crm.api.bid.vo.BidReviewRecordsVO;
import com.elitesland.tw.tw5crm.api.bid.vo.BidVO;
import com.elitesland.tw.tw5crm.server.bid.convert.BidReviewRecordsConvert;
import com.elitesland.tw.tw5crm.server.bid.dao.BidReviewRecordsDAO;
import com.elitesland.tw.tw5crm.server.bid.entity.BidReviewRecordsDO;
import com.elitesland.tw.tw5crm.server.bid.repo.BidReviewRecordsRepo;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BidReviewRecordsServiceImpl
extends BaseServiceImpl
implements BidReviewRecordsService {
    private static final Logger log = LoggerFactory.getLogger(BidReviewRecordsServiceImpl.class);
    private final BidReviewRecordsRepo bidReviewRecordsRepo;
    private final BidReviewRecordsDAO bidReviewRecordsDAO;
    private final PrdSystemLogService logService;
    private final FileUtil fileUtil;
    @Autowired
    private BidService bidService;

    public PagingVO<BidReviewRecordsVO> queryPaging(BidReviewRecordsQuery query) {
        return this.bidReviewRecordsDAO.queryPaging(query);
    }

    public List<BidReviewRecordsVO> queryListDynamic(BidReviewRecordsQuery query) {
        return this.bidReviewRecordsDAO.queryListDynamic(query);
    }

    public BidReviewRecordsVO queryByKey(Long key) {
        BidReviewRecordsDO entity = this.bidReviewRecordsRepo.findById(key).orElseGet(BidReviewRecordsDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BidReviewRecordsVO vo = BidReviewRecordsConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public BidReviewRecordsVO insert(BidReviewRecordsPayload payload) {
        BidReviewRecordsDO entityDo = BidReviewRecordsConvert.INSTANCE.toDo(payload);
        BidVO bidVO = this.bidService.queryByKey(payload.getBidId());
        List<BidReviewRecordsDO> byBidId = this.bidReviewRecordsRepo.findByBidId(payload.getBidId());
        String version = bidVO.getBidProjectCode() + "-" + (byBidId.size() + 1);
        entityDo.setVersion(version);
        String changeLog = "\u521b\u5efa\u4e00\u6761\u8bc4\u5ba1\u8bb0\u5f55";
        this.logService.saveNewLog(payload.getBidId(), PrdSystemObjectEnum.BID_PROJECT.getCode(), changeLog);
        BidReviewRecordsVO bidReviewRecordsVO = BidReviewRecordsConvert.INSTANCE.toVo((BidReviewRecordsDO)this.bidReviewRecordsRepo.save(entityDo));
        bidReviewRecordsVO.setBidFileData(this.fileUtil.getFileDatas(bidReviewRecordsVO.getBidFile()));
        return bidReviewRecordsVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public BidReviewRecordsVO update(BidReviewRecordsPayload payload) {
        BidReviewRecordsDO entity = this.bidReviewRecordsRepo.findById(payload.getId()).orElseGet(BidReviewRecordsDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BidReviewRecordsDO entityDo = BidReviewRecordsConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        String changeLog = "\u4fee\u6539\u4e00\u6761\u8bc4\u5ba1\u8bb0\u5f55";
        this.logService.saveNewLog(payload.getBidId(), PrdSystemObjectEnum.BID_PROJECT.getCode(), changeLog);
        return BidReviewRecordsConvert.INSTANCE.toVo((BidReviewRecordsDO)this.bidReviewRecordsRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.bidReviewRecordsRepo.findById(id);
                if (!optional.isEmpty()) {
                    BidReviewRecordsDO entity = (BidReviewRecordsDO)optional.get();
                    entity.setDeleteFlag(1);
                    this.bidReviewRecordsRepo.save(entity);
                    String changeLog = "\u5220\u9664\u4e00\u6761\u8bc4\u5ba1\u8bb0\u5f55";
                    this.logService.saveNewLog(entity.getBidId(), PrdSystemObjectEnum.BID_PROJECT.getCode(), changeLog);
                }
            });
        }
    }

    public List<BidReviewRecordsVO> queryReviewRecordsByBidKey(Long bidKey) {
        List<BidReviewRecordsVO> reviewRecordsVOS = this.bidReviewRecordsDAO.queryReviewRecordsByBidKey(bidKey);
        reviewRecordsVOS.forEach(e -> e.setBidFileData(this.fileUtil.getFileDatas(e.getBidFile())));
        return reviewRecordsVOS;
    }

    public BidReviewRecordsServiceImpl(BidReviewRecordsRepo bidReviewRecordsRepo, BidReviewRecordsDAO bidReviewRecordsDAO, PrdSystemLogService logService, FileUtil fileUtil) {
        this.bidReviewRecordsRepo = bidReviewRecordsRepo;
        this.bidReviewRecordsDAO = bidReviewRecordsDAO;
        this.logService = logService;
        this.fileUtil = fileUtil;
    }
}

