/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.bid.service;

import com.el.coordinator.boot.fsm.model.vo.FileObjRespVO;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.partner.team.payload.BusinessTeamMemberPayload;
import com.elitesland.tw.tw5.api.partner.team.service.BusinessTeamMemberService;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.constants.BusinessTeamRoleEnum;
import com.elitesland.tw.tw5.server.common.constants.BusinessTeamTypeEnum;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.partner.team.entity.BusinessTeamMemberDO;
import com.elitesland.tw.tw5.server.partner.team.repo.BusinessTeamMemberRepo;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5crm.api.bid.payload.BidPayload;
import com.elitesland.tw.tw5crm.api.bid.query.BidQuery;
import com.elitesland.tw.tw5crm.api.bid.service.BidCostRecordsService;
import com.elitesland.tw.tw5crm.api.bid.service.BidOpeningDetailsService;
import com.elitesland.tw.tw5crm.api.bid.service.BidReviewRecordsService;
import com.elitesland.tw.tw5crm.api.bid.service.BidService;
import com.elitesland.tw.tw5crm.api.bid.vo.BidOppoVO;
import com.elitesland.tw.tw5crm.api.bid.vo.BidVO;
import com.elitesland.tw.tw5crm.server.bid.convert.BidConvert;
import com.elitesland.tw.tw5crm.server.bid.dao.BidDAO;
import com.elitesland.tw.tw5crm.server.bid.entity.BidDO;
import com.elitesland.tw.tw5crm.server.bid.repo.BidRepo;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class BidServiceImpl
extends BaseServiceImpl
implements BidService {
    private static final Logger log = LoggerFactory.getLogger(BidServiceImpl.class);
    private final BidRepo bidRepo;
    private final BidDAO bidDAO;
    @Autowired
    private BidReviewRecordsService reviewRecordsService;
    private final BidOpeningDetailsService openingDetailsService;
    private final BidCostRecordsService costRecordsService;
    private final CacheUtil cacheUtil;
    private final BusinessTeamMemberService businessTeamMemberService;
    private final BusinessTeamMemberRepo teamMemberRepo;
    private final PrdSystemLogService logService;
    private final ChangeFieldLogUtil changeFieldLogUtil;
    private final FileUtil fileUtil;
    private final CrmOpportunityService crmOpportunityService;

    public PagingVO<BidVO> queryPaging(BidQuery query) {
        PagingVO<BidVO> bidVOPagingVO = this.bidDAO.queryPaging(query);
        List records = bidVOPagingVO.getRecords();
        ArrayList<Long> bidIds = new ArrayList<Long>();
        for (BidVO vo : records) {
            vo.setInviteBidFileData(this.fileUtil.getFileDatas(vo.getInviteBidFile()));
            vo.setBidWiningNotificationFileData(this.fileUtil.getFileDatas(vo.getBidWiningNotificationFile()));
            bidIds.add(vo.getId());
        }
        List<BusinessTeamMemberDO> teamMemberDOS = this.teamMemberRepo.findByDeleteFlagAndMemberRoleAndObjectIdIn(0, BusinessTeamRoleEnum.SALE_MANAGER.getCode(), bidIds);
        for (BidVO vo : records) {
            StringBuilder saleDutyIdDesc = new StringBuilder("");
            for (BusinessTeamMemberDO teamMemberDO : teamMemberDOS) {
                if (!teamMemberDO.getObjectId().equals(vo.getId())) continue;
                saleDutyIdDesc.append(this.cacheUtil.getUserName(teamMemberDO.getUserId())).append(" ");
            }
            vo.setSaleDutyIdDesc(String.valueOf(saleDutyIdDesc));
        }
        return bidVOPagingVO;
    }

    public List<BidVO> queryListDynamic(BidQuery query) {
        return this.bidDAO.queryListDynamic(query);
    }

    public BidVO queryByKey(Long key) {
        BidVO vo = this.bidDAO.queryByKey(key);
        Assert.notNull((Object)vo, (String)"\u4e0d\u5b58\u5728");
        vo.setInviteBidFileData(this.fileUtil.getFileDatas(vo.getInviteBidFile()));
        vo.setBidWiningNotificationFileData(this.fileUtil.getFileDatas(vo.getBidWiningNotificationFile()));
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public BidVO insert(BidPayload payload) {
        Long orgId;
        String code = this.generateSeqNum("CRM_BID_PROJECT", new String[0]);
        payload.setBidProjectCode(code);
        payload.setBidStatus("CREATE");
        payload.setBidSchedule("PRE");
        BusinessTeamMemberPayload teamMemberPayload = new BusinessTeamMemberPayload();
        teamMemberPayload.setObjectId(payload.getId());
        teamMemberPayload.setType(BusinessTeamTypeEnum.BID.getCode());
        SysUserDTO loginUser = GlobalUtil.getLoginUser();
        BidDO entityDo = BidConvert.INSTANCE.toDo(payload);
        BidVO bidVO = BidConvert.INSTANCE.toVo((BidDO)this.bidRepo.save(entityDo));
        if (loginUser.getId() != null) {
            orgId = this.cacheUtil.getDefaultOrgIdByUserId(loginUser.getId());
            teamMemberPayload.setUserId(loginUser.getId());
            teamMemberPayload.setMemberRole(BusinessTeamRoleEnum.BASE.getCode());
            teamMemberPayload.setMemberRoleName(BusinessTeamRoleEnum.BASE.getDesc());
            teamMemberPayload.setIsCreator(Boolean.valueOf(true));
            teamMemberPayload.setSortNo(Integer.valueOf(1));
            teamMemberPayload.setOrgId(orgId);
            teamMemberPayload.setObjectId(bidVO.getId());
            this.businessTeamMemberService.save(teamMemberPayload);
        }
        if (payload.getSaleDutyId() != null) {
            orgId = this.cacheUtil.getDefaultOrgIdByUserId(payload.getSaleDutyId());
            teamMemberPayload.setUserId(payload.getSaleDutyId());
            teamMemberPayload.setMemberRole(BusinessTeamRoleEnum.SALE_MANAGER.getCode());
            teamMemberPayload.setMemberRoleName(BusinessTeamRoleEnum.SALE_MANAGER.getDesc());
            teamMemberPayload.setIsCreator(Boolean.valueOf(false));
            teamMemberPayload.setSortNo(Integer.valueOf(2));
            teamMemberPayload.setOrgId(orgId);
            teamMemberPayload.setObjectId(bidVO.getId());
            this.businessTeamMemberService.save(teamMemberPayload);
        }
        if (payload.getPresaleDutyId() != null) {
            orgId = this.cacheUtil.getDefaultOrgIdByUserId(payload.getPresaleDutyId());
            teamMemberPayload.setUserId(payload.getPresaleDutyId());
            teamMemberPayload.setMemberRole(BusinessTeamRoleEnum.PRESALE_MANAGER.getCode());
            teamMemberPayload.setMemberRoleName(BusinessTeamRoleEnum.PRESALE_MANAGER.getDesc());
            teamMemberPayload.setIsCreator(Boolean.valueOf(false));
            teamMemberPayload.setSortNo(Integer.valueOf(3));
            teamMemberPayload.setOrgId(orgId);
            teamMemberPayload.setObjectId(bidVO.getId());
            this.businessTeamMemberService.save(teamMemberPayload);
        }
        if (payload.getPayDutyId() != null) {
            orgId = this.cacheUtil.getDefaultOrgIdByUserId(payload.getPayDutyId());
            teamMemberPayload.setUserId(payload.getPayDutyId());
            teamMemberPayload.setMemberRole(BusinessTeamRoleEnum.PAY_MANAGER.getCode());
            teamMemberPayload.setMemberRoleName(BusinessTeamRoleEnum.PAY_MANAGER.getDesc());
            teamMemberPayload.setIsCreator(Boolean.valueOf(false));
            teamMemberPayload.setSortNo(Integer.valueOf(4));
            teamMemberPayload.setOrgId(orgId);
            teamMemberPayload.setObjectId(bidVO.getId());
            this.businessTeamMemberService.save(teamMemberPayload);
        }
        String changeLog = "\u521b\u5efa\u4e86 " + bidVO.getBidProjectName();
        this.logService.saveNewLog(bidVO.getId(), PrdSystemObjectEnum.BID_PROJECT.getCode(), changeLog);
        return bidVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public BidVO update(BidPayload payload) {
        List nullFields;
        StringBuilder fileChangeLog;
        List newFileDataList;
        List oldFileDataList;
        BidDO entity = this.bidRepo.findById(payload.getId()).orElseGet(BidDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BidDO entityLog = new BidDO();
        BeanUtils.copyProperties((Object)entity, (Object)entityLog);
        BidDO entityDO = BidConvert.INSTANCE.toDo(payload);
        entity.copy(entityDO);
        StringBuilder fieldsUpdateLog = this.changeFieldLogUtil.nullFieldsProcess((TwCommonPayload)payload, entityLog, entity);
        fieldsUpdateLog.append(this.changeFieldLogUtil.getFieldsUpdateLog(entityDO, entityLog));
        if (StringUtils.hasText((CharSequence)fieldsUpdateLog)) {
            this.logService.saveNewLog(entityDO.getId(), PrdSystemObjectEnum.BID_PROJECT.getCode(), fieldsUpdateLog.toString());
        }
        if (payload.getOpportunityId() != null) {
            CrmOpportunityVO oldOppo = this.crmOpportunityService.queryByKeySimple(entityLog.getOpportunityId());
            CrmOpportunityVO newOppo = this.crmOpportunityService.queryByKeySimple(entityDO.getOpportunityId());
            if (payload.getNullFields() != null && payload.getNullFields().contains("opportunityId")) {
                changeLog = new StringBuilder("\u5546\u673a \u7531 " + oldOppo.getProjectName() + " \u4fee\u6539\u4e3a \u7a7a");
                this.logService.saveNewLog(entityDO.getId(), PrdSystemObjectEnum.BID_PROJECT.getCode(), changeLog.toString());
            } else if (!Objects.equals(oldOppo.getProjectName(), newOppo.getProjectName())) {
                changeLog = new StringBuilder("\u5546\u673a \u7531 " + oldOppo.getProjectName() + " \u4fee\u6539\u4e3a " + newOppo.getProjectName());
                this.logService.saveNewLog(entityDO.getId(), PrdSystemObjectEnum.BID_PROJECT.getCode(), changeLog.toString());
            }
        }
        if (!Objects.equals(entityDO.getInviteBidFile(), entityLog.getInviteBidFile())) {
            oldFileDataList = (List)this.fileUtil.getFileDatas(entityLog.getInviteBidFile());
            newFileDataList = (List)this.fileUtil.getFileDatas(entityDO.getInviteBidFile());
            if (newFileDataList != null) {
                if (oldFileDataList != null) {
                    newFileDataList.removeAll(oldFileDataList);
                }
                if (newFileDataList.size() > 0) {
                    fileChangeLog = new StringBuilder("\u65b0\u589e \u62db\u6807\u6587\u4ef6 ");
                    for (FileObjRespVO fileObjRespVO : newFileDataList) {
                        fileChangeLog.append(fileObjRespVO.getOriginalName()).append(" ");
                    }
                    this.logService.saveNewLog(entityDO.getId(), PrdSystemObjectEnum.BID_PROJECT.getCode(), fileChangeLog.toString());
                }
            }
        }
        if (!Objects.equals(entityDO.getBidWiningNotificationFile(), entityLog.getBidWiningNotificationFile())) {
            oldFileDataList = (List)this.fileUtil.getFileDatas(entityLog.getBidWiningNotificationFile());
            newFileDataList = (List)this.fileUtil.getFileDatas(entityDO.getBidWiningNotificationFile());
            if (newFileDataList != null) {
                if (oldFileDataList != null) {
                    newFileDataList.removeAll(oldFileDataList);
                }
                if (newFileDataList.size() > 0) {
                    fileChangeLog = new StringBuilder("\u65b0\u589e \u4e2d\u6807\u901a\u77e5\u4e66\u53ca\u9644\u4ef6 ");
                    for (FileObjRespVO fileObjRespVO : newFileDataList) {
                        fileChangeLog.append(fileObjRespVO.getOriginalName()).append(" ");
                    }
                    this.logService.saveNewLog(entityDO.getId(), PrdSystemObjectEnum.BID_PROJECT.getCode(), fileChangeLog.toString());
                }
            }
        }
        if (entityDO.getRemark() != null && !Objects.equals(entityLog.getRemark(), entityDO.getRemark())) {
            String changeLogEnd;
            String changeLogStart = entityLog.getRemark() == null || "".equals(entityLog.getRemark()) ? "\u7a7a" : entityLog.getRemark();
            String string = changeLogEnd = entityDO.getRemark() == null || "".equals(entityDO.getRemark()) ? "\u7a7a" : entityDO.getRemark();
            if (!changeLogStart.equals(changeLogEnd)) {
                String remarkChangeLog = "\u5907\u6ce8 \u7531 " + changeLogStart + " \u4fee\u6539\u4e3a " + changeLogEnd;
                this.logService.saveNewLog(entityDO.getId(), PrdSystemObjectEnum.BID_PROJECT.getCode(), remarkChangeLog);
            }
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.contains("bidResult")) {
            nullFields.add("bidWinningAmount");
            nullFields.add("bidWiningNotificationFile");
            nullFields.add("reasonLoseBid");
        } else if ("FAIL".equals(payload.getBidResult())) {
            nullFields.add("bidWinningAmount");
            nullFields.add("bidWiningNotificationFile");
        } else if ("SUCCESS".equals(payload.getBidResult())) {
            nullFields.add("reasonLoseBid");
        }
        payload.setNullFields(nullFields);
        this.bidDAO.updateByKeyDynamic(payload);
        return this.queryByKey(payload.getId());
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.bidRepo.findById(id);
                if (!optional.isEmpty()) {
                    BidDO entity = (BidDO)optional.get();
                    entity.setDeleteFlag(1);
                    this.bidRepo.save(entity);
                }
            });
        }
    }

    public BidVO queryReviewRecordsByBidKey(Long bidKey) {
        List reviewRecordsVOS = this.reviewRecordsService.queryReviewRecordsByBidKey(bidKey);
        BidVO bidVO = this.queryByKey(bidKey);
        bidVO.setReviewRecordsVOS(reviewRecordsVOS);
        return bidVO;
    }

    public BidVO queryOpeningDetailsByBidKey(Long bidKey) {
        List openingDetailsVOS = this.openingDetailsService.queryOpeningDetailsByBidKey(bidKey);
        BidVO bidVO = this.queryByKey(bidKey);
        bidVO.setOpeningDetailsVOS(openingDetailsVOS);
        return bidVO;
    }

    public BidVO queryCostRecordsByBidKey(Long bidKey) {
        List costRecordsVOS = this.costRecordsService.queryCostRecordsByBidKey(bidKey);
        BidVO bidVO = this.queryByKey(bidKey);
        bidVO.setCostRecordsVOS(costRecordsVOS);
        return bidVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateBidStatus(Long key, String bidStatus, String bidResult) {
        BidVO bidVO = this.queryByKey(key);
        if (bidResult == null) {
            bidResult = bidVO.getBidResult();
        }
        if (bidVO.getBidStatus().equals(bidStatus) && !bidVO.getBidStatus().equals("CREATE")) {
            if ("ACTIVATE".equals(bidStatus)) {
                throw TwException.error((String)"", (String)"\u8be5\u6295\u6807\u9879\u76ee\u5df2\u7ecf\u6fc0\u6d3b\u8fc7\u4e86");
            }
            if ("CLOSE".equals(bidStatus)) {
                throw TwException.error((String)"", (String)"\u8be5\u6295\u6807\u9879\u76ee\u5df2\u7ecf\u5173\u95ed\u8fc7\u4e86");
            }
        }
        String changeLogEnd = "";
        String changeLogStart = "";
        if ("ACTIVATE".equals(bidStatus)) {
            changeLogEnd = "\u6fc0\u6d3b";
        } else if ("CLOSE".equals(bidStatus)) {
            changeLogEnd = "\u5173\u95ed";
        } else if ("CREATE".equals(bidStatus)) {
            changeLogEnd = "\u65b0\u5efa";
        }
        if ("ACTIVATE".equals(bidVO.getBidStatus())) {
            changeLogStart = "\u6fc0\u6d3b";
        } else if ("CLOSE".equals(bidVO.getBidStatus())) {
            changeLogStart = "\u5173\u95ed";
        } else if ("CREATE".equals(bidVO.getBidStatus())) {
            changeLogStart = "\u65b0\u5efa";
        }
        if (!changeLogEnd.equals(changeLogStart)) {
            String changeLog = "\u72b6\u6001 \u7531 " + changeLogStart + " \u4fee\u6539\u4e3a " + changeLogEnd;
            this.logService.saveNewLog(bidVO.getId(), PrdSystemObjectEnum.BID_PROJECT.getCode(), changeLog);
        }
        this.bidDAO.updateBidStatus(key, bidStatus, bidResult);
    }

    public List<BidOppoVO> queryOppoListSimple() {
        List<BidDO> bidDOS = this.bidRepo.findByDeleteFlag(0);
        ArrayList bidOppoIds = new ArrayList();
        bidDOS.forEach(e -> bidOppoIds.add(e.getOpportunityId()));
        ArrayList<BidOppoVO> bidOppoVOS = new ArrayList<BidOppoVO>();
        CrmOpportunityQuery query = new CrmOpportunityQuery();
        query.setProjectStatus("ACTIVE");
        query.setProjectStatusType("0");
        List crmOpportunityVOS = this.crmOpportunityService.queryOppoList(query);
        for (CrmOpportunityVO crmOpportunityVO : crmOpportunityVOS) {
            BidOppoVO bidOppoVO = new BidOppoVO();
            boolean contains = bidOppoIds.contains(crmOpportunityVO.getId());
            bidOppoVO.setOpportunityId(crmOpportunityVO.getId());
            bidOppoVO.setOpportunityName(crmOpportunityVO.getProjectName());
            bidOppoVO.setCustBookName(crmOpportunityVO.getCustBookName());
            bidOppoVO.setCustomerContact(crmOpportunityVO.getContactName());
            bidOppoVO.setCustomerContactPhone(crmOpportunityVO.getContactPhone());
            bidOppoVO.setSaleDutyId(crmOpportunityVO.getSaleUserId());
            bidOppoVO.setPresaleDutyId(crmOpportunityVO.getPreSaleUserId());
            bidOppoVO.setPayDutyId(crmOpportunityVO.getDeliUserId());
            bidOppoVO.setWhetherRelevance(Boolean.valueOf(contains));
            bidOppoVOS.add(bidOppoVO);
        }
        return bidOppoVOS;
    }

    public BidVO queryByOppoKey(Long oppoKey) {
        BidVO vo = this.bidDAO.queryByOppoKey(oppoKey);
        Assert.notNull((Object)vo, (String)"\u4e0d\u5b58\u5728");
        vo.setInviteBidFileData(this.fileUtil.getFileDatas(vo.getInviteBidFile()));
        vo.setBidWiningNotificationFileData(this.fileUtil.getFileDatas(vo.getBidWiningNotificationFile()));
        List reviewRecordsVOS = this.reviewRecordsService.queryReviewRecordsByBidKey(vo.getId());
        vo.setReviewRecordsVOS(reviewRecordsVOS);
        return vo;
    }

    public BidServiceImpl(BidRepo bidRepo, BidDAO bidDAO, BidOpeningDetailsService openingDetailsService, BidCostRecordsService costRecordsService, CacheUtil cacheUtil, BusinessTeamMemberService businessTeamMemberService, BusinessTeamMemberRepo teamMemberRepo, PrdSystemLogService logService, ChangeFieldLogUtil changeFieldLogUtil, FileUtil fileUtil, CrmOpportunityService crmOpportunityService) {
        this.bidRepo = bidRepo;
        this.bidDAO = bidDAO;
        this.openingDetailsService = openingDetailsService;
        this.costRecordsService = costRecordsService;
        this.cacheUtil = cacheUtil;
        this.businessTeamMemberService = businessTeamMemberService;
        this.teamMemberRepo = teamMemberRepo;
        this.logService = logService;
        this.changeFieldLogUtil = changeFieldLogUtil;
        this.fileUtil = fileUtil;
        this.crmOpportunityService = crmOpportunityService;
    }
}

