/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.common.change.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.elitesland.tw.tw5.api.common.TwWorkFlowCommonVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import com.elitesland.tw.tw5crm.api.common.change.query.ComBusinessChangeQuery;
import com.elitesland.tw.tw5crm.api.common.change.service.ComBusinessChangeService;
import com.elitesland.tw.tw5crm.api.common.change.vo.ComBusinessChangeVO;
import com.elitesland.tw.tw5crm.server.common.change.convert.ComBusinessChangeConvert;
import com.elitesland.tw.tw5crm.server.common.change.dao.ComBusinessChangeDAO;
import com.elitesland.tw.tw5crm.server.common.change.entity.ComBusinessChangeDO;
import com.elitesland.tw.tw5crm.server.common.change.repo.ComBusinessChangeRepo;
import com.elitesland.workflow.TaskInfo;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.WorkflowService;
import com.elitesland.workflow.payload.CurrentTaskInfosPayload;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class ComBusinessChangeServiceImpl
implements ComBusinessChangeService {
    private static final Logger log = LoggerFactory.getLogger(ComBusinessChangeServiceImpl.class);
    private final CacheUtil cacheUtil;
    private final ComBusinessChangeRepo repo;
    private final ComBusinessChangeDAO dao;
    private final UdcUtil udcUtil;
    private final WorkflowService workflowService;

    @Transactional(rollbackOn={Exception.class})
    public Long save(String changeType, Object originalModel, Object changeModel, String docId) {
        ComBusinessChangeDO originalDO;
        ComBusinessChangeDO save;
        String originalContent = JSONObject.toJSONString((Object)this.udcUtil.translate(originalModel));
        log.info("originalContent = {}", (Object)originalContent);
        ComBusinessChangeDO v0 = this.repo.findByDeleteFlagAndChangeTypeAndChangeDocIdAndVersionNo(0, changeType, docId, 0);
        if (v0 == null && (save = (ComBusinessChangeDO)this.repo.save(originalDO = new ComBusinessChangeDO().setChangeType(changeType).setVersionNo(0).setChangeContent(originalContent).setChangeDocId(docId))) == null) {
            return -1L;
        }
        Long count = this.repo.countByDeleteFlagAndChangeTypeAndChangeDocId(0, changeType, docId);
        String changeContent = JSONObject.toJSONString((Object)this.udcUtil.translate(changeModel));
        log.info("changeContent = {}", (Object)changeContent);
        ComBusinessChangeDO changeDO = new ComBusinessChangeDO().setChangeType(changeType).setVersionNo(count.intValue()).setChangeContent(changeContent).setChangeDocId(docId);
        ComBusinessChangeDO changeSave = (ComBusinessChangeDO)this.repo.save(changeDO);
        if (changeSave == null) {
            return -1L;
        }
        return changeSave.getId();
    }

    public Long update(String changeType, String docId, Object changeModel) {
        List<ComBusinessChangeDO> dos = this.repo.findByDeleteFlagAndChangeTypeAndChangeDocId(0, changeType, docId);
        if (ObjectUtils.isEmpty(dos)) {
            throw TwException.error((String)"", (String)"\u53d8\u66f4\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        ComBusinessChangeDO changeDO = null;
        Integer versionNo = 0;
        for (ComBusinessChangeDO businessChange : dos) {
            if (businessChange.getVersionNo() <= versionNo) continue;
            versionNo = businessChange.getVersionNo();
            changeDO = businessChange;
        }
        String changeContent = JSONObject.toJSONString((Object)changeModel);
        changeDO.setChangeContent(changeContent);
        this.repo.save(changeDO);
        return changeDO.getId();
    }

    public List<ComBusinessChangeVO> changeSearch(ComBusinessChangeQuery query) {
        List<ComBusinessChangeVO> comBusinessChangeVOS = this.dao.queryListDynamic(query);
        comBusinessChangeVOS.forEach(vo -> {
            vo.setCreateUserName(this.cacheUtil.getUserName(vo.getCreateUserId()));
            vo.setChangeStatusName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.FlowStatus.getCode(), vo.getChangeStatus()));
            vo.setApprStatusName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.FlowStatus.getCode(), vo.getApprStatus()));
        });
        this.getTaskInfo(comBusinessChangeVOS);
        return comBusinessChangeVOS;
    }

    private void getTaskInfo(List<ComBusinessChangeVO> voList) {
        Map map;
        if (!CollectionUtils.isEmpty(voList) && null != (map = voList.stream().filter(vo -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{vo.getProcInstId()})).collect(Collectors.toMap(TwWorkFlowCommonVO::getProcInstId, Function.identity()))) && !map.isEmpty()) {
            Set<String> procInstIds = map.keySet();
            HashSet<String> hashSet = new HashSet<String>(procInstIds);
            CurrentTaskInfosPayload currentTaskInfosPayload = new CurrentTaskInfosPayload();
            currentTaskInfosPayload.setProcInstIds(hashSet);
            WorkflowResult workflowResult = this.workflowService.currentTaskInfos(currentTaskInfosPayload);
            if (workflowResult.isSuccess()) {
                HashMap currentTaskNames = (HashMap)workflowResult.getData();
                currentTaskNames.forEach((key, value) -> {
                    TwWorkFlowCommonVO vo = (TwWorkFlowCommonVO)map.get(key);
                    vo.setTaskInfo(value);
                });
            }
        }
    }

    public Object getCompareChange(Long id, Long compareId) {
        ComBusinessChangeVO vo = this.dao.queryByKey(id);
        WorkflowResult workflowResultVo = this.workflowService.currentTaskInfo(vo.getProcInstId());
        if (workflowResultVo.isSuccess()) {
            TaskInfo taskInfo = (TaskInfo)workflowResultVo.getData();
            vo.setTaskInfo(taskInfo);
        }
        if (vo.getVersionNo() == 0) {
            return vo;
        }
        ComBusinessChangeVO vo1 = null;
        if (compareId == null) {
            ComBusinessChangeDO changeDO = this.repo.findByDeleteFlagAndChangeTypeAndChangeDocIdAndVersionNo(0, vo.getChangeType(), vo.getChangeDocId(), vo.getVersionNo() - 1);
            if (ObjectUtils.isEmpty((Object)changeDO)) {
                throw TwException.error((String)"", (String)"\u6bd4\u5bf9\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            vo1 = ComBusinessChangeConvert.INSTANCE.toVo(changeDO);
        } else {
            vo1 = this.dao.queryByKey(compareId);
        }
        if (vo1.getVersionNo() >= vo.getVersionNo()) {
            throw TwException.error((String)"", (String)"\u6bd4\u5bf9\u6570\u636e\u4ec5\u652f\u6301\u524d\u540e\u6bd4\u5bf9\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        Map oldMap = (Map)JSON.parseObject((String)vo1.getChangeContent(), Map.class);
        Map newMap = (Map)JSON.parseObject((String)vo.getChangeContent(), Map.class);
        Map<String, Object> updateCompare = ComBusinessChangeServiceImpl.getUpdateCompare(oldMap, newMap);
        WorkflowResult workflowResult = this.workflowService.currentTaskInfo(vo.getProcInstId());
        if (workflowResult.isSuccess()) {
            TaskInfo taskInfo = (TaskInfo)workflowResult.getData();
            updateCompare.put("taskInfo", taskInfo);
        }
        return updateCompare;
    }

    public static Map<String, Object> getUpdateCompare(Map<String, Object> oldMap, Map<String, Object> newMap) {
        for (Map.Entry<String, Object> entry : newMap.entrySet()) {
            if (oldMap.containsKey(entry.getKey())) continue;
            oldMap.put(entry.getKey(), null);
        }
        HashMap<String, Object> comparedMap = new HashMap<String, Object>();
        comparedMap.putAll(oldMap);
        for (Map.Entry<String, Object> entry : oldMap.entrySet()) {
            String oldKey = entry.getKey();
            Object oldValue = entry.getValue();
            Object newValue = newMap.get(oldKey);
            if (oldKey.toLowerCase().contains("status") || oldKey.toLowerCase().contains("createtime") || oldKey.toLowerCase().contains("creator")) continue;
            if (ObjectUtils.isEmpty((Object)oldValue)) {
                if (ObjectUtils.isEmpty((Object)newValue)) continue;
                ComBusinessChangeServiceImpl.operateMap(comparedMap, oldKey, oldValue, newValue);
                continue;
            }
            if (ObjectUtils.isEmpty((Object)newValue)) {
                comparedMap.put(oldKey + "_$$_new", "");
                continue;
            }
            if (ComBusinessChangeServiceImpl.checkEquals(oldValue.toString(), newValue.toString())) continue;
            ComBusinessChangeServiceImpl.operateMap(comparedMap, oldKey, oldValue, newValue);
        }
        return comparedMap;
    }

    static void operateMap(Map<String, Object> comparedMap, String key, Object oldValue, Object newValue) {
        if (newValue instanceof Map) {
            HashMap<String, Object> oldValue0 = new HashMap();
            if (!ObjectUtils.isEmpty((Object)oldValue)) {
                oldValue0 = (Map)oldValue;
            }
            Map newValue0 = (Map)newValue;
            Map<String, Object> comparedMap0 = ComBusinessChangeServiceImpl.getUpdateCompare(oldValue0, newValue0);
            comparedMap.put(key, comparedMap0);
        } else if (newValue instanceof List) {
            List oldValueList = new ArrayList();
            if (!ObjectUtils.isEmpty((Object)oldValue)) {
                oldValueList = (List)oldValue;
            }
            List newValueList = (List)newValue;
            ArrayList<Map> comparedList = new ArrayList<Map>();
            for (Map oldValue0 : oldValueList) {
                List collect = newValueList.stream().filter(newValue1 -> {
                    boolean isHave = true;
                    if (ObjectUtils.isEmpty(oldValue0.get("id"))) {
                        if (ObjectUtils.isEmpty(oldValue0.get("attrId"))) {
                            if (ObjectUtils.isEmpty(oldValue0.get("groupId"))) {
                                if (ObjectUtils.isEmpty(oldValue0.get("selectionValue"))) {
                                    return false;
                                }
                                isHave = oldValue0.get("selectionValue").toString().equals(newValue1.get("selectionValue").toString());
                            } else {
                                isHave = oldValue0.get("groupId").toString().equals(newValue1.get("groupId").toString());
                            }
                        } else {
                            isHave = oldValue0.get("attrId").toString().equals(newValue1.get("attrId").toString());
                        }
                    } else {
                        isHave = oldValue0.get("id").toString().equals(newValue1.get("id").toString());
                    }
                    return isHave;
                }).collect(Collectors.toList());
                if (!ObjectUtils.isEmpty(collect)) {
                    Map newValue0 = (Map)collect.get(0);
                    Map<String, Object> comparedMap0 = ComBusinessChangeServiceImpl.getUpdateCompare(oldValue0, newValue0);
                    comparedList.add(comparedMap0);
                    newValueList.remove(newValue0);
                    continue;
                }
                oldValue0.put("dataStatus", 1);
                comparedList.add(oldValue0);
            }
            for (Map newValue0 : newValueList) {
                newValue0.put("dataStatus", 2);
                comparedList.add(newValue0);
            }
            comparedMap.put(key, comparedList);
        } else {
            comparedMap.put(key + "_$$_new", newValue);
        }
    }

    private static boolean checkEquals(String value1, String value2) {
        if (ComBusinessChangeServiceImpl.isNumeric(value1) && ComBusinessChangeServiceImpl.isNumeric(value2)) {
            value1 = new BigDecimal(value1).stripTrailingZeros().toPlainString();
            value2 = new BigDecimal(value2).stripTrailingZeros().toPlainString();
        }
        return value1.equals(value2);
    }

    public static boolean isNumeric(String str) {
        if (null == str || "".equals(str) || str.contains("-")) {
            return false;
        }
        String regx = "[+-]*\\d+\\.?\\d*[Ee]*[+-]*\\d+";
        Pattern pattern = Pattern.compile(regx);
        boolean isNumber = pattern.matcher(str).matches();
        if (isNumber) {
            return isNumber;
        }
        regx = "^[-\\+]?[.\\d]*$";
        pattern = Pattern.compile(regx);
        return pattern.matcher(str).matches();
    }

    public ComBusinessChangeServiceImpl(CacheUtil cacheUtil, ComBusinessChangeRepo repo, ComBusinessChangeDAO dao, UdcUtil udcUtil, WorkflowService workflowService) {
        this.cacheUtil = cacheUtil;
        this.repo = repo;
        this.dao = dao;
        this.udcUtil = udcUtil;
        this.workflowService = workflowService;
    }
}

