/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.contract.controller;

import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitesland.tw.tw5crm.api.contract.payload.ContractPayload;
import com.elitesland.tw.tw5crm.api.contract.payload.ContractSignPayload;
import com.elitesland.tw.tw5crm.api.contract.query.ContractQuery;
import com.elitesland.tw.tw5crm.api.contract.service.ContractService;
import com.elitesland.tw.tw5crm.api.contract.service.ContractSignService;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractSearchVO;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractSimpleVO;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5408\u540c\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/api/crm/contract"})
public class ContractController {
    private static final Logger log = LoggerFactory.getLogger(ContractController.class);
    private final ContractService contractService;
    private final ContractSignService contractSignService;

    @PostMapping
    @ApiOperation(value="\u5408\u540c-\u65b0\u589e")
    public TwOutputUtil<ContractVO> insert(@RequestBody ContractPayload payload) {
        return TwOutputUtil.ok((Object)this.contractService.insert(payload));
    }

    @PostMapping(value={"sign"})
    @ApiOperation(value="\u5408\u540c-\u5408\u540c\u7b7e\u8ba2")
    public TwOutputUtil sign(@RequestBody ContractSignPayload payload) {
        return TwOutputUtil.ok((Object)this.contractSignService.insert(payload));
    }

    @PutMapping
    @ApiOperation(value="\u5408\u540c-\u66f4\u65b0")
    public TwOutputUtil<ContractVO> update(@RequestBody ContractPayload payload) {
        return TwOutputUtil.ok((Object)this.contractService.update(payload));
    }

    @PutMapping(value={"updateFiled"})
    @ApiOperation(value="\u5408\u540c-\u5f52\u6863")
    public TwOutputUtil<ContractVO> updateFiled(@RequestBody ContractPayload payload) {
        return TwOutputUtil.ok((Object)this.contractService.updateFiled(payload));
    }

    @GetMapping(value={"/{key}"})
    @UdcNameClass
    @ApiOperation(value="\u5408\u540c-\u4e3b\u952e\u67e5\u8be2")
    public TwOutputUtil<ContractVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok((Object)this.contractService.queryByKey(key));
    }

    @GetMapping(value={"/paging"})
    @UdcNameClass
    @ApiOperation(value="\u5408\u540c-\u5206\u9875")
    public TwOutputUtil<ContractVO> paging(ContractQuery query) {
        return TwOutputUtil.ok((Object)this.contractService.queryPaging(query));
    }

    @ApiOperation(value="\u5408\u540c-\u67e5\u8be2\u5217\u8868")
    public TwOutputUtil<ContractVO> queryList(ContractQuery query) {
        return TwOutputUtil.ok((Object)this.contractService.queryListDynamic(query));
    }

    @GetMapping(value={"/listSimpleAll"})
    @UdcNameClass
    @ApiOperation(value="\u5408\u540c-\u5408\u540c\u4e0b\u62c9\u9009\u62e9\uff08\u5168\u90e8\uff09")
    public TwOutputUtil<ContractSimpleVO> listSimpleAll(Long customerId, Long partnerId) {
        ContractQuery query = new ContractQuery();
        if (null != customerId) {
            query.setCustomerId(customerId);
        }
        if (null != partnerId) {
            query.setPartnerId(partnerId);
        }
        return TwOutputUtil.ok((Object)this.contractService.listSimple(query));
    }

    @GetMapping(value={"/listSimple"})
    @UdcNameClass
    @ApiOperation(value="\u5408\u540c-\u5408\u540c\u4e0b\u62c9\u9009\u62e9\uff08\u6fc0\u6d3b\u3001\u5f85\u5f52\u6863\u6570\u636e\uff09")
    public TwOutputUtil<ContractSimpleVO> listSimple(Long customerId, Long partnerId) {
        ContractQuery query = new ContractQuery();
        if (null != customerId) {
            query.setCustomerId(customerId);
        }
        if (null != partnerId) {
            query.setPartnerId(partnerId);
        }
        return TwOutputUtil.ok((Object)this.contractService.listSimple(query));
    }

    @DeleteMapping(value={"/deleteSoft"})
    @ApiOperation(value="\u5408\u540c-\u5220\u9664")
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.contractService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/listSimpleByKeyword"})
    @UdcNameClass
    @ApiOperation(value="\u8054\u60f3\u5408\u540c\u540d\u79f0and\u7f16\u53f7")
    public TwOutputUtil<List<ContractSearchVO>> listSimpleByKeyword(ContractQuery query) {
        List contractVOS = this.contractService.queryListDynamic(query);
        ArrayList contractSearchVOS = new ArrayList();
        contractVOS.stream().forEach(contractVO -> contractSearchVOS.add(new ContractSearchVO(contractVO.getId(), contractVO.getContractName() + "-" + contractVO.getContractCode())));
        return TwOutputUtil.ok(contractSearchVOS);
    }

    public ContractController(ContractService contractService, ContractSignService contractSignService) {
        this.contractService = contractService;
        this.contractSignService = contractSignService;
    }
}

