/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.contract.controller;

import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5crm.api.contract.payload.ContractInvoicePayload;
import com.elitesland.tw.tw5crm.api.contract.query.ContractInvoiceQuery;
import com.elitesland.tw.tw5crm.api.contract.service.ContractInvoiceService;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractInvoiceVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5408\u540c\u7ba1\u7406-\u53d1\u7968\u8be6\u60c5"})
@RestController
@RequestMapping(value={"/api/crm/contract/invoice"})
public class ContractInvoiceController {
    private static final Logger log = LoggerFactory.getLogger(ContractInvoiceController.class);
    private final ContractInvoiceService contractInvoiceService;

    @PostMapping
    @ApiOperation(value="\u65b0\u589e")
    public TwOutputUtil<ContractInvoiceVO> insert(@RequestBody ContractInvoicePayload payload) {
        return TwOutputUtil.ok((Object)this.contractInvoiceService.insert(payload));
    }

    @PutMapping
    @ApiOperation(value="\u66f4\u65b0")
    public TwOutputUtil<ContractInvoiceVO> update(@RequestBody ContractInvoicePayload payload) {
        return TwOutputUtil.ok((Object)this.contractInvoiceService.update(payload));
    }

    @GetMapping(value={"/{key}"})
    @ApiOperation(value="\u4e3b\u952e\u67e5\u8be2")
    public TwOutputUtil<ContractInvoiceVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok((Object)this.contractInvoiceService.queryByKey(key));
    }

    @GetMapping(value={"/paging"})
    @ApiOperation(value="\u5206\u9875")
    public TwOutputUtil<ContractInvoiceVO> paging(ContractInvoiceQuery query) {
        return TwOutputUtil.ok((Object)this.contractInvoiceService.queryPaging(query));
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    public TwOutputUtil<ContractInvoiceVO> queryList(ContractInvoiceQuery query) {
        return TwOutputUtil.ok((Object)this.contractInvoiceService.queryListDynamic(query));
    }

    @DeleteMapping(value={"/deleteSoft"})
    @ApiOperation(value="\u5220\u9664")
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.contractInvoiceService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    public ContractInvoiceController(ContractInvoiceService contractInvoiceService) {
        this.contractInvoiceService = contractInvoiceService;
    }
}

