/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.contract.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5crm.api.contract.payload.ContractBillingDetailPayload;
import com.elitesland.tw.tw5crm.api.contract.query.ContractBillingDetailQuery;
import com.elitesland.tw.tw5crm.api.contract.query.ContractInvoiceBillingDetailQuery;
import com.elitesland.tw.tw5crm.api.contract.service.ContractBillingDetailService;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractBillingDetailVO;
import com.elitesland.tw.tw5crm.server.common.constants.ContractBillingApplyStatusEnum;
import com.elitesland.tw.tw5crm.server.contract.convert.ContractBillingDetailConvert;
import com.elitesland.tw.tw5crm.server.contract.dao.ContractBillingDetailDAO;
import com.elitesland.tw.tw5crm.server.contract.entity.ContractBillingDetailDO;
import com.elitesland.tw.tw5crm.server.contract.repo.ContractBillingDetailRepo;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class ContractBillingDetailServiceImpl
extends BaseServiceImpl
implements ContractBillingDetailService {
    private static final Logger log = LoggerFactory.getLogger(ContractBillingDetailServiceImpl.class);
    private final ContractBillingDetailRepo contractBillingDetailRepo;
    private final ContractBillingDetailDAO contractBillingDetailDAO;

    public PagingVO<ContractBillingDetailVO> queryPaging(ContractBillingDetailQuery query) {
        return this.contractBillingDetailDAO.queryPaging(query);
    }

    public List<ContractBillingDetailVO> queryListDynamic(ContractBillingDetailQuery query) {
        return this.contractBillingDetailDAO.queryListDynamic(query);
    }

    public ContractBillingDetailVO queryByKey(Long key) {
        ContractBillingDetailDO entity = this.contractBillingDetailRepo.findById(key).orElseGet(ContractBillingDetailDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ContractBillingDetailVO vo = ContractBillingDetailConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public ContractBillingDetailVO insert(ContractBillingDetailPayload payload) {
        ContractBillingDetailDO entityDo = ContractBillingDetailConvert.INSTANCE.toDo(payload);
        return ContractBillingDetailConvert.INSTANCE.toVo((ContractBillingDetailDO)this.contractBillingDetailRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public ContractBillingDetailVO update(ContractBillingDetailPayload payload) {
        ContractBillingDetailDO entity = this.contractBillingDetailRepo.findById(payload.getId()).orElseGet(ContractBillingDetailDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ContractBillingDetailDO entityDo = ContractBillingDetailConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return ContractBillingDetailConvert.INSTANCE.toVo((ContractBillingDetailDO)this.contractBillingDetailRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.contractBillingDetailRepo.findById(id);
                if (!optional.isEmpty()) {
                    ContractBillingDetailDO entity = (ContractBillingDetailDO)optional.get();
                    entity.setDeleteFlag(1);
                    this.contractBillingDetailRepo.save(entity);
                }
            });
        }
    }

    public List<ContractBillingDetailVO> queryListByBillingId(Long billingId) {
        return this.contractBillingDetailDAO.queryListByBillingId(billingId);
    }

    @Transactional(rollbackFor={Exception.class})
    public List<ContractBillingDetailVO> saveAll(List<ContractBillingDetailPayload> contractBillingDetailPayloadList, long billingId, String billingCode) {
        List contractBillingDetailDOList = contractBillingDetailPayloadList.stream().map(contractBillingDetailPayload -> {
            ContractBillingDetailDO contractBillingDetailDO = ContractBillingDetailConvert.INSTANCE.toDo((ContractBillingDetailPayload)contractBillingDetailPayload);
            contractBillingDetailDO.setBillingId(billingId);
            contractBillingDetailDO.setBillingCode(billingCode);
            BigDecimal billingTotalAmount = this.getAmoutByPlanIdAndBillingStatus(contractBillingDetailDO.getCollectionPlanId(), ContractBillingApplyStatusEnum.BILLING.getCode());
            BigDecimal invoicedTotalAmount = this.getAmoutByPlanIdAndBillingStatus(contractBillingDetailDO.getCollectionPlanId(), ContractBillingApplyStatusEnum.INVOICED.getCode());
            BigDecimal unbillingAmount = contractBillingDetailPayload.getCollectionAmount().subtract(billingTotalAmount).subtract(invoicedTotalAmount);
            if (contractBillingDetailPayload.getBillingAmount().compareTo(unbillingAmount) > 0) {
                String errorMsg = "\u5f00\u7968\u91d1\u989d\u4e0d\u53ef\u5927\u4e8e\u672a\u5f00\u7968\u91d1\u989d";
                log.error(errorMsg);
                throw TwException.error((String)"", (String)errorMsg);
            }
            return contractBillingDetailDO;
        }).collect(Collectors.toList());
        return ContractBillingDetailConvert.INSTANCE.toVoList(this.contractBillingDetailRepo.saveAll(contractBillingDetailDOList));
    }

    public PagingVO<ContractBillingDetailVO> queryBillingDetailList(ContractInvoiceBillingDetailQuery query) {
        return this.contractBillingDetailDAO.queryBillingDetailList(query);
    }

    public BigDecimal getAmoutByPlanIdAndBillingStatus(Long planId, String billingStatus) {
        return this.contractBillingDetailDAO.getAmoutByPlanIdAndBillingStatus(planId, billingStatus);
    }

    public ContractBillingDetailServiceImpl(ContractBillingDetailRepo contractBillingDetailRepo, ContractBillingDetailDAO contractBillingDetailDAO) {
        this.contractBillingDetailRepo = contractBillingDetailRepo;
        this.contractBillingDetailDAO = contractBillingDetailDAO;
    }
}

