/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.contract.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.partner.common.vo.BusinessPartnerVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5crm.api.contract.payload.ContractCollectionPlanPayload;
import com.elitesland.tw.tw5crm.api.contract.query.ContractCollectionPlanQuery;
import com.elitesland.tw.tw5crm.api.contract.service.ContractBillingDetailService;
import com.elitesland.tw.tw5crm.api.contract.service.ContractCollectionPlanService;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractCollectionPlanSimpleVO;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractCollectionPlanVO;
import com.elitesland.tw.tw5crm.server.common.constants.ContractBillingApplyStatusEnum;
import com.elitesland.tw.tw5crm.server.contract.convert.ContractCollectionPlanConvert;
import com.elitesland.tw.tw5crm.server.contract.dao.ContractCollectionPlanDAO;
import com.elitesland.tw.tw5crm.server.contract.dao.ContractDAO;
import com.elitesland.tw.tw5crm.server.contract.dao.ContractReceiveDetailsDAO;
import com.elitesland.tw.tw5crm.server.contract.entity.ContractCollectionPlanDO;
import com.elitesland.tw.tw5crm.server.contract.repo.ContractCollectionPlanRepo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class ContractCollectionPlanServiceImpl
extends BaseServiceImpl
implements ContractCollectionPlanService {
    private static final Logger log = LoggerFactory.getLogger(ContractCollectionPlanServiceImpl.class);
    private final ContractCollectionPlanRepo contractCollectionPlanRepo;
    private final ContractCollectionPlanDAO contractCollectionPlanDAO;
    private final CacheUtil cacheUtil;
    private final FileUtil fileUtil;
    private final ContractBillingDetailService contractBillingDetailService;
    private final ContractReceiveDetailsDAO contractReceiveDetailsDAO;
    private final BusinessPartnerService businessPartnerService;
    private final ContractDAO contractDAO;

    public PagingVO<ContractCollectionPlanVO> queryPaging(ContractCollectionPlanQuery query) {
        this.dataPermissionFlag(query);
        PagingVO<ContractCollectionPlanVO> pagingVO = this.contractCollectionPlanDAO.queryPagingJoin(query);
        List records = pagingVO.getRecords();
        if (!CollectionUtils.isEmpty((Collection)records)) {
            records.forEach(vo -> this.translation((ContractCollectionPlanVO)vo));
        }
        return pagingVO;
    }

    private void checkParam(ContractCollectionPlanQuery query) {
        if (ObjectUtils.isEmpty((Object)query.getContractId())) {
            throw TwException.error((String)"", (String)"contractId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void dataPermissionFlag(ContractCollectionPlanQuery query) {
        Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.CONTRACT_ADMIN.getCode()));
        query.setDataPermissionFlag(Boolean.valueOf(rolePermission == false));
        if (!rolePermission.booleanValue()) {
            Long loginUserId = GlobalUtil.getLoginUserId();
            query.setLoginUserId(loginUserId);
            List managerOrgIdsByUserId = this.cacheUtil.getManagerOrgIdsByUserId(loginUserId);
            query.setSignOrgIdList(managerOrgIdsByUserId);
        }
    }

    private void translation(ContractCollectionPlanVO vo) {
        vo.setFileDatas(this.fileUtil.getFileDatas(vo.getFileCodes()));
        BigDecimal billingTotalAmount = this.contractBillingDetailService.getAmoutByPlanIdAndBillingStatus(vo.getId(), ContractBillingApplyStatusEnum.BILLING.getCode());
        BigDecimal invoicedTotalAmount = this.contractBillingDetailService.getAmoutByPlanIdAndBillingStatus(vo.getId(), ContractBillingApplyStatusEnum.INVOICED.getCode());
        vo.setInvoicingAmount(billingTotalAmount);
        vo.setInvoicedAmount(invoicedTotalAmount);
        vo.setReceivedAmount(this.contractReceiveDetailsDAO.queryTotalReceiveMoneyByPlanId(vo.getId()));
        vo.setUnCollectionAmount((vo.getCollectionAmount() == null ? BigDecimal.ZERO : vo.getCollectionAmount()).subtract(vo.getReceivedAmount()));
        vo.setCollectionRatio(BigDecimal.ZERO);
        if (vo.getCollectionAmount() != null && !vo.getCollectionAmount().equals(BigDecimal.ZERO) && !vo.getContractAmount().equals(BigDecimal.ZERO)) {
            vo.setCollectionRatio(vo.getCollectionAmount().divide(vo.getContractAmount(), 2, RoundingMode.HALF_UP).setScale(2, RoundingMode.HALF_UP));
        }
    }

    public List<ContractCollectionPlanVO> queryListDynamic(ContractCollectionPlanQuery query) {
        this.checkParam(query);
        return this.contractCollectionPlanDAO.queryListDynamic(query);
    }

    public List<ContractCollectionPlanSimpleVO> queryListDynamicSimple(ContractCollectionPlanQuery query) {
        this.checkParam(query);
        List<ContractCollectionPlanVO> contractCollectionPlanVOS = this.contractCollectionPlanDAO.queryListDynamic(query);
        List<ContractCollectionPlanSimpleVO> resultList = contractCollectionPlanVOS.stream().map(contractCollectionPlanVO -> {
            ContractCollectionPlanSimpleVO contractCollectionPlanSimpleVO = ContractCollectionPlanConvert.INSTANCE.toSimpleVo((ContractCollectionPlanVO)contractCollectionPlanVO);
            BigDecimal billingTotalAmount = this.contractBillingDetailService.getAmoutByPlanIdAndBillingStatus(contractCollectionPlanSimpleVO.getId(), ContractBillingApplyStatusEnum.BILLING.getCode());
            BigDecimal invoicedTotalAmount = this.contractBillingDetailService.getAmoutByPlanIdAndBillingStatus(contractCollectionPlanSimpleVO.getId(), ContractBillingApplyStatusEnum.INVOICED.getCode());
            contractCollectionPlanSimpleVO.setInvoicingAmount(billingTotalAmount);
            contractCollectionPlanSimpleVO.setInvoicedAmount(invoicedTotalAmount);
            BigDecimal collectionAmount = contractCollectionPlanSimpleVO.getCollectionAmount() == null ? BigDecimal.ZERO : contractCollectionPlanSimpleVO.getCollectionAmount();
            contractCollectionPlanSimpleVO.setUninvoicingAmount(collectionAmount.subtract(billingTotalAmount).subtract(invoicedTotalAmount));
            contractCollectionPlanSimpleVO.setReceivedAmount(this.contractReceiveDetailsDAO.queryTotalReceiveMoneyByPlanId(contractCollectionPlanVO.getId()));
            contractCollectionPlanSimpleVO.setUnCollectionAmount(contractCollectionPlanSimpleVO.getUnCollectionAmount());
            return contractCollectionPlanSimpleVO;
        }).collect(Collectors.toList());
        return resultList;
    }

    public ContractCollectionPlanVO queryByKey(Long key) {
        ContractCollectionPlanDO entity = this.contractCollectionPlanRepo.findById(key).orElseGet(ContractCollectionPlanDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u6536\u6b3e\u8ba1\u5212\u4e0d\u5b58\u5728");
        ContractCollectionPlanVO vo = ContractCollectionPlanConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public ContractCollectionPlanVO insert(ContractCollectionPlanPayload payload) {
        this.checkPayload(payload);
        ContractCollectionPlanDO entityDo = ContractCollectionPlanConvert.INSTANCE.toDo(payload);
        return ContractCollectionPlanConvert.INSTANCE.toVo((ContractCollectionPlanDO)this.contractCollectionPlanRepo.save(entityDo));
    }

    private void checkPayload(ContractCollectionPlanPayload payload) {
        if (null == payload.getContractId()) {
            throw TwException.error((String)"", (String)"contractId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public ContractCollectionPlanVO update(ContractCollectionPlanPayload payload) {
        ContractCollectionPlanDO entity = this.contractCollectionPlanRepo.findById(payload.getId()).orElseGet(ContractCollectionPlanDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u6536\u6b3e\u8ba1\u5212\u4e0d\u5b58\u5728");
        ContractCollectionPlanDO entityDo = ContractCollectionPlanConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return ContractCollectionPlanConvert.INSTANCE.toVo((ContractCollectionPlanDO)this.contractCollectionPlanRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.contractCollectionPlanRepo.findById(id);
                if (!optional.isEmpty()) {
                    ContractCollectionPlanDO entity = (ContractCollectionPlanDO)optional.get();
                    entity.setDeleteFlag(1);
                    this.contractCollectionPlanRepo.save(entity);
                }
            });
        }
    }

    public List<ContractCollectionPlanSimpleVO> queryListByplanId(List<Long> planIdList) {
        List<ContractCollectionPlanSimpleVO> contractCollectionPlanSimpleVOS = this.contractCollectionPlanDAO.queryListByplanId(planIdList);
        contractCollectionPlanSimpleVOS.stream().forEach(vo -> {
            BusinessPartnerVO businessPartnerVO = this.businessPartnerService.queryByKey(vo.getPartnerId());
            vo.setBookId(businessPartnerVO.getBookId());
            ContractCollectionPlanQuery query = new ContractCollectionPlanQuery();
            query.setContractId(vo.getContractId());
            List<ContractCollectionPlanSimpleVO> list = this.queryListDynamicSimple(query);
            vo.setContractCollectionPlanSimpleVOList(list);
        });
        return contractCollectionPlanSimpleVOS;
    }

    public ContractCollectionPlanServiceImpl(ContractCollectionPlanRepo contractCollectionPlanRepo, ContractCollectionPlanDAO contractCollectionPlanDAO, CacheUtil cacheUtil, FileUtil fileUtil, ContractBillingDetailService contractBillingDetailService, ContractReceiveDetailsDAO contractReceiveDetailsDAO, BusinessPartnerService businessPartnerService, ContractDAO contractDAO) {
        this.contractCollectionPlanRepo = contractCollectionPlanRepo;
        this.contractCollectionPlanDAO = contractCollectionPlanDAO;
        this.cacheUtil = cacheUtil;
        this.fileUtil = fileUtil;
        this.contractBillingDetailService = contractBillingDetailService;
        this.contractReceiveDetailsDAO = contractReceiveDetailsDAO;
        this.businessPartnerService = businessPartnerService;
        this.contractDAO = contractDAO;
    }
}

