/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.contract.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5crm.api.contract.payload.ContractCountersidePayload;
import com.elitesland.tw.tw5crm.api.contract.query.ContractCountersideQuery;
import com.elitesland.tw.tw5crm.api.contract.service.ContractCountersideService;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractCountersideVO;
import com.elitesland.tw.tw5crm.server.contract.convert.ContractCountersideConvert;
import com.elitesland.tw.tw5crm.server.contract.dao.ContractCountersideDAO;
import com.elitesland.tw.tw5crm.server.contract.entity.ContractCountersideDO;
import com.elitesland.tw.tw5crm.server.contract.repo.ContractCountersideRepo;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class ContractCountersideServiceImpl
extends BaseServiceImpl
implements ContractCountersideService {
    private static final Logger log = LoggerFactory.getLogger(ContractCountersideServiceImpl.class);
    private final ContractCountersideRepo contractCountersideRepo;
    private final ContractCountersideDAO contractCountersideDAO;

    public PagingVO<ContractCountersideVO> queryPaging(ContractCountersideQuery query) {
        this.checkQuery(query);
        return this.contractCountersideDAO.queryPaging(query);
    }

    private void checkQuery(ContractCountersideQuery query) {
        if (null == query.getContractId()) {
            throw TwException.error((String)"", (String)"contractId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void checkPayload(ContractCountersidePayload query) {
        if (null == query.getContractId()) {
            throw TwException.error((String)"", (String)"contractId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public List<ContractCountersideVO> queryListDynamic(ContractCountersideQuery query) {
        this.checkQuery(query);
        return this.contractCountersideDAO.queryListDynamic(query);
    }

    public ContractCountersideVO queryByKey(Long key) {
        ContractCountersideDO entity = this.contractCountersideRepo.findById(key).orElseGet(ContractCountersideDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ContractCountersideVO vo = ContractCountersideConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public ContractCountersideVO insert(ContractCountersidePayload payload) {
        this.checkPayload(payload);
        ContractCountersideDO entityDo = ContractCountersideConvert.INSTANCE.toDo(payload);
        return ContractCountersideConvert.INSTANCE.toVo((ContractCountersideDO)this.contractCountersideRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public ContractCountersideVO update(ContractCountersidePayload payload) {
        ContractCountersideDO entity = this.contractCountersideRepo.findById(payload.getId()).orElseGet(ContractCountersideDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ContractCountersideDO entityDo = ContractCountersideConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return ContractCountersideConvert.INSTANCE.toVo((ContractCountersideDO)this.contractCountersideRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.contractCountersideRepo.findById(id);
                if (!optional.isEmpty()) {
                    ContractCountersideDO entity = (ContractCountersideDO)optional.get();
                    entity.setDeleteFlag(1);
                    this.contractCountersideRepo.save(entity);
                }
            });
        }
    }

    public ContractCountersideServiceImpl(ContractCountersideRepo contractCountersideRepo, ContractCountersideDAO contractCountersideDAO) {
        this.contractCountersideRepo = contractCountersideRepo;
        this.contractCountersideDAO = contractCountersideDAO;
    }
}

