/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.contract.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.common.TwWorkFlowCommonVO;
import com.elitesland.tw.tw5.api.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.partner.common.vo.BusinessPartnerVO;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustomerService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerSimpleVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.common.workFlow.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5crm.api.contract.payload.ContractCollectionPlanPayload;
import com.elitesland.tw.tw5crm.api.contract.payload.ContractCountersidePayload;
import com.elitesland.tw.tw5crm.api.contract.payload.ContractPayload;
import com.elitesland.tw.tw5crm.api.contract.payload.ContractProductRefPayload;
import com.elitesland.tw.tw5crm.api.contract.query.ContractCollectionPlanQuery;
import com.elitesland.tw.tw5crm.api.contract.query.ContractCountersideQuery;
import com.elitesland.tw.tw5crm.api.contract.query.ContractProductRefQuery;
import com.elitesland.tw.tw5crm.api.contract.query.ContractQuery;
import com.elitesland.tw.tw5crm.api.contract.service.ContractCollectionPlanService;
import com.elitesland.tw.tw5crm.api.contract.service.ContractCountersideService;
import com.elitesland.tw.tw5crm.api.contract.service.ContractProductRefService;
import com.elitesland.tw.tw5crm.api.contract.service.ContractService;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractSimpleVO;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractVO;
import com.elitesland.tw.tw5crm.server.common.constants.ContractCollectionPlanPlanStatus;
import com.elitesland.tw.tw5crm.server.common.constants.ContractCollectionPlanStatus;
import com.elitesland.tw.tw5crm.server.common.constants.ContractStatus;
import com.elitesland.tw.tw5crm.server.contract.convert.ContractCollectionPlanConvert;
import com.elitesland.tw.tw5crm.server.contract.convert.ContractConvert;
import com.elitesland.tw.tw5crm.server.contract.convert.ContractCountersideConvert;
import com.elitesland.tw.tw5crm.server.contract.convert.ContractProductRefConvert;
import com.elitesland.tw.tw5crm.server.contract.dao.ContractCollectionPlanDAO;
import com.elitesland.tw.tw5crm.server.contract.dao.ContractDAO;
import com.elitesland.tw.tw5crm.server.contract.entity.ContractCollectionPlanDO;
import com.elitesland.tw.tw5crm.server.contract.entity.ContractCountersideDO;
import com.elitesland.tw.tw5crm.server.contract.entity.ContractDO;
import com.elitesland.tw.tw5crm.server.contract.entity.ContractProductRefDO;
import com.elitesland.tw.tw5crm.server.contract.repo.ContractCollectionPlanRepo;
import com.elitesland.tw.tw5crm.server.contract.repo.ContractCountersideRepo;
import com.elitesland.tw.tw5crm.server.contract.repo.ContractProductRefRepo;
import com.elitesland.tw.tw5crm.server.contract.repo.ContractRepo;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.TaskInfo;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.WorkflowService;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.CurrentTaskInfosPayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class ContractServiceImpl
extends BaseServiceImpl
implements ContractService {
    private static final Logger log = LoggerFactory.getLogger(ContractServiceImpl.class);
    private final ContractRepo contractRepo;
    private final ContractDAO contractDAO;
    private final CacheUtil cacheUtil;
    private final CrmCustomerService crmCustomerService;
    private final CrmOpportunityService crmOpportunityService;
    private final ContractCountersideRepo contractCountersideRepo;
    private final ContractCollectionPlanRepo contractCollectionPlanRepo;
    private final ContractProductRefRepo contractProductRefRepo;
    private final ContractProductRefService contractProductRefService;
    private final ContractCollectionPlanService contractCollectionPlanService;
    private final ContractCountersideService contractCountersideService;
    @Value(value="${tw5.workflow.enabled:false}")
    private Boolean workflow_enabled;
    private final WorkflowUtil workflowUtil;
    private final WorkflowService workflowService;
    private final TransactionUtilService transactionUtilService;
    private final ContractCollectionPlanDAO contractCollectionPlanDAO;
    private final FileUtil fileUtil;
    @Autowired
    private BusinessPartnerService businessPartnerService;

    public PagingVO<ContractVO> queryPaging(ContractQuery query) {
        this.dataPermissionFlag(query);
        PagingVO<ContractVO> pagingVO = this.contractDAO.queryPagingJoin(query);
        List records = pagingVO.getRecords();
        this.getTaskInfo(records);
        records.forEach(record -> {
            ContractQuery queryChild = new ContractQuery();
            BeanUtils.copyProperties((Object)query, (Object)queryChild);
            queryChild.setParentId(record.getId());
            List<ContractVO> childrenList = this.queryListDynamic(queryChild);
            this.getTaskInfo(childrenList);
            record.setChildrenList(childrenList);
        });
        pagingVO.setRecords(records);
        return pagingVO;
    }

    public long count(ContractQuery query) {
        this.dataPermissionFlag(query);
        return this.contractDAO.countJoin(query);
    }

    private void getTaskInfo(List<ContractVO> voList) {
        Map map;
        if (!CollectionUtils.isEmpty(voList) && null != (map = voList.stream().filter(vo -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{vo.getProcInstId()})).collect(Collectors.toMap(TwWorkFlowCommonVO::getProcInstId, Function.identity(), (entity1, entity2) -> entity1))) && !map.isEmpty()) {
            Set<String> procInstIds = map.keySet();
            HashSet<String> hashSet = new HashSet<String>(procInstIds);
            CurrentTaskInfosPayload currentTaskInfosPayload = new CurrentTaskInfosPayload();
            currentTaskInfosPayload.setProcInstIds(hashSet);
            WorkflowResult workflowResult = this.workflowService.currentTaskInfos(currentTaskInfosPayload);
            if (workflowResult.isSuccess()) {
                HashMap currentTaskNames = (HashMap)workflowResult.getData();
                currentTaskNames.forEach((key, value) -> {
                    TwWorkFlowCommonVO vo = (TwWorkFlowCommonVO)map.get(key);
                    vo.setTaskInfo(value);
                });
            }
        }
    }

    private void dataPermissionFlag(ContractQuery query) {
        Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.CONTRACT_ADMIN.getCode()));
        query.setDataPermissionFlag(Boolean.valueOf(rolePermission == false));
        if (!rolePermission.booleanValue()) {
            Long loginUserId = GlobalUtil.getLoginUserId();
            query.setLoginUserId(loginUserId);
            List managerOrgIdsByUserId = this.cacheUtil.getManagerOrgIdsByUserId(loginUserId);
            query.setSignOrgIdList(managerOrgIdsByUserId);
        }
    }

    public List<ContractVO> queryListDynamic(ContractQuery query) {
        this.dataPermissionFlag(query);
        return this.contractDAO.queryListDynamic(query);
    }

    public List<ContractVO> contractSaleCount(ContractQuery query) {
        return this.contractDAO.queryListDynamic(query);
    }

    public List<ContractSimpleVO> listSimple(ContractQuery query) {
        this.dataPermissionFlag(query);
        List<ContractSimpleVO> listResult = this.contractDAO.queryListSimple(query);
        listResult.forEach(contractReceiveVO -> {
            ContractQuery queryChild = new ContractQuery();
            BeanUtils.copyProperties((Object)query, (Object)queryChild);
            queryChild.setParentId(contractReceiveVO.getId());
            List<ContractSimpleVO> children = this.listSimpleParentId(queryChild);
            contractReceiveVO.setChildren(children);
        });
        return listResult;
    }

    public ContractVO queryByKey(Long key) {
        ContractDO contractDO = this.contractRepo.findById(key).orElseGet(ContractDO::new);
        Assert.notNull((Object)contractDO.getId(), (String)"\u5408\u540c\u4e0d\u5b58\u5728");
        ContractVO contractVO = ContractConvert.INSTANCE.toVo(contractDO);
        this.translation(contractVO);
        this.getContractCountersideVOList(contractVO);
        this.getContractCollectionPlanVOList(contractVO);
        this.getContractProductRefVOList(contractVO);
        WorkflowResult workflowResult = this.workflowService.currentTaskInfo(contractVO.getProcInstId());
        if (workflowResult.isSuccess()) {
            TaskInfo taskInfo = (TaskInfo)workflowResult.getData();
            contractVO.setTaskInfo(taskInfo);
        }
        return contractVO;
    }

    private void translation(ContractVO contractVO) {
        contractVO.setContractFile1Data(this.fileUtil.getFileDatas(contractVO.getContractFile1()));
        contractVO.setContractFile2Data(this.fileUtil.getFileDatas(contractVO.getContractFile2()));
        contractVO.setContractFile4Data(this.fileUtil.getFileDatas(contractVO.getContractFile4()));
        contractVO.setContractFile5Data(this.fileUtil.getFileDatas(contractVO.getContractFile5()));
    }

    @Transactional(rollbackFor={Exception.class})
    public ContractVO insert(ContractPayload payload) {
        this.dataProcess(payload);
        ContractDO contractDO = ContractConvert.INSTANCE.toDo(payload);
        ContractDO save = (ContractDO)this.contractRepo.save(contractDO);
        this.saveOtherData(payload, save);
        if (payload.getSubmit().booleanValue()) {
            payload.setId(save.getId());
            this.submitProc(payload);
        }
        return ContractConvert.INSTANCE.toVo(save);
    }

    void submitProc(ContractPayload payload) {
        ProcessInfo processInfo = new ProcessInfo();
        String status = WorkFlowStatusEnum.APPROVED_WORK.getCode();
        if (this.workflow_enabled.booleanValue()) {
            status = WorkFlowStatusEnum.APPROVING_WORK.getCode();
            HashMap batchMap = new HashMap();
            processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.CONTRACT.name(), (String)(payload.getContractName() + "-\u6fc0\u6d3b\u5ba1\u6279\u6d41\u7a0b"), (String)("" + payload.getId()), batchMap));
        }
        if (Objects.equals(processInfo.getProcInstStatus(), ProcInstStatus.APPROVED)) {
            status = WorkFlowStatusEnum.APPROVED_WORK.getCode();
        }
        ContractPayload payload0 = new ContractPayload();
        payload0.setId(payload.getId());
        payload0.setProcInstId(processInfo.getProcInstId());
        payload0.setProcInstStatus(processInfo.getProcInstStatus());
        payload0.setSubmitTime(LocalDateTime.now());
        payload0.setContractStatus(status);
        this.transactionUtilService.executeWithRunnable(() -> this.contractDAO.updateWorkFlow(payload0));
        if (status.equals(WorkFlowStatusEnum.APPROVED_WORK.getCode())) {
            this.contractCollectionPlanDAO.updateStatusByContractId(ContractCollectionPlanStatus.ACTIVE.getCode(), payload.getId());
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public ContractVO update(ContractPayload payload) {
        if (payload.getId() == null) {
            throw TwException.error((String)"1", (String)"\u5408\u540cid\u4e0d\u5b58\u5728");
        }
        ContractDO entity = this.contractRepo.findById(payload.getId()).orElseGet(ContractDO::new);
        this.dataProcess(payload);
        ContractDO entityDo = ContractConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        ContractDO contractDO = (ContractDO)this.contractRepo.save(entity);
        this.saveOtherData(payload, contractDO);
        if (payload.getSubmit().booleanValue()) {
            payload.setId(contractDO.getId());
            this.submitProc(payload);
        }
        return ContractConvert.INSTANCE.toVo(contractDO);
    }

    public ContractVO updateFiled(ContractPayload payload) {
        if (payload.getId() == null) {
            throw TwException.error((String)"1", (String)"\u5408\u540cid\u4e0d\u5b58\u5728");
        }
        ContractDO entity = this.contractRepo.findById(payload.getId()).orElseGet(ContractDO::new);
        ContractPayload update = new ContractPayload();
        update.setId(payload.getId());
        update.setContractFile1(payload.getContractFile1());
        ContractDO entityDo = ContractConvert.INSTANCE.toDo(payload);
        entityDo.setContractStatus(ContractStatus.FILED.getCode());
        entityDo.setContractFile1(entityDo.getContractFile1());
        entity.copy(entityDo);
        ContractDO contractDO = (ContractDO)this.contractRepo.save(entity);
        return ContractConvert.INSTANCE.toVo(contractDO);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.contractRepo.findById(id);
                if (!optional.isEmpty()) {
                    ContractDO entity = (ContractDO)optional.get();
                    entity.setDeleteFlag(1);
                    this.contractRepo.save(entity);
                }
            });
        }
    }

    public List<ContractVO> queryByParentKey(Long id) {
        return this.contractDAO.queryByParentKey(id);
    }

    public List<ContractSimpleVO> listSimpleParentId(ContractQuery query) {
        return this.contractDAO.listSimpleParentId(query);
    }

    private void dataProcess(ContractPayload payload) {
        if (null == payload.getId()) {
            if (ObjectUtils.isEmpty((Object)payload.getContractStatus())) {
                payload.setContractStatus(ContractStatus.CREATE.getCode());
            }
            String code = this.generateSeqNum("CRM_CONTRACT", new String[0]);
            payload.setContractCode(code);
        }
        if (payload.getCustomerId() != null) {
            CrmCustomerSimpleVO customerVO = this.crmCustomerService.querySimpleByKey(payload.getCustomerId());
            payload.setCustomerName(customerVO.getCustomerName());
        }
        if (payload.getPartnerId() != null) {
            BusinessPartnerVO businessPartnerVO = this.businessPartnerService.queryByKey(payload.getPartnerId());
            payload.setCustomerName(businessPartnerVO.getPartnerName());
        }
        if (payload.getSuppliersId() != null) {
            CrmCustomerSimpleVO suppliersVO = this.crmCustomerService.querySimpleByKey(payload.getSuppliersId());
            payload.setSuppliersName(suppliersVO.getCustomerName());
        }
        if (payload.getRelateBusinessId() != null) {
            CrmOpportunityVO crmOpportunityVO = this.crmOpportunityService.queryByKeySimple(payload.getRelateBusinessId());
            payload.setRelateBusinessName(crmOpportunityVO.getProjectName());
        }
        if (payload.getRelateContractId() != null) {
            ContractVO contractVO = this.contractDAO.queryByKey(payload.getRelateContractId());
            payload.setRelateContractName(contractVO.getContractName());
        }
        String signOrgName = this.cacheUtil.getOrgName(payload.getSignOrgId());
        payload.setSignOrgName(signOrgName);
        String purchaseOrgName = this.cacheUtil.getOrgName(payload.getPurchaseOrgId());
        payload.setPurchaseOrgName(purchaseOrgName);
        String payOrgName = this.cacheUtil.getOrgName(payload.getPayOrgId());
        payload.setPayOrgName(payOrgName);
    }

    void saveOtherData(ContractPayload contractPayload, ContractDO contractDO) {
        List productRefPayloadLists;
        List deleteProductIdList;
        List collectionPlanLists;
        List deleteCollectionIdList;
        List countersideLists;
        Long contractId = contractDO.getId();
        List deleteCountersideIdList = contractPayload.getDeleteCountersideIdList();
        if (!CollectionUtils.isEmpty((Collection)deleteCountersideIdList)) {
            this.contractCountersideService.deleteSoft(deleteCountersideIdList);
        }
        if (!ObjectUtils.isEmpty((Object)(countersideLists = contractPayload.getContractCountersideList()))) {
            ArrayList contractCountersideDOS = new ArrayList();
            countersideLists.forEach(countersideList -> {
                ContractCountersideDO contractCountersideDO = ContractCountersideConvert.INSTANCE.toDo((ContractCountersidePayload)countersideList);
                contractCountersideDO.setContractId(contractId);
                contractCountersideDOS.add(contractCountersideDO);
            });
            this.contractCountersideRepo.saveAll(contractCountersideDOS);
        }
        if (!CollectionUtils.isEmpty((Collection)(deleteCollectionIdList = contractPayload.getDeleteCollectionIdList()))) {
            this.contractCollectionPlanService.deleteSoft(deleteCollectionIdList);
        }
        if (!ObjectUtils.isEmpty((Object)(collectionPlanLists = contractPayload.getCollectionPlanList()))) {
            ArrayList contractCollectionPlanDOS = new ArrayList();
            collectionPlanLists.forEach(collectionPlanList -> {
                ContractCollectionPlanDO contractCollectionPlanDO = ContractCollectionPlanConvert.INSTANCE.toDo((ContractCollectionPlanPayload)collectionPlanList);
                contractCollectionPlanDO.setContractId(contractId);
                contractCollectionPlanDO.setStatus(ContractCollectionPlanPlanStatus.NO.getCode());
                contractCollectionPlanDO.setPlanStatus(ContractCollectionPlanStatus.CREATE.getCode());
                contractCollectionPlanDOS.add(contractCollectionPlanDO);
            });
            this.contractCollectionPlanRepo.saveAll(contractCollectionPlanDOS);
        }
        if (!CollectionUtils.isEmpty((Collection)(deleteProductIdList = contractPayload.getDeleteProductIdList()))) {
            this.contractProductRefService.deleteSoft(deleteProductIdList);
        }
        if (!CollectionUtils.isEmpty((Collection)(productRefPayloadLists = contractPayload.getProductRefPayloadList()))) {
            ArrayList contractProductRefDOS = new ArrayList();
            productRefPayloadLists.forEach(productRefPayloadList -> {
                ContractProductRefDO contractProductRefDO = ContractProductRefConvert.INSTANCE.toDo((ContractProductRefPayload)productRefPayloadList);
                contractProductRefDO.setContractId(contractId);
                contractProductRefDOS.add(contractProductRefDO);
            });
            this.contractProductRefRepo.saveAll(contractProductRefDOS);
        }
    }

    void getContractCountersideVOList(ContractVO contractVO) {
        ContractCountersideQuery query = new ContractCountersideQuery();
        query.setContractId(contractVO.getId());
        List contractCountersideVOS = this.contractCountersideService.queryListDynamic(query);
        contractVO.setContractCountersideVOList(contractCountersideVOS);
    }

    void getContractCollectionPlanVOList(ContractVO contractVO) {
        ContractCollectionPlanQuery query = new ContractCollectionPlanQuery();
        query.setContractId(contractVO.getId());
        List contractCollectionPlanVOS = this.contractCollectionPlanService.queryListDynamic(query);
        contractVO.setContractCollectionPlanVOList(contractCollectionPlanVOS);
    }

    void getContractProductRefVOList(ContractVO contractVO) {
        ContractProductRefQuery query = new ContractProductRefQuery();
        query.setContractId(contractVO.getId());
        List contractProductRefVOS = this.contractProductRefService.queryListDynamic(query);
        contractVO.setContractProductRefVOList(contractProductRefVOS);
    }

    public ContractServiceImpl(ContractRepo contractRepo, ContractDAO contractDAO, CacheUtil cacheUtil, CrmCustomerService crmCustomerService, CrmOpportunityService crmOpportunityService, ContractCountersideRepo contractCountersideRepo, ContractCollectionPlanRepo contractCollectionPlanRepo, ContractProductRefRepo contractProductRefRepo, ContractProductRefService contractProductRefService, ContractCollectionPlanService contractCollectionPlanService, ContractCountersideService contractCountersideService, WorkflowUtil workflowUtil, WorkflowService workflowService, TransactionUtilService transactionUtilService, ContractCollectionPlanDAO contractCollectionPlanDAO, FileUtil fileUtil) {
        this.contractRepo = contractRepo;
        this.contractDAO = contractDAO;
        this.cacheUtil = cacheUtil;
        this.crmCustomerService = crmCustomerService;
        this.crmOpportunityService = crmOpportunityService;
        this.contractCountersideRepo = contractCountersideRepo;
        this.contractCollectionPlanRepo = contractCollectionPlanRepo;
        this.contractProductRefRepo = contractProductRefRepo;
        this.contractProductRefService = contractProductRefService;
        this.contractCollectionPlanService = contractCollectionPlanService;
        this.contractCountersideService = contractCountersideService;
        this.workflowUtil = workflowUtil;
        this.workflowService = workflowService;
        this.transactionUtilService = transactionUtilService;
        this.contractCollectionPlanDAO = contractCollectionPlanDAO;
        this.fileUtil = fileUtil;
    }
}

