/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.contract.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5crm.api.contract.payload.ContractSignPayload;
import com.elitesland.tw.tw5crm.api.contract.query.ContractSignQuery;
import com.elitesland.tw.tw5crm.api.contract.service.ContractSignService;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractSignVO;
import com.elitesland.tw.tw5crm.server.common.constants.ContractStatus;
import com.elitesland.tw.tw5crm.server.contract.convert.ContractSignConvert;
import com.elitesland.tw.tw5crm.server.contract.dao.ContractSignDAO;
import com.elitesland.tw.tw5crm.server.contract.entity.ContractDO;
import com.elitesland.tw.tw5crm.server.contract.entity.ContractSignDO;
import com.elitesland.tw.tw5crm.server.contract.repo.ContractRepo;
import com.elitesland.tw.tw5crm.server.contract.repo.ContractSignRepo;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class ContractSignServiceImpl
extends BaseServiceImpl
implements ContractSignService {
    private static final Logger log = LoggerFactory.getLogger(ContractSignServiceImpl.class);
    private final ContractSignRepo contractSignRepo;
    private final ContractSignDAO contractSignDAO;
    private final ContractRepo contractRepo;

    public PagingVO<ContractSignVO> queryPaging(ContractSignQuery query) {
        this.checkQuery(query);
        return this.contractSignDAO.queryPaging(query);
    }

    public List<ContractSignVO> queryListDynamic(ContractSignQuery query) {
        this.checkQuery(query);
        return this.contractSignDAO.queryListDynamic(query);
    }

    private void checkQuery(ContractSignQuery query) {
        if (null == query.getContractId()) {
            throw TwException.error((String)"", (String)"contractId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public ContractSignVO queryByKey(Long key) {
        ContractSignDO entity = this.contractSignRepo.findById(key).orElseGet(ContractSignDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ContractSignVO vo = ContractSignConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public ContractSignVO insert(ContractSignPayload payload) {
        if (null == payload.getContractId()) {
            throw TwException.error((String)"", (String)"contractId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ContractDO contractDO = this.contractRepo.findById(payload.getContractId()).orElseGet(ContractDO::new);
        if (!contractDO.getContractStatus().equals(ContractStatus.ACTIVE.getCode())) {
            throw TwException.error((String)"", (String)"\u5408\u540c\u72b6\u6001\u662f\u6fc0\u6d3b\u7684\u652f\u6301\u7b7e\u8ba2");
        }
        payload.setContractName(contractDO.getContractName());
        payload.setCustomerId(contractDO.getCustomerId());
        payload.setCustomerName(contractDO.getCustomerName());
        payload.setSigncompanyId(contractDO.getSignCompanyId());
        payload.setSigncompanyName(contractDO.getSignCompanyName());
        payload.setCurrency(contractDO.getCurrency());
        payload.setContractAmount(contractDO.getContractAmount());
        ContractSignDO entityDo = ContractSignConvert.INSTANCE.toDo(payload);
        ContractSignDO save = (ContractSignDO)this.contractSignRepo.save(entityDo);
        contractDO.setContractStatus(ContractStatus.TOFILED.getCode());
        this.contractRepo.save(contractDO);
        return ContractSignConvert.INSTANCE.toVo(save);
    }

    @Transactional(rollbackFor={Exception.class})
    public ContractSignVO update(ContractSignPayload payload) {
        ContractSignDO entity = this.contractSignRepo.findById(payload.getId()).orElseGet(ContractSignDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ContractSignDO entityDo = ContractSignConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return ContractSignConvert.INSTANCE.toVo((ContractSignDO)this.contractSignRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.contractSignRepo.findById(id);
                if (!optional.isEmpty()) {
                    ContractSignDO entity = (ContractSignDO)optional.get();
                    entity.setDeleteFlag(1);
                    this.contractSignRepo.save(entity);
                }
            });
        }
    }

    public ContractSignServiceImpl(ContractSignRepo contractSignRepo, ContractSignDAO contractSignDAO, ContractRepo contractRepo) {
        this.contractSignRepo = contractSignRepo;
        this.contractSignDAO = contractSignDAO;
        this.contractRepo = contractRepo;
    }
}

