/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.handover.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5crm.api.handover.query.HandoverQuery;
import com.elitesland.tw.tw5crm.api.handover.service.HandoverRecordService;
import com.elitesland.tw.tw5crm.api.handover.service.HandoverService;
import com.elitesland.tw.tw5crm.api.handover.vo.HandoverAllTypeVO;
import com.elitesland.tw.tw5crm.api.handover.vo.HandoverOperateRecordVO;
import com.elitesland.tw.tw5crm.api.handover.vo.HandoverQueryBusPartnerVO;
import com.elitesland.tw.tw5crm.api.handover.vo.HandoverQueryLeadsVO;
import com.elitesland.tw.tw5crm.api.handover.vo.HandoverQueryOpportunityVO;
import com.elitesland.tw.tw5crm.api.handover.vo.HandoverTotalTatVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u9500\u552e\u7ee7\u627f"})
@RestController
@RequestMapping(value={"/api/crm/handover"})
public class HandoverController {
    private static final Logger log = LoggerFactory.getLogger(HandoverController.class);
    private final HandoverService handoverService;
    private final HandoverRecordService handoverRecordService;

    @GetMapping(value={"/leads"})
    @ApiOperation(value="\u9500\u552e\u7ee7\u627f-\u5df2\u6709\u6216\u8005\u5f85\u5206\u914d\u7ebf\u7d22\u67e5\u8be2")
    public TwOutputUtil<List<HandoverQueryLeadsVO>> queryHaveLeads(HandoverQuery query) {
        return TwOutputUtil.ok((Object)this.handoverService.queryHaveLeads(query));
    }

    @GetMapping(value={"/opportunity"})
    @ApiOperation(value="\u9500\u552e\u7ee7\u627f-\u5df2\u6709\u6216\u8005\u5f85\u5206\u914d\u5546\u673a\u67e5\u8be2")
    public TwOutputUtil<List<HandoverQueryOpportunityVO>> queryHaveOpportunity(HandoverQuery query) {
        return TwOutputUtil.ok((Object)this.handoverService.queryHaveOpportunity(query));
    }

    @GetMapping(value={"/busPartner"})
    @ApiOperation(value="\u9500\u552e\u7ee7\u627f-\u5df2\u6709\u6216\u8005\u5f85\u5206\u914d\u4e1a\u52a1\u4f19\u4f34\u67e5\u8be2")
    public TwOutputUtil<List<HandoverQueryBusPartnerVO>> queryHaveBusPartner(HandoverQuery query) {
        return TwOutputUtil.ok((Object)this.handoverService.queryHaveBusPartner(query));
    }

    @GetMapping(value={"/queryTotalTatList"})
    @ApiOperation(value="\u9500\u552e\u7ee7\u627f-\u5458\u5de5\u5df2\u6709\u6216\u8005\u5f85\u5206\u914d\u7ebf\u7d22/\u5546\u673a/\u4e1a\u52a1\u4f19\u4f34\u4e2a\u6570\u7edf\u8ba1\u67e5\u8be2")
    public TwOutputUtil<PagingVO<HandoverTotalTatVo>> queryTotalTatList(HandoverQuery query) {
        return TwOutputUtil.ok((Object)this.handoverService.queryTotalTatList(query));
    }

    @PostMapping(value={"/handover/active"})
    @ApiOperation(value="\u9500\u552e\u7ee7\u627f-\u5168\u90e8\u6216\u8005\u90e8\u5206\u7ee7\u627f\u5206\u914d\u64cd\u4f5c")
    public TwOutputUtil handoverLeadsActive(@RequestBody List<HandoverAllTypeVO> handovers) {
        int i = this.handoverService.handoverActive(handovers);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/statistics/record/{userId}"})
    @ApiOperation(value="\u9500\u552e\u7ee7\u627f-\u7edf\u8ba1\u88ab\u7ee7\u627f\u8005\u7684\u5206\u914d\u8bb0\u5f55")
    public TwOutputUtil<List<HandoverOperateRecordVO>> statisticsHandOverRecord(@PathVariable(value="userId") Long userId) {
        return TwOutputUtil.ok((Object)this.handoverRecordService.statisticsHandOverRecord(userId));
    }

    public HandoverController(HandoverService handoverService, HandoverRecordService handoverRecordService) {
        this.handoverService = handoverService;
        this.handoverRecordService = handoverRecordService;
    }
}

