/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.handover.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.server.common.StringUtil;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.partner.common.entity.QBookContactsDO;
import com.elitesland.tw.tw5.server.partner.common.entity.QBusinessPartnerDO;
import com.elitesland.tw.tw5.server.partner.team.entity.QBusinessTeamMemberDO;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SystemDefaultEnum;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmLeadsDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmOpportunityDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.prj.entity.QPrjProjectDO;
import com.elitesland.tw.tw5crm.api.handover.query.HandoverQuery;
import com.elitesland.tw.tw5crm.api.handover.vo.HandoverQueryBusPartnerVO;
import com.elitesland.tw.tw5crm.api.handover.vo.HandoverQueryLeadsVO;
import com.elitesland.tw.tw5crm.api.handover.vo.HandoverQueryOpportunityVO;
import com.elitesland.tw.tw5crm.server.common.handover.EnableStatus;
import com.elitesland.tw.tw5crm.server.common.handover.EyeeResStatus;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.Arrays;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class HandoverDao {
    private final JPAQueryFactory jpaQueryFactory;
    private final QCrmLeadsDO qleadsDo = QCrmLeadsDO.crmLeadsDO;
    private final QCrmOpportunityDO qoppoDo = QCrmOpportunityDO.crmOpportunityDO;
    private final QPrjProjectDO qprjDo = QPrjProjectDO.prjProjectDO;
    private final QBusinessPartnerDO qbpDo = QBusinessPartnerDO.businessPartnerDO;
    private final QBusinessTeamMemberDO qbptmDo = QBusinessTeamMemberDO.businessTeamMemberDO;
    private final QPrdOrgEmployeeDO qemdo = QPrdOrgEmployeeDO.prdOrgEmployeeDO;
    private final QBookContactsDO qBookContactsDO = QBookContactsDO.bookContactsDO;

    public List<HandoverQueryLeadsVO> queryHaveLeads(HandoverQuery payload) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(HandoverQueryLeadsVO.class, (Expression[])new Expression[]{this.qleadsDo.id, this.qleadsDo.leadsNo, this.qleadsDo.leadsName, this.qleadsDo.saleUserId, this.qbpDo.partnerName, this.qbpDo.partnerPhone, this.qbpDo.partnerIndustry, this.qleadsDo.demandProduct, this.qBookContactsDO.contactsName.as("sourceUserName")})).from((EntityPath)this.qleadsDo)).leftJoin((EntityPath)this.qbpDo)).on((Predicate)this.qleadsDo.partnerId.longValue().eq((Expression)this.qbpDo.id.longValue()))).leftJoin((EntityPath)this.qBookContactsDO)).on((Predicate)this.qbpDo.bookId.longValue().eq((Expression)this.qBookContactsDO.bookId.longValue()).and((Predicate)this.qBookContactsDO.isDefault.eq(Boolean.valueOf(true)).and((Predicate)this.qBookContactsDO.deleteFlag.eq((Object)0))));
        jpaQuery.where((Predicate)this.qleadsDo.saleUserId.isNotNull());
        jpaQuery.where((Predicate)this.qleadsDo.deleteFlag.eq((Object)0));
        if (StringUtil.isNotBlank((CharSequence)payload.getTypeName())) {
            jpaQuery.where((Predicate)this.qleadsDo.leadsName.like(SqlUtil.toSqlLikeString((String)payload.getTypeName())));
        }
        if (StringUtil.isNotBlank((CharSequence)payload.getIndustry())) {
            jpaQuery.where((Predicate)this.qbpDo.partnerIndustry.eq((Object)payload.getIndustry()));
        }
        if (StringUtil.isNotBlank((CharSequence)payload.getCustomerName())) {
            jpaQuery.where((Predicate)this.qbpDo.partnerName.like(SqlUtil.toSqlLikeString((String)payload.getCustomerName())));
        }
        if (payload.getUserId() != null) {
            jpaQuery.where((Predicate)this.qleadsDo.saleUserId.longValue().eq((Object)payload.getUserId()));
        }
        return jpaQuery.fetch();
    }

    public List<HandoverQueryOpportunityVO> queryHaveOpportunity(HandoverQuery payload) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(HandoverQueryOpportunityVO.class, (Expression[])new Expression[]{this.qoppoDo.id, this.qprjDo.projectNo, this.qprjDo.projectName, this.qoppoDo.saleUserId, this.qoppoDo.preSaleUserId, this.qoppoDo.deliUserId, this.qoppoDo.oppoLevel, this.qoppoDo.probability, this.qoppoDo.salePhase, this.qprjDo.projectStatus, this.qbpDo.partnerName, this.qbpDo.partnerIndustry})).from((EntityPath)this.qoppoDo)).leftJoin((EntityPath)this.qprjDo)).on((Predicate)this.qoppoDo.projectId.longValue().eq((Expression)this.qprjDo.id.longValue()))).leftJoin((EntityPath)this.qbpDo)).on((Predicate)this.qoppoDo.partnerId.longValue().eq((Expression)this.qbpDo.id.longValue()));
        jpaQuery.where((Predicate)this.qoppoDo.preSaleUserId.isNotNull().or((Predicate)this.qoppoDo.deliUserId.isNotNull()).or((Predicate)this.qoppoDo.saleUserId.isNotNull()));
        jpaQuery.where((Predicate)this.qoppoDo.deleteFlag.eq((Object)0));
        if (StringUtil.isNotBlank((CharSequence)payload.getTypeName())) {
            jpaQuery.where((Predicate)this.qprjDo.projectName.like(SqlUtil.toSqlLikeString((String)payload.getTypeName())));
        }
        if (StringUtil.isNotBlank((CharSequence)payload.getOpportunityStatus())) {
            jpaQuery.where((Predicate)this.qprjDo.projectStatus.eq((Object)payload.getOpportunityStatus()));
        }
        if (StringUtil.isNotBlank((CharSequence)payload.getCustomerName())) {
            jpaQuery.where((Predicate)this.qbpDo.partnerName.like(SqlUtil.toSqlLikeString((String)payload.getCustomerName())));
        }
        if (payload.getUserId() != null) {
            jpaQuery.where((Predicate)this.qoppoDo.preSaleUserId.longValue().eq((Object)payload.getUserId()).or((Predicate)this.qoppoDo.deliUserId.longValue().eq((Object)payload.getUserId())).or((Predicate)this.qoppoDo.saleUserId.longValue().eq((Object)payload.getUserId())));
        }
        return jpaQuery.fetch();
    }

    public List<HandoverQueryBusPartnerVO> queryHaveBusPartner(HandoverQuery payload) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(HandoverQueryBusPartnerVO.class, (Expression[])new Expression[]{this.qbpDo.id, this.qbpDo.businessPartnerNo.as("partnerNo"), this.qbpDo.partnerName, this.qbptmDo.userId.as("formUserId"), this.qbptmDo.memberName.as("formUserName"), this.qbptmDo.memberRole.as("currentUserRole"), this.qbptmDo.memberRoleName.as("currentUserRoleDesc"), this.qbpDo.partnerIdentity, this.qbpDo.partnerIndustry, this.qbpDo.bookId, this.qbpDo.partnerEmail, this.qbpDo.partnerPhone, this.qbpDo.partnerPhone.as("telephone"), this.qbptmDo.id.as("teamMemberId")})).from((EntityPath)this.qbpDo)).leftJoin((EntityPath)this.qbptmDo)).on((Predicate)this.qbpDo.id.longValue().eq((Expression)this.qbptmDo.objectId.longValue()));
        jpaQuery.where((Predicate)this.qbptmDo.userId.isNotNull());
        jpaQuery.where((Predicate)this.qbpDo.deleteFlag.eq((Object)0));
        if (StringUtil.isNotBlank((CharSequence)payload.getTypeName())) {
            jpaQuery.where((Predicate)this.qbpDo.partnerName.like(SqlUtil.toSqlLikeString((String)payload.getTypeName())));
        }
        if (StringUtil.isNotBlank((CharSequence)payload.getPartnerIdentity())) {
            jpaQuery.where((Predicate)this.qbpDo.partnerIdentity.eq((Object)payload.getPartnerIdentity()));
        }
        if (StringUtil.isNotBlank((CharSequence)payload.getIndustry())) {
            jpaQuery.where((Predicate)this.qbpDo.partnerIndustry.eq((Object)payload.getIndustry()));
        }
        if (payload.getUserId() != null) {
            jpaQuery.where((Predicate)this.qbptmDo.userId.longValue().eq((Object)payload.getUserId()));
        }
        return jpaQuery.fetch();
    }

    public PagingVO<PrdOrgEmployeeVO> queryUserPaging(HandoverQuery query) {
        JPAQuery<PrdOrgEmployeeVO> jpaQuery = this.getJpaQueryWhere(query);
        QueryResults result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetchResults();
        return PagingVO.builder().records(result.getResults()).total(result.getTotal()).build();
    }

    private JPAQuery<PrdOrgEmployeeVO> getJpaQueryWhere(HandoverQuery query) {
        String[] s;
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdOrgEmployeeVO.class, (Expression[])new Expression[]{this.qemdo.id, this.qemdo.userId, this.qemdo.employeeName})).from((EntityPath)this.qemdo)).leftJoin((EntityPath)this.qleadsDo)).on((Predicate)this.qemdo.userId.longValue().eq((Expression)this.qleadsDo.saleUserId.longValue()))).leftJoin((EntityPath)this.qoppoDo)).on((Predicate)this.qemdo.userId.longValue().eq((Expression)this.qoppoDo.saleUserId.longValue()).or((Predicate)this.qemdo.userId.longValue().eq((Expression)this.qoppoDo.preSaleUserId.longValue())).or((Predicate)this.qemdo.userId.longValue().eq((Expression)this.qoppoDo.deliUserId.longValue())))).leftJoin((EntityPath)this.qbptmDo)).on((Predicate)this.qemdo.userId.longValue().eq((Expression)this.qbptmDo.userId.longValue()))).leftJoin((EntityPath)this.qbpDo)).on((Predicate)this.qbptmDo.objectId.longValue().eq((Expression)this.qbpDo.id.longValue()));
        jpaQuery.distinct();
        jpaQuery.where((Predicate)this.qemdo.hrStatus.eq((Object)SystemDefaultEnum.DefaultHrStatus.getCode()));
        jpaQuery.where((Predicate)this.qleadsDo.deleteFlag.eq((Object)0).or((Predicate)this.qoppoDo.deleteFlag.eq((Object)0)).or((Predicate)this.qbpDo.deleteFlag.eq((Object)0)));
        if (query.getEmployeeId() != null) {
            jpaQuery.where((Predicate)this.qemdo.userId.eq((Object)query.getEmployeeId()));
        }
        if (EnableStatus.YES.getKey().equals(query.getResouceStatus())) {
            s = new String[]{EyeeResStatus.ENTRYING.getStatus(), EyeeResStatus.ENTRYED.getStatus(), EyeeResStatus.DEPARTING.getStatus(), EyeeResStatus.BUUPDATE.getStatus()};
            jpaQuery.where((Predicate)this.qemdo.resourceStatus.in(Arrays.asList(s)));
        }
        if (EnableStatus.NO.getKey().equals(query.getResouceStatus())) {
            s = new String[]{EyeeResStatus.DEPARTED.getStatus()};
            jpaQuery.where((Predicate)this.qemdo.resourceStatus.in(Arrays.asList(s)));
        }
        jpaQuery.where((Predicate)this.qleadsDo.saleUserId.isNotNull().or((Predicate)this.qoppoDo.saleUserId.isNotNull()).or((Predicate)this.qoppoDo.preSaleUserId.isNotNull()).or((Predicate)this.qoppoDo.deliUserId.isNotNull()).or((Predicate)this.qbptmDo.userId.isNotNull().and((Predicate)this.qbptmDo.objectId.isNotNull())));
        return jpaQuery;
    }

    public HandoverDao(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

