/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.partner.business.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOperationPlanTempDetailQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOperationPlanTempQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOperationPlanTempDetailService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOperationPlanTempService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmFollowVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOperationPlanTempVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemLogEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5crm.api.partner.business.payload.BusinessCustomerOperationPayload;
import com.elitesland.tw.tw5crm.api.partner.business.payload.BusinessCustomerOperationPlanDetailPayload;
import com.elitesland.tw.tw5crm.api.partner.business.query.BusinessCustomerOperationPlanDetailQuery;
import com.elitesland.tw.tw5crm.api.partner.business.query.BusinessCustomerOperationQuery;
import com.elitesland.tw.tw5crm.api.partner.business.query.CrmBusinessCustomerOperationQuery;
import com.elitesland.tw.tw5crm.api.partner.business.service.BusinessCustomerOperationPlanDetailService;
import com.elitesland.tw.tw5crm.api.partner.business.service.BusinessCustomerOperationService;
import com.elitesland.tw.tw5crm.api.partner.business.vo.BusinessCustomerOperationVO;
import com.elitesland.tw.tw5crm.server.partner.business.convert.BusinessCustomerOperationConvert;
import com.elitesland.tw.tw5crm.server.partner.business.dao.BusinessCustomerOperationDAO;
import com.elitesland.tw.tw5crm.server.partner.business.entity.BusinessCustomerOperationDO;
import com.elitesland.tw.tw5crm.server.partner.business.repo.BusinessCustomerOperationRepo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class BusinessCustomerOperationServiceImpl
extends BaseServiceImpl
implements BusinessCustomerOperationService {
    private static final Logger log = LoggerFactory.getLogger(BusinessCustomerOperationServiceImpl.class);
    private final BusinessCustomerOperationRepo businessCustomerOperationRepo;
    private final BusinessCustomerOperationDAO businessCustomerOperationDAO;
    private final ChangeFieldLogUtil changeFieldLogUtil;
    private final PrdSystemLogService logService;
    private final CrmOperationPlanTempDetailService crmOperationPlanTempDetailService;
    private final CrmOperationPlanTempService crmOperationPlanTempService;
    private final BusinessCustomerOperationPlanDetailService businessCustomerOperationPlanDetailService;

    public PagingVO<BusinessCustomerOperationVO> queryPaging(BusinessCustomerOperationQuery query) {
        return this.businessCustomerOperationDAO.queryPaging(query);
    }

    public List<BusinessCustomerOperationVO> queryListDynamic(BusinessCustomerOperationQuery query) {
        return this.businessCustomerOperationDAO.queryListDynamic(query);
    }

    public BusinessCustomerOperationVO queryByKey(Long key) {
        BusinessCustomerOperationDO entity = this.businessCustomerOperationRepo.findById(key).orElseGet(BusinessCustomerOperationDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessCustomerOperationVO vo = BusinessCustomerOperationConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessCustomerOperationVO insert(BusinessCustomerOperationPayload payload) {
        BusinessCustomerOperationDO entityDo = BusinessCustomerOperationConvert.INSTANCE.toDo(payload);
        BusinessCustomerOperationDO save = (BusinessCustomerOperationDO)this.businessCustomerOperationRepo.save(entityDo);
        return BusinessCustomerOperationConvert.INSTANCE.toVo(save);
    }

    @Transactional(rollbackFor={Exception.class})
    public void initOpertionPlanCommon(String custGrade, Long partnerId) {
        BusinessCustomerOperationPlanDetailQuery operationPlanDetailQuery = new BusinessCustomerOperationPlanDetailQuery();
        operationPlanDetailQuery.setPartnerId(partnerId);
        Long count = this.businessCustomerOperationPlanDetailService.count(operationPlanDetailQuery);
        if (count == 0L) {
            this.initOperationPlan(custGrade, partnerId);
        }
    }

    private void initOperationPlan(String custGrade, Long partnerId) {
        if (StringUtils.hasText((String)custGrade)) {
            CrmOperationPlanTempQuery planTempQuery = new CrmOperationPlanTempQuery(custGrade);
            List planTempVOList = this.crmOperationPlanTempService.queryList(planTempQuery);
            if (!CollectionUtils.isEmpty((Collection)planTempVOList)) {
                if (planTempVOList.size() > 1) {
                    log.error("\u5ba2\u6237\u7ecf\u8425-\u7ecf\u8425\u8ba1\u5212\u6a21\u677f\u6709\u91cd\u590d\u6570\u636e\uff0c\u7ea7\u522b\uff1a{}", (Object)custGrade);
                }
                CrmOperationPlanTempVO planTempVO = (CrmOperationPlanTempVO)planTempVOList.get(0);
                CrmOperationPlanTempDetailQuery planTempDetailQuery = new CrmOperationPlanTempDetailQuery(planTempVO.getId());
                List planTempDetailVOList = this.crmOperationPlanTempDetailService.queryList(planTempDetailQuery);
                ArrayList planDetailDOS = new ArrayList();
                planTempDetailVOList.forEach(crmOperationPlanTempDetailVO -> {
                    BusinessCustomerOperationPlanDetailPayload planDetailDO = new BusinessCustomerOperationPlanDetailPayload();
                    BeanUtils.copyProperties((Object)crmOperationPlanTempDetailVO, (Object)planDetailDO);
                    planDetailDO.setPartnerId(partnerId);
                    planDetailDO.setReadFlag(Integer.valueOf(0));
                    planDetailDOS.add(planDetailDO);
                });
                this.businessCustomerOperationPlanDetailService.saveAll(planDetailDOS);
            } else {
                log.warn("\u5ba2\u6237\u7ecf\u8425-\u7ecf\u8425\u8ba1\u5212\u6a21\u677f\u672a\u914d\u7f6e,\u7ea7\u522b\uff1a{}", (Object)custGrade);
            }
        } else {
            log.warn("\u5ba2\u6237\u7ecf\u8425-\u7ecf\u8425\u7ea7\u522b\u672a\u8bbe\u7f6e\uff0cpartnerId \uff1a{}", (Object)partnerId);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessCustomerOperationVO update(BusinessCustomerOperationPayload payload) {
        BusinessCustomerOperationDO entity = this.businessCustomerOperationRepo.findById(payload.getId()).orElseGet(BusinessCustomerOperationDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessCustomerOperationDO entityLog = new BusinessCustomerOperationDO();
        BeanUtils.copyProperties((Object)entity, (Object)entityLog);
        BusinessCustomerOperationDO entityDo = BusinessCustomerOperationConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        StringBuilder fieldsUpdateLog = this.changeFieldLogUtil.nullFieldsProcess((TwCommonPayload)payload, entityLog, entity);
        BusinessCustomerOperationDO save = (BusinessCustomerOperationDO)this.businessCustomerOperationRepo.save(entity);
        fieldsUpdateLog.append(this.changeFieldLogUtil.getFieldsUpdateLog(entityDo, entityLog));
        if (StringUtils.hasText((CharSequence)fieldsUpdateLog)) {
            // empty if block
        }
        this.logService.saveNewLog(entity.getPartnerId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), PrdSystemLogEnum.UPDATE.getDesc() + PrdSystemObjectEnum.BUSINESS_CUSTOMER_OPERATION.getDesc());
        return BusinessCustomerOperationConvert.INSTANCE.toVo(save);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.businessCustomerOperationRepo.findById(id);
                if (!optional.isEmpty()) {
                    BusinessCustomerOperationDO entity = (BusinessCustomerOperationDO)optional.get();
                    entity.setDeleteFlag(1);
                    this.businessCustomerOperationRepo.save(entity);
                }
            });
        }
    }

    public List<CrmFollowVO> queryOperateFollowList(Long partnerId) {
        return null;
    }

    public Object queryBusinessFollowPaging(CrmBusinessCustomerOperationQuery query) {
        Object resultData = new Object();
        BusinessCustomerOperationVO businessCustomerOperationVO = this.queryByKey(query.getOperId());
        this.checkRelation(businessCustomerOperationVO);
        query.setPartnerId(businessCustomerOperationVO.getPartnerId());
        return resultData;
    }

    public int checkCustNameUnique(String custName) {
        return this.businessCustomerOperationRepo.countByCustName(custName);
    }

    void checkRelation(BusinessCustomerOperationVO operationVO) {
        if (ObjectUtils.isEmpty((Object)operationVO)) {
            throw TwException.error((String)"", (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (operationVO.getPartnerId() == null) {
            throw TwException.error((String)"", (String)"\u6682\u672a\u5173\u8054\u5ba2\u6237\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
    }

    public BusinessCustomerOperationServiceImpl(BusinessCustomerOperationRepo businessCustomerOperationRepo, BusinessCustomerOperationDAO businessCustomerOperationDAO, ChangeFieldLogUtil changeFieldLogUtil, PrdSystemLogService logService, CrmOperationPlanTempDetailService crmOperationPlanTempDetailService, CrmOperationPlanTempService crmOperationPlanTempService, BusinessCustomerOperationPlanDetailService businessCustomerOperationPlanDetailService) {
        this.businessCustomerOperationRepo = businessCustomerOperationRepo;
        this.businessCustomerOperationDAO = businessCustomerOperationDAO;
        this.changeFieldLogUtil = changeFieldLogUtil;
        this.logService = logService;
        this.crmOperationPlanTempDetailService = crmOperationPlanTempDetailService;
        this.crmOperationPlanTempService = crmOperationPlanTempService;
        this.businessCustomerOperationPlanDetailService = businessCustomerOperationPlanDetailService;
    }
}

