/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.sale.service;

import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.partner.common.query.BusinessPartnerQuery;
import com.elitesland.tw.tw5.api.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmLeadsQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmLeadsService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.server.common.constants.BusinessPartnerIdentityEnum;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5crm.api.contract.query.ContractQuery;
import com.elitesland.tw.tw5crm.api.contract.query.ContractReceiveDetailsQuery;
import com.elitesland.tw.tw5crm.api.contract.service.ContractReceiveDetailsService;
import com.elitesland.tw.tw5crm.api.contract.service.ContractService;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractReceiveDetailsVO;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractVO;
import com.elitesland.tw.tw5crm.api.sale.service.CrmSaleCountService;
import com.elitesland.tw.tw5crm.api.sale.vo.CrmSaleCountVO;
import com.elitesland.tw.tw5crm.api.visit.query.VisitTaskQuery;
import com.elitesland.tw.tw5crm.api.visit.service.VisitTaskService;
import com.elitesland.tw.tw5crm.server.common.constants.CrmSaleCountDateTypeEnum;
import com.elitesland.tw.tw5crm.server.common.constants.CrmSaleCountPersonTypeEnum;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CrmSaleCountServiceImpl
extends BaseServiceImpl
implements CrmSaleCountService {
    private static final Logger log = LoggerFactory.getLogger(CrmSaleCountServiceImpl.class);
    private final CacheUtil cacheUtil;
    private final BusinessPartnerService businessPartnerService;
    private final CrmLeadsService crmLeadsService;
    private final CrmOpportunityService crmOpportunityService;
    private final ContractService contractService;
    private final ContractReceiveDetailsService contractReceiveDetailsService;
    private final VisitTaskService visitTaskService;
    private final PrdOrgEmployeeService prdOrgEmployeeService;

    public CrmSaleCountVO count(String personType, String dateType) {
        ArrayList<Long> userIdList = new ArrayList<Long>();
        Long loginUserId = GlobalUtil.getLoginUserId();
        if (CrmSaleCountPersonTypeEnum.SELF.getCode().equals(personType)) {
            userIdList.add(loginUserId);
        } else {
            List list = this.prdOrgEmployeeService.querySubUserIdByParentId(loginUserId);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                userIdList.addAll(list);
            }
            userIdList.add(loginUserId);
        }
        if (userIdList == null || userIdList.size() == 0) {
            return new CrmSaleCountVO(Long.valueOf(0L), Long.valueOf(0L), Long.valueOf(0L), Long.valueOf(0L), Long.valueOf(0L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
        }
        LocalDateTime createTimeStart = CrmSaleCountDateTypeEnum.WEEK.getCode().equals(dateType) ? LocalDateTime.of(LocalDate.now().minusDays(LocalDate.now().getDayOfWeek().getValue() - 1), LocalTime.MIN) : LocalDateTime.of(LocalDate.now().minusDays(LocalDate.now().getDayOfMonth() - 1), LocalTime.MIN);
        CrmSaleCountVO crmSaleCountVO = new CrmSaleCountVO();
        this.getData(crmSaleCountVO, userIdList, createTimeStart);
        return crmSaleCountVO;
    }

    private void getData(CrmSaleCountVO crmSaleCountVO, List<Long> userIdList, LocalDateTime createTimeStart) {
        BusinessPartnerQuery businessPartnerQuery = new BusinessPartnerQuery();
        businessPartnerQuery.setUserIdList(userIdList);
        businessPartnerQuery.setCreateTimeStart(createTimeStart);
        businessPartnerQuery.setPartnerIdentity(BusinessPartnerIdentityEnum.CUSTOMER.getCode());
        crmSaleCountVO.setAddBusinessCount(Long.valueOf(this.businessPartnerService.saleCount(businessPartnerQuery)));
        CrmLeadsQuery crmLeadsQuery = new CrmLeadsQuery();
        crmLeadsQuery.setSourceUserIds(userIdList);
        crmLeadsQuery.setCreateTimeStart(createTimeStart);
        crmSaleCountVO.setAddLeadsCount(this.crmLeadsService.count(crmLeadsQuery));
        CrmOpportunityQuery crmOpportunityQuery = new CrmOpportunityQuery();
        crmOpportunityQuery.setManageUserIds(userIdList);
        crmOpportunityQuery.setCreateTimeStart(createTimeStart);
        List crmOpportunityVOS = this.crmOpportunityService.saleCountOppoList(crmOpportunityQuery);
        BigDecimal oppoAmout = BigDecimal.ZERO;
        crmSaleCountVO.setAddOppoCount(Long.valueOf(0L));
        crmSaleCountVO.setOppoAmount(oppoAmout);
        if (crmOpportunityVOS != null && crmOpportunityVOS.size() > 0) {
            crmSaleCountVO.setAddOppoCount(Long.valueOf(crmOpportunityVOS.size()));
            oppoAmout = crmOpportunityVOS.stream().map(CrmOpportunityVO::getForecastAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            crmSaleCountVO.setOppoAmount(oppoAmout);
        } else {
            crmSaleCountVO.setAddOppoCount(Long.valueOf(0L));
            crmSaleCountVO.setOppoAmount(BigDecimal.ZERO);
        }
        ContractQuery query = new ContractQuery();
        query.setCreateTimeStart(createTimeStart);
        query.setSaleDutyIds(userIdList);
        query.setDataPermissionFlag(Boolean.valueOf(false));
        crmSaleCountVO.setAddContractCount(Long.valueOf(0L));
        crmSaleCountVO.setContractAmount(BigDecimal.ZERO);
        List contractVOS = this.contractService.contractSaleCount(query);
        if (contractVOS != null && contractVOS.size() > 0) {
            crmSaleCountVO.setAddContractCount(Long.valueOf(contractVOS.size()));
            BigDecimal contractTotalAmount = contractVOS.stream().map(ContractVO::getContractAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            crmSaleCountVO.setContractAmount(contractTotalAmount);
        }
        VisitTaskQuery visitTaskQuery = new VisitTaskQuery();
        visitTaskQuery.setCreateTimeStart(createTimeStart);
        visitTaskQuery.setVisitMemberIds(userIdList);
        visitTaskQuery.setStatus("OK");
        long visitCount = this.visitTaskService.count(visitTaskQuery);
        crmSaleCountVO.setAddVisitCount(Long.valueOf(visitCount));
        ContractReceiveDetailsQuery contractReceiveDetailsQuery = new ContractReceiveDetailsQuery();
        contractReceiveDetailsQuery.setCreateTimeStart(createTimeStart);
        contractReceiveDetailsQuery.setSaleDutyIds(userIdList);
        crmSaleCountVO.setReceiveAmount(BigDecimal.ZERO);
        List contractReceiveDetailsVOS = this.contractReceiveDetailsService.queryListDynamic(contractReceiveDetailsQuery);
        if (contractReceiveDetailsVOS != null && contractReceiveDetailsVOS.size() > 0) {
            BigDecimal receiveAmount = contractReceiveDetailsVOS.stream().map(ContractReceiveDetailsVO::getReceiveMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
            crmSaleCountVO.setReceiveAmount(receiveAmount);
        }
    }

    public CrmSaleCountServiceImpl(CacheUtil cacheUtil, BusinessPartnerService businessPartnerService, CrmLeadsService crmLeadsService, CrmOpportunityService crmOpportunityService, ContractService contractService, ContractReceiveDetailsService contractReceiveDetailsService, VisitTaskService visitTaskService, PrdOrgEmployeeService prdOrgEmployeeService) {
        this.cacheUtil = cacheUtil;
        this.businessPartnerService = businessPartnerService;
        this.crmLeadsService = crmLeadsService;
        this.crmOpportunityService = crmOpportunityService;
        this.contractService = contractService;
        this.contractReceiveDetailsService = contractReceiveDetailsService;
        this.visitTaskService = visitTaskService;
        this.prdOrgEmployeeService = prdOrgEmployeeService;
    }
}

