/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.tenant.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.QBaseModel;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5crm.api.tenant.payload.TwTenantPayload;
import com.elitesland.tw.tw5crm.api.tenant.query.TwTenantQuery;
import com.elitesland.tw.tw5crm.api.tenant.vo.TwTenantVO;
import com.elitesland.tw.tw5crm.server.tenant.entity.QTwTenantDO;
import com.elitesland.tw.tw5crm.server.tenant.entity.TwTenantDO;
import com.elitesland.tw.tw5crm.server.tenant.repo.TwTenantRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class TwTenantDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final TwTenantRepo repo;
    private final QTwTenantDO qdo = QTwTenantDO.twTenantDO;

    private JPAQuery<TwTenantVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(TwTenantVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.tenantCode, this.qdo.tenantName, this.qdo.adminUserId, this.qdo.tenantType, this.qdo.inited, this.qdo.enabled, this.qdo.linkman, this.qdo.contactNumber, this.qdo.address, this.qdo.tenantIsolation, this.qdo.dbInitialized, this.qdo.databaseSourceId, this.qdo.schemaName, this.qdo.tenantDomain, this.qdo.customDomain, this.qdo.adminAccount, this.qdo.baseDataSyncId, this.qdo.industry, this.qdo.customer, this.qdo.sysTenantId})).from((EntityPath)this.qdo);
    }

    private JPAQuery<TwTenantVO> getJpaQueryWhere(TwTenantQuery query) {
        JPAQuery<TwTenantVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn((EntityPathBase)this.qdo, (List)query.getOrders()));
        return jpaQuery;
    }

    public long count(TwTenantQuery query) {
        long total = (Long)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo)).where(this.where(query))).fetchOne();
        return total;
    }

    private Predicate where(TwTenantQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTenantCode())) {
            list.add(this.qdo.tenantCode.eq((Object)query.getTenantCode()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTenantName())) {
            list.add(this.qdo.tenantName.like(SqlUtil.toSqlLikeString((String)query.getTenantName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAdminUserId())) {
            list.add(this.qdo.adminUserId.eq((Object)query.getAdminUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTenantType())) {
            list.add(this.qdo.tenantType.eq((Object)query.getTenantType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getInited())) {
            list.add(this.qdo.inited.eq(query.getInited()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getEnabled())) {
            list.add(this.qdo.enabled.eq(query.getEnabled()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getLinkman())) {
            list.add(this.qdo.linkman.like(SqlUtil.toSqlLikeString((String)query.getLinkman())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getContactNumber())) {
            list.add(this.qdo.contactNumber.like(SqlUtil.toSqlLikeString((String)query.getContactNumber())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAddress())) {
            list.add(this.qdo.address.like(SqlUtil.toSqlLikeString((String)query.getAddress())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTenantIsolation())) {
            list.add(this.qdo.tenantIsolation.eq((Object)query.getTenantIsolation()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDbInitialized())) {
            list.add(this.qdo.dbInitialized.eq(query.getDbInitialized()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDatabaseSourceId())) {
            list.add(this.qdo.databaseSourceId.eq((Object)query.getDatabaseSourceId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSchemaName())) {
            list.add(this.qdo.schemaName.eq((Object)query.getSchemaName()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTenantDomain())) {
            list.add(this.qdo.tenantDomain.like(SqlUtil.toSqlLikeString((String)query.getTenantDomain())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustomDomain())) {
            list.add(this.qdo.customDomain.like(SqlUtil.toSqlLikeString((String)query.getCustomDomain())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAdminAccount())) {
            list.add(this.qdo.adminAccount.eq((Object)query.getAdminAccount()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBaseDataSyncId())) {
            list.add(this.qdo.baseDataSyncId.eq((Object)query.getBaseDataSyncId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getIndustry())) {
            list.add(this.qdo.industry.eq((Object)query.getIndustry()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustomer())) {
            list.add(this.qdo.customer.eq((Object)query.getCustomer()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSysTenantId())) {
            list.add(this.qdo.sysTenantId.eq((Object)query.getSysTenantId()));
        }
        return ExpressionUtils.allOf(list);
    }

    public TwTenantVO queryByKey(Long id) {
        JPAQuery<TwTenantVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (TwTenantVO)jpaQuery.fetchFirst();
    }

    public List<TwTenantVO> queryListDynamic(TwTenantQuery query) {
        JPAQuery<TwTenantVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<TwTenantVO> queryPaging(TwTenantQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<TwTenantVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public TwTenantDO save(TwTenantDO ado) {
        return (TwTenantDO)this.repo.save(ado);
    }

    public List<TwTenantDO> saveAll(List<TwTenantDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(TwTenantPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getTenantCode() != null) {
            update.set((Path)this.qdo.tenantCode, (Object)payload.getTenantCode());
        }
        if (payload.getTenantName() != null) {
            update.set((Path)this.qdo.tenantName, (Object)payload.getTenantName());
        }
        if (payload.getAdminUserId() != null) {
            update.set(this.qdo.adminUserId, (Object)payload.getAdminUserId());
        }
        if (payload.getTenantType() != null) {
            update.set((Path)this.qdo.tenantType, (Object)payload.getTenantType());
        }
        if (payload.getInited() != null) {
            update.set((Path)this.qdo.inited, (Object)payload.getInited());
        }
        if (payload.getEnabled() != null) {
            update.set((Path)this.qdo.enabled, (Object)payload.getEnabled());
        }
        if (payload.getLinkman() != null) {
            update.set((Path)this.qdo.linkman, (Object)payload.getLinkman());
        }
        if (payload.getContactNumber() != null) {
            update.set((Path)this.qdo.contactNumber, (Object)payload.getContactNumber());
        }
        if (payload.getAddress() != null) {
            update.set((Path)this.qdo.address, (Object)payload.getAddress());
        }
        if (payload.getTenantIsolation() != null) {
            update.set((Path)this.qdo.tenantIsolation, (Object)payload.getTenantIsolation());
        }
        if (payload.getDbInitialized() != null) {
            update.set((Path)this.qdo.dbInitialized, (Object)payload.getDbInitialized());
        }
        if (payload.getDatabaseSourceId() != null) {
            update.set(this.qdo.databaseSourceId, (Object)payload.getDatabaseSourceId());
        }
        if (payload.getSchemaName() != null) {
            update.set((Path)this.qdo.schemaName, (Object)payload.getSchemaName());
        }
        if (payload.getTenantDomain() != null) {
            update.set((Path)this.qdo.tenantDomain, (Object)payload.getTenantDomain());
        }
        if (payload.getCustomDomain() != null) {
            update.set((Path)this.qdo.customDomain, (Object)payload.getCustomDomain());
        }
        if (payload.getAdminAccount() != null) {
            update.set((Path)this.qdo.adminAccount, (Object)payload.getAdminAccount());
        }
        if (payload.getBaseDataSyncId() != null) {
            update.set(this.qdo.baseDataSyncId, (Object)payload.getBaseDataSyncId());
        }
        if (payload.getIndustry() != null) {
            update.set((Path)this.qdo.industry, (Object)payload.getIndustry());
        }
        if (payload.getCustomer() != null) {
            update.set((Path)this.qdo.customer, (Object)payload.getCustomer());
        }
        if (payload.getSysTenantId() != null) {
            update.set(this.qdo.sysTenantId, (Object)payload.getSysTenantId());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("tenantCode")) {
                update.setNull((Path)this.qdo.tenantCode);
            }
            if (nullFields.contains("tenantName")) {
                update.setNull((Path)this.qdo.tenantName);
            }
            if (nullFields.contains("adminUserId")) {
                update.setNull(this.qdo.adminUserId);
            }
            if (nullFields.contains("tenantType")) {
                update.setNull((Path)this.qdo.tenantType);
            }
            if (nullFields.contains("inited")) {
                update.setNull((Path)this.qdo.inited);
            }
            if (nullFields.contains("enabled")) {
                update.setNull((Path)this.qdo.enabled);
            }
            if (nullFields.contains("linkman")) {
                update.setNull((Path)this.qdo.linkman);
            }
            if (nullFields.contains("contactNumber")) {
                update.setNull((Path)this.qdo.contactNumber);
            }
            if (nullFields.contains("address")) {
                update.setNull((Path)this.qdo.address);
            }
            if (nullFields.contains("tenantIsolation")) {
                update.setNull((Path)this.qdo.tenantIsolation);
            }
            if (nullFields.contains("dbInitialized")) {
                update.setNull((Path)this.qdo.dbInitialized);
            }
            if (nullFields.contains("databaseSourceId")) {
                update.setNull(this.qdo.databaseSourceId);
            }
            if (nullFields.contains("schemaName")) {
                update.setNull((Path)this.qdo.schemaName);
            }
            if (nullFields.contains("tenantDomain")) {
                update.setNull((Path)this.qdo.tenantDomain);
            }
            if (nullFields.contains("customDomain")) {
                update.setNull((Path)this.qdo.customDomain);
            }
            if (nullFields.contains("adminAccount")) {
                update.setNull((Path)this.qdo.adminAccount);
            }
            if (nullFields.contains("baseDataSyncId")) {
                update.setNull(this.qdo.baseDataSyncId);
            }
            if (nullFields.contains("industry")) {
                update.setNull((Path)this.qdo.industry);
            }
            if (nullFields.contains("customer")) {
                update.setNull((Path)this.qdo.customer);
            }
            if (nullFields.contains("sysTenantId")) {
                update.setNull(this.qdo.sysTenantId);
            }
        }
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public TwTenantDAO(JPAQueryFactory jpaQueryFactory, TwTenantRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

