/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.common.util.criticalPath;

import java.util.LinkedList;
import java.util.List;

public class Task {
    private String taskNumber;
    private String logic;
    private String relyPlanIds;
    private double earlyStartTime;
    private double earlyFinishTime;
    private double lateStartTime;
    private double lateFinishTime;
    private double dut;
    private double delayTime;
    private double slack;
    private String[] logicArray;
    private double[] earlyStartTimeArray;
    private double[] earlyFinishTimeArray;
    private double[] lateStartTimeArray;
    private double[] lateFinishTimeArray;
    private double[] dutArray;
    private double[] delayTimeArray;
    private double[] slackArray;
    private boolean isCalEST = false;
    private boolean isCalEFT = false;
    private boolean isCalLST = false;
    private boolean isCalLFT = false;
    private boolean isCalSlack = false;
    private boolean isCriticalPath = false;
    private List<Task> previousTasks = new LinkedList<Task>();
    private List<Task> nextTasks = new LinkedList<Task>();

    public void calculateET() {
        if (!this.isCalEST()) {
            double est = 0.0;
            boolean isTmp = false;
            if (this.getPreviousTasks().size() == 0) {
                this.earlyStartTime = est;
                this.isCalEST = true;
            } else {
                if ("FS".equals(this.logic)) {
                    for (Task previousTask : this.getPreviousTasks()) {
                        if (!(previousTask.getEarlyFinishTime() > est) || !previousTask.isCalEFT()) continue;
                        est = previousTask.getEarlyFinishTime();
                        isTmp = previousTask.isCalEFT();
                    }
                    est += this.getDelayTime();
                } else if ("FF".equals(this.logic)) {
                    for (Task previousTask : this.getPreviousTasks()) {
                        if (!(previousTask.getEarlyFinishTime() > est) || !previousTask.isCalEFT()) continue;
                        est = previousTask.getEarlyFinishTime();
                        isTmp = previousTask.isCalEFT();
                    }
                    est = est + this.getDelayTime() - this.getDut();
                } else if ("SS".equals(this.logic)) {
                    for (Task previousTask : this.getPreviousTasks()) {
                        if (!(previousTask.getEarlyStartTime() > est) || !previousTask.isCalEST()) continue;
                        est = previousTask.getEarlyStartTime();
                        isTmp = previousTask.isCalEST();
                    }
                    est += this.getDelayTime();
                } else if ("SF".equals(this.logic)) {
                    for (Task previousTask : this.getPreviousTasks()) {
                        if (!(previousTask.getEarlyStartTime() > est) || !previousTask.isCalEST()) continue;
                        est = previousTask.getEarlyStartTime();
                        isTmp = previousTask.isCalEST();
                    }
                    est = est - this.getDut() + this.getDelayTime();
                }
                if (isTmp) {
                    this.earlyStartTime = est;
                    this.isCalEST = true;
                }
            }
        }
        if (!this.isCalEFT() && this.isCalEST()) {
            this.earlyFinishTime = this.getEarlyStartTime() + this.getDut();
            this.isCalEFT = true;
        }
    }

    public void calculateLT() {
        if (!this.isCalLST()) {
            this.calculateLT(this.nextTasks, this);
        }
        if (!this.isCalLFT()) {
            this.calculateLT(this.nextTasks, this);
        }
    }

    public void calculateLT(List<Task> nextTasks, Task task) {
        double tmpSlack = 0.0;
        boolean isTmp = false;
        if (nextTasks.size() == 0) {
            if (task.isCalEST() && task.isCalEFT()) {
                task.lateFinishTime = task.getEarlyFinishTime();
                task.slack = 0.0;
                task.isCalLFT = true;
                task.isCalSlack = true;
                task.lateStartTime = task.getEarlyStartTime();
                task.slack = 0.0;
                task.isCalLST = true;
                task.isCalSlack = true;
            }
        } else {
            for (int i = 0; i < nextTasks.size(); ++i) {
                Task nextTask = nextTasks.get(i);
                if (!nextTask.isCalLFT()) {
                    return;
                }
                if (!nextTask.isCalLST()) {
                    return;
                }
                if (!nextTask.isCalSlack) continue;
                double _tmp = tmpSlack;
                if ("FS".equals(nextTask.logic) && nextTask.isCalEST() && task.isCalEFT()) {
                    _tmp = nextTask.getSlack() + nextTask.getEarlyStartTime() - task.getEarlyFinishTime() - nextTask.getDelayTime();
                    isTmp = true;
                } else if ("FF".equals(nextTask.logic) && nextTask.isCalEFT() && task.isCalEFT()) {
                    _tmp = nextTask.getSlack() + nextTask.getEarlyFinishTime() - task.getEarlyFinishTime() - nextTask.getDelayTime();
                    isTmp = true;
                } else if ("SF".equals(nextTask.logic) && nextTask.isCalEFT() && task.isCalEST()) {
                    _tmp = nextTask.getSlack() + nextTask.getEarlyFinishTime() - task.getEarlyStartTime() - nextTask.getDelayTime();
                    isTmp = true;
                } else if ("SS".equals(nextTask.logic) && nextTask.isCalEST() && task.isCalEST()) {
                    _tmp = nextTask.getSlack() + nextTask.getEarlyStartTime() - task.getEarlyStartTime() - nextTask.getDelayTime();
                    isTmp = true;
                }
                if (i == 0) {
                    tmpSlack = _tmp;
                }
                if (!(_tmp < tmpSlack)) continue;
                tmpSlack = _tmp;
            }
        }
        if (isTmp && task.isCalEST() && task.isCalEFT()) {
            task.lateFinishTime = task.getEarlyFinishTime() + tmpSlack;
            task.setSlack(tmpSlack);
            task.isCalLFT = true;
            task.isCalSlack = true;
            task.lateStartTime = task.getEarlyStartTime() + tmpSlack;
            task.setSlack(tmpSlack);
            task.isCalLST = true;
            task.isCalSlack = true;
        }
    }

    public Task(String taskNumber, String logic, double dut, double delayTime) {
        this.taskNumber = taskNumber;
        this.logic = logic;
        this.dut = dut;
        this.delayTime = delayTime;
    }

    public Task(String taskNumber, String logic, double dut, double delayTime, String relyPlanIds) {
        this.taskNumber = taskNumber;
        this.logic = logic;
        this.dut = dut;
        this.delayTime = delayTime;
        this.relyPlanIds = relyPlanIds;
    }

    public Task(String taskNumber, String[] logicArray, double[] dutArray, double[] delayTimeArray) {
        this.taskNumber = taskNumber;
        this.logicArray = logicArray;
        this.dutArray = dutArray;
        this.delayTimeArray = delayTimeArray;
    }

    public String getTaskNumber() {
        return this.taskNumber;
    }

    public double getDelayTime() {
        return this.delayTime;
    }

    public double getDut() {
        return this.dut;
    }

    public String getRelyPlanIds() {
        return this.relyPlanIds;
    }

    public double getEarlyFinishTime() {
        return this.earlyFinishTime;
    }

    public double getEarlyStartTime() {
        return this.earlyStartTime;
    }

    public double getLateFinishTime() {
        return this.lateFinishTime;
    }

    public double getLateStartTime() {
        return this.lateStartTime;
    }

    public double getSlack() {
        return this.slack;
    }

    public void setSlack(double slack) {
        this.slack = slack;
    }

    public boolean isCalEST() {
        return this.isCalEST;
    }

    public boolean isCalEFT() {
        return this.isCalEFT;
    }

    public boolean isCalLST() {
        return this.isCalLST;
    }

    public boolean isCalLFT() {
        return this.isCalLFT;
    }

    public boolean isCriticalPath() {
        return this.isCriticalPath;
    }

    public List<Task> getPreviousTasks() {
        return this.previousTasks;
    }

    public void setPreviousTasks(List<Task> previousTasks) {
        this.previousTasks = previousTasks;
        for (Task task : this.previousTasks) {
            task.getNextTasks().add(this);
        }
    }

    public List<Task> getNextTasks() {
        return this.nextTasks;
    }

    public void setCriticalPath() {
        if (this.isCalLST() && this.isCalEST() && this.getLateStartTime() - this.getEarlyStartTime() == 0.0) {
            this.isCriticalPath = true;
        }
    }
}

