/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.my.controller;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerOperationExcelExport;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.excel.ExcelUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import com.elitesland.tw.tw5pms.api.my.payload.TimesheetListPayload;
import com.elitesland.tw.tw5pms.api.my.payload.TimesheetPayload;
import com.elitesland.tw.tw5pms.api.my.query.TimesheetQuery;
import com.elitesland.tw.tw5pms.api.my.service.TimesheetService;
import com.elitesland.tw.tw5pms.api.my.vo.TimesheetExcel;
import com.elitesland.tw.tw5pms.server.my.convert.TimesheetConvert;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/pms/timesheet"})
public class TimesheetController {
    private static final Logger log = LoggerFactory.getLogger(TimesheetController.class);
    private final TimesheetService timesheetService;
    private final PrdSystemRoleDAO systemRoleDAO;
    private final UdcUtil udcUtil;

    @PostMapping(value={"/batchInsert"})
    public TwOutputUtil batchInsert(@RequestBody TimesheetListPayload payload) {
        return TwOutputUtil.ok((Object)this.timesheetService.batchInsert(payload));
    }

    @PutMapping
    public TwOutputUtil update(@RequestBody TimesheetPayload payload) {
        return TwOutputUtil.ok((Object)this.timesheetService.update(payload));
    }

    @GetMapping(value={"/{key}"})
    @UdcNameClass
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok((Object)this.timesheetService.queryByKey(key));
    }

    @GetMapping(value={"/paging"})
    @UdcNameClass
    public TwOutputUtil paging(TimesheetQuery query) {
        query.setIsPermission(Boolean.valueOf(true));
        PagingVO paging1 = this.timesheetService.paging(query);
        return TwOutputUtil.ok((Object)paging1);
    }

    @GetMapping(value={"/list"})
    @UdcNameClass
    public TwOutputUtil queryList(TimesheetQuery query) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        query.setTsUserId(loginUserId);
        return TwOutputUtil.ok((Object)this.timesheetService.queryList(query));
    }

    @GetMapping(value={"/getTimesheetOverview"})
    @UdcNameClass
    public TwOutputUtil getTimesheetOverview(TimesheetQuery query) {
        return TwOutputUtil.ok((Object)this.timesheetService.getTimesheetOverview(query));
    }

    @GetMapping(value={"/approving/count"})
    public TwOutputUtil approvingCount(TimesheetQuery query) {
        query.setApprUserId(GlobalUtil.getLoginUserId());
        long total = this.timesheetService.count(query);
        return TwOutputUtil.ok((Object)total);
    }

    @GetMapping(value={"/approving/paging"})
    @UdcNameClass
    public TwOutputUtil approvingPaging(TimesheetQuery query) {
        query.setIsPermission(Boolean.valueOf(false));
        this.approvingDataFilterQuery(query);
        OrderItem orderItem = OrderItem.desc((String)"workDate");
        query.setOrders(Arrays.asList(orderItem));
        return TwOutputUtil.ok((Object)this.timesheetService.paging(query));
    }

    @GetMapping(value={"/approving/pagingGroup"})
    @UdcNameClass
    public TwOutputUtil approvingPagingGroup(TimesheetQuery query) {
        this.approvingDataFilterQuery(query);
        return TwOutputUtil.ok((Object)this.timesheetService.pagingGroup(query));
    }

    @GetMapping(value={"/approving/exportList"})
    public void exportList(TimesheetQuery query, HttpServletResponse response) throws IOException {
        String sheetName = "\u5de5\u4f5c\u65e5\u5fd7\u5ba1\u6279";
        OrderItem orderItem = OrderItem.asc((String)"createTime");
        query.defaultOrder(orderItem);
        this.approvingDataFilterQuery(query);
        List list = this.timesheetService.queryList(query);
        list = this.udcUtil.translateList(list);
        List<TimesheetExcel> excelList = TimesheetConvert.INSTANCE.voListVoExcelExport(list);
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
        ExcelWriterSheetBuilder sheet = ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), CrmCustomerOperationVO.class).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet(sheetName);
        ExcelUtil.excelHelper((ExcelWriterSheetBuilder)sheet, TimesheetExcel.class, null);
        sheet.doWrite(excelList);
    }

    @GetMapping(value={"/approving/exportListGroup"})
    public void exportListGroup(TimesheetQuery query, HttpServletResponse response) throws IOException {
        String sheetName = "\u5de5\u4f5c\u65e5\u5fd7\u5ba1\u6279";
        OrderItem orderItem = OrderItem.asc((String)"createTime");
        query.defaultOrder(orderItem);
        this.approvingDataFilterQuery(query);
        List list = this.timesheetService.listGroup(query);
        list = this.udcUtil.translateList(list);
        List<TimesheetExcel> excelList = TimesheetConvert.INSTANCE.voListVoExcelExport(list);
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
        ExcelWriterSheetBuilder sheet = ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), CrmCustomerOperationVO.class).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet(sheetName);
        ExcelUtil.excelHelper((ExcelWriterSheetBuilder)sheet, CrmCustomerOperationExcelExport.class, null);
        sheet.doWrite(excelList);
    }

    private void approvingDataFilterQuery(TimesheetQuery query) {
        List userIdsByRole;
        Long loginUserId = GlobalUtil.getLoginUserId();
        boolean isSystemAdmin = GlobalUtil.getLoginGeneralUser().isSystemAdmin();
        boolean isAdmin = "admin_pms".equals(GlobalUtil.getLoginGeneralUser().getUsername());
        if (!(isSystemAdmin || isAdmin || !CollectionUtils.isEmpty((Collection)(userIdsByRole = this.systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.TIME_SHEET_APPROVAL_MANAGER.getCode())))) && userIdsByRole.contains(loginUserId))) {
            query.setApprUserId(loginUserId);
        }
    }

    @PostMapping(value={"/approving/revoked"})
    public TwOutputUtil revoked(Long[] keys) {
        this.timesheetService.revoked(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/updateApprUserId"})
    public TwOutputUtil updateApprUserId(Long[] keys, Long apprUserId) {
        if (ObjectUtils.isEmpty((Object)apprUserId)) {
            throw TwException.error((String)"", (String)"\u5ba1\u6279\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        boolean isSystemAdmin = GlobalUtil.getLoginGeneralUser().isSystemAdmin();
        boolean isAdmin = "admin_pms".equals(GlobalUtil.getLoginGeneralUser().getUsername());
        if (isSystemAdmin || isAdmin) {
            this.timesheetService.updateApprUserId(Arrays.asList(keys), apprUserId);
            return TwOutputUtil.ok();
        }
        throw TwException.error((String)"", (String)"\u53ea\u6709\u7ba1\u7406\u5458\u624d\u53ef\u4ee5\u8fdb\u884c\u5de5\u65f6\u66f4\u6539\u5ba1\u6279\u4eba\uff01");
    }

    @PostMapping(value={"/approving/approved"})
    public TwOutputUtil toApproved(Long[] keys) {
        this.timesheetService.toApproved(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/approving/rejected"})
    public TwOutputUtil rejected(Long[] keys, String apprResult) {
        this.timesheetService.rejected(Arrays.asList(keys), apprResult);
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/approving/approvedPro"})
    public TwOutputUtil approvedPro(Long[] keys) {
        this.timesheetService.toAdvanced(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @DeleteMapping(value={"/deleteSoft"})
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.timesheetService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    public TimesheetController(TimesheetService timesheetService, PrdSystemRoleDAO systemRoleDAO, UdcUtil udcUtil) {
        this.timesheetService = timesheetService;
        this.systemRoleDAO = systemRoleDAO;
        this.udcUtil = udcUtil;
    }
}

