/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.project.controller;

import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5pms.api.project.payload.PmsProjectCalendarPayload;
import com.elitesland.tw.tw5pms.api.project.service.PmsProjectCalendarService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u9879\u76ee\u5de5\u4f5c\u65e5\u5386"})
@RestController
@RequestMapping(value={"/api/pms/projectCalendar"})
public class PmsProjectCalendarController {
    private static final Logger log = LoggerFactory.getLogger(PmsProjectCalendarController.class);
    private final PmsProjectCalendarService calendarService;

    @PostMapping
    @ApiOperation(value="\u65b0\u589e\u5de5\u4f5c\u65e5\u5386")
    public TwOutputUtil insert(@RequestBody PmsProjectCalendarPayload payload) {
        this.calendarService.saveData(payload);
        return TwOutputUtil.ok();
    }

    @PutMapping
    @ApiOperation(value="\u66f4\u65b0\u5de5\u4f5c\u65e5\u5386")
    public TwOutputUtil update(@RequestBody PmsProjectCalendarPayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getId())) {
            throw TwException.error((String)"", (String)"\u4e3b\u952e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        this.calendarService.saveData(payload);
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/getCarryoverInformation"})
    @ApiOperation(value="\u67e5\u770b\u5de5\u4f5c\u65e5\u5386")
    public TwOutputUtil getCarryoverInformation(@RequestBody PmsProjectCalendarPayload payload) {
        return TwOutputUtil.ok((Object)this.calendarService.findBySource(payload));
    }

    @GetMapping(value={"/restoreDefault"})
    @ApiOperation(value="\u6062\u590d\u9ed8\u8ba4\u65e5\u5386")
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.calendarService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    public PmsProjectCalendarController(PmsProjectCalendarService calendarService) {
        this.calendarService = calendarService;
    }
}

