/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.project.controller;

import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.annotation.ReSubmitCheck;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5pms.api.project.payload.PmsProjectPayload;
import com.elitesland.tw.tw5pms.api.project.query.PmsProjectQuery;
import com.elitesland.tw.tw5pms.api.project.service.PmsProjectService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u9879\u76ee"})
@RestController
@RequestMapping(value={"/api/pms/project"})
public class PmsProjectController {
    private static final Logger log = LoggerFactory.getLogger(PmsProjectController.class);
    private final PmsProjectService pmsProjectService;

    @PostMapping
    @ApiOperation(value="\u65b0\u589e")
    @ReSubmitCheck(argExpressions={"[0].id", "[0].projectName"})
    public TwOutputUtil insert(@RequestBody PmsProjectPayload payload) {
        return TwOutputUtil.ok((Object)this.pmsProjectService.insert(payload));
    }

    @PutMapping
    @ApiOperation(value="\u66f4\u65b0")
    public TwOutputUtil update(@RequestBody PmsProjectPayload payload) {
        return TwOutputUtil.ok((Object)this.pmsProjectService.update(payload));
    }

    @GetMapping(value={"/{key}"})
    @ApiOperation(value="\u4e3b\u952e\u67e5\u8be2")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok((Object)this.pmsProjectService.queryByKey(key));
    }

    @GetMapping(value={"/submitStartProject/{key}"})
    @ApiOperation(value="\u63d0\u4ea4\u7acb\u9879\u6d41\u7a0b")
    public TwOutputUtil submitStartProject(@PathVariable Long key) {
        this.pmsProjectService.submitStartProject(key);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/paging"})
    @ApiOperation(value="\u5206\u9875")
    public TwOutputUtil paging(PmsProjectQuery query) {
        return TwOutputUtil.ok((Object)this.pmsProjectService.queryPaging(query));
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    public TwOutputUtil queryList(PmsProjectQuery query) {
        query.setLoginUserId(GlobalUtil.getLoginUserId());
        return TwOutputUtil.ok((Object)this.pmsProjectService.queryListDynamic(query));
    }

    @DeleteMapping(value={"/deleteSoft"})
    @ApiOperation(value="\u5220\u9664")
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.pmsProjectService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @PutMapping(value={"/updateWorkflowProject"})
    @ApiOperation(value="\u6267\u884c\u6d41\u7a0b\u5185\u6570\u636e\u53d8\u66f4")
    public TwOutputUtil updateWorkflowProject(@RequestBody PmsProjectPayload payload) {
        this.pmsProjectService.updateWorkflowProject(payload);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/queryUseTaskList"})
    @ApiOperation(value="\u4efb\u52a1\u5305\u521b\u5efa\u67e5\u8be2\u53ef\u7528\u9879\u76ee\u67e5\u8be2\u5217\u8868")
    public TwOutputUtil queryUseTaskList(PmsProjectQuery query) {
        return TwOutputUtil.ok((Object)this.pmsProjectService.queryUseTaskList(query));
    }

    @GetMapping(value={"/queryUseAuthorizeList"})
    @ApiOperation(value="\u7528\u4f5c\u6388\u6743\u7684\u9879\u76ee\u5217\u8868")
    public TwOutputUtil queryUseAuthorizeList(PmsProjectQuery query) {
        return TwOutputUtil.ok((Object)this.pmsProjectService.queryUseAuthorizeList(query));
    }

    @GetMapping(value={"/queryProjectEqva"})
    @ApiOperation(value="\u67e5\u8be2\u9879\u76ee\u5f53\u91cf\u6d3e\u53d1\u60c5\u51b5")
    public TwOutputUtil queryProjectEqva(Long key) {
        return TwOutputUtil.ok((Object)this.pmsProjectService.queryProjectEqva(key));
    }

    public PmsProjectController(PmsProjectService pmsProjectService) {
        this.pmsProjectService = pmsProjectService;
    }
}

