/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.project.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.QBaseModel;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5pms.api.project.payload.PmsBudgetSubjectPayload;
import com.elitesland.tw.tw5pms.api.project.query.PmsBudgetSubjectQuery;
import com.elitesland.tw.tw5pms.api.project.vo.PmsBudgetSubjectVO;
import com.elitesland.tw.tw5pms.server.project.entity.PmsBudgetSubjectDO;
import com.elitesland.tw.tw5pms.server.project.entity.QPmsBudgetSubjectDO;
import com.elitesland.tw.tw5pms.server.project.repo.PmsBudgetSubjectRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class PmsBudgetSubjectDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PmsBudgetSubjectRepo repo;
    private final QPmsBudgetSubjectDO qdo = QPmsBudgetSubjectDO.pmsBudgetSubjectDO;

    private JPAQuery<PmsBudgetSubjectVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PmsBudgetSubjectVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remark, this.qdo.createTime, this.qdo.subjectCode, this.qdo.subjectName, this.qdo.parentId, this.qdo.parentName, this.qdo.subjectLevel, this.qdo.subjectStatus})).from((EntityPath)this.qdo);
    }

    private JPAQuery<PmsBudgetSubjectVO> getJpaQueryWhere(PmsBudgetSubjectQuery query) {
        JPAQuery<PmsBudgetSubjectVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        jpaQuery.orderBy(SqlUtil.getSortedColumn((EntityPathBase)this.qdo, (List)query.getOrders()));
        return jpaQuery;
    }

    public long count(PmsBudgetSubjectQuery query) {
        long total = (Long)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo)).where(this.where(query))).fetchOne();
        return total;
    }

    private Predicate where(PmsBudgetSubjectQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getSubjectCode())) {
            list.add(this.qdo.subjectCode.like(SqlUtil.toSqlLikeString((String)query.getSubjectCode())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSubjectName())) {
            list.add(this.qdo.subjectName.like(SqlUtil.toSqlLikeString((String)query.getSubjectName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSubjectLevel())) {
            list.add(this.qdo.subjectLevel.eq((Object)query.getSubjectLevel()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSubjectIds())) {
            list.add(this.qdo.id.in((Collection)query.getSubjectIds()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSubjectStatus())) {
            list.add(this.qdo.subjectStatus.eq((Object)query.getSubjectStatus()));
        }
        return ExpressionUtils.allOf(list);
    }

    public PmsBudgetSubjectVO queryByKey(Long id) {
        JPAQuery<PmsBudgetSubjectVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PmsBudgetSubjectVO)jpaQuery.fetchFirst();
    }

    public PmsBudgetSubjectVO queryByCode(String subjectCode) {
        JPAQuery<PmsBudgetSubjectVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.subjectCode.eq((Object)subjectCode));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PmsBudgetSubjectVO)jpaQuery.fetchFirst();
    }

    public PmsBudgetSubjectVO queryByName(String subjectName) {
        JPAQuery<PmsBudgetSubjectVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.subjectName.eq((Object)subjectName));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PmsBudgetSubjectVO)jpaQuery.fetchFirst();
    }

    public List<PmsBudgetSubjectVO> queryListDynamic(PmsBudgetSubjectQuery query) {
        JPAQuery<PmsBudgetSubjectVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<PmsBudgetSubjectVO> queryPaging(PmsBudgetSubjectQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<PmsBudgetSubjectVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public PmsBudgetSubjectDO save(PmsBudgetSubjectDO ado) {
        return (PmsBudgetSubjectDO)this.repo.save(ado);
    }

    public List<PmsBudgetSubjectDO> saveAll(List<PmsBudgetSubjectDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(PmsBudgetSubjectPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getSubjectCode() != null) {
            update.set((Path)this.qdo.subjectCode, (Object)payload.getSubjectCode());
        }
        if (payload.getSubjectName() != null) {
            update.set((Path)this.qdo.subjectName, (Object)payload.getSubjectName());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("subjectCode")) {
                update.setNull((Path)this.qdo.subjectCode);
            }
            if (nullFields.contains("subjectName")) {
                update.setNull((Path)this.qdo.subjectName);
            }
        }
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys).or((Predicate)this.qdo.parentId.in(keys))});
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long updateSubjectStatus(Long[] keys, Integer subjectStatus) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.subjectStatus, (Object)subjectStatus).where(new Predicate[]{this.qdo.id.in((Object[])keys).or((Predicate)this.qdo.parentId.in((Object[])keys))});
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public PmsBudgetSubjectDAO(JPAQueryFactory jpaQueryFactory, PmsBudgetSubjectRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

