/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.project.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.QBaseModel;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5pms.api.project.payload.PmsBudgetTemplateSubjectPayload;
import com.elitesland.tw.tw5pms.api.project.query.PmsBudgetTemplateSubjectQuery;
import com.elitesland.tw.tw5pms.api.project.vo.PmsBudgetTemplateSubjectVO;
import com.elitesland.tw.tw5pms.server.project.entity.PmsBudgetTemplateSubjectDO;
import com.elitesland.tw.tw5pms.server.project.entity.QPmsBudgetSubjectDO;
import com.elitesland.tw.tw5pms.server.project.entity.QPmsBudgetTemplateSubjectDO;
import com.elitesland.tw.tw5pms.server.project.repo.PmsBudgetTemplateSubjectRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class PmsBudgetTemplateSubjectDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PmsBudgetTemplateSubjectRepo repo;
    private final QPmsBudgetTemplateSubjectDO qdo = QPmsBudgetTemplateSubjectDO.pmsBudgetTemplateSubjectDO;
    private final QPmsBudgetSubjectDO qSdo = QPmsBudgetSubjectDO.pmsBudgetSubjectDO;

    private JPAQuery<PmsBudgetTemplateSubjectVO> getJpaQuerySelect() {
        return (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PmsBudgetTemplateSubjectVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.templateId, this.qdo.subjectId, this.qSdo.subjectCode, this.qSdo.subjectName, this.qSdo.parentName, this.qSdo.parentId, this.qSdo.subjectStatus, this.qSdo.subjectLevel, this.qSdo.remark})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qSdo)).on((Predicate)this.qSdo.id.eq(this.qdo.subjectId));
    }

    private JPAQuery<PmsBudgetTemplateSubjectVO> getJpaQueryWhere(PmsBudgetTemplateSubjectQuery query) {
        JPAQuery<PmsBudgetTemplateSubjectVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        jpaQuery.where((Predicate)this.qSdo.deleteFlag.eq((Object)0));
        SqlUtil.handleCommonJpaQuery(jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn((EntityPathBase)this.qdo, (List)query.getOrders()));
        return jpaQuery;
    }

    public long count(PmsBudgetTemplateSubjectQuery query) {
        long total = (Long)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo)).where(this.where(query))).fetchOne();
        return total;
    }

    private Predicate where(PmsBudgetTemplateSubjectQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTemplateId())) {
            list.add(this.qdo.templateId.eq((Object)query.getTemplateId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSubjectId())) {
            list.add(this.qdo.subjectId.eq((Object)query.getSubjectId()));
        }
        return ExpressionUtils.allOf(list);
    }

    public PmsBudgetTemplateSubjectVO queryByKey(Long id) {
        JPAQuery<PmsBudgetTemplateSubjectVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PmsBudgetTemplateSubjectVO)jpaQuery.fetchFirst();
    }

    public List<PmsBudgetTemplateSubjectVO> queryListDynamic(PmsBudgetTemplateSubjectQuery query) {
        JPAQuery<PmsBudgetTemplateSubjectVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<PmsBudgetTemplateSubjectVO> queryPaging(PmsBudgetTemplateSubjectQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<PmsBudgetTemplateSubjectVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public PmsBudgetTemplateSubjectDO save(PmsBudgetTemplateSubjectDO ado) {
        return (PmsBudgetTemplateSubjectDO)this.repo.save(ado);
    }

    public List<PmsBudgetTemplateSubjectDO> saveAll(List<PmsBudgetTemplateSubjectDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(PmsBudgetTemplateSubjectPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getTemplateId() != null) {
            update.set(this.qdo.templateId, (Object)payload.getTemplateId());
        }
        if (payload.getSubjectId() != null) {
            update.set(this.qdo.subjectId, (Object)payload.getSubjectId());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("templateId")) {
                update.setNull(this.qdo.templateId);
            }
            if (nullFields.contains("subjectId")) {
                update.setNull(this.qdo.subjectId);
            }
        }
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long deleteSoftByTemplateIds(List<Long> templateIds) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.templateId.in(templateIds)});
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long deleteSoftBySubjectIds(List<Long> subjectIds) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.subjectId.in(subjectIds)});
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long deleteSoftByTemplateId(Long templateId) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.templateId.eq((Object)templateId)});
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public List<PmsBudgetTemplateSubjectVO> queryByTemplateId(Long templateId) {
        JPAQuery<PmsBudgetTemplateSubjectVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.templateId.eq((Object)templateId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        jpaQuery.where((Predicate)this.qSdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public List<PmsBudgetTemplateSubjectVO> queryByBySubjectId(Long subjectId) {
        JPAQuery<PmsBudgetTemplateSubjectVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.subjectId.eq((Object)subjectId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public PmsBudgetTemplateSubjectVO queryBySubjectNameAndTemplateId(PmsBudgetTemplateSubjectPayload payload) {
        JPAQuery<PmsBudgetTemplateSubjectVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.subjectId.eq((Object)payload.getSubjectId()));
        jpaQuery.where((Predicate)this.qdo.templateId.eq((Object)payload.getTemplateId()));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        jpaQuery.where((Predicate)this.qSdo.deleteFlag.eq((Object)0));
        return (PmsBudgetTemplateSubjectVO)jpaQuery.fetchFirst();
    }

    public PmsBudgetTemplateSubjectDAO(JPAQueryFactory jpaQueryFactory, PmsBudgetTemplateSubjectRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

