/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.project.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.QBaseModel;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5pms.api.project.payload.PmsWbsActPayPayload;
import com.elitesland.tw.tw5pms.api.project.query.PmsWbsActPayQuery;
import com.elitesland.tw.tw5pms.api.project.vo.PmsWbsActPayVO;
import com.elitesland.tw.tw5pms.server.project.entity.PmsWbsActPayDO;
import com.elitesland.tw.tw5pms.server.project.entity.QPmsWbsActPayDO;
import com.elitesland.tw.tw5pms.server.project.repo.PmsWbsActPayRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class PmsWbsActPayDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PmsWbsActPayRepo repo;
    private final QPmsWbsActPayDO qdo = QPmsWbsActPayDO.pmsWbsActPayDO;

    private JPAQuery<PmsWbsActPayVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PmsWbsActPayVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.projectId, this.qdo.wbsId, this.qdo.wbsName, this.qdo.payName, this.qdo.payTypeName, this.qdo.payType})).from((EntityPath)this.qdo);
    }

    private JPAQuery<PmsWbsActPayVO> getJpaQueryWhere(PmsWbsActPayQuery query) {
        JPAQuery<PmsWbsActPayVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn((EntityPathBase)this.qdo, (List)query.getOrders()));
        return jpaQuery;
    }

    public long count(PmsWbsActPayQuery query) {
        long total = (Long)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo)).where(this.where(query))).fetchOne();
        return total;
    }

    private Predicate where(PmsWbsActPayQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjectId())) {
            list.add(this.qdo.projectId.eq((Object)query.getProjectId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getWbsId())) {
            list.add(this.qdo.wbsId.eq((Object)query.getWbsId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getWbsName())) {
            list.add(this.qdo.wbsName.like(SqlUtil.toSqlLikeString((String)query.getWbsName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPayName())) {
            list.add(this.qdo.payName.like(SqlUtil.toSqlLikeString((String)query.getPayName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPayType())) {
            list.add(this.qdo.payType.eq((Object)query.getPayType()));
        }
        return ExpressionUtils.allOf(list);
    }

    public PmsWbsActPayVO queryByKey(Long id) {
        JPAQuery<PmsWbsActPayVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PmsWbsActPayVO)jpaQuery.fetchFirst();
    }

    public List<PmsWbsActPayVO> queryByProjectId(Long ProjectId) {
        JPAQuery<PmsWbsActPayVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.projectId.eq((Object)ProjectId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public List<PmsWbsActPayVO> queryByWbsId(Long wbsId) {
        JPAQuery<PmsWbsActPayVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.wbsId.eq((Object)wbsId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public List<PmsWbsActPayVO> queryListDynamic(PmsWbsActPayQuery query) {
        JPAQuery<PmsWbsActPayVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<PmsWbsActPayVO> queryPaging(PmsWbsActPayQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<PmsWbsActPayVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public PmsWbsActPayDO save(PmsWbsActPayDO ado) {
        return (PmsWbsActPayDO)this.repo.save(ado);
    }

    public List<PmsWbsActPayDO> saveAll(List<PmsWbsActPayDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(PmsWbsActPayPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getProjectId() != null) {
            update.set(this.qdo.projectId, (Object)payload.getProjectId());
        }
        if (payload.getWbsId() != null) {
            update.set(this.qdo.wbsId, (Object)payload.getWbsId());
        }
        if (payload.getWbsName() != null) {
            update.set((Path)this.qdo.wbsName, (Object)payload.getWbsName());
        }
        if (payload.getPayName() != null) {
            update.set((Path)this.qdo.payName, (Object)payload.getPayName());
        }
        if (payload.getPayType() != null) {
            update.set((Path)this.qdo.payType, (Object)payload.getPayType());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("projectId")) {
                update.setNull(this.qdo.projectId);
            }
            if (nullFields.contains("wbsId")) {
                update.setNull(this.qdo.wbsId);
            }
            if (nullFields.contains("wbsName")) {
                update.setNull((Path)this.qdo.wbsName);
            }
            if (nullFields.contains("payName")) {
                update.setNull((Path)this.qdo.payName);
            }
            if (nullFields.contains("payType")) {
                update.setNull((Path)this.qdo.payType);
            }
        }
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long deleteSoftByWbsIds(List<Long> wbsIds) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.wbsId.in(wbsIds)});
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public PmsWbsActPayDAO(JPAQueryFactory jpaQueryFactory, PmsWbsActPayRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

