/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.project.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.workFlow.WorkflowUtil;
import com.elitesland.tw.tw5pms.api.project.payload.PmsBudgetAppropriateDetailPayload;
import com.elitesland.tw.tw5pms.api.project.payload.PmsBudgetAppropriatePayload;
import com.elitesland.tw.tw5pms.api.project.payload.PmsBudgetPayload;
import com.elitesland.tw.tw5pms.api.project.query.PmsBudgetAppropriateQuery;
import com.elitesland.tw.tw5pms.api.project.service.PmsBudgetAppropriateService;
import com.elitesland.tw.tw5pms.api.project.service.PmsBudgetCommonService;
import com.elitesland.tw.tw5pms.api.project.service.PmsBudgetService;
import com.elitesland.tw.tw5pms.api.project.vo.PmsBudgetAppropriateDetailVO;
import com.elitesland.tw.tw5pms.api.project.vo.PmsBudgetAppropriateVO;
import com.elitesland.tw.tw5pms.api.project.vo.PmsBudgetDetailPlanVO;
import com.elitesland.tw.tw5pms.api.project.vo.PmsBudgetDetailSubjectVO;
import com.elitesland.tw.tw5pms.api.project.vo.PmsBudgetVO;
import com.elitesland.tw.tw5pms.api.project.vo.PmsProjectVO;
import com.elitesland.tw.tw5pms.server.common.functionEnum.BudgetStatusEnum;
import com.elitesland.tw.tw5pms.server.common.functionEnum.ProjectStatusEnum;
import com.elitesland.tw.tw5pms.server.project.convert.PmsBudgetAppropriateConvert;
import com.elitesland.tw.tw5pms.server.project.convert.PmsBudgetAppropriateDetailConvert;
import com.elitesland.tw.tw5pms.server.project.dao.PmsBudgetAppropriateDAO;
import com.elitesland.tw.tw5pms.server.project.dao.PmsBudgetAppropriateDetailDAO;
import com.elitesland.tw.tw5pms.server.project.dao.PmsBudgetCommonDao;
import com.elitesland.tw.tw5pms.server.project.dao.PmsBudgetDAO;
import com.elitesland.tw.tw5pms.server.project.dao.PmsBudgetDetailPlanDAO;
import com.elitesland.tw.tw5pms.server.project.dao.PmsProjectDAO;
import com.elitesland.tw.tw5pms.server.project.entity.PmsBudgetAppropriateDO;
import com.elitesland.tw.tw5pms.server.project.repo.PmsBudgetAppropriateDetailRepo;
import com.elitesland.tw.tw5pms.server.project.repo.PmsBudgetAppropriateRepo;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class PmsBudgetAppropriateServiceImpl
extends BaseServiceImpl
implements PmsBudgetAppropriateService {
    private static final Logger log = LoggerFactory.getLogger(PmsBudgetAppropriateServiceImpl.class);
    private final PmsBudgetAppropriateRepo pmsBudgetAppropriateRepo;
    private final PmsBudgetAppropriateDAO pmsBudgetAppropriateDAO;
    private final PmsBudgetAppropriateDetailRepo pmsBudgetAppropriateDetailRepo;
    private final WorkflowUtil workflowUtil;
    private final PmsBudgetDAO pmsBudgetDAO;
    private final PmsBudgetDetailPlanDAO pmsBudgetDetailPlanDAO;
    private final PmsBudgetCommonDao pmsBudgetCommonDao;
    private final PmsBudgetAppropriateDetailDAO pmsBudgetAppropriateDetailDAO;
    private final PmsProjectDAO projectDAO;
    private final PmsBudgetService pmsBudgetService;
    private final TransactionUtilService transactionUtilService;
    private final PmsBudgetCommonService pmsBudgetCommonService;

    public PagingVO<PmsBudgetAppropriateVO> queryPaging(PmsBudgetAppropriateQuery query) {
        return this.pmsBudgetAppropriateDAO.queryPaging(query);
    }

    public List<PmsBudgetAppropriateVO> queryListDynamic(PmsBudgetAppropriateQuery query) {
        return this.pmsBudgetAppropriateDAO.queryListDynamic(query);
    }

    public PmsBudgetAppropriateVO queryByKey(Long key) {
        PmsBudgetAppropriateDO entity = this.pmsBudgetAppropriateRepo.findById(key).orElseGet(PmsBudgetAppropriateDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PmsBudgetAppropriateVO vo = PmsBudgetAppropriateConvert.INSTANCE.toVo(entity);
        return vo;
    }

    public PmsBudgetVO queryBudgetByKey(Long key) {
        List planList;
        PmsBudgetAppropriateDO entity = this.pmsBudgetAppropriateRepo.findById(key).orElseGet(PmsBudgetAppropriateDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        List<PmsBudgetAppropriateDetailVO> detailList = this.pmsBudgetAppropriateDetailDAO.queryByAppropriateId(key);
        HashMap<Long, PmsBudgetAppropriateDetailVO> subjectInfo = new HashMap<Long, PmsBudgetAppropriateDetailVO>();
        HashMap<Long, PmsBudgetAppropriateDetailVO> planInfo = new HashMap<Long, PmsBudgetAppropriateDetailVO>();
        for (PmsBudgetAppropriateDetailVO detail : detailList) {
            if ("0".equals(detail.getBudgetDetailType())) {
                subjectInfo.put(detail.getBudgetDetailId(), detail);
                continue;
            }
            if (!"1".equals(detail.getBudgetDetailType())) continue;
            planInfo.put(detail.getBudgetDetailId(), detail);
        }
        PmsBudgetVO budgetVO = this.pmsBudgetService.queryByProjectId(entity.getProjectId());
        budgetVO.setTotalMoney(entity.getTotalMoney());
        budgetVO.setPaidMoney(entity.getPaidMoney());
        budgetVO.setUsedMoney(entity.getUsedMoney());
        budgetVO.setAppropriationProportion(entity.getAppropriationProportion());
        budgetVO.setAppropriationCode(entity.getAppropriationCode());
        budgetVO.setRemark(entity.getRemark());
        List subjectList = budgetVO.getSubjectList();
        if (!ObjectUtils.isEmpty((Object)subjectList)) {
            for (PmsBudgetDetailSubjectVO object : subjectList) {
                PmsBudgetAppropriateDetailVO detailVO = (PmsBudgetAppropriateDetailVO)subjectInfo.get(object.getId());
                if (ObjectUtils.isEmpty((Object)detailVO)) continue;
                object.setApplicationAmount(detailVO.getApplicationAmount());
                object.setPaidMoney(detailVO.getPaidMoney());
                object.setResidueMoney(detailVO.getResidueMoney());
                object.setRemainingBudgetMoney(detailVO.getRemainingBudgetMoney());
                object.setMayApplyMoney(detailVO.getTotalMoney().subtract(detailVO.getPaidMoney()));
            }
        }
        if (!ObjectUtils.isEmpty((Object)(planList = budgetVO.getPlanList()))) {
            for (PmsBudgetDetailPlanVO object : planList) {
                PmsBudgetAppropriateDetailVO detailVO = (PmsBudgetAppropriateDetailVO)planInfo.get(object.getId());
                if (ObjectUtils.isEmpty((Object)detailVO)) continue;
                object.setApplicationAmount(detailVO.getApplicationAmount());
                object.setPaidMoney(detailVO.getPaidMoney());
                object.setResidueMoney(detailVO.getResidueMoney());
                object.setRemainingBudgetMoney(detailVO.getRemainingBudgetMoney());
                object.setMayApplyMoney(detailVO.getTotalMoney().subtract(detailVO.getPaidMoney()));
            }
        }
        return budgetVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsBudgetAppropriateVO insert(PmsBudgetAppropriatePayload payload) {
        Long projectId = payload.getProjectId();
        if (ObjectUtils.isEmpty((Object)projectId)) {
            throw TwException.error((String)"", (String)"\u5173\u8054\u9879\u76ee \u4e0d\u80fd\u4e3a\u7a7a");
        }
        PmsProjectVO projectVO = this.projectDAO.queryByKey(projectId);
        if (ObjectUtils.isEmpty((Object)projectVO)) {
            throw TwException.error((String)"", (String)"\u5173\u8054\u9879\u76ee\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        Boolean payment = true;
        if (payload.getQuickPayment().booleanValue()) {
            PmsBudgetVO budgetVO = this.pmsBudgetDAO.queryByProjectId(payload.getProjectId());
            if (!BudgetStatusEnum.APPROVED.getCode().equals(budgetVO.getBudgetStatus())) {
                payment = false;
            }
        }
        if (payment.booleanValue()) {
            payload.setAppropriationCode(this.generateSeqNum("PMS_BUDGET_APPROPRIATE", new String[0]));
            payload.setAppropriationStatus(BudgetStatusEnum.APPROVING.getCode());
            BigDecimal applicationAmount = new BigDecimal(0.0);
            ArrayList detailPayloadList = new ArrayList();
            List list2 = payload.getDetailPayloadList();
            payload = this.countSubjectInfo(payload, applicationAmount);
            detailPayloadList.addAll(payload.getDetailPayloadList());
            payload.setDetailPayloadList(list2);
            payload = this.countPlanInfo(payload, payload.getAppropriationAmount());
            detailPayloadList.addAll(payload.getDetailPayloadList());
            PmsBudgetAppropriateDO entityDo = PmsBudgetAppropriateConvert.INSTANCE.toDo(payload);
            PmsBudgetAppropriateVO vo = PmsBudgetAppropriateConvert.INSTANCE.toVo((PmsBudgetAppropriateDO)this.pmsBudgetAppropriateRepo.save(entityDo));
            for (PmsBudgetAppropriateDetailPayload detailPayload : detailPayloadList) {
                detailPayload.setBudgetAppropriateId(vo.getId());
                this.pmsBudgetAppropriateDetailRepo.save(PmsBudgetAppropriateDetailConvert.INSTANCE.toDo(detailPayload));
            }
            if (payload.getSubmit().booleanValue()) {
                PmsBudgetAppropriatePayload finalPayload = payload;
                finalPayload.setDetailPayloadList(detailPayloadList);
                this.transactionUtilService.executeWithRunnable(() -> {
                    finalPayload.setId(vo.getId());
                    this.submitWorkFlow(finalPayload);
                    this.pmsBudgetService.appropriateCallBack(vo, ProcInstStatus.APPROVED);
                    PmsBudgetAppropriatePayload appropriatePayload = new PmsBudgetAppropriatePayload();
                    appropriatePayload.setId(vo.getId());
                    appropriatePayload.setAppropriationStatus(ProjectStatusEnum.APPROVED.getCode());
                    appropriatePayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    appropriatePayload.setApprovedTime(LocalDateTime.now());
                    PmsBudgetVO budgetVO = this.pmsBudgetDAO.queryByProjectId(vo.getProjectId());
                    appropriatePayload.setAppropriationProportion(budgetVO.getAppropriationProportion());
                    appropriatePayload.setTotalMoney(budgetVO.getTotalMoney());
                    appropriatePayload.setUsedMoney(budgetVO.getUsedMoney());
                    appropriatePayload.setPaidMoney(budgetVO.getPaidMoney());
                    this.pmsBudgetAppropriateDAO.updateWorkFlow(appropriatePayload);
                });
            }
            return vo;
        }
        return null;
    }

    PmsBudgetAppropriatePayload countSubjectInfo(PmsBudgetAppropriatePayload payload, BigDecimal applicationAmount) {
        List detailPayloadList = payload.getDetailPayloadList();
        List list = detailPayloadList.stream().filter(detail -> "0".equals(detail.getBudgetDetailType())).collect(Collectors.toList());
        if (!ObjectUtils.isEmpty(list)) {
            HashMap<Long, BigDecimal> fromPage = new HashMap<Long, BigDecimal>();
            HashMap<Long, BigDecimal> fromSubset = new HashMap<Long, BigDecimal>();
            HashSet<Long> parentIds = new HashSet<Long>();
            for (PmsBudgetAppropriateDetailPayload pmsBudgetAppropriateDetailPayload : list) {
                parentIds.add(pmsBudgetAppropriateDetailPayload.getSubjectId());
                parentIds.add(pmsBudgetAppropriateDetailPayload.getSubjectParentId());
                BigDecimal money = pmsBudgetAppropriateDetailPayload.getApplicationAmount();
                if (ObjectUtils.isEmpty((Object)pmsBudgetAppropriateDetailPayload.getSubjectParentId())) {
                    fromPage.put(pmsBudgetAppropriateDetailPayload.getSubjectId(), money);
                    continue;
                }
                Long parentId = pmsBudgetAppropriateDetailPayload.getSubjectParentId();
                if (fromSubset.containsKey(parentId)) {
                    fromSubset.put(parentId, ((BigDecimal)fromSubset.get(parentId)).add(money));
                    continue;
                }
                fromSubset.put(parentId, money);
            }
            for (Map.Entry entry : fromPage.entrySet()) {
                int flag;
                Long parentId = (Long)entry.getKey();
                if (fromSubset.containsKey(parentId) && -1 == (flag = ((BigDecimal)fromPage.get(parentId)).compareTo((BigDecimal)fromSubset.get(parentId)))) {
                    fromPage.put(parentId, (BigDecimal)fromSubset.get(parentId));
                }
                applicationAmount = applicationAmount.add((BigDecimal)fromPage.get(parentId));
                parentIds.remove(parentId);
            }
            for (Long l : parentIds) {
                if (!fromSubset.containsKey(l)) continue;
                applicationAmount = applicationAmount.add((BigDecimal)fromSubset.get(l));
            }
            for (PmsBudgetAppropriateDetailPayload pmsBudgetAppropriateDetailPayload : list) {
                if (!ObjectUtils.isEmpty((Object)pmsBudgetAppropriateDetailPayload.getSubjectParentId()) || fromPage.get(pmsBudgetAppropriateDetailPayload.getSubjectId()) == null) continue;
                pmsBudgetAppropriateDetailPayload.setApplicationAmount((BigDecimal)fromPage.get(pmsBudgetAppropriateDetailPayload.getSubjectId()));
            }
            for (PmsBudgetAppropriateDetailPayload pmsBudgetAppropriateDetailPayload : list) {
                if (ObjectUtils.isEmpty((Object)pmsBudgetAppropriateDetailPayload.getSubjectParentId()) || fromSubset.get(pmsBudgetAppropriateDetailPayload.getSubjectId()) == null) continue;
                pmsBudgetAppropriateDetailPayload.setApplicationAmount((BigDecimal)fromPage.get(pmsBudgetAppropriateDetailPayload.getSubjectId()));
            }
        }
        payload.setDetailPayloadList(list);
        payload.setAppropriationAmount(applicationAmount);
        return payload;
    }

    PmsBudgetAppropriatePayload countPlanInfo(PmsBudgetAppropriatePayload payload, BigDecimal applicationAmount) {
        List detailPayloadList = payload.getDetailPayloadList();
        List list = detailPayloadList.stream().filter(detail -> "1".equals(detail.getBudgetDetailType())).collect(Collectors.toList());
        if (!ObjectUtils.isEmpty(list)) {
            HashMap<Long, BigDecimal> STAGEFromPage = new HashMap<Long, BigDecimal>();
            HashMap<Long, BigDecimal> STAGEFromSubset = new HashMap<Long, BigDecimal>();
            BigDecimal PROJECTfromPage = BigDecimal.ZERO;
            BigDecimal PROJECTSubset = BigDecimal.ZERO;
            for (PmsBudgetAppropriateDetailPayload pmsBudgetAppropriateDetailPayload : list) {
                BigDecimal money = pmsBudgetAppropriateDetailPayload.getApplicationAmount();
                if ("PROJECT".equals(pmsBudgetAppropriateDetailPayload.getPlanType())) {
                    PROJECTfromPage = money;
                    continue;
                }
                if ("STAGE".equals(pmsBudgetAppropriateDetailPayload.getPlanType())) {
                    STAGEFromPage.put(pmsBudgetAppropriateDetailPayload.getPlanId(), money);
                    continue;
                }
                if (!"ACT".equals(pmsBudgetAppropriateDetailPayload.getPlanType())) continue;
                Long parentId = pmsBudgetAppropriateDetailPayload.getPlanParentId();
                if (STAGEFromSubset.containsKey(parentId)) {
                    STAGEFromSubset.put(parentId, ((BigDecimal)STAGEFromSubset.get(parentId)).add(money));
                    continue;
                }
                STAGEFromSubset.put(parentId, money);
            }
            for (Map.Entry entry : STAGEFromPage.entrySet()) {
                int flag;
                Long parentId = (Long)entry.getKey();
                if (!STAGEFromSubset.containsKey(parentId) || -1 != (flag = ((BigDecimal)STAGEFromPage.get(parentId)).compareTo((BigDecimal)STAGEFromSubset.get(parentId)))) continue;
                STAGEFromPage.put(parentId, (BigDecimal)STAGEFromSubset.get(parentId));
            }
            for (Map.Entry entry : STAGEFromPage.entrySet()) {
                PROJECTSubset = PROJECTSubset.add((BigDecimal)entry.getValue());
            }
            int flag = PROJECTfromPage.compareTo(PROJECTSubset);
            if (-1 == flag) {
                PROJECTfromPage = PROJECTSubset;
            }
            applicationAmount = applicationAmount.add(PROJECTfromPage);
            for (PmsBudgetAppropriateDetailPayload object : list) {
                if ("PROJECT".equals(object.getPlanType())) {
                    object.setApplicationAmount(PROJECTfromPage);
                    continue;
                }
                if (!"STAGE".equals(object.getPlanType()) || STAGEFromPage.get(object.getPlanId()) == null) continue;
                object.setApplicationAmount((BigDecimal)STAGEFromPage.get(object.getPlanId()));
            }
        }
        payload.setDetailPayloadList(list);
        payload.setAppropriationAmount(applicationAmount);
        return payload;
    }

    void submitWorkFlow(PmsBudgetAppropriatePayload payload) {
        ProcessInfo processInfo = new ProcessInfo();
        processInfo.setProcInstId("111");
        processInfo.setProcInstStatus(ProcInstStatus.APPROVING);
        PmsBudgetAppropriatePayload payload0 = new PmsBudgetAppropriatePayload();
        payload0.setId(payload.getId());
        payload0.setSubmitTime(LocalDateTime.now());
        payload0.setProcInstId(processInfo.getProcInstId());
        payload0.setProcInstStatus(processInfo.getProcInstStatus());
        payload0.setAppropriationStatus(BudgetStatusEnum.APPROVING.getCode());
        this.pmsBudgetAppropriateDAO.updateWorkFlow(payload0);
        PmsBudgetVO budgetVO = this.pmsBudgetService.queryByProjectId(payload.getProjectId());
        PmsBudgetPayload budgetPayload = new PmsBudgetPayload();
        budgetPayload.setId(budgetVO.getId());
        budgetPayload.setSubmitTime(LocalDateTime.now());
        budgetPayload.setBudgetStatus(BudgetStatusEnum.APPROVING.getCode());
        this.pmsBudgetDAO.updateWorkFlow(budgetPayload);
        List detailPayloadList = payload.getDetailPayloadList();
        for (PmsBudgetAppropriateDetailPayload detail : detailPayloadList) {
            this.pmsBudgetCommonService.appropriation(detail.getBudgetDetailId(), detail.getApplicationAmount(), detail.getBudgetDetailType(), ProcInstStatus.APPROVING);
        }
    }

    public PmsBudgetAppropriateServiceImpl(PmsBudgetAppropriateRepo pmsBudgetAppropriateRepo, PmsBudgetAppropriateDAO pmsBudgetAppropriateDAO, PmsBudgetAppropriateDetailRepo pmsBudgetAppropriateDetailRepo, WorkflowUtil workflowUtil, PmsBudgetDAO pmsBudgetDAO, PmsBudgetDetailPlanDAO pmsBudgetDetailPlanDAO, PmsBudgetCommonDao pmsBudgetCommonDao, PmsBudgetAppropriateDetailDAO pmsBudgetAppropriateDetailDAO, PmsProjectDAO projectDAO, PmsBudgetService pmsBudgetService, TransactionUtilService transactionUtilService, PmsBudgetCommonService pmsBudgetCommonService) {
        this.pmsBudgetAppropriateRepo = pmsBudgetAppropriateRepo;
        this.pmsBudgetAppropriateDAO = pmsBudgetAppropriateDAO;
        this.pmsBudgetAppropriateDetailRepo = pmsBudgetAppropriateDetailRepo;
        this.workflowUtil = workflowUtil;
        this.pmsBudgetDAO = pmsBudgetDAO;
        this.pmsBudgetDetailPlanDAO = pmsBudgetDetailPlanDAO;
        this.pmsBudgetCommonDao = pmsBudgetCommonDao;
        this.pmsBudgetAppropriateDetailDAO = pmsBudgetAppropriateDetailDAO;
        this.projectDAO = projectDAO;
        this.pmsBudgetService = pmsBudgetService;
        this.transactionUtilService = transactionUtilService;
        this.pmsBudgetCommonService = pmsBudgetCommonService;
    }
}

