/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.project.service;

import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5pms.api.project.service.PmsBudgetCommonService;
import com.elitesland.tw.tw5pms.api.project.vo.BudgetCommonVO;
import com.elitesland.tw.tw5pms.api.project.vo.PmsBudgetDetailPlanVO;
import com.elitesland.tw.tw5pms.server.project.dao.PmsBudgetCommonDao;
import com.elitesland.tw.tw5pms.server.project.dao.PmsBudgetDetailPlanDAO;
import com.elitesland.tw.tw5pms.server.project.dao.PmsBudgetDetailSubjectDAO;
import com.elitesland.workflow.enums.ProcInstStatus;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class PmsBudgetCommonServiceImpl
implements PmsBudgetCommonService {
    private static final Logger log = LoggerFactory.getLogger(PmsBudgetCommonServiceImpl.class);
    private final PmsBudgetDetailPlanDAO pmsBudgetDetailPlanDAO;
    private final PmsBudgetDetailSubjectDAO pmsBudgetDetailSubjectDAO;
    private final PmsBudgetCommonDao pmsBudgetCommonDao;

    @Transactional(rollbackFor={Exception.class})
    public void updatePlanUsed(Long projectId, Long planId, BigDecimal usedMoney) {
        PmsBudgetDetailPlanVO vo = new PmsBudgetDetailPlanVO();
        vo = ObjectUtils.isEmpty((Object)planId) ? this.pmsBudgetDetailPlanDAO.queryByPlanIdIsNull(projectId) : this.pmsBudgetDetailPlanDAO.queryByPlanId(projectId, planId);
        if (ObjectUtils.isEmpty((Object)vo)) {
            throw TwException.error((String)"", (String)"\u8be5\u8ba1\u5212\u67e5\u627e\u4e0d\u5230\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        BigDecimal used = vo.getUsedMoney().add(usedMoney);
        BigDecimal proportion = BigDecimal.ZERO;
        if (vo.getTotalMoney().doubleValue() > 0.0) {
            proportion = used.divide(vo.getTotalMoney(), 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
        }
        BigDecimal residue = vo.getPaidMoney().subtract(used);
        BigDecimal summaryUsageMoney = used.add(vo.getApplyingMoney());
        BigDecimal remainingBudgetMoney = vo.getTotalMoney().subtract(summaryUsageMoney);
        if (residue.doubleValue() < 0.0) {
            throw TwException.error((String)"", (String)"\u8be5\u8ba1\u5212\u53ef\u4f7f\u7528\u91d1\u989d\u5df2\u4e0d\u8db3\u652f\u4ed8\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        vo.setUsedMoney(used);
        vo.setProportion(proportion);
        vo.setResidueMoney(residue);
        vo.setSummaryUsageMoney(summaryUsageMoney);
        vo.setRemainingBudgetMoney(remainingBudgetMoney);
        this.pmsBudgetDetailPlanDAO.updateUsed(vo);
    }

    @Transactional(rollbackFor={Exception.class})
    public void appropriation(Long id, BigDecimal appropriationAmount, String type, ProcInstStatus procInstStatus) {
        BigDecimal exceedBudgetMoney;
        BudgetCommonVO vo = this.pmsBudgetCommonDao.queryByKey(id, type);
        if (ObjectUtils.isEmpty((Object)vo)) {
            throw TwException.error((String)"", (String)"\u8be5\u9884\u7b97\u660e\u7ec6\u67e5\u627e\u4e0d\u5230\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        BigDecimal applyingMoney = null;
        BigDecimal paidMoney = null;
        BigDecimal residueMoney = null;
        BigDecimal mayApplyMoney = null;
        BigDecimal summaryUsageMoney = null;
        if (ProcInstStatus.APPROVED.equals((Object)procInstStatus)) {
            applyingMoney = vo.getApplyingMoney().subtract(appropriationAmount);
            paidMoney = vo.getPaidMoney().add(appropriationAmount);
            residueMoney = paidMoney.subtract(vo.getUsedMoney());
            mayApplyMoney = vo.getTotalMoney().subtract(paidMoney);
            summaryUsageMoney = vo.getSummaryUsageMoney().subtract(appropriationAmount);
        } else if (ProcInstStatus.APPROVING.equals((Object)procInstStatus)) {
            applyingMoney = vo.getApplyingMoney().add(appropriationAmount);
            summaryUsageMoney = vo.getSummaryUsageMoney().add(appropriationAmount);
        } else if (ProcInstStatus.REJECTED.equals((Object)procInstStatus)) {
            applyingMoney = vo.getApplyingMoney().subtract(appropriationAmount);
            summaryUsageMoney = vo.getSummaryUsageMoney().subtract(appropriationAmount);
        }
        BigDecimal remainingBudgetMoney = vo.getTotalMoney().subtract(summaryUsageMoney);
        if (remainingBudgetMoney.doubleValue() < 0.0) {
            remainingBudgetMoney = remainingBudgetMoney.negate();
        }
        if ((exceedBudgetMoney = summaryUsageMoney.subtract(vo.getTotalMoney())).doubleValue() < 0.0) {
            exceedBudgetMoney = BigDecimal.ZERO;
        }
        this.pmsBudgetCommonDao.appropriation(vo.getId(), type, applyingMoney, paidMoney, residueMoney, mayApplyMoney, summaryUsageMoney, remainingBudgetMoney, exceedBudgetMoney);
    }

    @Transactional(rollbackFor={Exception.class})
    public void change(Long id, String type, BigDecimal totalMoney, String remark, String wbsCode) {
        BigDecimal exceedBudgetMoney;
        BudgetCommonVO vo = this.pmsBudgetCommonDao.queryByKey(id, type);
        if (ObjectUtils.isEmpty((Object)vo)) {
            throw TwException.error((String)"", (String)"\u8be5\u9884\u7b97\u660e\u7ec6\u67e5\u627e\u4e0d\u5230\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        BigDecimal mayApplyMoney = totalMoney.subtract(vo.getPaidMoney());
        BigDecimal remainingBudgetMoney = totalMoney.subtract(vo.getSummaryUsageMoney());
        if (remainingBudgetMoney.doubleValue() < 0.0) {
            remainingBudgetMoney = remainingBudgetMoney.negate();
        }
        if ((exceedBudgetMoney = vo.getSummaryUsageMoney().subtract(totalMoney)).doubleValue() < 0.0) {
            exceedBudgetMoney = BigDecimal.ZERO;
        }
        BigDecimal proportion = BigDecimal.ZERO;
        if (totalMoney.doubleValue() > 0.0) {
            proportion = new BigDecimal(vo.getUsedMoney().divide(totalMoney, 4, RoundingMode.HALF_UP).doubleValue() * 100.0);
        }
        this.pmsBudgetCommonDao.change(vo.getId(), type, totalMoney, mayApplyMoney, remainingBudgetMoney, exceedBudgetMoney, proportion, remark, wbsCode);
    }

    public PmsBudgetCommonServiceImpl(PmsBudgetDetailPlanDAO pmsBudgetDetailPlanDAO, PmsBudgetDetailSubjectDAO pmsBudgetDetailSubjectDAO, PmsBudgetCommonDao pmsBudgetCommonDao) {
        this.pmsBudgetDetailPlanDAO = pmsBudgetDetailPlanDAO;
        this.pmsBudgetDetailSubjectDAO = pmsBudgetDetailSubjectDAO;
        this.pmsBudgetCommonDao = pmsBudgetCommonDao;
    }
}

