/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.project.service;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.common.change.payload.ComChangeDataPayload;
import com.elitesland.tw.tw5.api.common.change.payload.ComChangePayload;
import com.elitesland.tw.tw5.api.common.change.service.ComChangeService;
import com.elitesland.tw.tw5.api.common.change.vo.ComChangeVO;
import com.elitesland.tw.tw5.api.common.log.payload.ComLogPayload;
import com.elitesland.tw.tw5.api.common.log.query.ComLogQuery;
import com.elitesland.tw.tw5.api.common.log.service.ComLogService;
import com.elitesland.tw.tw5.api.common.log.vo.ComLogVO;
import com.elitesland.tw.tw5.api.prd.crm.payload.PmsBudgetSubjectExcel;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.workFlow.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import com.elitesland.tw.tw5pms.api.project.payload.PmsBudgetDetailPlanPayload;
import com.elitesland.tw.tw5pms.api.project.payload.PmsBudgetDetailSubjectPayload;
import com.elitesland.tw.tw5pms.api.project.payload.PmsBudgetPayload;
import com.elitesland.tw.tw5pms.api.project.query.PmsBudgetLogQuery;
import com.elitesland.tw.tw5pms.api.project.service.PmsBudgetCommonService;
import com.elitesland.tw.tw5pms.api.project.service.PmsBudgetDetailPlanService;
import com.elitesland.tw.tw5pms.api.project.service.PmsBudgetDetailSubjectService;
import com.elitesland.tw.tw5pms.api.project.service.PmsBudgetService;
import com.elitesland.tw.tw5pms.api.project.service.PmsBudgetTemplateSubjectService;
import com.elitesland.tw.tw5pms.api.project.vo.PmsBudgetAppropriateDetailVO;
import com.elitesland.tw.tw5pms.api.project.vo.PmsBudgetAppropriateVO;
import com.elitesland.tw.tw5pms.api.project.vo.PmsBudgetDetailPlanVO;
import com.elitesland.tw.tw5pms.api.project.vo.PmsBudgetDetailSubjectVO;
import com.elitesland.tw.tw5pms.api.project.vo.PmsBudgetSubjectVO;
import com.elitesland.tw.tw5pms.api.project.vo.PmsBudgetTemplateSubjectVO;
import com.elitesland.tw.tw5pms.api.project.vo.PmsBudgetVO;
import com.elitesland.tw.tw5pms.api.project.vo.PmsProjectTemplateVO;
import com.elitesland.tw.tw5pms.api.project.vo.PmsProjectVO;
import com.elitesland.tw.tw5pms.server.common.functionEnum.BudgetStatusEnum;
import com.elitesland.tw.tw5pms.server.common.functionEnum.ComChangeTypeEnum;
import com.elitesland.tw.tw5pms.server.common.functionEnum.ComLogTypeEnum;
import com.elitesland.tw.tw5pms.server.common.functionEnum.ProjectStatusEnum;
import com.elitesland.tw.tw5pms.server.common.util.ChangeFieldUtil;
import com.elitesland.tw.tw5pms.server.project.convert.PmsBudgetConvert;
import com.elitesland.tw.tw5pms.server.project.convert.PmsBudgetDetailPlanConvert;
import com.elitesland.tw.tw5pms.server.project.convert.PmsBudgetDetailSubjectConvert;
import com.elitesland.tw.tw5pms.server.project.dao.PmsBudgetAppropriateDetailDAO;
import com.elitesland.tw.tw5pms.server.project.dao.PmsBudgetDAO;
import com.elitesland.tw.tw5pms.server.project.dao.PmsBudgetDetailPlanDAO;
import com.elitesland.tw.tw5pms.server.project.dao.PmsBudgetDetailSubjectDAO;
import com.elitesland.tw.tw5pms.server.project.dao.PmsBudgetSubjectDAO;
import com.elitesland.tw.tw5pms.server.project.dao.PmsBudgetTemplateSubjectDAO;
import com.elitesland.tw.tw5pms.server.project.dao.PmsProjectDAO;
import com.elitesland.tw.tw5pms.server.project.dao.PmsProjectTemplateDAO;
import com.elitesland.tw.tw5pms.server.project.entity.PmsBudgetDO;
import com.elitesland.tw.tw5pms.server.project.repo.PmsBudgetRepo;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class PmsBudgetServiceImpl
extends BaseServiceImpl
implements PmsBudgetService {
    private static final Logger log = LoggerFactory.getLogger(PmsBudgetServiceImpl.class);
    private final PmsBudgetRepo pmsBudgetRepo;
    private final PmsBudgetDAO pmsBudgetDAO;
    private final ComChangeService changeService;
    private final TransactionUtilService transactionUtilService;
    private final WorkflowUtil workflowUtil;
    private final ComLogService logService;
    private final CacheUtil cacheUtil;
    private final FileUtil fileUtil;
    private final PmsProjectDAO projectDAO;
    private final UdcUtil udcUtil;
    private final PmsBudgetDetailPlanService pmsBudgetDetailPlanService;
    private final PmsBudgetDetailSubjectService pmsBudgetDetailSubjectService;
    private final PmsBudgetTemplateSubjectDAO pmsBudgetTemplateSubjectDAO;
    private final ChangeFieldUtil changeFieldUtil;
    private final PmsBudgetAppropriateDetailDAO pmsBudgetAppropriateDetailDAO;
    private final PmsBudgetDetailSubjectDAO pmsBudgetDetailSubjectDAO;
    private final PmsBudgetDetailPlanDAO pmsBudgetDetailPlanDAO;
    private final PmsBudgetCommonService pmsBudgetCommonService;
    private final PmsBudgetSubjectDAO pmsBudgetSubjectDAO;
    private final PmsProjectTemplateDAO pmsProjectTemplateDAO;
    private final PmsBudgetTemplateSubjectService budgetTemplateSubjectService;

    public PmsBudgetVO queryByKey(Long key) {
        PmsBudgetDO entity = this.pmsBudgetRepo.findById(key).orElseGet(PmsBudgetDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PmsBudgetVO vo = PmsBudgetConvert.INSTANCE.toVo(entity);
        return vo;
    }

    public PmsBudgetVO queryByProjectId(Long projectId) {
        PmsProjectVO projectVO = this.projectDAO.queryByKey(projectId);
        if (ObjectUtils.isEmpty((Object)projectVO)) {
            throw TwException.error((String)"", (String)"\u5173\u8054\u9879\u76ee\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        PmsBudgetVO vo = this.pmsBudgetDAO.queryByProjectId(projectId);
        if (!ObjectUtils.isEmpty((Object)vo)) {
            vo.setSubjectList(this.pmsBudgetDetailSubjectService.queryByProjectId(projectId));
            vo.setPlanList(this.pmsBudgetDetailPlanService.queryByProjectId(projectId, new String[0]));
            if (projectVO.getProjectStatus().equals(ProjectStatusEnum.PENDING.getCode()) || projectVO.getProjectStatus().equals(ProjectStatusEnum.TERMINATED.getCode()) || projectVO.getProjectStatus().equals(ProjectStatusEnum.CLOSED.getCode())) {
                vo.setBudgetStatus(ProjectStatusEnum.CLOSED.getCode());
            }
            vo.setBudgetFilesDatas(this.fileUtil.getFileDatas(vo.getBudgetFiles()));
        }
        return vo;
    }

    public PmsBudgetVO queryByProjectId2(Long projectId) {
        PmsProjectVO projectVO = this.projectDAO.queryByKey(projectId);
        if (ObjectUtils.isEmpty((Object)projectVO)) {
            throw TwException.error((String)"", (String)"\u5173\u8054\u9879\u76ee\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        PmsProjectTemplateVO pmsProjectTemplateVO = this.pmsProjectTemplateDAO.queryByKey(projectVO.getTemplateId());
        PmsBudgetVO vo = this.pmsBudgetDAO.queryByProjectId(projectId);
        if (ObjectUtils.isEmpty((Object)vo)) {
            vo = new PmsBudgetVO();
        }
        vo.setBudgetControlFlag(pmsProjectTemplateVO.getBudgetControlFlag());
        vo.setBudgetControlStrategyFlag(pmsProjectTemplateVO.getBudgetControlStrategyFlag());
        LinkedList<PmsBudgetSubjectVO> subjectDetails = new LinkedList<PmsBudgetSubjectVO>();
        PmsBudgetSubjectVO subjectVO = new PmsBudgetSubjectVO();
        subjectVO.setSubjectLevel(Integer.valueOf(1));
        subjectVO.setSubjectCode("\u9879\u76ee\u603b\u8ba1");
        subjectDetails.add(subjectVO);
        subjectDetails.addAll(this.budgetTemplateSubjectService.queryByTemplateId(projectVO.getTemplateId()));
        vo.setSubjectDetails(subjectDetails);
        return vo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Transactional(rollbackFor={Exception.class})
    public PmsBudgetVO insertOrUpdate(PmsBudgetPayload payload) {
        PmsBudgetVO budgetVO;
        List planPayloadList;
        Object vo2;
        this.checkData(payload);
        Long projectId = payload.getProjectId();
        if (ObjectUtils.isEmpty((Object)projectId)) {
            throw TwException.error((String)"", (String)"\u5173\u8054\u9879\u76ee \u4e0d\u80fd\u4e3a\u7a7a");
        }
        PmsProjectVO projectVO = this.projectDAO.queryByKey(projectId);
        if (ObjectUtils.isEmpty((Object)projectVO)) {
            throw TwException.error((String)"", (String)"\u5173\u8054\u9879\u76ee\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (!ProjectStatusEnum.APPROVED.getCode().equals(projectVO.getProjectStatus())) {
            throw TwException.error((String)"", (String)"\u53ea\u6709\u9879\u76ee\u6fc0\u6d3b\u72b6\u6001\uff0c\u624d\u53ef\u4ee5\u7f16\u8f91\u9884\u7b97\uff01");
        }
        List subjectPayloadList = payload.getSubjectList();
        if (!ObjectUtils.isEmpty((Object)subjectPayloadList)) {
            for (Object vo2 : subjectPayloadList) {
                if (!ObjectUtils.isEmpty((Object)vo2.getSubjectId())) continue;
                throw TwException.error((String)"", (String)"\u79d1\u76eeid \u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (!ObjectUtils.isEmpty((Object)(planPayloadList = payload.getPlanList()))) {
            for (PmsBudgetDetailPlanPayload vo3 : planPayloadList) {
                if (!ObjectUtils.isEmpty((Object)vo3.getPlanType())) continue;
                throw TwException.error((String)"", (String)"\u8ba1\u5212\u7c7b\u578b \u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (ObjectUtils.isEmpty((Object)payload.getId())) {
            payload = this.createData(payload);
        } else if (payload.getChange().booleanValue()) {
            payload = this.changeData(payload);
            subjectPayloadList = payload.getSubjectList();
            for (PmsBudgetDetailPlanPayload vo3 : subjectPayloadList) {
                if (ObjectUtils.isEmpty((Object)vo3.getPaidMoney()) || !(vo3.getTotalMoney().doubleValue() < vo3.getPaidMoney().doubleValue())) continue;
                throw TwException.error((String)"", (String)"\u53d8\u66f4\u540e\u7684\u9884\u7b97\u4e0d\u53ef\u4ee5\u5c0f\u4e8e\u5df2\u62e8\u4ed8\u9884\u7b97\u91d1\u989d");
            }
            planPayloadList = payload.getPlanList();
            for (PmsBudgetDetailPlanPayload vo3 : planPayloadList) {
                if (ObjectUtils.isEmpty((Object)vo3.getPaidMoney()) || !(vo3.getTotalMoney().doubleValue() < vo3.getPaidMoney().doubleValue())) continue;
                throw TwException.error((String)"", (String)"\u53d8\u66f4\u540e\u7684\u9884\u7b97\u4e0d\u53ef\u4ee5\u5c0f\u4e8e\u5df2\u62e8\u4ed8\u9884\u7b97\u91d1\u989d");
            }
        } else {
            vo2 = this.pmsBudgetDAO.queryByProjectId(payload.getProjectId());
            if (payload.getTemplateId().equals(vo2.getTemplateId())) {
                payload = this.editData(payload);
            } else {
                this.pmsBudgetDetailSubjectDAO.deleteByProjectId(projectId);
                this.pmsBudgetDetailPlanDAO.deleteByProjectId(projectId);
                payload = this.createData(payload);
            }
        }
        if (payload.getSubmit().booleanValue()) {
            payload.setBudgetStatus(BudgetStatusEnum.APPROVING.getCode());
            vo2 = this.save(payload);
            payload.setId(vo2.getId());
            this.submitWorkFlow(payload, projectVO);
            this.transactionUtilService.executeWithRunnable(() -> this.lambda$insertOrUpdate$0((PmsBudgetVO)vo2));
            return vo2;
        }
        if (payload.getChange().booleanValue()) {
            budgetVO = this.queryByKey(payload.getId());
            if (ObjectUtils.isEmpty((Object)budgetVO)) throw TwException.error((String)"", (String)"\u53d8\u66f4\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
            if (!budgetVO.getBudgetStatus().equals(BudgetStatusEnum.APPROVED.getCode())) {
                throw TwException.error((String)"", (String)"\u4ec5\u6fc0\u6d3b\u72b6\u6001\u652f\u6301\u53d8\u66f4\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
        } else {
            payload.setBudgetStatus(BudgetStatusEnum.CREATE.getCode());
            return this.save(payload);
        }
        this.transferData(budgetVO);
        PmsBudgetVO budgetVO1 = PmsBudgetConvert.INSTANCE.toVO(payload);
        this.transferData(budgetVO1);
        ComChangeDataPayload changeDataPayload = new ComChangeDataPayload();
        changeDataPayload.setChangeType(ComChangeTypeEnum.PMS_PROJECT_BUDGET_CHANGE.getCode());
        changeDataPayload.setChangeDocId("" + payload.getProjectId());
        changeDataPayload.setOriginalModel((Object)budgetVO);
        changeDataPayload.setChangeModel((Object)budgetVO1);
        changeDataPayload.setExtString1(payload.getChangeDescription());
        changeDataPayload.setExtString2(payload.getChangeContent());
        Long saveId = this.changeService.save(changeDataPayload);
        ComChangeVO insert = this.changeService.queryByKey(saveId);
        this.addChangeLog(payload, insert.getVersionNo());
        this.transactionUtilService.executeWithRunnable(() -> {
            this.changeWorkFlow(budgetVO, saveId, projectVO);
            this.changeCallBack(insert, ProcInstStatus.APPROVED);
            ComChangePayload changePayload = new ComChangePayload();
            changePayload.setId(insert.getId());
            changePayload.setApprStatus(ProcInstStatus.APPROVED.name());
            changePayload.setChangeStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
            this.changeService.updateWorkFlow(changePayload);
        });
        return null;
    }

    public PmsBudgetVO save(PmsBudgetPayload payload) {
        List subjectPayloadList;
        PmsBudgetDO entityDo = PmsBudgetConvert.INSTANCE.toDo(payload);
        PmsBudgetVO vo = PmsBudgetConvert.INSTANCE.toVo((PmsBudgetDO)this.pmsBudgetRepo.save(entityDo));
        List planPayloadList = payload.getPlanList();
        if (!ObjectUtils.isEmpty((Object)planPayloadList)) {
            this.pmsBudgetDetailPlanService.insertBacth(planPayloadList);
        }
        if (!ObjectUtils.isEmpty((Object)(subjectPayloadList = payload.getSubjectList()))) {
            this.pmsBudgetDetailSubjectService.insertBacth(subjectPayloadList);
        }
        Long projectId = payload.getProjectId();
        vo.setSubjectList(this.pmsBudgetDetailSubjectService.queryByProjectId(projectId));
        vo.setPlanList(this.pmsBudgetDetailPlanService.queryByProjectId(projectId, new String[0]));
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateWorkflowBudget(PmsBudgetPayload payload) {
        PmsBudgetVO vo = this.pmsBudgetDAO.queryByKey(payload.getId());
        if (vo != null) {
            if (!vo.getBudgetStatus().equals(BudgetStatusEnum.APPROVING_EJECTED.getCode())) {
                throw TwException.error((String)"", (String)"\u4ec5\u652f\u6301\u6d41\u7a0b\u88ab\u9a73\u56de\u7684\u53d8\u66f4\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
        } else {
            throw TwException.error((String)"", (String)"\u53d8\u66f4\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        PmsBudgetVO vO1 = PmsBudgetConvert.INSTANCE.toVO(payload);
        this.transferData(vO1);
        this.changeService.update(ComChangeTypeEnum.PMS_PROJECT_BUDGET_CHANGE.getCode(), "" + payload.getId(), (Object)PmsBudgetConvert.INSTANCE.toPayload(vO1));
    }

    public List<PmsBudgetDetailSubjectVO> importProbablyFile(MultipartFile file, Long templateId) {
        int dataStartRow;
        Row row;
        String subjectCode;
        if (file == null) {
            throw TwException.error((String)"", (String)"\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38");
        }
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create((InputStream)file.getInputStream());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            throw TwException.error((String)"", (String)"\u6587\u4ef6\u89e3\u6790\u5f02\u5e38");
        }
        Sheet sheet = workbook.getSheet("\u79d1\u76ee\u6982\u7b97");
        if (sheet == null) {
            throw TwException.error((String)"", (String)"\u8868\u7ed3\u6784\u9519\u8bef");
        }
        HashMap<String, PmsBudgetDetailSubjectVO> map = new HashMap<String, PmsBudgetDetailSubjectVO>();
        List<PmsBudgetTemplateSubjectVO> pmsBudgetTemplateSubjectVOS = this.pmsBudgetTemplateSubjectDAO.queryByTemplateId(templateId);
        if (pmsBudgetTemplateSubjectVOS.size() > 0) {
            for (PmsBudgetTemplateSubjectVO vo : pmsBudgetTemplateSubjectVOS) {
                if (!"0".equals(vo.getSubjectStatus())) continue;
                PmsBudgetDetailSubjectVO subject = new PmsBudgetDetailSubjectVO();
                if (!ObjectUtils.isEmpty((Object)vo.getParentId())) {
                    subject.setSubjectParentId(Long.valueOf(vo.getParentId()));
                }
                subject.setSubjectId(vo.getSubjectId());
                subject.setSubjectCode(vo.getSubjectCode());
                subject.setSubjectName(vo.getSubjectName());
                subject.setRemark(vo.getRemark());
                subject.setSubjectLevel(vo.getSubjectLevel());
                map.put(vo.getSubjectCode(), subject);
            }
        }
        for (int i = dataStartRow = 1; i <= sheet.getLastRowNum() && !ObjectUtils.isEmpty((Object)(subjectCode = ExcelUtil.getCellFormatValue((Cell)(row = sheet.getRow(i)).getCell(0)))); ++i) {
            String object;
            PmsBudgetDetailSubjectVO subject = (PmsBudgetDetailSubjectVO)map.get(subjectCode);
            if (ObjectUtils.isEmpty((Object)subject) || ObjectUtils.isEmpty((Object)(object = ExcelUtil.getCellFormatValue((Cell)row.getCell(2))))) continue;
            subject.setProbablyMoney(new BigDecimal(object));
        }
        Collection values = map.values();
        return new ArrayList<PmsBudgetDetailSubjectVO>(values);
    }

    public void downloadBatch(HttpServletResponse response, Long templateId) {
        List<PmsBudgetTemplateSubjectVO> records = this.pmsBudgetTemplateSubjectDAO.queryByTemplateId(templateId);
        String sheetName = "\u79d1\u76ee\u6982\u7b97";
        ArrayList<PmsBudgetSubjectExcel> resultList = new ArrayList<PmsBudgetSubjectExcel>();
        for (PmsBudgetTemplateSubjectVO vo : records) {
            if (!"0".equals(vo.getSubjectStatus())) continue;
            PmsBudgetSubjectExcel subject = new PmsBudgetSubjectExcel();
            subject.setSubjectCode(vo.getSubjectCode());
            subject.setSubjectName(vo.getSubjectName());
            resultList.add(subject);
        }
        String fileName = null;
        try {
            fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setCharacterEncoding("utf-8");
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            ExcelWriterSheetBuilder sheet = ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), PmsBudgetSubjectExcel.class).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet(sheetName);
            com.elitesland.tw.tw5.server.common.excel.ExcelUtil.excelHelper((ExcelWriterSheetBuilder)sheet, PmsBudgetSubjectExcel.class, null);
            sheet.doWrite(resultList);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<ComLogVO> queryLogList(PmsBudgetLogQuery query) {
        if (query.getProjectId() != null && query.getVersionNo() != null) {
            ComLogQuery logQuery = new ComLogQuery();
            logQuery.setLogType(ComLogTypeEnum.pms_project_budge.getCode());
            if (query.getProjectId() != null && query.getVersionNo() != null) {
                String vid = query.getProjectId() + "-" + query.getVersionNo();
                logQuery.setExtString1(vid);
            }
            List comLogVOS = this.logService.queryList(logQuery);
            comLogVOS.forEach(comLogVO -> {
                String extString3 = comLogVO.getExtString3();
                if (StringUtils.hasText((String)extString3)) {
                    extString3 = extString3.equals("DEL") ? "\u5220\u9664" : (extString3.equals("UPDATE") ? "\u66f4\u65b0" : "\u521b\u5efa");
                }
                comLogVO.setExtString3(extString3);
            });
            return this.logService.queryList(logQuery);
        }
        throw TwException.error((String)"", (String)"\u67e5\u8be2\u53c2\u6570\u5f02\u5e38\uff0c\u8bf7\u6838\u9a8c\uff01");
    }

    public void changeCallBack(ComChangeVO comChangeVO, ProcInstStatus procInstStatus) {
        PmsBudgetPayload payload = (PmsBudgetPayload)JSON.parseObject((String)comChangeVO.getChangeContent(), PmsBudgetPayload.class);
        PmsBudgetVO budgetVO = this.pmsBudgetDAO.queryByKey(payload.getId());
        if (ProcInstStatus.REJECTED.equals((Object)procInstStatus)) {
            budgetVO.setBudgetStatus(BudgetStatusEnum.APPROVED.getCode());
            budgetVO.setApprovedTime(LocalDateTime.now());
            this.pmsBudgetDAO.updateWorkFlow(PmsBudgetConvert.INSTANCE.toPayload(budgetVO));
        } else if (ProcInstStatus.APPROVED.equals((Object)procInstStatus)) {
            List subjectPayloadList;
            BigDecimal totalMoney = payload.getTotalMoney();
            this.pmsBudgetDAO.updateMoney(budgetVO, totalMoney, payload);
            List planPayloadList = payload.getPlanList();
            if (!ObjectUtils.isEmpty((Object)planPayloadList)) {
                for (PmsBudgetDetailPlanPayload object : planPayloadList) {
                    if (ObjectUtils.isEmpty((Object)object.getId())) {
                        object.setApplyingMoney(BigDecimal.ZERO);
                        object.setSummaryUsageMoney(BigDecimal.ZERO);
                        object.setRemainingBudgetMoney(object.getTotalMoney());
                        object.setMayApplyMoney(object.getTotalMoney());
                        object.setExceedBudgetMoney(BigDecimal.ZERO);
                        this.pmsBudgetDetailPlanDAO.save(PmsBudgetDetailPlanConvert.INSTANCE.toDo(object));
                        continue;
                    }
                    this.pmsBudgetCommonService.change(object.getId(), "1", object.getTotalMoney(), object.getRemark(), "");
                }
            }
            if (!ObjectUtils.isEmpty((Object)(subjectPayloadList = payload.getSubjectList()))) {
                for (PmsBudgetDetailSubjectPayload object : subjectPayloadList) {
                    if (ObjectUtils.isEmpty((Object)object.getId())) {
                        object.setApplyingMoney(BigDecimal.ZERO);
                        object.setSummaryUsageMoney(BigDecimal.ZERO);
                        object.setRemainingBudgetMoney(object.getTotalMoney());
                        object.setMayApplyMoney(object.getTotalMoney());
                        object.setExceedBudgetMoney(BigDecimal.ZERO);
                        this.pmsBudgetDetailSubjectDAO.save(PmsBudgetDetailSubjectConvert.INSTANCE.toDo(object));
                        continue;
                    }
                    this.pmsBudgetCommonService.change(object.getId(), "0", object.getTotalMoney(), object.getRemark(), object.getWbsCode());
                }
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void appropriateCallBack(PmsBudgetAppropriateVO appropriateVO, ProcInstStatus procInstStatus) {
        long projectId = appropriateVO.getProjectId();
        if (ProcInstStatus.REJECTED.equals((Object)procInstStatus)) {
            this.pmsBudgetDAO.updateAppropriationAmount(projectId, BigDecimal.ZERO);
        } else if (ProcInstStatus.APPROVED.equals((Object)procInstStatus)) {
            this.pmsBudgetDAO.updateAppropriationAmount(projectId, appropriateVO.getAppropriationAmount());
        }
        List<PmsBudgetAppropriateDetailVO> detailList = this.pmsBudgetAppropriateDetailDAO.queryByAppropriateId(appropriateVO.getId());
        for (PmsBudgetAppropriateDetailVO detail : detailList) {
            this.pmsBudgetCommonService.appropriation(detail.getBudgetDetailId(), detail.getApplicationAmount(), detail.getBudgetDetailType(), procInstStatus);
        }
    }

    @Transactional
    public void updatePlanBudget(Long projectId, Long planId, BigDecimal usedMoney) {
        this.pmsBudgetDAO.updateUsedMoney(projectId, usedMoney);
        if (!ObjectUtils.isEmpty((Object)planId)) {
            this.pmsBudgetCommonService.updatePlanUsed(projectId, planId, usedMoney);
            PmsBudgetDetailPlanVO parentPlan = this.pmsBudgetDetailPlanDAO.queryByPlanId(projectId, planId);
            if ("ACT".equals(parentPlan.getPlanType()) && !ObjectUtils.isEmpty((Object)parentPlan.getPlanParentId())) {
                this.pmsBudgetCommonService.updatePlanUsed(projectId, parentPlan.getPlanParentId(), usedMoney);
            }
        }
        this.pmsBudgetCommonService.updatePlanUsed(projectId, null, usedMoney);
    }

    @Transactional
    public void addChangeLog(PmsBudgetPayload payload, Integer versionNo) {
        ArrayList logPayloads = new ArrayList();
        List subjectList = payload.getSubjectList();
        subjectList.forEach(load -> {
            String fieldsCreateLog = this.changeFieldUtil.getFieldsCreateLog(load, null);
            ComLogPayload logPayload = new ComLogPayload();
            logPayload.setObjectId("" + load.getId());
            logPayload.setLogType(ComLogTypeEnum.pms_project_budge.getCode());
            logPayload.setExtString2(load.getSubjectName());
            logPayload.setExtString3("CREATE");
            logPayload.setLogContent(fieldsCreateLog);
            logPayloads.add(logPayload);
        });
        List planList = payload.getPlanList();
        planList.forEach(load -> {
            String fieldsCreateLog = this.changeFieldUtil.getFieldsCreateLog(load, null);
            ComLogPayload logPayload = new ComLogPayload();
            logPayload.setObjectId("" + load.getId());
            logPayload.setLogType(ComLogTypeEnum.pms_project_budge.getCode());
            logPayload.setExtString2(load.getPlanName());
            logPayload.setExtString3("CREATE");
            logPayload.setLogContent(fieldsCreateLog);
            logPayloads.add(logPayload);
        });
        String vid = payload.getProjectId() + "-" + versionNo;
        logPayloads.forEach(log -> log.setExtString1(vid));
        this.logService.insertBacth(logPayloads);
    }

    void checkData(PmsBudgetPayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getProjectId())) {
            throw TwException.error((String)"", (String)"\u5173\u8054\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getBudgetName())) {
            throw TwException.error((String)"", (String)"\u9884\u7b97\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getTemplateId())) {
            throw TwException.error((String)"", (String)"\u672a\u9009\u62e9\u6a21\u677f\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getStartTime())) {
            throw TwException.error((String)"", (String)"\u8d77\u6b62\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getEndTime())) {
            throw TwException.error((String)"", (String)"\u8d77\u6b62\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
    }

    PmsBudgetPayload initData(PmsBudgetPayload payload) {
        List subjectPayloadList;
        payload.setPaidMoney(BigDecimal.ZERO);
        payload.setUsedMoney(BigDecimal.ZERO);
        payload.setProportion(BigDecimal.ZERO);
        payload.setResidueMoney(BigDecimal.ZERO);
        payload.setAppropriationProportion(BigDecimal.ZERO);
        List planPayloadList = payload.getPlanList();
        if (!ObjectUtils.isEmpty((Object)planPayloadList)) {
            for (PmsBudgetDetailPlanPayload object : planPayloadList) {
                if (ObjectUtils.isEmpty((Object)object.getTotalMoney())) {
                    object.setTotalMoney(BigDecimal.ZERO);
                }
                object.setRemainingBudgetMoney(object.getTotalMoney());
                object.setMayApplyMoney(object.getTotalMoney());
                object.setUsedMoney(BigDecimal.ZERO);
                object.setProportion(BigDecimal.ZERO);
                object.setResidueMoney(BigDecimal.ZERO);
                object.setPaidMoney(BigDecimal.ZERO);
                object.setApplyingMoney(BigDecimal.ZERO);
                object.setSummaryUsageMoney(BigDecimal.ZERO);
                object.setExceedBudgetMoney(BigDecimal.ZERO);
                object.setProjectId(payload.getProjectId());
            }
        }
        if (!ObjectUtils.isEmpty((Object)(subjectPayloadList = payload.getSubjectList()))) {
            for (PmsBudgetDetailSubjectPayload object : subjectPayloadList) {
                if (ObjectUtils.isEmpty((Object)object.getTotalMoney())) {
                    object.setTotalMoney(BigDecimal.ZERO);
                }
                object.setRemainingBudgetMoney(object.getTotalMoney());
                object.setMayApplyMoney(object.getTotalMoney());
                object.setUsedMoney(BigDecimal.ZERO);
                object.setProportion(BigDecimal.ZERO);
                object.setResidueMoney(BigDecimal.ZERO);
                object.setPaidMoney(BigDecimal.ZERO);
                object.setApplyingMoney(BigDecimal.ZERO);
                object.setSummaryUsageMoney(BigDecimal.ZERO);
                object.setExceedBudgetMoney(BigDecimal.ZERO);
                object.setProjectId(payload.getProjectId());
            }
        }
        payload.setTotalMoney(BigDecimal.ZERO);
        payload.setResidueMoney(payload.getTotalMoney());
        return payload;
    }

    PmsBudgetPayload createData(PmsBudgetPayload payload) {
        payload.setBudgetCode(this.generateSeqNum("PMS_BUDGET", new String[0]));
        this.initData(payload);
        BigDecimal totalMoney = BigDecimal.ZERO;
        payload = this.countSubjectInfo(payload, totalMoney);
        totalMoney = payload.getTotalMoney();
        payload = this.countPlanInfo(payload, totalMoney);
        payload.setResidueMoney(payload.getTotalMoney());
        return payload;
    }

    public PmsBudgetPayload editData(PmsBudgetPayload payload) {
        this.initData(payload);
        List subjectFromPage = payload.getSubjectList();
        List planFromPage = payload.getPlanList();
        List subjectFromDB = this.pmsBudgetDetailSubjectService.queryByProjectId(payload.getProjectId());
        List planFromDB = this.pmsBudgetDetailPlanService.queryByProjectId(payload.getProjectId(), new String[0]);
        List subjectList = new ArrayList<PmsBudgetDetailSubjectPayload>();
        List planList = new ArrayList<Object>();
        HashMap<Long, PmsBudgetDetailSubjectPayload> subjectMap = new HashMap<Long, PmsBudgetDetailSubjectPayload>();
        HashMap<Long, PmsBudgetDetailSubjectPayload> planMap = new HashMap<Long, PmsBudgetDetailSubjectPayload>();
        for (PmsBudgetDetailSubjectPayload object : subjectFromPage) {
            if (ObjectUtils.isEmpty((Object)object.getId())) {
                subjectList.add(object);
            }
            subjectMap.put(object.getId(), object);
        }
        for (PmsBudgetDetailSubjectPayload object : planFromPage) {
            if (ObjectUtils.isEmpty((Object)object.getId())) {
                planList.add(object);
            }
            planMap.put(object.getId(), object);
        }
        for (PmsBudgetDetailSubjectVO vo : subjectFromDB) {
            if (subjectMap.containsKey(vo.getId())) {
                subjectList.add((PmsBudgetDetailSubjectPayload)subjectMap.get(vo.getId()));
                continue;
            }
            subjectList.add(PmsBudgetDetailSubjectConvert.INSTANCE.toPayload(vo));
        }
        for (PmsBudgetDetailSubjectVO vo : planFromDB) {
            if (planMap.containsKey(vo.getId())) {
                planList.add((PmsBudgetDetailPlanPayload)planMap.get(vo.getId()));
                continue;
            }
            planList.add(PmsBudgetDetailPlanConvert.INSTANCE.toPayload((PmsBudgetDetailPlanVO)vo));
        }
        payload.setSubjectList(subjectList);
        payload.setPlanList(planList);
        BigDecimal totalMoney = BigDecimal.ZERO;
        payload = this.countSubjectInfo(payload, totalMoney);
        totalMoney = payload.getTotalMoney();
        this.countPlanInfo(payload, totalMoney);
        payload.setMayApplyMoney(payload.getTotalMoney());
        subjectList = payload.getSubjectList();
        for (PmsBudgetDetailSubjectPayload object : subjectList) {
            object.setMayApplyMoney(object.getTotalMoney());
            object.setRemainingBudgetMoney(object.getTotalMoney());
        }
        planList = payload.getPlanList();
        for (PmsBudgetDetailSubjectPayload object : planList) {
            object.setMayApplyMoney(object.getTotalMoney());
            object.setRemainingBudgetMoney(object.getTotalMoney());
        }
        return payload;
    }

    PmsBudgetPayload changeData(PmsBudgetPayload payload) {
        List planFromPage = payload.getPlanList();
        List subjectFromPage = payload.getSubjectList();
        List subjectFromDB = this.pmsBudgetDetailSubjectService.queryByProjectId(payload.getProjectId());
        List planFromDB = this.pmsBudgetDetailPlanService.queryByProjectId(payload.getProjectId(), new String[0]);
        ArrayList<Object> planList = new ArrayList<Object>();
        ArrayList<PmsBudgetDetailSubjectPayload> subjectList = new ArrayList<PmsBudgetDetailSubjectPayload>();
        HashMap<Long, PmsBudgetDetailSubjectPayload> subjectMap = new HashMap<Long, PmsBudgetDetailSubjectPayload>();
        HashMap<Long, PmsBudgetDetailSubjectPayload> planMap = new HashMap<Long, PmsBudgetDetailSubjectPayload>();
        for (PmsBudgetDetailSubjectPayload object : subjectFromPage) {
            if (ObjectUtils.isEmpty((Object)object.getId())) {
                subjectList.add(object);
            }
            subjectMap.put(object.getId(), object);
        }
        for (PmsBudgetDetailSubjectPayload object : planFromPage) {
            if (ObjectUtils.isEmpty((Object)object.getId())) {
                planList.add(object);
            }
            planMap.put(object.getId(), object);
        }
        for (PmsBudgetDetailSubjectVO vo : subjectFromDB) {
            if (subjectMap.containsKey(vo.getId())) {
                vo.setTotalMoney(((PmsBudgetDetailSubjectPayload)subjectMap.get(vo.getId())).getTotalMoney());
                vo.setWbsCode(((PmsBudgetDetailSubjectPayload)subjectMap.get(vo.getId())).getWbsCode());
                vo.setRemark(((PmsBudgetDetailSubjectPayload)subjectMap.get(vo.getId())).getRemark());
            }
            subjectList.add(PmsBudgetDetailSubjectConvert.INSTANCE.toPayload(vo));
        }
        for (PmsBudgetDetailSubjectVO vo : planFromDB) {
            if (planMap.containsKey(vo.getId())) {
                vo.setTotalMoney(((PmsBudgetDetailPlanPayload)planMap.get(vo.getId())).getTotalMoney());
                vo.setRemark(((PmsBudgetDetailPlanPayload)planMap.get(vo.getId())).getRemark());
                vo.setPlanName(((PmsBudgetDetailPlanPayload)planMap.get(vo.getId())).getPlanName());
            }
            planList.add(PmsBudgetDetailPlanConvert.INSTANCE.toPayload((PmsBudgetDetailPlanVO)vo));
        }
        payload.setSubjectList(subjectList);
        payload.setPlanList(planList);
        BigDecimal totalMoney = BigDecimal.ZERO;
        payload = this.countSubjectInfo(payload, totalMoney);
        totalMoney = payload.getTotalMoney();
        this.countPlanInfo(payload, totalMoney);
        return payload;
    }

    PmsBudgetPayload countSubjectInfo(PmsBudgetPayload payload, BigDecimal totalMoney) {
        List list = payload.getSubjectList();
        if (!ObjectUtils.isEmpty((Object)list)) {
            HashMap<Long, BigDecimal> fromPage = new HashMap<Long, BigDecimal>();
            HashMap<Long, BigDecimal> fromSubset = new HashMap<Long, BigDecimal>();
            HashSet<Long> parentIds = new HashSet<Long>();
            for (PmsBudgetDetailSubjectPayload pmsBudgetDetailSubjectPayload : list) {
                parentIds.add(pmsBudgetDetailSubjectPayload.getSubjectId());
                parentIds.add(pmsBudgetDetailSubjectPayload.getSubjectParentId());
                BigDecimal money = pmsBudgetDetailSubjectPayload.getTotalMoney();
                if (ObjectUtils.isEmpty((Object)pmsBudgetDetailSubjectPayload.getSubjectParentId())) {
                    fromPage.put(pmsBudgetDetailSubjectPayload.getSubjectId(), money);
                    continue;
                }
                Long parentId = pmsBudgetDetailSubjectPayload.getSubjectParentId();
                if (fromSubset.containsKey(parentId)) {
                    fromSubset.put(parentId, ((BigDecimal)fromSubset.get(parentId)).add(money));
                    continue;
                }
                fromSubset.put(parentId, money);
            }
            for (Map.Entry entry : fromPage.entrySet()) {
                int flag;
                Long parentId = (Long)entry.getKey();
                if (fromSubset.containsKey(parentId) && -1 == (flag = ((BigDecimal)fromPage.get(parentId)).compareTo((BigDecimal)fromSubset.get(parentId)))) {
                    fromPage.put(parentId, (BigDecimal)fromSubset.get(parentId));
                }
                totalMoney = totalMoney.add((BigDecimal)fromPage.get(parentId));
                parentIds.remove(parentId);
            }
            for (Long l : parentIds) {
                if (!fromSubset.containsKey(l)) continue;
                totalMoney = totalMoney.add((BigDecimal)fromSubset.get(l));
            }
            for (PmsBudgetDetailSubjectPayload pmsBudgetDetailSubjectPayload : list) {
                if (!ObjectUtils.isEmpty((Object)pmsBudgetDetailSubjectPayload.getSubjectParentId()) || fromPage.get(pmsBudgetDetailSubjectPayload.getSubjectId()) == null) continue;
                pmsBudgetDetailSubjectPayload.setTotalMoney((BigDecimal)fromPage.get(pmsBudgetDetailSubjectPayload.getSubjectId()));
            }
        }
        payload.setSubjectList(list);
        payload.setTotalMoney(totalMoney);
        return payload;
    }

    PmsBudgetPayload countPlanInfo(PmsBudgetPayload payload, BigDecimal totalMoney) {
        List list = payload.getPlanList();
        if (!ObjectUtils.isEmpty((Object)list)) {
            HashMap<Long, BigDecimal> STAGEFromPage = new HashMap<Long, BigDecimal>();
            HashMap<Long, BigDecimal> STAGEFromSubset = new HashMap<Long, BigDecimal>();
            BigDecimal PROJECTfromPage = BigDecimal.ZERO;
            BigDecimal PROJECTSubset = BigDecimal.ZERO;
            for (PmsBudgetDetailPlanPayload pmsBudgetDetailPlanPayload : list) {
                BigDecimal money = pmsBudgetDetailPlanPayload.getTotalMoney();
                if ("PROJECT".equals(pmsBudgetDetailPlanPayload.getPlanType())) {
                    PROJECTfromPage = money;
                    continue;
                }
                if ("STAGE".equals(pmsBudgetDetailPlanPayload.getPlanType())) {
                    STAGEFromPage.put(pmsBudgetDetailPlanPayload.getPlanId(), money);
                    continue;
                }
                if (!"ACT".equals(pmsBudgetDetailPlanPayload.getPlanType())) continue;
                Long parentId = pmsBudgetDetailPlanPayload.getPlanParentId();
                if (STAGEFromSubset.containsKey(parentId)) {
                    STAGEFromSubset.put(parentId, ((BigDecimal)STAGEFromSubset.get(parentId)).add(money));
                    continue;
                }
                STAGEFromSubset.put(parentId, money);
            }
            for (Map.Entry entry : STAGEFromPage.entrySet()) {
                int flag;
                Long parentId = (Long)entry.getKey();
                if (!STAGEFromSubset.containsKey(parentId) || -1 != (flag = ((BigDecimal)STAGEFromPage.get(parentId)).compareTo((BigDecimal)STAGEFromSubset.get(parentId)))) continue;
                STAGEFromPage.put(parentId, (BigDecimal)STAGEFromSubset.get(parentId));
            }
            for (Map.Entry entry : STAGEFromPage.entrySet()) {
                PROJECTSubset = PROJECTSubset.add((BigDecimal)entry.getValue());
            }
            int flag = PROJECTfromPage.compareTo(PROJECTSubset);
            if (-1 == flag) {
                PROJECTfromPage = PROJECTSubset;
            }
            totalMoney = totalMoney.add(PROJECTfromPage);
            for (PmsBudgetDetailPlanPayload object : list) {
                if ("PROJECT".equals(object.getPlanType())) {
                    object.setTotalMoney(PROJECTfromPage);
                    continue;
                }
                if (!"STAGE".equals(object.getPlanType()) || STAGEFromPage.get(object.getPlanId()) == null) continue;
                object.setTotalMoney((BigDecimal)STAGEFromPage.get(object.getPlanId()));
            }
        }
        payload.setPlanList(list);
        payload.setTotalMoney(totalMoney);
        return payload;
    }

    void submitWorkFlow(PmsBudgetPayload payload, PmsProjectVO projectVO) {
        ProcessInfo processInfo = new ProcessInfo();
        processInfo.setProcInstId("111");
        processInfo.setProcInstStatus(ProcInstStatus.APPROVING);
        PmsBudgetPayload payload0 = new PmsBudgetPayload();
        payload0.setId(payload.getId());
        payload0.setSubmitTime(LocalDateTime.now());
        payload0.setBudgetStatus(BudgetStatusEnum.APPROVING.getCode());
        payload0.setProcInstId(processInfo.getProcInstId());
        payload0.setProcInstStatus(processInfo.getProcInstStatus());
        this.pmsBudgetDAO.updateWorkFlow(payload0);
    }

    void changeWorkFlow(PmsBudgetVO budgetVO, Long saveId, PmsProjectVO projectVO) {
        ProcessInfo processInfo = new ProcessInfo();
        processInfo.setProcInstId("111");
        processInfo.setProcInstStatus(ProcInstStatus.APPROVING);
        PmsBudgetPayload payload0 = new PmsBudgetPayload();
        payload0.setId(budgetVO.getId());
        payload0.setSubmitTime(LocalDateTime.now());
        payload0.setBudgetStatus(BudgetStatusEnum.APPROVING.getCode());
        this.pmsBudgetDAO.updateWorkFlow(payload0);
        ComChangePayload changePayload = new ComChangePayload();
        changePayload.setId(saveId);
        changePayload.setApprProcInstId(processInfo.getProcInstId());
        changePayload.setApprStatus(ProcInstStatus.APPROVING.name());
        changePayload.setChangeStatus(WorkFlowStatusEnum.CHANGING_WORK.getCode());
        this.changeService.updateWorkFlow(changePayload);
    }

    void transferData(PmsBudgetVO vo) {
        vo.setBudgetFilesDatas(this.fileUtil.getFileDatas(vo.getBudgetFiles()));
        vo.setCreator(this.cacheUtil.getUserName(vo.getCreateUserId()));
    }

    public PmsBudgetServiceImpl(PmsBudgetRepo pmsBudgetRepo, PmsBudgetDAO pmsBudgetDAO, ComChangeService changeService, TransactionUtilService transactionUtilService, WorkflowUtil workflowUtil, ComLogService logService, CacheUtil cacheUtil, FileUtil fileUtil, PmsProjectDAO projectDAO, UdcUtil udcUtil, PmsBudgetDetailPlanService pmsBudgetDetailPlanService, PmsBudgetDetailSubjectService pmsBudgetDetailSubjectService, PmsBudgetTemplateSubjectDAO pmsBudgetTemplateSubjectDAO, ChangeFieldUtil changeFieldUtil, PmsBudgetAppropriateDetailDAO pmsBudgetAppropriateDetailDAO, PmsBudgetDetailSubjectDAO pmsBudgetDetailSubjectDAO, PmsBudgetDetailPlanDAO pmsBudgetDetailPlanDAO, PmsBudgetCommonService pmsBudgetCommonService, PmsBudgetSubjectDAO pmsBudgetSubjectDAO, PmsProjectTemplateDAO pmsProjectTemplateDAO, PmsBudgetTemplateSubjectService budgetTemplateSubjectService) {
        this.pmsBudgetRepo = pmsBudgetRepo;
        this.pmsBudgetDAO = pmsBudgetDAO;
        this.changeService = changeService;
        this.transactionUtilService = transactionUtilService;
        this.workflowUtil = workflowUtil;
        this.logService = logService;
        this.cacheUtil = cacheUtil;
        this.fileUtil = fileUtil;
        this.projectDAO = projectDAO;
        this.udcUtil = udcUtil;
        this.pmsBudgetDetailPlanService = pmsBudgetDetailPlanService;
        this.pmsBudgetDetailSubjectService = pmsBudgetDetailSubjectService;
        this.pmsBudgetTemplateSubjectDAO = pmsBudgetTemplateSubjectDAO;
        this.changeFieldUtil = changeFieldUtil;
        this.pmsBudgetAppropriateDetailDAO = pmsBudgetAppropriateDetailDAO;
        this.pmsBudgetDetailSubjectDAO = pmsBudgetDetailSubjectDAO;
        this.pmsBudgetDetailPlanDAO = pmsBudgetDetailPlanDAO;
        this.pmsBudgetCommonService = pmsBudgetCommonService;
        this.pmsBudgetSubjectDAO = pmsBudgetSubjectDAO;
        this.pmsProjectTemplateDAO = pmsProjectTemplateDAO;
        this.budgetTemplateSubjectService = budgetTemplateSubjectService;
    }

    private /* synthetic */ void lambda$insertOrUpdate$0(PmsBudgetVO vo) {
        PmsBudgetPayload pmsBudgetPayload = new PmsBudgetPayload();
        pmsBudgetPayload.setId(vo.getId());
        pmsBudgetPayload.setBudgetStatus(ProjectStatusEnum.APPROVED.getCode());
        pmsBudgetPayload.setProcInstStatus(ProcInstStatus.APPROVED);
        pmsBudgetPayload.setApprovedTime(LocalDateTime.now());
        this.pmsBudgetDAO.updateWorkFlow(pmsBudgetPayload);
    }
}

