/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.project.service;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.prd.my.service.VacationService;
import com.elitesland.tw.tw5.api.prd.my.vo.VacationVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.scheduling.TimeUtil;
import com.elitesland.tw.tw5pms.api.project.payload.PmsProjectCalendarPayload;
import com.elitesland.tw.tw5pms.api.project.service.PmsProjectCalendarService;
import com.elitesland.tw.tw5pms.api.project.vo.PmsProjectCalendarVO;
import com.elitesland.tw.tw5pms.server.project.convert.PmsProjectCalendarConvert;
import com.elitesland.tw.tw5pms.server.project.entity.PmsProjectCalendarDO;
import com.elitesland.tw.tw5pms.server.project.repo.PmsProjectCalendarRepo;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class PmsProjectCalendarServiceImpl
implements PmsProjectCalendarService {
    private static final Logger log = LoggerFactory.getLogger(PmsProjectCalendarServiceImpl.class);
    private final PmsProjectCalendarRepo pmsProjectCalendarRepo;
    private final VacationService vacationService;

    public PmsProjectCalendarVO findBySource(PmsProjectCalendarPayload payload) {
        LinkedList<Map<String, Object>> list;
        this.nonEmptyValidation(payload);
        PmsProjectCalendarVO vo = new PmsProjectCalendarVO();
        vo.setSourceId(payload.getSourceId());
        vo.setSourceType(payload.getSourceType());
        vo.setStartDate(payload.getStartDate());
        vo.setEndDate(payload.getEndDate());
        PmsProjectCalendarDO pmsProjectCalendar = this.pmsProjectCalendarRepo.findBySource(payload.getSourceId(), payload.getSourceType());
        if (!ObjectUtils.isEmpty((Object)pmsProjectCalendar) && !ObjectUtils.isEmpty((Object)pmsProjectCalendar.getCalendarInfo())) {
            vo.setId(pmsProjectCalendar.getId());
            vo.setSetFixedShiftSystemFlag(pmsProjectCalendar.getSetFixedShiftSystemFlag());
            vo.setHoliday(pmsProjectCalendar.getHoliday());
            list = new LinkedList<Map<String, Object>>();
            Gson gson = new Gson();
            Type listType = new TypeToken<List<Map<String, Object>>>(){}.getType();
            if (payload.getStartDate().isBefore(pmsProjectCalendar.getStartDate())) {
                list.addAll(this.getInfo(payload.getStartDate(), pmsProjectCalendar.getStartDate()));
            }
            list.addAll((Collection)gson.fromJson(pmsProjectCalendar.getCalendarInfo(), listType));
            if (payload.getEndDate().isAfter(pmsProjectCalendar.getEndDate())) {
                list.addAll(this.getInfo(pmsProjectCalendar.getEndDate(), payload.getEndDate()));
            }
            LinkedList<Map> linkedList = new LinkedList<Map>();
            for (Map map : list) {
                for (String key : map.keySet()) {
                    LocalDate date = LocalDate.parse(key);
                    if (date.isBefore(payload.getEndDate()) && date.isAfter(payload.getStartDate())) {
                        linkedList.add(map);
                    }
                    if (!date.isEqual(payload.getEndDate()) && !date.isEqual(payload.getStartDate())) continue;
                    linkedList.add(map);
                }
            }
            vo.setCalendarList(linkedList);
        } else {
            vo.setCalendarList(this.getInfo(payload.getStartDate(), payload.getEndDate()));
        }
        list = vo.getCalendarList();
        if (!ObjectUtils.isEmpty((Object)list)) {
            int durationDays = 0;
            for (Map map : list) {
                boolean hasValueGreaterThanZero = false;
                for (Object value : map.values()) {
                    if (!(((Number)value).doubleValue() > 0.0)) continue;
                    hasValueGreaterThanZero = true;
                    break;
                }
                if (!hasValueGreaterThanZero) continue;
                ++durationDays;
            }
            vo.setDurationDays(durationDays);
        }
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveData(PmsProjectCalendarPayload payload) {
        this.nonEmptyValidation(payload);
        this.setFixedShiftSystem(payload);
        if (!ObjectUtils.isEmpty((Object)payload.getId())) {
            PmsProjectCalendarDO calendarDO = this.pmsProjectCalendarRepo.findById(payload.getId()).orElse(null);
            if (ObjectUtils.isEmpty((Object)calendarDO)) {
                throw TwException.error((String)"", (String)"\u5de5\u4f5c\u65e5\u5386\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            calendarDO.setStartDate(payload.getStartDate());
            calendarDO.setEndDate(payload.getEndDate());
            calendarDO.setSetFixedShiftSystemFlag(payload.getSetFixedShiftSystemFlag());
            calendarDO.setHoliday(payload.getHoliday());
            Gson gson = new Gson();
            calendarDO.setCalendarInfo(gson.toJson((Object)payload.getCalendarList()));
            this.pmsProjectCalendarRepo.save(calendarDO);
        } else {
            PmsProjectCalendarDO entityDo = PmsProjectCalendarConvert.INSTANCE.toDo(payload);
            Gson gson = new Gson();
            entityDo.setCalendarInfo(gson.toJson((Object)payload.getCalendarList()));
            this.pmsProjectCalendarRepo.save(entityDo);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchSave(List<PmsProjectCalendarPayload> list) {
        long count;
        List<Long> ids = list.stream().map(TwCommonPayload::getId).collect(Collectors.toList());
        if (!ObjectUtils.isEmpty(ids) && (count = this.pmsProjectCalendarRepo.findCountByKey(ids)) != (long)ids.size()) {
            throw TwException.error((String)"", (String)"\u5b58\u5728\u5de5\u4f5c\u65e5\u5386\u4e3b\u952e\u4e0d\u5b58\u5728\u95ee\u9898\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        ArrayList<PmsProjectCalendarDO> doList = new ArrayList<PmsProjectCalendarDO>();
        for (PmsProjectCalendarPayload payload : list) {
            this.nonEmptyValidation(payload);
            this.setFixedShiftSystem(payload);
            PmsProjectCalendarDO entityDo = PmsProjectCalendarConvert.INSTANCE.toDo(payload);
            Gson gson = new Gson();
            entityDo.setCalendarInfo(gson.toJson((Object)payload.getCalendarList()));
            doList.add(entityDo);
        }
        this.pmsProjectCalendarRepo.saveAll(doList);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        this.pmsProjectCalendarRepo.deleteByKey(keys);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoftBySource(List<Long> sourceIds, String sourceType) {
        this.pmsProjectCalendarRepo.deleteSoftBySource(sourceIds, sourceType);
    }

    private void nonEmptyValidation(PmsProjectCalendarPayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getSourceId())) {
            throw TwException.error((String)"", (String)"\u5173\u8054\u4e3b\u952e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getSourceType())) {
            throw TwException.error((String)"", (String)"\u5173\u8054\u7c7b\u578b\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getStartDate())) {
            throw TwException.error((String)"", (String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getEndDate())) {
            throw TwException.error((String)"", (String)"\u7ed3\u675f\u65e5\u671f\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
    }

    private void setFixedShiftSystem(PmsProjectCalendarPayload payload) {
        if (1 == payload.getSetFixedShiftSystemFlag()) {
            LinkedList info = new LinkedList();
            String holiday = payload.getHoliday();
            LocalDate startDate = payload.getStartDate();
            LocalDate endDate = payload.getEndDate();
            LocalDate currentDate = startDate;
            while (!currentDate.isAfter(endDate)) {
                DayOfWeek dayOfWeek = currentDate.getDayOfWeek();
                int day = dayOfWeek.getValue();
                HashMap<String, Double> m = new HashMap<String, Double>();
                if (!ObjectUtils.isEmpty((Object)holiday) && holiday.contains("" + day)) {
                    m.put(TimeUtil.dateToYmd((LocalDate)currentDate), 0.0);
                } else {
                    m.put(TimeUtil.dateToYmd((LocalDate)currentDate), 8.0);
                }
                info.add(m);
                currentDate = currentDate.plusDays(1L);
            }
            payload.setCalendarList(info);
        }
    }

    private List<Map<String, Object>> getInfo(LocalDate startDate, LocalDate endDate) {
        LinkedList<Map<String, Object>> info = new LinkedList<Map<String, Object>>();
        List list = this.vacationService.findListByDate(startDate, endDate);
        List<VacationVO> resultList = list.stream().sorted(Comparator.comparing(vo -> vo.getNaturalDate())).collect(Collectors.toList());
        resultList.forEach(twVacationView -> {
            HashMap<String, Float> map = new HashMap<String, Float>();
            map.put(TimeUtil.dateToYmd((LocalDate)twVacationView.getNaturalDate()), twVacationView.getWorkHours());
            info.add(map);
        });
        return info;
    }

    public PmsProjectCalendarServiceImpl(PmsProjectCalendarRepo pmsProjectCalendarRepo, VacationService vacationService) {
        this.pmsProjectCalendarRepo = pmsProjectCalendarRepo;
        this.vacationService = vacationService;
    }
}

