/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.project.service;

import com.elitescloud.cloudt.common.base.BaseViewModel;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.common.change.payload.ComChangePayload;
import com.elitesland.tw.tw5.api.common.change.service.ComChangeService;
import com.elitesland.tw.tw5.api.common.log.payload.ComLogPayload;
import com.elitesland.tw.tw5.api.common.log.service.ComLogService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.workFlow.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5pms.api.project.payload.PmsProjectPayload;
import com.elitesland.tw.tw5pms.api.project.query.PmsProjectQuery;
import com.elitesland.tw.tw5pms.api.project.service.PmsBudgetDetailPlanService;
import com.elitesland.tw.tw5pms.api.project.service.PmsProjectService;
import com.elitesland.tw.tw5pms.api.project.vo.PmsBudgetDetailPlanVO;
import com.elitesland.tw.tw5pms.api.project.vo.PmsProjectDataVO;
import com.elitesland.tw.tw5pms.api.project.vo.PmsProjectPlanDataVO;
import com.elitesland.tw.tw5pms.api.project.vo.PmsProjectTemplateVO;
import com.elitesland.tw.tw5pms.api.project.vo.PmsProjectVO;
import com.elitesland.tw.tw5pms.server.common.functionEnum.ComChangeTypeEnum;
import com.elitesland.tw.tw5pms.server.common.functionEnum.ComLogTypeEnum;
import com.elitesland.tw.tw5pms.server.common.functionEnum.PmsProcDefKey;
import com.elitesland.tw.tw5pms.server.common.functionEnum.ProjectStatusEnum;
import com.elitesland.tw.tw5pms.server.project.convert.PmsProjectConvert;
import com.elitesland.tw.tw5pms.server.project.dao.PmsProjectDAO;
import com.elitesland.tw.tw5pms.server.project.dao.PmsProjectTemplateDAO;
import com.elitesland.tw.tw5pms.server.project.entity.PmsProjectDO;
import com.elitesland.tw.tw5pms.server.project.repo.PmsProjectRepo;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Root;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class PmsProjectServiceImpl
extends BaseServiceImpl
implements PmsProjectService {
    private static final Logger log = LoggerFactory.getLogger(PmsProjectServiceImpl.class);
    private final PmsProjectRepo pmsProjectRepo;
    private final PmsProjectDAO pmsProjectDAO;
    private final CacheUtil cacheUtil;
    private final ComLogService logService;
    private final ComChangeService changeService;
    private final PmsProjectTemplateDAO pmsProjectTemplateDAO;
    private final WorkflowUtil workflowUtil;
    private final TransactionUtilService transactionUtilService;
    private final FileUtil fileUtil;
    private final PmsBudgetDetailPlanService pmsBudgetDetailPlanService;
    private final PrdOrgEmployeeService employeeService;
    @Value(value="${tw5pms.user.preson_cost:2000}")
    private BigDecimal preson_cost;

    public List<PmsProjectDataVO> queryUseAuthorizeList(PmsProjectQuery query) {
        Long userId = GlobalUtil.getLoginUserId();
        query.setPermissionFlag(Boolean.valueOf(false));
        query.setManagerUserId(userId);
        query.setProjectStatus(ProjectStatusEnum.APPROVED.getCode());
        List<PmsProjectVO> pmsProjectVOS = this.pmsProjectDAO.queryListDynamic(query);
        if (!ObjectUtils.isEmpty(pmsProjectVOS)) {
            Map maps = pmsProjectVOS.stream().collect(Collectors.toMap(BaseViewModel::getId, Function.identity()));
            List pmsBudgetDetailPlanVOS = this.pmsBudgetDetailPlanService.queryByProjectIds(new ArrayList<Long>(maps.keySet()), "PROJECT");
            List<PmsProjectDataVO> projectDataVOS = pmsBudgetDetailPlanVOS.stream().map(detailPlanVO -> {
                Long projectId = detailPlanVO.getProjectId();
                PmsProjectVO pmsProjectVO = (PmsProjectVO)maps.get(projectId);
                PmsProjectDataVO dataVO = new PmsProjectDataVO();
                dataVO.setId(projectId);
                dataVO.setProjectCode(pmsProjectVO.getProjectCode());
                dataVO.setProjectName(pmsProjectVO.getProjectName());
                dataVO.setResidueMoney(detailPlanVO.getResidueMoney());
                BigDecimal residueEqva = dataVO.getResidueMoney().divide(this.preson_cost, 4, RoundingMode.DOWN);
                dataVO.setResidueEqva(residueEqva);
                BigDecimal totalEqva = detailPlanVO.getTotalMoney().divide(this.preson_cost, 4, RoundingMode.DOWN);
                BigDecimal paidEqva = detailPlanVO.getPaidMoney().divide(this.preson_cost, 4, RoundingMode.DOWN);
                BigDecimal usedEqva = (detailPlanVO.getUsedMoney() == null ? BigDecimal.ZERO : detailPlanVO.getUsedMoney()).divide(this.preson_cost, 4, RoundingMode.DOWN);
                dataVO.setTotalEqva(totalEqva);
                dataVO.setPaidEqva(paidEqva);
                dataVO.setUsedEqva(usedEqva);
                return dataVO;
            }).collect(Collectors.toList());
            return projectDataVOS;
        }
        return null;
    }

    public PmsProjectDataVO queryProjectEqva(Long key) {
        List pmsBudgetDetailPlanVOS = this.pmsBudgetDetailPlanService.queryByProjectId(key, new String[]{"PROJECT"});
        if (!ObjectUtils.isEmpty((Object)pmsBudgetDetailPlanVOS)) {
            PmsBudgetDetailPlanVO detailPlanVO = (PmsBudgetDetailPlanVO)pmsBudgetDetailPlanVOS.get(0);
            PmsProjectDataVO dataVO = new PmsProjectDataVO();
            dataVO.setId(key);
            dataVO.setResidueMoney(detailPlanVO.getResidueMoney());
            BigDecimal residueEqva = dataVO.getResidueMoney().divide(this.preson_cost, 4, RoundingMode.DOWN);
            dataVO.setResidueEqva(residueEqva);
            BigDecimal totalEqva = detailPlanVO.getTotalMoney().divide(this.preson_cost, 4, RoundingMode.DOWN);
            BigDecimal paidEqva = detailPlanVO.getPaidMoney().divide(this.preson_cost, 4, RoundingMode.DOWN);
            BigDecimal usedEqva = (detailPlanVO.getUsedMoney() == null ? BigDecimal.ZERO : detailPlanVO.getUsedMoney()).divide(this.preson_cost, 4, RoundingMode.DOWN);
            dataVO.setTotalEqva(totalEqva);
            dataVO.setPaidEqva(paidEqva);
            dataVO.setUsedEqva(usedEqva);
            return dataVO;
        }
        throw TwException.error((String)"", (String)"\u67e5\u8be2\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
    }

    public List<PmsProjectDataVO> queryUseTaskList(PmsProjectQuery query) {
        Long userId = GlobalUtil.getLoginUserId();
        query.setPermissionFlag(Boolean.valueOf(false));
        query.setManagerUserId(userId);
        query.setProjectStatus(ProjectStatusEnum.APPROVED.getCode());
        List<PmsProjectVO> pmsProjectVOS = this.pmsProjectDAO.queryListDynamic(query);
        HashMap<Long, PmsProjectVO> maps = new HashMap<Long, PmsProjectVO>();
        if (!ObjectUtils.isEmpty(pmsProjectVOS)) {
            Map maps0 = pmsProjectVOS.stream().collect(Collectors.toMap(BaseViewModel::getId, Function.identity()));
            maps.putAll(maps0);
        }
        query.setLoginUserId(userId);
        List<PmsProjectVO> pmsProjectVOS1 = this.pmsProjectDAO.queryTaskAuthorizeList(query);
        if (!ObjectUtils.isEmpty(pmsProjectVOS1)) {
            Map maps1 = pmsProjectVOS1.stream().collect(Collectors.toMap(BaseViewModel::getId, Function.identity()));
            maps.putAll(maps1);
        }
        HashSet projectIds = new HashSet();
        if (!ObjectUtils.isEmpty(maps)) {
            projectIds.addAll(maps.keySet());
        }
        List<PmsProjectDataVO> projectVOs = null;
        if (projectIds.size() > 0) {
            List pmsBudgetDetailPlanVOS = this.pmsBudgetDetailPlanService.queryByProjectIds(new ArrayList(projectIds), null);
            projectVOs = this.operBudgetDetailPlan(pmsBudgetDetailPlanVOS, maps, userId);
        }
        return projectVOs;
    }

    List<PmsProjectDataVO> operBudgetDetailPlan(List<PmsBudgetDetailPlanVO> pmsBudgetDetailPlanVOS, Map<Long, PmsProjectVO> maps, Long userId) {
        ArrayList<PmsProjectDataVO> projectVOs = new ArrayList<PmsProjectDataVO>();
        if (!ObjectUtils.isEmpty(pmsBudgetDetailPlanVOS)) {
            List<Map<String, Object>> costTypes;
            List<Long> planActIds = pmsBudgetDetailPlanVOS.stream().filter(vo -> vo.getPlanId() != null && vo.getPlanType().equals("ACT")).map(PmsBudgetDetailPlanVO::getPlanId).collect(Collectors.toList());
            HashMap maps1 = new HashMap();
            if (!ObjectUtils.isEmpty(planActIds) && !ObjectUtils.isEmpty(costTypes = this.pmsProjectRepo.queryPlanWbs(planActIds))) {
                costTypes.forEach(costType -> maps1.put(Long.valueOf("" + costType.get("id")), "" + costType.get("act_cost_type")));
            }
            List<PmsBudgetDetailPlanVO> collect = pmsBudgetDetailPlanVOS.stream().filter(vo -> vo.getPlanType().equals("PROJECT")).collect(Collectors.toList());
            collect.forEach(budgetDetailPlanVO -> {
                Long projectId = budgetDetailPlanVO.getProjectId();
                PmsProjectVO pmsProjectVO = (PmsProjectVO)maps.get(projectId);
                PmsProjectDataVO dataVO = new PmsProjectDataVO();
                dataVO.setId(projectId);
                if (pmsProjectVO.getManagerUserId().equals(userId)) {
                    dataVO.setIsEmpower(Boolean.valueOf(false));
                } else {
                    dataVO.setIsEmpower(Boolean.valueOf(true));
                    dataVO.setAuthorizeStatus(pmsProjectVO.getAuthorizeStatus());
                }
                dataVO.setProjectCode(pmsProjectVO.getProjectCode());
                dataVO.setProjectName(pmsProjectVO.getProjectName());
                dataVO.setResidueMoney(budgetDetailPlanVO.getResidueMoney());
                BigDecimal residueEqva = dataVO.getResidueMoney().divide(this.preson_cost, 4, RoundingMode.DOWN);
                dataVO.setResidueEqva(residueEqva);
                projectVOs.add(dataVO);
                ArrayList planStageVOs = new ArrayList();
                dataVO.setPlanStageVOs(planStageVOs);
                List<PmsBudgetDetailPlanVO> collect1 = pmsBudgetDetailPlanVOS.stream().filter(vo -> vo.getProjectId().equals(projectId) && vo.getPlanType().equals("STAGE")).collect(Collectors.toList());
                collect1.forEach(budgetDetailPlanVO1 -> {
                    Long planId = budgetDetailPlanVO1.getPlanId();
                    PmsProjectPlanDataVO planStageVO = new PmsProjectPlanDataVO();
                    planStageVO.setId(planId);
                    planStageVO.setPlanName(budgetDetailPlanVO1.getPlanName());
                    planStageVO.setResidueMoney(budgetDetailPlanVO1.getResidueMoney());
                    BigDecimal residueEqva1 = planStageVO.getResidueMoney().divide(this.preson_cost, 4, RoundingMode.DOWN);
                    planStageVO.setResidueEqva(residueEqva1);
                    planStageVOs.add(planStageVO);
                    ArrayList planActVOs = new ArrayList();
                    planStageVO.setPlanActVOs(planActVOs);
                    List<PmsBudgetDetailPlanVO> collect2 = pmsBudgetDetailPlanVOS.stream().filter(vo -> vo.getPlanParentId() != null && vo.getPlanParentId().equals(planId) && vo.getPlanType().equals("ACT")).collect(Collectors.toList());
                    collect2.forEach(budgetDetailPlanVO2 -> {
                        Long planId1 = budgetDetailPlanVO2.getPlanId();
                        PmsProjectPlanDataVO planActVO = new PmsProjectPlanDataVO();
                        planActVO.setId(planId1);
                        planActVO.setCooperationType((String)maps1.get(planId1));
                        planActVO.setPlanName(budgetDetailPlanVO2.getPlanName());
                        planActVO.setResidueMoney(budgetDetailPlanVO2.getResidueMoney());
                        BigDecimal residueEqva2 = planActVO.getResidueMoney().divide(this.preson_cost, 4, RoundingMode.DOWN);
                        planActVO.setResidueEqva(residueEqva2);
                        planActVOs.add(planActVO);
                    });
                });
            });
        }
        return projectVOs;
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsProjectVO insert(PmsProjectPayload payload) {
        this.checkData(payload);
        PmsProjectTemplateVO pmsProjectTemplateVO = this.pmsProjectTemplateDAO.queryByKey(payload.getTemplateId());
        PmsProjectDO entityDo = PmsProjectConvert.INSTANCE.toDo(payload);
        String code = this.generateSeqNum("CRM_PRODUCT_PRICE", new String[0]);
        entityDo.setProjectCode(code);
        entityDo.setHideFields(pmsProjectTemplateVO.getHideFields());
        entityDo.setProjectStatus(ProjectStatusEnum.CREATE.getCode());
        entityDo = this.pmsProjectDAO.save(entityDo);
        ComLogPayload logPayload = new ComLogPayload();
        logPayload.setObjectId("" + entityDo.getId());
        logPayload.setLogType(ComLogTypeEnum.pms_project.getCode());
        String content = "\u65b0\u589e\u9879\u76ee\uff1a\u3010" + entityDo.getProjectName() + "\u3011";
        logPayload.setLogContent(content);
        this.logService.insert(logPayload);
        if (payload.getSubmit().booleanValue()) {
            payload.setId(entityDo.getId());
            this.submitProc(payload);
        }
        return PmsProjectConvert.INSTANCE.toVo(entityDo);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Transactional(rollbackFor={Exception.class})
    public PmsProjectVO update(PmsProjectPayload payload) {
        PmsProjectVO pmsProjectVO = this.pmsProjectDAO.queryByKey(payload.getId());
        if (ObjectUtils.isEmpty((Object)pmsProjectVO)) throw TwException.error((String)"", (String)"\u53d8\u66f4\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        this.checkData(payload);
        if (pmsProjectVO.getProjectStatus().equals(ProjectStatusEnum.CREATE.getCode())) {
            this.updateProject(payload);
            if (!payload.getSubmit().booleanValue()) return null;
            this.submitProc(payload);
            return null;
        } else {
            if (!pmsProjectVO.getProjectStatus().equals(ProjectStatusEnum.APPROVED.getCode())) throw TwException.error((String)"", (String)"\u4ec5\u65b0\u5efa\u548c\u6fc0\u6d3b\u72b6\u6001\u652f\u6301\u53d8\u66f4\uff0c\u8bf7\u6838\u9a8c\uff01");
            this.transferData(pmsProjectVO);
            PmsProjectVO pmsProjectVO1 = PmsProjectConvert.INSTANCE.toVO(payload);
            this.transferData(pmsProjectVO1);
            Long saveId = this.changeService.save(ComChangeTypeEnum.PMS_PROJECT_CHANGE.getCode(), (Object)PmsProjectConvert.INSTANCE.toPayload(pmsProjectVO), (Object)PmsProjectConvert.INSTANCE.toPayload(pmsProjectVO1), "" + payload.getId());
            ProcessInfo processInfo = this.startChangeWorkFlow(pmsProjectVO, saveId);
            String status = ProjectStatusEnum.APPROVING.getCode();
            String changeStatus = WorkFlowStatusEnum.CHANGING_WORK.getCode();
            if (processInfo.getProcInstStatus().equals((Object)ProcInstStatus.APPROVED)) {
                status = ProjectStatusEnum.APPROVED.getCode();
                changeStatus = WorkFlowStatusEnum.APPROVED_WORK.getCode();
            }
            PmsProjectPayload payload0 = new PmsProjectPayload();
            payload0.setId(payload.getId());
            payload0.setSubmitTime(LocalDateTime.now());
            payload0.setProjectStatus(status);
            ComChangePayload changePayload = new ComChangePayload();
            changePayload.setId(saveId);
            changePayload.setApprProcInstId(processInfo.getProcInstId());
            changePayload.setApprStatus(processInfo.getProcInstStatus().name());
            changePayload.setChangeStatus(changeStatus);
            this.transactionUtilService.executeWithRunnable(() -> {
                this.pmsProjectDAO.updateWorkFlow(payload0);
                this.changeService.updateWorkFlow(changePayload);
            });
        }
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateWorkflowProject(PmsProjectPayload payload) {
        PmsProjectVO pmsProjectVO = this.pmsProjectDAO.queryByKey(payload.getId());
        if (pmsProjectVO != null) {
            if (!pmsProjectVO.getProjectStatus().equals(ProjectStatusEnum.APPROVING_EJECTED.getCode())) {
                throw TwException.error((String)"", (String)"\u4ec5\u652f\u6301\u6d41\u7a0b\u88ab\u9a73\u56de\u7684\u53d8\u66f4\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
        } else {
            throw TwException.error((String)"", (String)"\u53d8\u66f4\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        PmsProjectVO pmsProjectVO1 = PmsProjectConvert.INSTANCE.toVO(payload);
        this.transferData(pmsProjectVO1);
        this.changeService.update(ComChangeTypeEnum.PMS_PROJECT_CHANGE.getCode(), "" + payload.getId(), (Object)PmsProjectConvert.INSTANCE.toPayload(pmsProjectVO1));
    }

    public List<PmsProjectVO> queryListByIds(List<Long> projectIds) {
        return this.pmsProjectDAO.queryByKeys(projectIds);
    }

    private ProcessInfo startChangeWorkFlow(PmsProjectVO pmsProjectVO, Long saveId) {
        HashMap<String, ArrayList> batchMap = new HashMap<String, ArrayList>();
        batchMap.put("Activity_1kq74go", Lists.newArrayList((Object[])new String[]{pmsProjectVO.getPmoManagerUserId().toString()}));
        batchMap.put("Activity_0suh44b", Lists.newArrayList((Object[])new String[]{pmsProjectVO.getManagerUserId().toString()}));
        ProcessInfo processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)PmsProcDefKey.PMS_PROJECT_CHANGE.name(), (String)(pmsProjectVO.getProjectName() + "-\u9879\u76ee\u53d8\u66f4\u5ba1\u6279\u6d41\u7a0b"), (String)("" + saveId), batchMap));
        return processInfo;
    }

    void submitProc(PmsProjectPayload payload) {
        HashMap<String, ArrayList> batchMap = new HashMap<String, ArrayList>();
        batchMap.put("Activity_1kq74go", Lists.newArrayList((Object[])new String[]{payload.getPmoManagerUserId().toString()}));
        batchMap.put("Activity_0suh44b", Lists.newArrayList((Object[])new String[]{payload.getManagerUserId().toString()}));
        ProcessInfo processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)PmsProcDefKey.PMS_PROJECT.name(), (String)(payload.getProjectName() + "-\u9879\u76ee\u5ba1\u6279\u6d41\u7a0b"), (String)("" + payload.getId()), batchMap));
        PmsProjectPayload payload0 = new PmsProjectPayload();
        payload0.setId(payload.getId());
        payload0.setProcInstId(processInfo.getProcInstId());
        payload0.setProcInstStatus(processInfo.getProcInstStatus());
        payload0.setSubmitTime(LocalDateTime.now());
        String status = ProjectStatusEnum.APPROVING.getCode();
        if (processInfo.getProcInstStatus().equals((Object)ProcInstStatus.APPROVED)) {
            status = ProjectStatusEnum.APPROVED.getCode();
        }
        payload0.setProjectStatus(status);
        this.transactionUtilService.executeWithRunnable(() -> this.pmsProjectDAO.updateWorkFlow(payload0));
    }

    public void updateProject(PmsProjectPayload payload) {
        PmsProjectDO entityDo = PmsProjectConvert.INSTANCE.toDo(payload);
        this.pmsProjectDAO.save(entityDo);
        ComLogPayload logPayload = new ComLogPayload();
        logPayload.setObjectId("" + entityDo.getId());
        logPayload.setLogType(ComLogTypeEnum.pms_project.getCode());
        String content = "\u7f16\u8f91\u9879\u76ee\uff1a\u3010" + entityDo.getProjectName() + "\u3011";
        logPayload.setLogContent(content);
        this.logService.insert(logPayload);
    }

    public PagingVO<PmsProjectVO> queryPaging(PmsProjectQuery query) {
        this.operPermissionFlag(query);
        PagingVO<PmsProjectVO> projectVOPagingVO = this.pmsProjectDAO.queryPaging(query);
        projectVOPagingVO.getRecords().forEach(vo -> this.transferData((PmsProjectVO)vo));
        return projectVOPagingVO;
    }

    void transferData(PmsProjectVO vo) {
        vo.setContractFilesDatas(this.fileUtil.getFileDatas(vo.getContractFiles()));
        vo.setSowFilesDatas(this.fileUtil.getFileDatas(vo.getSowFiles()));
        vo.setBudgetFilesDatas(this.fileUtil.getFileDatas(vo.getBudgetFiles()));
        vo.setCreator(this.cacheUtil.getUserName(vo.getCreateUserId()));
        vo.setCustIndustryName(this.cacheUtil.transferSystemSelection("crm:leads_customer_industry", vo.getCustIndustry()));
        vo.setProjectTypeName(this.cacheUtil.transferSystemSelection("PMS:PROJECT:TYPE", vo.getProjectType()));
        vo.setTimesheetPeriodName(this.cacheUtil.transferSystemSelection("PMS:PROJECT:TIMESHEET", vo.getTimesheetPeriod()));
        vo.setProjectImportanceName(this.cacheUtil.transferSystemSelection("PMS:PROJECT:IMPORTANCE", vo.getProjectImportance()));
        vo.setProjectDifficultyName(this.cacheUtil.transferSystemSelection("PMS:PROJECT;DIFFICULTY", vo.getProjectDifficulty()));
        vo.setProjectStatusName(this.cacheUtil.transferSystemSelection("PMS:PROJECT:STATUS", vo.getProjectStatus()));
        vo.setManagerUserName(this.cacheUtil.getUserName(vo.getManagerUserId()));
        vo.setPmoManagerUserName(this.cacheUtil.getUserName(vo.getPmoManagerUserId()));
        vo.setSaleManagerUserName(this.cacheUtil.getUserName(vo.getSaleManagerUserId()));
        vo.setPayManagerUserName(this.cacheUtil.getUserName(vo.getPayManagerUserId()));
        vo.setFinanceUserName(this.cacheUtil.getUserName(vo.getFinanceUserId()));
        vo.setCreator(this.cacheUtil.getUserName(vo.getCreateUserId()));
    }

    public List<PmsProjectVO> queryList(PmsProjectQuery query) {
        return PmsProjectConvert.INSTANCE.toVoList(this.pmsProjectRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate((Root)root, (Object)query, (CriteriaBuilder)criteriaBuilder), query.getPageRequest().getSort()));
    }

    public List<PmsProjectVO> queryListDynamic(PmsProjectQuery query) {
        this.operPermissionFlag(query);
        return this.pmsProjectDAO.queryListDynamic(query);
    }

    public PmsProjectVO queryByKey(Long key) {
        PmsProjectVO pmsProjectVO = this.pmsProjectDAO.queryByKey(key);
        this.transferData(pmsProjectVO);
        return pmsProjectVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public void submitStartProject(Long key) {
        PmsProjectVO pmsProjectVO = this.pmsProjectDAO.queryByKey(key);
        if (ObjectUtils.isEmpty((Object)pmsProjectVO)) {
            throw TwException.error((String)"", (String)"\u63d0\u4ea4\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        PmsProjectPayload pmsProjectPayload = PmsProjectConvert.INSTANCE.toPayload(pmsProjectVO);
        this.submitProc(pmsProjectPayload);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            List<PmsProjectVO> pmsProjectVOS = this.pmsProjectDAO.queryByKeys(keys);
            Object content = "\u5220\u9664\u9879\u76ee\uff1a\u3010";
            for (PmsProjectVO pmsProjectVO : pmsProjectVOS) {
                String projectStatus = pmsProjectVO.getProjectStatus();
                if (!projectStatus.equals(ProjectStatusEnum.CREATE.getCode()) && !projectStatus.equals(ProjectStatusEnum.PENDING.getCode())) {
                    throw TwException.error((String)"", (String)"\u4ec5\u652f\u6301\u65b0\u5efa\u548c\u6682\u6302\u72b6\u6001\u4e0b\u7684\u5220\u9664\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
                content = (String)content + pmsProjectVO.getProjectName() + "\u3011,\u3010";
            }
            this.pmsProjectDAO.deleteSoft(keys);
            ComLogPayload logPayload = new ComLogPayload();
            logPayload.setObjectId("");
            logPayload.setLogType(ComLogTypeEnum.pms_project.getCode());
            content = ((String)content).substring(0, ((String)content).length() - 2);
            logPayload.setLogContent((String)content);
            this.logService.insert(logPayload);
        }
    }

    void checkData(PmsProjectPayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getCustId())) {
            throw TwException.error((String)"", (String)"\u5173\u8054\u5ba2\u6237\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getTemplateId())) {
            throw TwException.error((String)"", (String)"\u672a\u9009\u62e9\u6a21\u677f\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getManagerUserId())) {
            throw TwException.error((String)"", (String)"\u9879\u76ee\u7ecf\u7406\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getPmoManagerUserId())) {
            throw TwException.error((String)"", (String)"pmo\u8d1f\u8d23\u4eba\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getPayManagerUserId())) {
            throw TwException.error((String)"", (String)"\u4ea4\u4ed8\u8d1f\u8d23\u4eba\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getFinanceUserId())) {
            throw TwException.error((String)"", (String)"\u8d22\u52a1\u8d1f\u8d23\u4eba\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
    }

    void operPermissionFlag(PmsProjectQuery query) {
        Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.PROJECT_ADMIN.getCode()));
        query.setPermissionFlag(Boolean.valueOf(rolePermission == false));
        if (!rolePermission.booleanValue()) {
            Long loginUserId = GlobalUtil.getLoginUserId();
            query.setLoginUserId(loginUserId);
            Set longs = this.employeeService.querySubordinatesIdsByUserId(loginUserId);
            query.setLowerUserIds(longs);
        }
    }

    public PmsProjectServiceImpl(PmsProjectRepo pmsProjectRepo, PmsProjectDAO pmsProjectDAO, CacheUtil cacheUtil, ComLogService logService, ComChangeService changeService, PmsProjectTemplateDAO pmsProjectTemplateDAO, WorkflowUtil workflowUtil, TransactionUtilService transactionUtilService, FileUtil fileUtil, PmsBudgetDetailPlanService pmsBudgetDetailPlanService, PrdOrgEmployeeService employeeService) {
        this.pmsProjectRepo = pmsProjectRepo;
        this.pmsProjectDAO = pmsProjectDAO;
        this.cacheUtil = cacheUtil;
        this.logService = logService;
        this.changeService = changeService;
        this.pmsProjectTemplateDAO = pmsProjectTemplateDAO;
        this.workflowUtil = workflowUtil;
        this.transactionUtilService = transactionUtilService;
        this.fileUtil = fileUtil;
        this.pmsBudgetDetailPlanService = pmsBudgetDetailPlanService;
        this.employeeService = employeeService;
    }
}

