/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.project.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5pms.api.project.payload.PmsProjectTeamBasePayload;
import com.elitesland.tw.tw5pms.api.project.query.PmsProjectTeamBaseQuery;
import com.elitesland.tw.tw5pms.api.project.service.PmsProjectTeamBaseService;
import com.elitesland.tw.tw5pms.api.project.vo.PmsProjectTeamBaseVO;
import com.elitesland.tw.tw5pms.server.project.convert.PmsProjectTeamBaseConvert;
import com.elitesland.tw.tw5pms.server.project.dao.PmsProjectTeamBaseDAO;
import com.elitesland.tw.tw5pms.server.project.entity.PmsProjectTeamBaseDO;
import com.elitesland.tw.tw5pms.server.project.repo.PmsProjectTeamBaseRepo;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Root;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class PmsProjectTeamBaseServiceImpl
extends BaseServiceImpl
implements PmsProjectTeamBaseService {
    private static final Logger log = LoggerFactory.getLogger(PmsProjectTeamBaseServiceImpl.class);
    private final PmsProjectTeamBaseRepo pmsProjectTeamBaseRepo;
    private final PmsProjectTeamBaseDAO pmsProjectTeamBaseDAO;

    @Transactional(rollbackFor={Exception.class})
    public PmsProjectTeamBaseVO insert(PmsProjectTeamBasePayload payload) {
        this.checkStartWeek(payload);
        PmsProjectTeamBaseDO entityDo = PmsProjectTeamBaseConvert.INSTANCE.toDo(payload);
        entityDo.setStopDate(entityDo.getStartDate().plusWeeks(entityDo.getContinueWeek().intValue()));
        return PmsProjectTeamBaseConvert.INSTANCE.toVo((PmsProjectTeamBaseDO)this.pmsProjectTeamBaseRepo.save(entityDo));
    }

    private void checkStartWeek(PmsProjectTeamBasePayload payload) {
        LocalDate startDate = payload.getStartDate();
        Date date = Date.from(startDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (calendar.get(7) - 1 != 1) {
            throw TwException.error((String)"", (String)"\u5f00\u59cb\u5468\u5fc5\u987b\u4e3a\u5468\u4e00\uff01");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsProjectTeamBaseVO update(PmsProjectTeamBasePayload payload) {
        PmsProjectTeamBaseDO entity = this.pmsProjectTeamBaseRepo.findById(payload.getId()).orElseGet(PmsProjectTeamBaseDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        this.checkStartWeek(payload);
        PmsProjectTeamBaseDO entityDo = PmsProjectTeamBaseConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        entity.setStopDate(entity.getStartDate().plusWeeks(entity.getContinueWeek().intValue()));
        return PmsProjectTeamBaseConvert.INSTANCE.toVo((PmsProjectTeamBaseDO)this.pmsProjectTeamBaseRepo.save(entity));
    }

    public PmsProjectTeamBaseVO queryByProjectId(Long projectId) {
        PmsProjectTeamBaseDO entity = this.pmsProjectTeamBaseRepo.findByProjectId(projectId).orElseGet(PmsProjectTeamBaseDO::new);
        PmsProjectTeamBaseVO vo = PmsProjectTeamBaseConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.pmsProjectTeamBaseDAO.deleteSoft(keys);
        }
    }

    public PmsProjectTeamBaseVO queryByKey(Long key) {
        PmsProjectTeamBaseDO entity = this.pmsProjectTeamBaseRepo.findById(key).orElseGet(PmsProjectTeamBaseDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PmsProjectTeamBaseVO vo = PmsProjectTeamBaseConvert.INSTANCE.toVo(entity);
        return vo;
    }

    public PagingVO<PmsProjectTeamBaseVO> paging(PmsProjectTeamBaseQuery query) {
        Page page = this.pmsProjectTeamBaseRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate((Root)root, (Object)query, (CriteriaBuilder)criteriaBuilder), (Pageable)query.getPageRequest());
        return PageUtil.toPageVo((Page)page.map(PmsProjectTeamBaseConvert.INSTANCE::toVo));
    }

    public PagingVO<PmsProjectTeamBaseVO> queryPaging(PmsProjectTeamBaseQuery query) {
        return this.pmsProjectTeamBaseDAO.queryPaging(query);
    }

    public List<PmsProjectTeamBaseVO> queryList(PmsProjectTeamBaseQuery query) {
        return PmsProjectTeamBaseConvert.INSTANCE.toVoList(this.pmsProjectTeamBaseRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate((Root)root, (Object)query, (CriteriaBuilder)criteriaBuilder), query.getPageRequest().getSort()));
    }

    public List<PmsProjectTeamBaseVO> queryListDynamic(PmsProjectTeamBaseQuery query) {
        return this.pmsProjectTeamBaseDAO.queryListDynamic(query);
    }

    public List<PmsProjectTeamBaseVO> queryByKeys(Set<Long> keys) {
        if (!keys.isEmpty()) {
            return this.pmsProjectTeamBaseDAO.queryByKeys(keys);
        }
        return new ArrayList<PmsProjectTeamBaseVO>();
    }

    public PmsProjectTeamBaseServiceImpl(PmsProjectTeamBaseRepo pmsProjectTeamBaseRepo, PmsProjectTeamBaseDAO pmsProjectTeamBaseDAO) {
        this.pmsProjectTeamBaseRepo = pmsProjectTeamBaseRepo;
        this.pmsProjectTeamBaseDAO = pmsProjectTeamBaseDAO;
    }
}

