/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.project.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.prd.my.vo.PrdUserCompositeVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5pms.api.project.payload.PmsProjectTeamMemberPayload;
import com.elitesland.tw.tw5pms.api.project.payload.PmsProjectTeamMemberWeekPayload;
import com.elitesland.tw.tw5pms.api.project.query.PmsProjectTeamMemberQuery;
import com.elitesland.tw.tw5pms.api.project.service.PmsProjectTeamMemberService;
import com.elitesland.tw.tw5pms.api.project.vo.PmsProjectTeamMemberVO;
import com.elitesland.tw.tw5pms.api.project.vo.PmsProjectTeamMemberWeekVO;
import com.elitesland.tw.tw5pms.server.project.convert.PmsProjectTeamMemberConvert;
import com.elitesland.tw.tw5pms.server.project.dao.PmsProjectTeamMemberDAO;
import com.elitesland.tw.tw5pms.server.project.entity.PmsProjectTeamMemberDO;
import com.elitesland.tw.tw5pms.server.project.repo.PmsProjectTeamMemberRepo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Root;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class PmsProjectTeamMemberServiceImpl
extends BaseServiceImpl
implements PmsProjectTeamMemberService {
    private static final Logger log = LoggerFactory.getLogger(PmsProjectTeamMemberServiceImpl.class);
    private final PmsProjectTeamMemberRepo pmsProjectTeamMemberRepo;
    private final PmsProjectTeamMemberDAO pmsProjectTeamMemberDAO;
    private final CacheUtil cacheUtil;

    public PagingVO<PmsProjectTeamMemberVO> queryPaging(PmsProjectTeamMemberQuery query) {
        PagingVO<PmsProjectTeamMemberVO> pagingVO = this.pmsProjectTeamMemberDAO.queryPaging(query);
        pagingVO.getRecords().forEach(this::transferData);
        pagingVO.getRecords().forEach(this::setWeekData);
        return pagingVO;
    }

    void transferData(PmsProjectTeamMemberVO vo) {
        vo.setUserName(this.cacheUtil.getUserName(vo.getUserId()));
        vo.setWorkTypeName(this.cacheUtil.transferSystemSelection("org:employee:worktype", vo.getWorkType()));
        vo.setSpecialtyLevelName(this.cacheUtil.transferSystemSelection("org:employee:specialtylevel", vo.getProfessionalLevel()));
    }

    void setWeekData(PmsProjectTeamMemberVO vo) {
        List list = JSONArray.parseArray((String)vo.getWeekData(), PmsProjectTeamMemberWeekVO.class);
        vo.setWeeks(list);
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsProjectTeamMemberVO insert(List<PmsProjectTeamMemberPayload> payloads) {
        if (payloads.isEmpty()) {
            throw TwException.error((String)"", (String)"\u6dfb\u52a0\u8d44\u6e90\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        List collect = payloads.stream().map(PmsProjectTeamMemberPayload::getUserId).distinct().collect(Collectors.toList());
        if (collect.size() < payloads.size()) {
            throw TwException.error((String)"", (String)"\u8d44\u6e90\u4e0d\u53ef\u91cd\u590d\u6dfb\u52a0\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        List<PmsProjectTeamMemberVO> vos = this.pmsProjectTeamMemberDAO.queryByProjectId(payloads.get(0).getProjectId());
        payloads.forEach(payload -> {
            PmsProjectTeamMemberVO pmsProjectTeamMemberVO;
            Optional<PmsProjectTeamMemberVO> first;
            this.checkData((PmsProjectTeamMemberPayload)payload);
            this.checkDate((PmsProjectTeamMemberPayload)payload);
            this.checkDays((PmsProjectTeamMemberPayload)payload);
            this.assignmentComposite((PmsProjectTeamMemberPayload)payload);
            if (!ObjectUtils.isEmpty((Object)vos) && (first = vos.stream().filter(vo -> vo.getUserId().equals(payload.getUserId())).findFirst()).isPresent() && !(pmsProjectTeamMemberVO = first.get()).getId().equals(payload.getId())) {
                throw TwException.error((String)"", (String)"\u8d44\u6e90\u4e0d\u53ef\u91cd\u590d\u6dfb\u52a0\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            String jsonString = JSON.toJSONString((Object)payload.getWeeks());
            payload.setWeekData(jsonString);
        });
        List<PmsProjectTeamMemberDO> entityDos = PmsProjectTeamMemberConvert.INSTANCE.toDos(payloads);
        this.pmsProjectTeamMemberRepo.saveAll(entityDos);
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void assignmentComposite(PmsProjectTeamMemberPayload teamMemberPayload) {
        PrdUserCompositeVO prdUserCompositeVO = this.pmsProjectTeamMemberDAO.queryCompositeById(teamMemberPayload.getCompositeId());
        if (prdUserCompositeVO == null) throw TwException.error((String)"", (String)"\u9009\u4e2d\u590d\u5408\u80fd\u529b\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        if (prdUserCompositeVO.getUserId() != -1L && !prdUserCompositeVO.getUserId().equals(teamMemberPayload.getUserId())) throw TwException.error((String)"", (String)"\u9009\u4e2d\u590d\u5408\u80fd\u529b\u5f52\u5c5e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        teamMemberPayload.setWorkType(prdUserCompositeVO.getWorkType());
        teamMemberPayload.setProfessionalLevel(prdUserCompositeVO.getSpecialtyLevel());
        PrdSystemSelectionVO prdSystemSelectionVO = this.cacheUtil.transferSystemSelectionObj("org:employee:specialtylevel", prdUserCompositeVO.getSpecialtyLevel());
        if (prdSystemSelectionVO == null) {
            throw TwException.error((String)"", (String)"\u9009\u4e2d\u5de5\u79cd\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        teamMemberPayload.setEqvaRatio(new BigDecimal(String.valueOf(prdSystemSelectionVO.getExtString1())));
    }

    private void checkData(PmsProjectTeamMemberPayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getStartDate())) {
            throw TwException.error((String)"", (String)"\u9884\u8ba1\u5f00\u59cb\u65e5\u671f\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getStopDate())) {
            throw TwException.error((String)"", (String)"\u9884\u8ba1\u7ed3\u675f\u65e5\u671f\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getWeeks())) {
            throw TwException.error((String)"", (String)"WEEK\u5929\u6570\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
    }

    private void checkDate(PmsProjectTeamMemberPayload payload) {
        if (payload.getStartDate().isBefore(payload.getPmsProjectTeamBasePayload().getStartDate())) {
            throw TwException.error((String)"", (String)"\u9884\u8ba1\u5f00\u59cb\u65e5\u671f\u4e0d\u5f97\u65e9\u4e8e\u5f00\u59cb\u5468\uff01");
        }
        if (payload.getStopDate().isAfter(payload.getPmsProjectTeamBasePayload().getStopDate())) {
            throw TwException.error((String)"", (String)"\u9884\u8ba1\u7ed3\u675f\u65e5\u671f\u4e0d\u5f97\u665a\u4e8e\u7ed3\u675f\u5468\uff01");
        }
        if (payload.getStartDate().isAfter(payload.getStopDate())) {
            throw TwException.error((String)"", (String)"\u9884\u8ba1\u7ed3\u675f\u65e5\u671f\u4e0d\u5f97\u5728\u9884\u8ba1\u5f00\u59cb\u65e5\u671f\u4e4b\u524d\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
    }

    private void checkDays(PmsProjectTeamMemberPayload payload) {
        List pmsProjectTeamMemberWeekPayloads = payload.getWeeks();
        if (pmsProjectTeamMemberWeekPayloads.size() > 0) {
            for (PmsProjectTeamMemberWeekPayload pmsProjectTeamMemberWeekPayload : pmsProjectTeamMemberWeekPayloads) {
                if (pmsProjectTeamMemberWeekPayload.getDays() == null || !(pmsProjectTeamMemberWeekPayload.getDays() > 7.0)) continue;
                throw TwException.error((String)"", (String)"\u4eba\u5929\u4e0d\u5f97\u5927\u4e8e6");
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsProjectTeamMemberVO update(PmsProjectTeamMemberPayload payload) {
        PmsProjectTeamMemberDO entity = this.pmsProjectTeamMemberRepo.findById(payload.getId()).orElseGet(PmsProjectTeamMemberDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        if (this.pmsProjectTeamMemberDAO.queryByUserIdAndBaseId(payload) != null && !Objects.equals(this.pmsProjectTeamMemberDAO.queryByKey(payload.getId()).getId(), payload.getId())) {
            throw TwException.error((String)"", (String)"\u8be5\u8d44\u6e90\u5df2\u5b58\u5728\uff01");
        }
        this.checkData(payload);
        this.checkDate(payload);
        this.checkDays(payload);
        JSONArray jsonArray = JSON.parseArray((String)JSON.toJSONString((Object)payload.getWeeks()));
        PmsProjectTeamMemberDO entityDo = PmsProjectTeamMemberConvert.INSTANCE.toDo(payload);
        entityDo.setWeekData(jsonArray.toString());
        entity.copy(entityDo);
        return PmsProjectTeamMemberConvert.INSTANCE.toVo((PmsProjectTeamMemberDO)this.pmsProjectTeamMemberRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.pmsProjectTeamMemberDAO.deleteSoft(keys);
        }
    }

    public List<Long> getProjectIdByUserId(Long userId) {
        List<PmsProjectTeamMemberVO> list = this.pmsProjectTeamMemberDAO.queryByUserId(userId);
        if (!ObjectUtils.isEmpty(list)) {
            return list.stream().filter(vo -> !ObjectUtils.isEmpty((Object)vo.getProjectId())).map(PmsProjectTeamMemberVO::getProjectId).toList();
        }
        return null;
    }

    public PmsProjectTeamMemberVO queryByKey(Long key) {
        PmsProjectTeamMemberDO entity = this.pmsProjectTeamMemberRepo.findById(key).orElseGet(PmsProjectTeamMemberDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        return PmsProjectTeamMemberConvert.INSTANCE.toVo(entity);
    }

    public PagingVO<PmsProjectTeamMemberVO> paging(PmsProjectTeamMemberQuery query) {
        Page page = this.pmsProjectTeamMemberRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate((Root)root, (Object)query, (CriteriaBuilder)criteriaBuilder), (Pageable)query.getPageRequest());
        return PageUtil.toPageVo((Page)page.map(PmsProjectTeamMemberConvert.INSTANCE::toVo));
    }

    public List<PmsProjectTeamMemberVO> queryList(PmsProjectTeamMemberQuery query) {
        return PmsProjectTeamMemberConvert.INSTANCE.toVoList(this.pmsProjectTeamMemberRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate((Root)root, (Object)query, (CriteriaBuilder)criteriaBuilder), query.getPageRequest().getSort()));
    }

    public List<PmsProjectTeamMemberVO> queryListDynamic(PmsProjectTeamMemberQuery query) {
        return this.pmsProjectTeamMemberDAO.queryListDynamic(query);
    }

    public PmsProjectTeamMemberServiceImpl(PmsProjectTeamMemberRepo pmsProjectTeamMemberRepo, PmsProjectTeamMemberDAO pmsProjectTeamMemberDAO, CacheUtil cacheUtil) {
        this.pmsProjectTeamMemberRepo = pmsProjectTeamMemberRepo;
        this.pmsProjectTeamMemberDAO = pmsProjectTeamMemberDAO;
        this.cacheUtil = cacheUtil;
    }
}

