/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.task.service;

import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5pms.api.task.payload.PmsTaskPackageMemberPayload;
import com.elitesland.tw.tw5pms.api.task.service.PmsTaskPackageMemberService;
import com.elitesland.tw.tw5pms.api.task.vo.PmsTaskPackageMemberVO;
import com.elitesland.tw.tw5pms.server.common.functionEnum.TaskRoleEnum;
import com.elitesland.tw.tw5pms.server.task.convert.PmsTaskPackageMemberConvert;
import com.elitesland.tw.tw5pms.server.task.dao.PmsTaskPackageMemberDAO;
import com.elitesland.tw.tw5pms.server.task.entity.PmsTaskPackageMemberDO;
import com.elitesland.tw.tw5pms.server.task.repo.PmsTaskPackageMemberRepo;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class PmsTaskPackageMemberServiceImpl
extends BaseServiceImpl
implements PmsTaskPackageMemberService {
    private static final Logger log = LoggerFactory.getLogger(PmsTaskPackageMemberServiceImpl.class);
    private final PmsTaskPackageMemberRepo pmsTaskPackageMemberRepo;
    private final PmsTaskPackageMemberDAO pmsTaskPackageMemberDAO;
    private final CacheUtil cacheUtil;

    @Transactional(rollbackFor={Exception.class})
    public PmsTaskPackageMemberVO operate(Long packageId, List<PmsTaskPackageMemberPayload> payloads) {
        if (!ObjectUtils.isEmpty(payloads)) {
            List<PmsTaskPackageMemberVO> memberVOS = this.pmsTaskPackageMemberDAO.queryByPackageId(packageId);
            if (!ObjectUtils.isEmpty(memberVOS)) {
                ArrayList<PmsTaskPackageMemberDO> pmsTaskPackageMemberDOS = new ArrayList<PmsTaskPackageMemberDO>();
                payloads.forEach(payload -> {
                    payload.setPackageId(packageId);
                    Optional<PmsTaskPackageMemberVO> first = memberVOS.stream().filter(memberVO -> memberVO.getUserId().equals(payload.getUserId())).findFirst();
                    if (first.isPresent()) {
                        if (!first.get().getTaskRole().equals(payload.getTaskRole()) && !payload.getTaskRole().equals(TaskRoleEnum.RECEIVER.getCode())) {
                            payload.setId(first.get().getId());
                            pmsTaskPackageMemberDOS.add(PmsTaskPackageMemberConvert.INSTANCE.toDo((PmsTaskPackageMemberPayload)payload));
                        }
                    } else {
                        pmsTaskPackageMemberDOS.add(PmsTaskPackageMemberConvert.INSTANCE.toDo((PmsTaskPackageMemberPayload)payload));
                    }
                });
                if (pmsTaskPackageMemberDOS.size() > 0) {
                    this.pmsTaskPackageMemberDAO.saveAll(pmsTaskPackageMemberDOS);
                }
            } else {
                payloads.forEach(payload -> payload.setPackageId(packageId));
                List<PmsTaskPackageMemberDO> pmsTaskPackageMemberDOS = PmsTaskPackageMemberConvert.INSTANCE.toDos(payloads);
                this.pmsTaskPackageMemberDAO.saveAll(pmsTaskPackageMemberDOS);
            }
        }
        return null;
    }

    public List<PmsTaskPackageMemberVO> queryTaskPackageMembers(Long packageId) {
        List<PmsTaskPackageMemberVO> memberVOS = this.pmsTaskPackageMemberDAO.queryByPackageId(packageId);
        memberVOS.forEach(this::transferData);
        return memberVOS;
    }

    void transferData(PmsTaskPackageMemberVO vo) {
        vo.setUserName(this.cacheUtil.getUserName(vo.getUserId()));
        vo.setTaskRoleName(this.cacheUtil.transferSystemSelection("PMS:TASK:ROLE", vo.getTaskRole()));
    }

    public PmsTaskPackageMemberServiceImpl(PmsTaskPackageMemberRepo pmsTaskPackageMemberRepo, PmsTaskPackageMemberDAO pmsTaskPackageMemberDAO, CacheUtil cacheUtil) {
        this.pmsTaskPackageMemberRepo = pmsTaskPackageMemberRepo;
        this.pmsTaskPackageMemberDAO = pmsTaskPackageMemberDAO;
        this.cacheUtil = cacheUtil;
    }
}

