/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.task.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.cloudt.common.base.BaseViewModel;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.common.log.payload.ComLogPayload;
import com.elitesland.tw.tw5.api.common.log.service.ComLogService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdCommentService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdFsmFileRefService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.system.constant.PrdCommentObjTypeEnum;
import com.elitesland.tw.tw5pms.api.project.service.PmsBudgetService;
import com.elitesland.tw.tw5pms.api.project.service.PmsProjectService;
import com.elitesland.tw.tw5pms.api.task.param.PmsTaskProgressData;
import com.elitesland.tw.tw5pms.api.task.payload.PmsTaskAppraisePayload;
import com.elitesland.tw.tw5pms.api.task.payload.PmsTaskAuthorizePayload;
import com.elitesland.tw.tw5pms.api.task.payload.PmsTaskPackagePayload;
import com.elitesland.tw.tw5pms.api.task.payload.PmsTaskPayload;
import com.elitesland.tw.tw5pms.api.task.query.PmsTaskQuery;
import com.elitesland.tw.tw5pms.api.task.service.PmsTaskAuthorizeService;
import com.elitesland.tw.tw5pms.api.task.service.PmsTaskService;
import com.elitesland.tw.tw5pms.api.task.vo.PmsProjectTaskDataVO;
import com.elitesland.tw.tw5pms.api.task.vo.PmsTaskAppraiseVO;
import com.elitesland.tw.tw5pms.api.task.vo.PmsTaskAuthorizeVO;
import com.elitesland.tw.tw5pms.api.task.vo.PmsTaskDataVO;
import com.elitesland.tw.tw5pms.api.task.vo.PmsTaskPackageVO;
import com.elitesland.tw.tw5pms.api.task.vo.PmsTaskVO;
import com.elitesland.tw.tw5pms.server.common.functionEnum.ComLogTypeEnum;
import com.elitesland.tw.tw5pms.server.common.functionEnum.TaskAuthorizeStatusEnum;
import com.elitesland.tw.tw5pms.server.common.functionEnum.TaskStatusEnum;
import com.elitesland.tw.tw5pms.server.task.convert.PmsTaskAppraiseConvert;
import com.elitesland.tw.tw5pms.server.task.convert.PmsTaskConvert;
import com.elitesland.tw.tw5pms.server.task.dao.PmsTaskAppraiseDAO;
import com.elitesland.tw.tw5pms.server.task.dao.PmsTaskDAO;
import com.elitesland.tw.tw5pms.server.task.dao.PmsTaskPackageDAO;
import com.elitesland.tw.tw5pms.server.task.entity.PmsTaskAppraiseDO;
import com.elitesland.tw.tw5pms.server.task.entity.PmsTaskDO;
import com.elitesland.tw.tw5pms.server.task.repo.PmsTaskRepo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class PmsTaskServiceImpl
extends BaseServiceImpl
implements PmsTaskService {
    private static final Logger log = LoggerFactory.getLogger(PmsTaskServiceImpl.class);
    private final PmsTaskRepo pmsTaskRepo;
    private final PmsTaskDAO pmsTaskDAO;
    private final CacheUtil cacheUtil;
    private final FileUtil fileUtil;
    private final PmsTaskPackageDAO pmsTaskPackageDAO;
    private final PmsBudgetService pmsBudgetService;
    private final PmsTaskAppraiseDAO pmsTaskAppraiseDAO;
    private final PrdCommentService prdCommentService;
    private final PrdFsmFileRefService prdFsmFileRefService;
    private final ComLogService logService;
    private final PmsProjectService pmsProjectService;
    private final PmsTaskAuthorizeService pmsTaskAuthorizeService;
    @Value(value="${tw5pms.user.preson_cost:2000}")
    private BigDecimal preson_cost;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Transactional(rollbackFor={Exception.class})
    public void appraiseTask(PmsTaskAppraisePayload payload) {
        PmsTaskPayload taskPayload = new PmsTaskPayload();
        taskPayload.setId(payload.getTaskId());
        PmsTaskVO pmsTaskVO = this.pmsTaskDAO.queryByKey(payload.getTaskId());
        if (pmsTaskVO == null) throw TwException.error((String)"", (String)"\u64cd\u4f5c\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        if (!pmsTaskVO.getTaskStatus().equals(TaskStatusEnum.FINISH.getCode())) throw TwException.error((String)"", (String)"\u672a\u5b8c\u6210\u4efb\u52a1\u4e0d\u53ef\u8bc4\u4ef7\uff0c\u8bf7\u6838\u9a8c\uff01");
        ArrayList<ComLogPayload> logPayloads = new ArrayList<ComLogPayload>();
        Long loginUserId = GlobalUtil.getLoginUserId();
        if (pmsTaskVO.getReceiverUserId().equals(loginUserId)) {
            if (pmsTaskVO.getReceiverAppraiseFlag() == 0) {
                payload.setCreateUserId(loginUserId);
                payload.setAppraiseType(Integer.valueOf(1));
                taskPayload.setReceiverAppraiseFlag(Integer.valueOf(1));
            } else {
                if (!pmsTaskVO.getReceiverUserId().equals(pmsTaskVO.getDisterUserId())) throw TwException.error((String)"", (String)"\u4e0d\u53ef\u91cd\u590d\u8bc4\u4ef7\uff0c\u8bf7\u6838\u9a8c\uff01");
                if (pmsTaskVO.getDisterAppraiseFlag() != 0) throw TwException.error((String)"", (String)"\u4e0d\u53ef\u91cd\u590d\u8bc4\u4ef7\uff0c\u8bf7\u6838\u9a8c\uff01");
                payload.setCreateUserId(loginUserId);
                payload.setAppraiseType(Integer.valueOf(0));
                taskPayload.setDisterAppraiseFlag(Integer.valueOf(1));
            }
        } else {
            if (!pmsTaskVO.getDisterUserId().equals(loginUserId)) throw TwException.error((String)"", (String)"\u65e0\u8be5\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u6838\u9a8c\uff01");
            if (pmsTaskVO.getDisterAppraiseFlag() != 0) throw TwException.error((String)"", (String)"\u4e0d\u53ef\u91cd\u590d\u8bc4\u4ef7\uff0c\u8bf7\u6838\u9a8c\uff01");
            payload.setCreateUserId(loginUserId);
            payload.setAppraiseType(Integer.valueOf(0));
            taskPayload.setDisterAppraiseFlag(Integer.valueOf(1));
        }
        PmsTaskAppraiseDO pmsTaskAppraiseDO = PmsTaskAppraiseConvert.INSTANCE.toDo(payload);
        this.pmsTaskAppraiseDAO.save(pmsTaskAppraiseDO);
        this.pmsTaskDAO.updateByKeyDynamic(taskPayload);
        String content = GlobalUtil.getLoginUserName() + " \u8bc4\u4ef7\u4e86\u4efb\u52a1 " + pmsTaskVO.getTaskName();
        this.createLog(logPayloads, content, pmsTaskVO.getPackageId());
        this.logService.insertBacth(logPayloads);
    }

    public List<PmsTaskAppraiseVO> queryAppraiseTaskList(Long taskId) {
        return this.pmsTaskAppraiseDAO.queryByTaskId(taskId);
    }

    @Transactional(rollbackFor={Exception.class})
    public void acceptTask(PmsTaskPayload payload) {
        String status;
        String content;
        ArrayList<ComLogPayload> logPayloads = new ArrayList<ComLogPayload>();
        PmsTaskVO pmsTaskVO = this.pmsTaskDAO.queryByKey(payload.getId());
        if (pmsTaskVO != null) {
            content = GlobalUtil.getLoginUserName() + " \u63a5\u6536\u4e86\u4efb\u52a1 " + pmsTaskVO.getTaskName();
            status = TaskStatusEnum.CREATE.getCode();
            if (payload.getIsAgree() == 1) {
                status = TaskStatusEnum.APPROVED.getCode();
            } else {
                BigDecimal subtract = (pmsTaskVO.getOldEqva() == null ? BigDecimal.ZERO : pmsTaskVO.getOldEqva()).subtract(pmsTaskVO.getEqvaQty());
                if (StringUtils.hasText((String)pmsTaskVO.getOldTaskStatus())) {
                    status = pmsTaskVO.getOldTaskStatus();
                    payload.setAddEqva(pmsTaskVO.getAddEqva().add(subtract));
                    payload.setEqvaQty(pmsTaskVO.getOldEqva() == null ? BigDecimal.ZERO : pmsTaskVO.getOldEqva());
                    payload.setDays(pmsTaskVO.getOldDays() == null ? BigDecimal.ZERO : pmsTaskVO.getOldDays());
                }
                content = GlobalUtil.getLoginUserName() + " \u62d2\u7edd\u4e86\u4efb\u52a1 " + pmsTaskVO.getTaskName();
                this.returnEqva(pmsTaskVO, subtract);
            }
        } else {
            throw TwException.error((String)"", (String)"\u64cd\u4f5c\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        payload.setTaskStatus(status);
        payload.setOldDays(BigDecimal.ZERO);
        payload.setOldEqva(BigDecimal.ZERO);
        payload.setOldTaskStatus("");
        this.pmsTaskDAO.updateByKeyDynamicInter(payload);
        this.createLog(logPayloads, content, pmsTaskVO.getPackageId());
        PmsTaskVO pmsTaskVO1 = this.pmsTaskDAO.queryByPackageIdOrder(pmsTaskVO.getPackageId());
        this.pmsTaskPackageDAO.updateStatus(pmsTaskVO.getPackageId(), pmsTaskVO1.getTaskStatus());
        this.logService.insertBacth(logPayloads);
    }

    void returnEqva(PmsTaskVO pmsTaskVO, BigDecimal subtractEqva) {
        PmsTaskPackageVO pmsTaskPackageVO = this.pmsTaskPackageDAO.queryByKey(pmsTaskVO.getPackageId());
        Long planId = null;
        if (pmsTaskPackageVO.getPlanStageId() != null) {
            planId = pmsTaskPackageVO.getPlanStageId();
        }
        if (pmsTaskPackageVO.getPlanActId() != null) {
            planId = pmsTaskPackageVO.getPlanActId();
        }
        BigDecimal multiply = subtractEqva.multiply(this.preson_cost);
        this.pmsBudgetService.updatePlanBudget(pmsTaskVO.getProjectId(), planId, multiply);
        if (pmsTaskVO.getAuthorizeId() != null) {
            PmsTaskAuthorizeVO authorizeVO = this.pmsTaskAuthorizeService.queryByKey(pmsTaskVO.getAuthorizeId());
            PmsTaskAuthorizePayload authorizePayload = new PmsTaskAuthorizePayload();
            authorizePayload.setId(authorizeVO.getId());
            BigDecimal usedEqva = (authorizeVO.getUsedEqva() == null ? BigDecimal.ZERO : authorizeVO.getUsedEqva()).add(subtractEqva);
            authorizePayload.setUsedEqva(usedEqva);
            if (authorizeVO.getAuthorizeEqva().compareTo(usedEqva) > 0 && authorizeVO.getAuthorizeStatus().equals(TaskAuthorizeStatusEnum.FINISH.getCode())) {
                authorizePayload.setAuthorizeStatus(TaskAuthorizeStatusEnum.RUNNING.getCode());
            }
            this.pmsTaskAuthorizeService.update(authorizePayload);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void applySettle(List<PmsTaskPayload> payloads) {
        if (ObjectUtils.isEmpty(payloads)) {
            throw TwException.error((String)"", (String)"\u63d0\u4ea4\u7ed3\u7b97\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        List<Long> ids = payloads.stream().map(TwCommonPayload::getId).collect(Collectors.toList());
        List<PmsTaskVO> pmsTaskVOS = this.pmsTaskDAO.queryByKeys(ids);
        Map pmsTaskVOMap = pmsTaskVOS.stream().collect(Collectors.toMap(BaseViewModel::getId, Function.identity()));
        payloads.forEach(payload -> {
            PmsTaskVO pmsTaskVO = (PmsTaskVO)pmsTaskVOMap.get(payload.getId());
            if (pmsTaskVO == null) throw TwException.error((String)"", (String)"\u64cd\u4f5c\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
            if (pmsTaskVO.getIsSettle() != 0) return;
            if (!pmsTaskVO.getReceiverUserId().equals(GlobalUtil.getLoginUserId())) throw TwException.error((String)"", (String)"\u65e0\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u6838\u9a8c\uff01");
            if (payload.getApplySettledEqva() == null || payload.getApplySettledEqva().signum() <= 0) throw TwException.error((String)"", (String)"\u4e0d\u5408\u7406\u7684\u7533\u8bf7\u7ed3\u7b97\u5f53\u91cf\uff0c\u8bf7\u6838\u9a8c\uff01");
            BigDecimal eqvaQty = pmsTaskVO.getEqvaQty();
            BigDecimal settledEqva = pmsTaskVO.getSettledEqva() == null ? BigDecimal.ZERO : pmsTaskVO.getSettledEqva();
            BigDecimal taskProgress = pmsTaskVO.getTaskProgress();
            BigDecimal add = settledEqva.add(payload.getApplySettledEqva());
            BigDecimal bigDecimal = add.divide(eqvaQty, 4, RoundingMode.UP);
            if (add.compareTo(eqvaQty) > 0) throw TwException.error((String)"", (String)"\u7533\u8bf7\u7ed3\u7b97\u5f53\u91cf\u4e0d\u53ef\u5927\u4e8e\u6d3e\u53d1\u5f53\u91cf\uff0c\u8bf7\u6838\u9a8c\uff01");
            if (taskProgress == null || taskProgress.compareTo(bigDecimal) < 0) throw TwException.error((String)"", (String)"\u7533\u8bf7\u7ed3\u7b97\u5f53\u91cf\u5df2\u8d85\u8fc7\u5b8c\u6210\u8fdb\u5ea6\uff0c\u8bf7\u6838\u9a8c\uff01");
            payload.setApplySettledTime(LocalDateTime.now());
            this.pmsTaskDAO.updateByKeyDynamic((PmsTaskPayload)payload);
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Transactional(rollbackFor={Exception.class})
    public void operApplySettle(PmsTaskPayload payload) {
        PmsTaskVO pmsTaskVO = this.pmsTaskDAO.queryByKey(payload.getId());
        if (pmsTaskVO == null) throw TwException.error((String)"", (String)"\u64cd\u4f5c\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        if (!pmsTaskVO.getDisterUserId().equals(GlobalUtil.getLoginUserId())) throw TwException.error((String)"", (String)"\u65e0\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u6838\u9a8c\uff01");
        Boolean isPackage = false;
        if (payload.getIsAgree() == 1) {
            BigDecimal settledEqva = pmsTaskVO.getSettledEqva() == null ? BigDecimal.ZERO : pmsTaskVO.getSettledEqva();
            settledEqva = settledEqva.add(pmsTaskVO.getApplySettledEqva());
            payload.setSettledEqva(settledEqva);
            payload.setSettledDays(settledEqva.divide(pmsTaskVO.getEqvaRatio(), 4, RoundingMode.UP));
            if (settledEqva.compareTo(pmsTaskVO.getEqvaQty()) == 0) {
                payload.setIsSettle(Integer.valueOf(1));
                payload.setTaskStatus(TaskStatusEnum.FINISH.getCode());
                isPackage = true;
            }
        }
        payload.setApplySettledEqva(BigDecimal.ZERO);
        this.pmsTaskDAO.updateByKeyDynamic(payload);
        if (!isPackage.booleanValue()) return;
        PmsTaskVO pmsTaskVO1 = this.pmsTaskDAO.queryByPackageIdOrder(pmsTaskVO.getPackageId());
        this.pmsTaskPackageDAO.updateStatus(pmsTaskVO.getPackageId(), pmsTaskVO1.getTaskStatus());
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateTaskProgress(List<PmsTaskPayload> payloads) {
        if (ObjectUtils.isEmpty(payloads)) {
            throw TwException.error((String)"", (String)"\u63d0\u4ea4\u7ed3\u7b97\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        ArrayList logPayloads = new ArrayList();
        List<Long> ids = payloads.stream().map(TwCommonPayload::getId).collect(Collectors.toList());
        List<PmsTaskVO> taskVOS = this.pmsTaskDAO.queryByKeys(ids);
        Map pmsTaskVOMap = taskVOS.stream().collect(Collectors.toMap(BaseViewModel::getId, Function.identity()));
        ArrayList<Long> packageIds = new ArrayList<Long>();
        payloads.forEach(payload -> {
            PmsTaskVO pmsTaskVO = (PmsTaskVO)pmsTaskVOMap.get(payload.getId());
            if (pmsTaskVO == null) throw TwException.error((String)"", (String)"\u64cd\u4f5c\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
            if (!pmsTaskVO.getReceiverUserId().equals(GlobalUtil.getLoginUserId())) throw TwException.error((String)"", (String)"\u65e0\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u6838\u9a8c\uff01");
            if (!ObjectUtils.isEmpty((Object)payload.getTaskProgress())) {
                if (payload.getTaskProgress().signum() < 0 || payload.getTaskProgress().compareTo(BigDecimal.valueOf(100L)) > 0) {
                    throw TwException.error((String)"", (String)"\u4efb\u52a1\u8fdb\u5ea6\u6570\u636e\u975e\u6cd5\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
                if (payload.getTaskProgress().compareTo(pmsTaskVO.getTaskProgress() == null ? BigDecimal.ZERO : pmsTaskVO.getTaskProgress()) <= 0) {
                    throw TwException.error((String)"", (String)"\u4efb\u52a1\u8fdb\u5ea6\u6570\u636e\u975e\u6cd5\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
                if (!pmsTaskVO.getTaskStatus().equals(TaskStatusEnum.APPROVED.getCode())) {
                    throw TwException.error((String)"", (String)"\u4ec5\u652f\u6301\u6fc0\u6d3b\u72b6\u6001\u8fdb\u5ea6\u8c03\u6574\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
            }
            List<PmsTaskProgressData> dataList = new ArrayList();
            if (StringUtils.hasText((String)pmsTaskVO.getTaskProgressData())) {
                dataList = JSON.parseArray((String)pmsTaskVO.getTaskProgressData(), PmsTaskProgressData.class);
            }
            PmsTaskProgressData data = new PmsTaskProgressData();
            data.setTaskProgress(payload.getTaskProgress());
            data.setTaskProgressDate(LocalDate.now());
            dataList.add(data);
            String dataContent = JSONObject.toJSONString(dataList);
            payload.setTaskProgressData(dataContent);
            this.pmsTaskDAO.updateByKeyDynamic((PmsTaskPayload)payload);
            if (!packageIds.contains(pmsTaskVO.getPackageId())) {
                packageIds.add(pmsTaskVO.getPackageId());
            }
            String content = GlobalUtil.getLoginUserName() + " \u4fee\u6539 " + pmsTaskVO.getTaskName() + " \u8fdb\u5ea6\u4e3a" + payload.getTaskProgress() + "%";
            this.createLog(logPayloads, content, pmsTaskVO.getPackageId());
        });
        List<PmsTaskVO> pmsTaskVOS = this.pmsTaskDAO.queryByPackageIds(packageIds);
        Map<Long, List<PmsTaskVO>> collect = pmsTaskVOS.stream().filter(vo -> !vo.getTaskStatus().equals(TaskStatusEnum.CREATE.getCode())).collect(Collectors.groupingBy(PmsTaskVO::getPackageId));
        collect.forEach((key, taskVOS1) -> {
            BigDecimal taskProgress = taskVOS1.stream().map(taskVO -> taskVO.getTaskProgress() == null ? BigDecimal.ZERO : taskVO.getTaskProgress()).reduce(BigDecimal.ZERO, BigDecimal::add);
            taskProgress = taskProgress.divide(BigDecimal.valueOf(taskVOS1.size()), 4, RoundingMode.UP);
            PmsTaskPackagePayload packagePayload = new PmsTaskPackagePayload();
            packagePayload.setId(key);
            packagePayload.setTaskProgress(taskProgress);
            this.pmsTaskPackageDAO.updateByKeyDynamic(packagePayload);
        });
        this.logService.insertBacth(logPayloads);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateTaskStatus(List<Long> ids) {
        ArrayList logPayloads;
        if (!ObjectUtils.isEmpty(ids)) {
            logPayloads = new ArrayList();
            List<PmsTaskVO> taskVOS = this.pmsTaskDAO.queryByKeys(ids);
            if (ObjectUtils.isEmpty(taskVOS)) {
                throw TwException.error((String)"", (String)"\u64cd\u4f5c\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            List collect = taskVOS.stream().map(PmsTaskVO::getTaskStatus).distinct().collect(Collectors.toList());
            if (collect.size() > 1) {
                throw TwException.error((String)"", (String)"\u76f8\u540c\u6570\u636e\u72b6\u6001\u53ef\u8fdb\u884c\u8be5\u64cd\u4f5c\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            String taskStatus = (String)collect.get(0);
            String taskStatusNew = taskStatus.equals(TaskStatusEnum.PENDING.getCode()) ? TaskStatusEnum.APPROVED.getCode() : TaskStatusEnum.PENDING.getCode();
            SysUserDTO loginUser = GlobalUtil.getLoginUser();
            String loginUserName = loginUser.getUsername();
            taskVOS.forEach(taskVO -> {
                if (!loginUser.getId().equals(taskVO.getReceiverUserId())) {
                    throw TwException.error((String)"", (String)"\u65e0\u6570\u636e\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
                String taskStatusName = taskStatusNew.equals(TaskStatusEnum.PENDING.getCode()) ? TaskStatusEnum.PENDING.getDesc() : TaskStatusEnum.APPROVED.getDesc();
                String content = loginUserName + " \u4fee\u6539 " + taskVO.getTaskName() + " \u72b6\u6001\u4e3a" + taskStatusName;
                this.createLog(logPayloads, content, taskVO.getPackageId());
            });
            this.pmsTaskDAO.updateStatus(ids, taskStatusNew);
            List<Long> packageIds = taskVOS.stream().map(PmsTaskVO::getPackageId).distinct().collect(Collectors.toList());
            if (taskStatus.equals(TaskStatusEnum.PENDING.getCode())) {
                this.pmsTaskPackageDAO.updateStatuss(packageIds, TaskStatusEnum.APPROVED.getCode());
            } else {
                ArrayList<Long> updateIds = new ArrayList<Long>();
                List<PmsTaskVO> pmsTaskVOS = this.pmsTaskDAO.queryByPackageIds(packageIds);
                Map<Long, List<PmsTaskVO>> listMap = pmsTaskVOS.stream().collect(Collectors.groupingBy(PmsTaskVO::getPackageId));
                listMap.forEach((key, taskVOS1) -> {
                    List collect0 = taskVOS1.stream().filter(taskVO -> taskVO.getTaskStatus().equals(TaskStatusEnum.PENDING.getCode())).collect(Collectors.toList());
                    if (collect0 != null && collect0.size() == taskVOS1.size()) {
                        updateIds.add((Long)key);
                    }
                });
                if (updateIds.size() > 0) {
                    this.pmsTaskPackageDAO.updateStatuss(updateIds, TaskStatusEnum.PENDING.getCode());
                }
            }
        } else {
            throw TwException.error((String)"", (String)"\u64cd\u4f5c\u6570\u636e\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        this.logService.insertBacth(logPayloads);
    }

    @Transactional(rollbackFor={Exception.class})
    public void returnTask(List<Long> ids) {
        List collect;
        ArrayList<ComLogPayload> logPayloads;
        if (!ObjectUtils.isEmpty(ids)) {
            logPayloads = new ArrayList<ComLogPayload>();
            List<PmsTaskVO> taskVOS = this.pmsTaskDAO.queryByKeys(ids);
            if (ObjectUtils.isEmpty(taskVOS)) {
                throw TwException.error((String)"", (String)"\u64cd\u4f5c\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            collect = taskVOS.stream().map(PmsTaskVO::getPackageId).distinct().collect(Collectors.toList());
            if (collect.size() > 1) {
                throw TwException.error((String)"", (String)"\u4ec5\u652f\u6301\u540c\u4e00\u4efb\u52a1\u5305\u4e0b\u7684\u4efb\u52a1\u9000\u56de\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            BigDecimal returnEqva = BigDecimal.ZERO;
            SysUserDTO loginUser = GlobalUtil.getLoginUser();
            ArrayList<PmsTaskPayload> payloads = new ArrayList<PmsTaskPayload>();
            for (PmsTaskVO taskVO : taskVOS) {
                if (taskVO.getReceiverUserId().equals(loginUser.getId())) {
                    if (taskVO.getTaskStatus().equals(TaskStatusEnum.APPROVED.getCode())) {
                        BigDecimal settledEqva = taskVO.getSettledEqva() == null ? BigDecimal.ZERO : taskVO.getSettledEqva();
                        BigDecimal eqva = taskVO.getEqvaQty().subtract(settledEqva);
                        if (eqva.compareTo(BigDecimal.ZERO) > 0) {
                            PmsTaskPayload payload2 = new PmsTaskPayload();
                            payload2.setId(taskVO.getId());
                            payload2.setOldEqva(taskVO.getEqvaQty());
                            payload2.setOldDays(taskVO.getDays());
                            payload2.setEqvaQty(settledEqva);
                            payload2.setDays(settledEqva.divide(taskVO.getEqvaRatio(), 4, RoundingMode.UP));
                            if (settledEqva.compareTo(BigDecimal.ZERO) == 0) {
                                payload2.setTaskProgress(BigDecimal.ZERO);
                                payload2.setTaskStatus(TaskStatusEnum.RETURN.getCode());
                            } else {
                                payload2.setTaskProgress(BigDecimal.valueOf(100L));
                                payload2.setTaskStatus(TaskStatusEnum.FINISH.getCode());
                                payload2.setIsSettle(Integer.valueOf(1));
                                List<PmsTaskProgressData> dataList = new ArrayList();
                                if (StringUtils.hasText((String)taskVO.getTaskProgressData())) {
                                    dataList = JSON.parseArray((String)taskVO.getTaskProgressData(), PmsTaskProgressData.class);
                                }
                                PmsTaskProgressData data = new PmsTaskProgressData();
                                data.setTaskProgress(payload2.getTaskProgress());
                                data.setTaskProgressDate(LocalDate.now());
                                dataList.add(data);
                                String dataContent = JSONObject.toJSONString(dataList);
                                payload2.setTaskProgressData(dataContent);
                            }
                            payloads.add(payload2);
                            returnEqva = returnEqva.add(eqva);
                            String content = loginUser.getUsername() + " \u9000\u56de " + taskVO.getTaskName() + " \u4efb\u52a1";
                            this.createLog(logPayloads, content, taskVO.getPackageId());
                            continue;
                        }
                        throw TwException.error((String)"", (String)"\u65e0\u9000\u56de\u8d44\u6e90\uff0c\u8bf7\u6838\u9a8c\uff01");
                    }
                    throw TwException.error((String)"", (String)"\u4ec5\u6fc0\u6d3b\u72b6\u6001\u53ef\u9000\u56de\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
                throw TwException.error((String)"", (String)"\u65e0\u8be5\u6570\u636e\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            this.returnEqva(taskVOS.get(0), returnEqva.multiply(BigDecimal.valueOf(-1L)));
            if (payloads.size() > 0) {
                payloads.forEach(payload -> this.pmsTaskDAO.updateByKeyDynamicInter((PmsTaskPayload)payload));
            }
        } else {
            throw TwException.error((String)"", (String)"\u64cd\u4f5c\u6570\u636e\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        PmsTaskVO pmsTaskVO1 = this.pmsTaskDAO.queryByPackageIdOrder((Long)collect.get(0));
        this.pmsTaskPackageDAO.updateStatus((Long)collect.get(0), pmsTaskVO1.getTaskStatus());
        this.logService.insertBacth(logPayloads);
    }

    public PmsTaskDataVO queryViewPaging(PmsTaskQuery query) {
        query.setLoginUserId(GlobalUtil.getLoginUserId());
        query.setTaskStatus(TaskStatusEnum.APPROVED.getCode());
        query.setOverdueFlag(Boolean.valueOf(true));
        List<PmsTaskVO> vo1 = this.pmsTaskDAO.queryViewPaging(query);
        query.setOverdueFlag(Boolean.valueOf(false));
        List<PmsTaskVO> vo2 = this.pmsTaskDAO.queryViewPaging(query);
        query.setTaskStatus(TaskStatusEnum.PENDING.getCode());
        List<PmsTaskVO> vo3 = this.pmsTaskDAO.queryViewPaging(query);
        query.setTaskStatus(TaskStatusEnum.FINISH.getCode());
        List<PmsTaskVO> vo4 = this.pmsTaskDAO.queryViewPaging(query);
        if (!ObjectUtils.isEmpty(vo1)) {
            vo1.forEach(vo -> {
                vo.setComments(Long.valueOf(this.prdCommentService.count(PrdCommentObjTypeEnum.PMS_TASK.getCode(), vo.getPackageId())));
                vo.setFiles(Long.valueOf(this.prdFsmFileRefService.count(PrdCommentObjTypeEnum.PMS_TASK.getCode(), vo.getPackageId())));
            });
        }
        if (!ObjectUtils.isEmpty(vo2)) {
            vo2.forEach(vo -> {
                vo.setComments(Long.valueOf(this.prdCommentService.count(PrdCommentObjTypeEnum.PMS_TASK.getCode(), vo.getPackageId())));
                vo.setFiles(Long.valueOf(this.prdFsmFileRefService.count(PrdCommentObjTypeEnum.PMS_TASK.getCode(), vo.getPackageId())));
            });
        }
        if (!ObjectUtils.isEmpty(vo3)) {
            vo3.forEach(vo -> {
                vo.setComments(Long.valueOf(this.prdCommentService.count(PrdCommentObjTypeEnum.PMS_TASK.getCode(), vo.getPackageId())));
                vo.setFiles(Long.valueOf(this.prdFsmFileRefService.count(PrdCommentObjTypeEnum.PMS_TASK.getCode(), vo.getPackageId())));
            });
        }
        if (!ObjectUtils.isEmpty(vo4)) {
            vo4.forEach(vo -> {
                vo.setComments(Long.valueOf(this.prdCommentService.count(PrdCommentObjTypeEnum.PMS_TASK.getCode(), vo.getPackageId())));
                vo.setFiles(Long.valueOf(this.prdFsmFileRefService.count(PrdCommentObjTypeEnum.PMS_TASK.getCode(), vo.getPackageId())));
            });
        }
        PmsTaskDataVO dataVO = new PmsTaskDataVO();
        dataVO.setVos1(vo1);
        dataVO.setVos2(vo2);
        dataVO.setVos3(vo3);
        dataVO.setVos4(vo4);
        return dataVO;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Transactional(rollbackFor={Exception.class})
    public void useTask(Long taskId, Long userId, BigDecimal hour) {
        PmsTaskVO pmsTaskVO = this.pmsTaskDAO.queryByKey(taskId);
        if (pmsTaskVO == null) throw TwException.error((String)"", (String)"\u64cd\u4f5c\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        if (!userId.equals(pmsTaskVO.getReceiverUserId())) throw TwException.error((String)"", (String)"\u65e0\u8be5\u4efb\u52a1\u4f7f\u7528\u6743\u9650\uff0c\u8bf7\u6838\u9a8c\uff01");
        BigDecimal useDay = hour.divide(BigDecimal.valueOf(8L), 4, RoundingMode.UP);
        BigDecimal useEqva = useDay.multiply(pmsTaskVO.getEqvaRatio());
        BigDecimal usedDays = (pmsTaskVO.getUsedDays() == null ? BigDecimal.ZERO : pmsTaskVO.getUsedDays()).add(useDay);
        BigDecimal usedEqva = (pmsTaskVO.getUsedEqva() == null ? BigDecimal.ZERO : pmsTaskVO.getUsedEqva()).add(useEqva);
        if (usedDays.compareTo(pmsTaskVO.getDays()) > 0 || usedEqva.compareTo(pmsTaskVO.getEqvaQty()) > 0) {
            throw TwException.error((String)"", (String)"\u4efb\u52a1\u4eba\u5de5\u6210\u672c\u8d85\u9650\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        PmsTaskPayload payload = new PmsTaskPayload();
        payload.setId(taskId);
        payload.setUsedDays(usedDays);
        payload.setUsedEqva(usedEqva);
        this.pmsTaskDAO.updateByKeyDynamic(payload);
    }

    public List<PmsTaskVO> queryListByIds(List<Long> keys) {
        List<PmsTaskVO> pmsTaskVOS = this.pmsTaskDAO.queryByKeys(keys);
        pmsTaskVOS.forEach(this::transferData);
        return pmsTaskVOS;
    }

    public PmsTaskVO queryByKey(Long key) {
        return this.pmsTaskDAO.queryByKey(key);
    }

    public PmsTaskPackageVO queryOneByKey(Long key) {
        PmsTaskVO pmsTaskVO = this.pmsTaskDAO.queryByKey(key);
        if (pmsTaskVO != null) {
            PmsTaskPackageVO pmsTaskPackageVO = this.pmsTaskPackageDAO.queryByKey(pmsTaskVO.getPackageId());
            List<PmsTaskVO> pmsTaskVOS = this.pmsTaskDAO.queryByPackageId(pmsTaskVO.getPackageId());
            BigDecimal days = BigDecimal.ZERO;
            BigDecimal oldDays = BigDecimal.ZERO;
            BigDecimal eqvaQty = BigDecimal.ZERO;
            BigDecimal oldEqva = BigDecimal.ZERO;
            BigDecimal usedEqva = BigDecimal.ZERO;
            BigDecimal usedDays = BigDecimal.ZERO;
            BigDecimal settledEqva = BigDecimal.ZERO;
            BigDecimal settledDays = BigDecimal.ZERO;
            for (PmsTaskVO taskVO : pmsTaskVOS) {
                if (taskVO.getTaskStatus().equals(TaskStatusEnum.CREATE.getCode())) continue;
                if (taskVO.getDays() != null) {
                    days = days.add(taskVO.getDays());
                }
                if (taskVO.getOldDays() != null) {
                    oldDays = oldDays.add(taskVO.getOldDays());
                }
                if (taskVO.getEqvaQty() != null) {
                    eqvaQty = eqvaQty.add(taskVO.getEqvaQty());
                }
                if (taskVO.getOldEqva() != null) {
                    oldEqva = oldEqva.add(taskVO.getOldEqva());
                }
                if (taskVO.getUsedEqva() != null) {
                    usedEqva = usedEqva.add(taskVO.getUsedEqva());
                }
                if (taskVO.getUsedDays() != null) {
                    usedDays = usedDays.add(taskVO.getUsedDays());
                }
                if (taskVO.getSettledEqva() != null) {
                    settledEqva = settledEqva.add(taskVO.getSettledEqva());
                }
                if (taskVO.getSettledDays() == null) continue;
                settledDays = settledDays.add(taskVO.getSettledDays());
            }
            BigDecimal disCost = eqvaQty.multiply(this.preson_cost);
            BigDecimal usedCost = usedEqva.multiply(this.preson_cost);
            BigDecimal settledCost = settledEqva.multiply(this.preson_cost);
            pmsTaskPackageVO.setDays(days);
            pmsTaskPackageVO.setOldDays(oldDays);
            pmsTaskPackageVO.setEqvaQty(eqvaQty);
            pmsTaskPackageVO.setOldEqva(oldEqva);
            pmsTaskPackageVO.setUsedDays(usedDays);
            pmsTaskPackageVO.setUsedEqva(usedEqva);
            pmsTaskPackageVO.setDisCost(disCost);
            pmsTaskPackageVO.setUsedCost(usedCost);
            pmsTaskPackageVO.setSettledDays(settledDays);
            pmsTaskPackageVO.setSettledEqva(settledEqva);
            pmsTaskPackageVO.setSettledCost(settledCost);
            pmsTaskPackageVO.setTaskVOs(List.of(pmsTaskVO));
            this.transferData(pmsTaskPackageVO);
            pmsTaskVO.setFileDatas(this.fileUtil.getFileDatas(pmsTaskPackageVO.getFileCodes()));
            return pmsTaskPackageVO;
        }
        throw TwException.error((String)"", (String)"\u64cd\u4f5c\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
    }

    void transferData(PmsTaskPackageVO vo) {
        vo.setPackageStatusName(this.cacheUtil.transferSystemSelection("PMS:TASK:SATUS", vo.getPackageStatus()));
        vo.setCooperationTypeName(this.cacheUtil.transferSystemSelection("PMS:TASK:COOP:TYPE", vo.getCooperationType()));
        vo.setReasonTypeName(this.cacheUtil.transferSystemSelection("PMS:TASK:ORIGIN:TYPE", vo.getReasonType()));
        vo.setPricingMethodName(this.cacheUtil.transferSystemSelection("PMS:TASK:PRICING:WAY", vo.getPricingMethod()));
        vo.setAcceptMethodName(this.cacheUtil.transferSystemSelection("PMS:TASK:CHECK:WAY", vo.getAcceptMethod()));
        vo.setExpenseOrgName(this.cacheUtil.getOrgName(vo.getExpenseOrgId()));
        vo.setCreator(this.cacheUtil.getUserName(vo.getCreateUserId()));
        Object receiverUserName = "";
        Object disterUserName = "";
        if (!ObjectUtils.isEmpty((Object)vo.getTaskVOs())) {
            for (PmsTaskVO taskVO : vo.getTaskVOs()) {
                taskVO.setTaskStatusName(this.cacheUtil.transferSystemSelection("PMS:TASK:SATUS", taskVO.getTaskStatus()));
                taskVO.setWorkTypeName(this.cacheUtil.transferSystemSelection("org:employee:worktype", taskVO.getWorkType()));
                taskVO.setSpecialtyLevelName(this.cacheUtil.transferSystemSelection("org:employee:specialtylevel", taskVO.getSpecialtyLevel()));
                taskVO.setCreator(this.cacheUtil.getUserName(taskVO.getCreateUserId()));
                taskVO.setReceiverUserName(this.cacheUtil.getUserName(taskVO.getReceiverUserId()));
                taskVO.setDisterUserName(this.cacheUtil.getUserName(taskVO.getDisterUserId()));
                receiverUserName = "".equals(receiverUserName) ? taskVO.getReceiverUserName() : (String)receiverUserName + "," + taskVO.getReceiverUserName();
                if ("".equals(disterUserName)) {
                    disterUserName = taskVO.getDisterUserName();
                    continue;
                }
                disterUserName = (String)disterUserName + "," + taskVO.getDisterUserName();
            }
        }
        vo.setReceiverUserName((String)receiverUserName);
        vo.setDisterUserName((String)disterUserName);
    }

    public PagingVO<PmsTaskVO> queryPaging(PmsTaskQuery query) {
        PagingVO<PmsTaskVO> pmsTaskVOPagingVO = this.pmsTaskDAO.queryPaging(query);
        if (!ObjectUtils.isEmpty((Object)pmsTaskVOPagingVO.getRecords())) {
            pmsTaskVOPagingVO.getRecords().forEach(this::transferData);
        }
        return pmsTaskVOPagingVO;
    }

    public List<PmsTaskVO> queryListDynamic(PmsTaskQuery query) {
        List<PmsTaskVO> pmsTaskVOS = this.pmsTaskDAO.queryListDynamic(query);
        pmsTaskVOS.forEach(this::transferData);
        return pmsTaskVOS;
    }

    public List<PmsProjectTaskDataVO> queryUseTimeSheetList() {
        PmsTaskQuery query = new PmsTaskQuery();
        query.setReceiverUserId(GlobalUtil.getLoginUserId());
        query.setTaskStatus(TaskStatusEnum.APPROVED.getCode());
        List<PmsTaskVO> pmsTaskVOS = this.pmsTaskDAO.queryListDynamic(query);
        ArrayList<PmsProjectTaskDataVO> taskDataVOS = new ArrayList<PmsProjectTaskDataVO>();
        if (!ObjectUtils.isEmpty(pmsTaskVOS)) {
            pmsTaskVOS.forEach(this::transferData);
            Map<Long, List<PmsTaskVO>> collect = pmsTaskVOS.stream().collect(Collectors.groupingBy(PmsTaskVO::getProjectId));
            List pmsProjectVOS = this.pmsProjectService.queryListByIds(new ArrayList<Long>(collect.keySet()));
            pmsProjectVOS.forEach(pmsProjectVO -> {
                PmsProjectTaskDataVO taskDataVO = new PmsProjectTaskDataVO();
                taskDataVO.setProjectId(pmsProjectVO.getId());
                taskDataVO.setProjectCode(pmsProjectVO.getProjectCode());
                taskDataVO.setProjectName(pmsProjectVO.getProjectName());
                taskDataVO.setTaskVOS((List)collect.get(pmsProjectVO.getId()));
                taskDataVOS.add(taskDataVO);
            });
        }
        return taskDataVOS;
    }

    void transferData(PmsTaskVO taskVO) {
        taskVO.setTaskStatusName(this.cacheUtil.transferSystemSelection("PMS:TASK:SATUS", taskVO.getTaskStatus()));
        taskVO.setWorkTypeName(this.cacheUtil.transferSystemSelection("org:employee:worktype", taskVO.getWorkType()));
        taskVO.setSpecialtyLevelName(this.cacheUtil.transferSystemSelection("org:employee:specialtylevel", taskVO.getSpecialtyLevel()));
        taskVO.setReceiverUserName(this.cacheUtil.getUserName(taskVO.getReceiverUserId()));
        taskVO.setDisterUserName(this.cacheUtil.getUserName(taskVO.getDisterUserId()));
        taskVO.setFileDatas(this.fileUtil.getFileDatas(taskVO.getFileCodes()));
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsTaskVO insert(PmsTaskPayload payload) {
        PmsTaskDO entityDo = PmsTaskConvert.INSTANCE.toDo(payload);
        return PmsTaskConvert.INSTANCE.toVo((PmsTaskDO)this.pmsTaskRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            List<PmsTaskVO> pmsTaskVOS = this.pmsTaskDAO.queryByKeys(keys);
            pmsTaskVOS.forEach(pmsTaskVO -> {
                if (!pmsTaskVO.getTaskStatus().equals(TaskStatusEnum.CREATE.getCode())) {
                    throw TwException.error((String)"", (String)"\u4ec5\u652f\u6301\u65b0\u5efa\u4efb\u52a1\u5220\u9664\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
            });
            this.pmsTaskDAO.deleteSoft(keys);
        }
    }

    void createLog(List<ComLogPayload> logPayloads, String content, Long packageId) {
        ComLogPayload logPayload = new ComLogPayload();
        logPayload.setObjectId("" + packageId);
        logPayload.setLogType(ComLogTypeEnum.pms_task.getCode());
        logPayload.setLogContent(content);
        logPayloads.add(logPayload);
    }

    public PmsTaskServiceImpl(PmsTaskRepo pmsTaskRepo, PmsTaskDAO pmsTaskDAO, CacheUtil cacheUtil, FileUtil fileUtil, PmsTaskPackageDAO pmsTaskPackageDAO, PmsBudgetService pmsBudgetService, PmsTaskAppraiseDAO pmsTaskAppraiseDAO, PrdCommentService prdCommentService, PrdFsmFileRefService prdFsmFileRefService, ComLogService logService, PmsProjectService pmsProjectService, PmsTaskAuthorizeService pmsTaskAuthorizeService) {
        this.pmsTaskRepo = pmsTaskRepo;
        this.pmsTaskDAO = pmsTaskDAO;
        this.cacheUtil = cacheUtil;
        this.fileUtil = fileUtil;
        this.pmsTaskPackageDAO = pmsTaskPackageDAO;
        this.pmsBudgetService = pmsBudgetService;
        this.pmsTaskAppraiseDAO = pmsTaskAppraiseDAO;
        this.prdCommentService = prdCommentService;
        this.prdFsmFileRefService = prdFsmFileRefService;
        this.logService = logService;
        this.pmsProjectService = pmsProjectService;
        this.pmsTaskAuthorizeService = pmsTaskAuthorizeService;
    }
}

