package com.elitesland.tw.tw5crm.api.${package}.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
<#--<#if queryHasTimestamp>-->
<#--import java.time.LocalDateTime;-->
<#--import java.time.LocalDate;-->
<#--</#if>-->
<#if hasTimestamp>
    import java.time.LocalDateTime;
</#if>
<#if hasLocalDate>
    import java.time.LocalDate;
</#if>
<#if hasLocalDateTime>
    import java.time.LocalDateTime;
</#if>
<#if queryHasBigDecimal>
import java.math.BigDecimal;
</#if>
<#if betweens??>
import java.util.List;
</#if>

/**
 * ${apiAlias}
 *
 * @author ${author}
 * @date ${date}
 */
@Getter
@Setter
public class ${className}Query extends TwQueryParam implements Serializable{
<#if queryColumns??>
    <#list queryColumns as column>
<#if column.queryType = '='>
    /** ${column.remark} 精确 */
    @ApiModelProperty("${column.remark}")
    private ${column.columnType} ${column.changeColumnName};
</#if>
<#if column.queryType = 'Like'>
    /** ${column.remark} 模糊 */
    @ApiModelProperty("${column.remark}")
    private ${column.columnType} ${column.changeColumnName};
</#if>
<#if column.queryType = '!='>
    /** ${column.remark} 不等于 */
    @ApiModelProperty("${column.remark}")
    private ${column.columnType} ${column.changeColumnName};
</#if>
<#if column.queryType = 'NotNull'>
    /** ${column.remark} 不为空 */
    @ApiModelProperty("${column.remark}")
    private ${column.columnType} ${column.changeColumnName};
</#if>
<#if column.queryType = '>='>
    /** ${column.remark} 大于等于 */
    @ApiModelProperty("${column.remark}")
    private ${column.columnType} ${column.changeColumnName};
</#if>
<#if column.queryType = '<='>
    /** ${column.remark} 小于等于 */
    @ApiModelProperty("${column.remark}")
    private ${column.columnType} ${column.changeColumnName};
</#if>
    </#list>
</#if>
<#if betweens??>
    <#list betweens as column>
    /** ${column.remark} BETWEEN */
    @ApiModelProperty("${column.remark}")
    private List<${column.columnType}> ${column.changeColumnName};
    </#list>
</#if>
}
