package com.elitesland.tw.tw5.server.${package}.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
<#if isNotNullColumns??>
import javax.validation.constraints.*;
</#if>
<#if hasDateAnnotation>
import javax.persistence.Entity;
import javax.persistence.Table;
import org.hibernate.annotations.*;
</#if>
<#if hasTimestamp>
import java.time.LocalDateTime;
</#if>
<#if hasLocalDate>
import java.time.LocalDate;
</#if>
<#if hasLocalDateTime>
import java.time.LocalDateTime;
</#if>
<#if hasBigDecimal>
import java.math.BigDecimal;
</#if>

/**
 * ${apiAlias}
 *
 * @author ${author}
 * @date ${date}
 */
@Entity
@Table(name = "${tableName}", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "${tableName}", comment = "${apiAlias}")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class ${className}DO extends BaseModel implements Serializable  {
<#if columns??>
    <#list columns as column>
    <#if column.remark != ''>
    /** ${column.remark} */
    @Comment("${column.remark}")
    @Column()
    <#else>
    /** ${column.changeColumnName} */
    @Comment("${column.changeColumnName}")
    @Column()
    </#if>
    private ${column.columnType} ${column.changeColumnName};
    </#list>
</#if>

    public void copy(${className}DO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
