/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.common.funConfig.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.funConfig.payload.BusinessDocTypeConfigPayload;
import com.elitesland.tw.tw5.api.common.funConfig.payload.BusinessDocTypePermissionPrevRecordPayload;
import com.elitesland.tw.tw5.api.common.funConfig.payload.BusinessDocTypeRefPayload;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessDocTypeConfigAllowRoleQuery;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessDocTypeConfigQuery;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessDocTypeConfigRoleRefQuery;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessDocTypeConfigRuleQuery;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessDocTypePermissionPrevRecordQuery;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessTableFieldsQuery;
import com.elitesland.tw.tw5.api.common.funConfig.service.BusinessDocTypeConfigAllowRoleService;
import com.elitesland.tw.tw5.api.common.funConfig.service.BusinessDocTypeConfigRoleRefService;
import com.elitesland.tw.tw5.api.common.funConfig.service.BusinessDocTypeConfigService;
import com.elitesland.tw.tw5.api.common.funConfig.service.BusinessDocTypePermissionPrevRecordService;
import com.elitesland.tw.tw5.api.common.funConfig.service.BusinessDocTypeRefService;
import com.elitesland.tw.tw5.api.common.funConfig.service.BusinessTableFieldsService;
import com.elitesland.tw.tw5.api.common.funConfig.service.BusinessTableService;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessDocTypeConfigRuleVO;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessDocTypeConfigVO;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessDocTypePermissionPrevRecordVO;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessDocTypeRefVO;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessTableFieldsVO;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessTableVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.constants.BusinessDocTypeRuleConditionEnum;
import com.elitesland.tw.tw5.server.common.funConfig.config.FunConfigProperties;
import com.elitesland.tw.tw5.server.common.funConfig.convert.BusinessDocTypeConfigConvert;
import com.elitesland.tw.tw5.server.common.funConfig.dao.BusinessDocTypeConfigDAO;
import com.elitesland.tw.tw5.server.common.funConfig.dao.BusinessDocTypeConfigRuleDAO;
import com.elitesland.tw.tw5.server.common.funConfig.entity.BusinessDocTypeConfigDO;
import com.elitesland.tw.tw5.server.common.funConfig.repo.BusinessDocTypeConfigRepo;
import com.elitesland.tw.tw5.server.common.funConfig.support.BusinessDocTypeCheckAuthorityFactory;
import com.elitesland.tw.tw5.server.common.funConfig.support.BusinessDocTypeCheckAuthorityService;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.yeedoc.config.YeedocProperties;
import com.elitesland.tw.tw5.server.yeedoc.service.YeedocService;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class BusinessDocTypeConfigServiceImpl
extends BaseServiceImpl
implements BusinessDocTypeConfigService {
    private static final Logger log = LoggerFactory.getLogger(BusinessDocTypeConfigServiceImpl.class);
    private final BusinessDocTypeConfigRepo businessDocTypeConfigRepo;
    private final BusinessDocTypeConfigDAO businessDocTypeConfigDAO;
    private final BusinessTableService businessTableService;
    private final BusinessTableFieldsService businessTableFieldsService;
    private final BusinessDocTypeConfigRuleDAO businessDocTypeConfigRuleDAO;
    private final BusinessDocTypeRefService businessDocTypeRefService;
    private final CacheUtil cacheUtil;
    private final YeedocService yeedocService;
    private final BusinessDocTypePermissionPrevRecordService businessDocTypePermissionPrevRecordService;
    private final BusinessDocTypeConfigAllowRoleService businessDocTypeConfigAllowRoleService;
    private final BusinessDocTypeConfigRoleRefService businessDocTypeConfigRoleRefService;
    private final FunConfigProperties funConfigProperties;
    private final YeedocProperties yeedocProperties;
    @PersistenceContext
    private EntityManager em;

    public PagingVO<BusinessDocTypeConfigVO> queryPaging(BusinessDocTypeConfigQuery query) {
        return this.businessDocTypeConfigDAO.queryPaging(query);
    }

    public List<BusinessDocTypeConfigVO> queryListDynamic(BusinessDocTypeConfigQuery query) {
        return this.businessDocTypeConfigDAO.queryListDynamic(query);
    }

    public Long count(BusinessDocTypeConfigQuery query) {
        return this.businessDocTypeConfigDAO.count(query);
    }

    public BusinessDocTypeConfigVO queryByKey(Long key) {
        BusinessDocTypeConfigDO entity = this.businessDocTypeConfigRepo.findById(key).orElseGet(BusinessDocTypeConfigDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u6587\u6863\u7c7b\u578b\u914d\u7f6e\u4e0d\u5b58\u5728");
        BusinessDocTypeConfigVO vo = BusinessDocTypeConfigConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessDocTypeConfigVO insert(BusinessDocTypeConfigPayload payload) {
        this.check(payload);
        this.initData(payload);
        BusinessDocTypeConfigDO entityDo = BusinessDocTypeConfigConvert.INSTANCE.toDo(payload);
        if (ObjectUtils.isEmpty((Object)entityDo.getPermissionControlFlag())) {
            entityDo.setPermissionControlFlag(Boolean.FALSE);
        }
        if (ObjectUtils.isEmpty((Object)entityDo.getEnabled())) {
            entityDo.setEnabled(Boolean.TRUE);
        }
        return BusinessDocTypeConfigConvert.INSTANCE.toVo((BusinessDocTypeConfigDO)this.businessDocTypeConfigRepo.save(entityDo));
    }

    private void initData(BusinessDocTypeConfigPayload payload) {
        if (!ObjectUtils.isEmpty((Object)payload.getTableId())) {
            BusinessTableVO businessTableVO = this.businessTableService.queryByKey(payload.getTableId());
            payload.setTableName(businessTableVO.getTableName());
        }
        if (!ObjectUtils.isEmpty((Object)payload.getFieldId())) {
            BusinessTableFieldsVO businessTableFieldsVO = this.businessTableFieldsService.queryByKey(payload.getFieldId());
            payload.setFieldShowName(businessTableFieldsVO.getShowName());
        }
    }

    private void check(BusinessDocTypeConfigPayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getFunctionId())) {
            throw TwException.error("", "functionId \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)payload.getName())) {
            throw TwException.error("", "\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BusinessDocTypeConfigQuery query = new BusinessDocTypeConfigQuery();
        query.setFunctionId(payload.getFunctionId());
        query.setName(payload.getName());
        query.setIdNe(payload.getId());
        Long count = this.count(query);
        if (count > 0L) {
            log.error("\u6587\u6863\u7c7b\u578b\u540d\u79f0\u4e0d\u53ef\u91cd\u590d\uff0c\u4e00\u4e2a\u529f\u80fd\u914d\u7f6e\u4e0b\u6587\u6863\u7c7b\u578b\u540d\u79f0\u552f\u4e00\uff01");
            throw TwException.error("", "\u5df2\u5b58\u5728\u6b64\u6587\u6863\u7c7b\u578b");
        }
        if (!ObjectUtils.isEmpty((Object)payload.getTableId()) && ObjectUtils.isEmpty((Object)payload.getFieldId())) {
            throw TwException.error("", "\u8bf7\u9009\u62e9\u8868\u5c5e\u6027");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessDocTypeConfigVO update(BusinessDocTypeConfigPayload payload) {
        BusinessDocTypeConfigDO entity = this.businessDocTypeConfigRepo.findById(payload.getId()).orElseGet(BusinessDocTypeConfigDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessDocTypeConfigDO entityDo = BusinessDocTypeConfigConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return BusinessDocTypeConfigConvert.INSTANCE.toVo((BusinessDocTypeConfigDO)this.businessDocTypeConfigRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(BusinessDocTypeConfigPayload payload) {
        BusinessDocTypeConfigDO entity = this.businessDocTypeConfigRepo.findById(payload.getId()).orElseGet(BusinessDocTypeConfigDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.businessDocTypeConfigDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.businessDocTypeConfigDAO.deleteSoft(keys);
            this.businessDocTypeConfigRuleDAO.deleteSoftByConfigId(keys);
        }
    }

    public BusinessDocTypePermissionPrevRecordVO getYeeedocInfo(Long docId, String docType, Long configId, String createFolderName) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        Long orgId = this.cacheUtil.getDefaultOrgIdByUserId(loginUserId);
        List<String> roleList = this.cacheUtil.getSystemRoleCodesNoCache(loginUserId);
        boolean systemAdmin = this.cacheUtil.isSystemAdmin();
        return this.getYeeedocInfo(systemAdmin, loginUserId, orgId, roleList, docId, docType, configId, createFolderName);
    }

    public BusinessDocTypePermissionPrevRecordVO getYeeedocInfo(boolean systemAdmin, Long userId, Long orgId, List<String> roleList, Long docId, String docType, Long configId, String createFolderName) {
        BusinessDocTypeRefPayload docTypeRefPayload;
        String libraryId;
        Long configRuleId;
        BusinessDocTypeConfigRuleVO ruleResult;
        BusinessDocTypeConfigServiceImpl.checkYeedocInfoQuery(docId, docType, configId, createFolderName);
        BusinessDocTypeConfigVO businessDocTypeConfigVO = this.queryByKey(configId);
        Boolean checkAuthFlag = this.funConfigProperties.getDocType().getPermissionFlag();
        if (checkAuthFlag.booleanValue()) {
            this.checkAuthority(systemAdmin, userId, orgId, roleList, docId, docType, businessDocTypeConfigVO);
        }
        String configName = businessDocTypeConfigVO.getName();
        log.info("\u6587\u4ef6\u7c7b\u578b\u540d\u79f0\uff1a{}", (Object)configName);
        Long tableId = businessDocTypeConfigVO.getTableId();
        String tableName = businessDocTypeConfigVO.getTableName();
        if (ObjectUtils.isEmpty((Object)tableName) && !ObjectUtils.isEmpty((Object)tableId)) {
            BusinessTableVO businessTableVO = this.businessTableService.queryByKey(tableId);
            tableName = businessTableVO.getTableName();
        }
        List<Object> businessTableFieldsVOS = new ArrayList<BusinessTableFieldsVO>();
        if (null != tableId) {
            BusinessTableFieldsQuery fieldsQuery = new BusinessTableFieldsQuery();
            fieldsQuery.setTableId(tableId);
            businessTableFieldsVOS = this.businessTableFieldsService.queryListDynamic(fieldsQuery);
        }
        if ((ruleResult = this.getBusinessDocTypeConfigRuleVO(docId, configId, tableName, businessTableFieldsVOS)) == null) {
            log.error("\u901a\u7528\u6587\u6863\u7ba1\u7406\u5f02\u5e38\uff1a\u672a\u5339\u914d\u5230\u89c4\u5219");
            BusinessDocTypePermissionPrevRecordVO recordVO = new BusinessDocTypePermissionPrevRecordVO();
            recordVO.setOk(false);
            recordVO.setWarnInfo("\u672a\u914d\u7f6e\u6b64\u7c7b\u6587\u6863\u7684\u5b58\u50a8\u8def\u5f84");
            return recordVO;
        }
        String floderIdResult = "";
        String libraryIdResult = "";
        String floderNameResult = "";
        Long docTypeRefId = null;
        Long configRuleIdResult = null;
        configRuleIdResult = configRuleId = ruleResult.getId();
        String itemId = ruleResult.getItemId();
        libraryIdResult = libraryId = ruleResult.getLibraryId();
        BusinessDocTypeRefVO docTypeRefVO = this.businessDocTypeRefService.getByDocTypeAndDocIdAndRuleId(docType, docId, configRuleIdResult);
        if (null == docTypeRefVO) {
            log.info("\u9879\u76ee\u672a\u521b\u5efa\u6613\u7a3b\u58f3\u76ee\u5f55\uff0c\u5f00\u59cb\u521b\u5efa");
            Result result = this.createFolder(createFolderName, itemId, libraryId);
            floderIdResult = result.floderId();
            floderNameResult = result.floderName();
            log.info("\u9879\u76ee\u5df2\u521b\u5efa\u6613\u7a3b\u58f3\u76ee\u5f55--\u5b8c\u6210");
            docTypeRefPayload = new BusinessDocTypeRefPayload();
            docTypeRefPayload.setDocId(docId);
            docTypeRefPayload.setDocType(docType);
            docTypeRefPayload.setConfigId(configId);
            docTypeRefPayload.setLibraryId(libraryId);
            docTypeRefPayload.setFolderId(result.floderId());
            docTypeRefPayload.setFolderName(result.floderName());
            docTypeRefPayload.setConfigName(configName);
            docTypeRefPayload.setConfigRuleId(configRuleId);
            BusinessDocTypeRefVO insert = this.businessDocTypeRefService.insert(docTypeRefPayload);
            docTypeRefId = insert.getId();
        } else {
            floderIdResult = docTypeRefVO.getFolderId();
            libraryIdResult = docTypeRefVO.getLibraryId();
            docTypeRefId = docTypeRefVO.getId();
        }
        if (ObjectUtils.isEmpty((Object)floderIdResult)) {
            log.error("\u901a\u7528\u6587\u6863\u7ba1\u7406\u5f02\u5e38[\u8c03\u7528\u6613\u9053\u58f3\u521b\u5efa\u6587\u4ef6\u5939]-floderIdResult:{}", (Object)floderIdResult);
            throw TwException.error("DOC_TYPE_CONFIG_YEEDOC_CREATE_FLODER_ERROR", "\u6613\u9053\u58f3\u521b\u5efa\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        if (createFolderName.startsWith("/")) {
            createFolderName = createFolderName.substring(1, createFolderName.length());
        }
        if (!createFolderName.equals(floderNameResult)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("ItemId", floderIdResult);
            map.put("NewName", createFolderName);
            this.yeedocService.reNameFolder(map);
            if (null != docTypeRefId) {
                docTypeRefPayload = new BusinessDocTypeRefPayload();
                docTypeRefPayload.setId(docTypeRefId);
                docTypeRefPayload.setFolderName(createFolderName);
                this.businessDocTypeRefService.updateByKeyDynamic(docTypeRefPayload);
            }
        }
        BusinessDocTypePermissionPrevRecordQuery permissionQuery = new BusinessDocTypePermissionPrevRecordQuery();
        permissionQuery.setUserId(userId);
        permissionQuery.setDocId(docId);
        permissionQuery.setDocType(docType);
        permissionQuery.setConfigId(configId);
        permissionQuery.setConfigRuleId(configRuleIdResult);
        List permissionPrevRecordVOS = this.businessDocTypePermissionPrevRecordService.queryListDynamic(permissionQuery);
        BusinessDocTypePermissionPrevRecordVO permissionPrevRecordVO = null;
        if (!CollectionUtils.isEmpty((Collection)permissionPrevRecordVOS)) {
            permissionPrevRecordVO = (BusinessDocTypePermissionPrevRecordVO)permissionPrevRecordVOS.get(0);
        }
        if (permissionPrevRecordVO == null || permissionPrevRecordVO != null && !permissionPrevRecordVO.getPermissionFlag().booleanValue()) {
            JSONObject resultJson;
            JSONObject data;
            BusinessDocTypePermissionPrevRecordPayload permissionPrevRecordPayload;
            log.info("\u9879\u76ee\u5df2\u521b\u5efa\u6613\u7a3b\u58f3\u76ee\u5f55\uff0c\u6613\u7a3b\u58f3\u4eba\u5458\u8d4b\u6743\u9650");
            if (permissionPrevRecordVO == null) {
                permissionPrevRecordPayload = new BusinessDocTypePermissionPrevRecordPayload();
                permissionPrevRecordPayload.setConfigId(configId);
                permissionPrevRecordPayload.setConfigRuleId(configRuleIdResult);
                permissionPrevRecordPayload.setLibraryId(libraryIdResult);
                permissionPrevRecordPayload.setDocId(docId);
                permissionPrevRecordPayload.setDocType(docType);
                permissionPrevRecordPayload.setUserId(userId);
            } else {
                permissionPrevRecordPayload = new BusinessDocTypePermissionPrevRecordPayload();
                permissionPrevRecordPayload.setId(permissionPrevRecordVO.getId());
            }
            boolean permissionFlag = false;
            String[] permission = this.yeedocProperties.getPermission();
            List<String> permissionIds = Arrays.asList(permission);
            String permissionsStr = this.yeedocService.setPermission(floderIdResult, permissionIds);
            if (ObjectUtils.isEmpty((Object)permissionsStr)) {
                log.error("\u901a\u7528\u6587\u6863\u7ba1\u7406\u5f02\u5e38[\u8c03\u7528\u6613\u9053\u58f3\u6587\u4ef6\u5939\u8d4b\u6743]! permissionsStr:{} ;floderIdResult:{}", (Object)permissionsStr, (Object)floderIdResult);
            }
            if (!((Boolean)JSONObject.parseObject((String)permissionsStr).get((Object)"IsSuccess")).booleanValue()) {
                log.error("\u901a\u7528\u6587\u6863\u7ba1\u7406\u5f02\u5e38[\u8c03\u7528\u6613\u9053\u58f3\u6587\u4ef6\u5939\u8d4b\u6743]! permissionsStr:{} ;floderIdResult:{}", (Object)permissionsStr, (Object)floderIdResult);
            } else {
                permissionFlag = true;
            }
            String previewUri = "";
            String itemNameResult = "";
            String itemPathResult = "";
            String preViewItemStr = this.yeedocService.preViewItemPro(floderIdResult);
            if (ObjectUtils.isEmpty((Object)preViewItemStr)) {
                log.error("\u901a\u7528\u6587\u6863\u7ba1\u7406\u5f02\u5e38[\u8c03\u7528\u6613\u9053\u58f3\u6587\u4ef6\u5939\u9884\u89c8\u5730\u5740]! preViewItemStr:{} ;floderIdResult:{}", (Object)preViewItemStr, (Object)floderIdResult);
            }
            if (ObjectUtils.isEmpty((Object)(data = (resultJson = JSONObject.parseObject((String)preViewItemStr)).getJSONObject("Data")))) {
                log.error("\u901a\u7528\u6587\u6863\u7ba1\u7406\u5f02\u5e38[\u8c03\u7528\u6613\u9053\u58f3\u6587\u4ef6\u5939\u9884\u89c8\u5730\u5740]! preViewItemStr:{} ;floderIdResult:{}", (Object)preViewItemStr, (Object)floderIdResult);
            } else {
                String itemPath;
                String itemName;
                String preview;
                previewUri = preview = data.getString("Preview");
                itemNameResult = itemName = data.getString("ItemName");
                itemPathResult = itemPath = data.getString("ItemPath");
                log.debug("\u6613\u7a3b\u58f3\u9884\u89c8\u5730\u5740:{}", (Object)previewUri);
                log.debug("\u6613\u7a3b\u58f3\u6587\u4ef6\u540d:{}", (Object)itemName);
                log.debug("\u6613\u7a3b\u58f3\u6587\u4ef6\u8def\u5f84:{}", (Object)itemPath);
            }
            if (permissionPrevRecordVO == null) {
                permissionPrevRecordPayload.setFolderId(floderIdResult);
                permissionPrevRecordPayload.setFolderName(itemNameResult);
                permissionPrevRecordPayload.setPermissionFlag(Boolean.valueOf(permissionFlag));
                permissionPrevRecordPayload.setPreviewUri(previewUri);
                permissionPrevRecordPayload.setItemPath(itemPathResult);
                permissionPrevRecordVO = this.businessDocTypePermissionPrevRecordService.insert(permissionPrevRecordPayload);
            } else {
                permissionPrevRecordVO = this.businessDocTypePermissionPrevRecordService.update(permissionPrevRecordPayload);
            }
            log.info("\u9879\u76ee\u5df2\u521b\u5efa\u6613\u7a3b\u58f3\u76ee\u5f55\uff0c\u6613\u7a3b\u58f3\u4eba\u5458\u8d4b\u6743\u9650 \u5b8c\u6210");
            return permissionPrevRecordVO;
        }
        return permissionPrevRecordVO;
    }

    private void checkAuthority(boolean systemAdmin, Long userId, Long orgId, List<String> roleList, Long docId, String docType, BusinessDocTypeConfigVO businessDocTypeConfigVO) {
        if (!systemAdmin) {
            if (ObjectUtils.isEmpty(roleList)) {
                throw TwException.error("", "\u89d2\u8272\u672a\u914d\u7f6e\uff0c\u6682\u65e0\u6743\u9650");
            }
            BusinessDocTypeConfigRoleRefQuery configRoleRefQuery = new BusinessDocTypeConfigRoleRefQuery();
            configRoleRefQuery.setRoleCodeList(roleList);
            configRoleRefQuery.setDocType(docType);
            Long count = this.businessDocTypeConfigRoleRefService.count(configRoleRefQuery);
            if (count < 1L) {
                BusinessDocTypeCheckAuthorityService businessDocTypeCheckAuthorityService;
                if (businessDocTypeConfigVO.getPermissionControlFlag() != null && businessDocTypeConfigVO.getPermissionControlFlag().booleanValue()) {
                    if (ObjectUtils.isEmpty(roleList)) {
                        throw TwException.error("", "\u6682\u65e0\u6743\u9650");
                    }
                    boolean flag = false;
                    for (String roleCode : roleList) {
                        if (this.businessDocTypeConfigAllowRoleService.count(new BusinessDocTypeConfigAllowRoleQuery(businessDocTypeConfigVO.getId(), roleCode)) <= 0L) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) {
                        throw TwException.error("", "\u6682\u65e0\u6743\u9650");
                    }
                }
                if (null != (businessDocTypeCheckAuthorityService = BusinessDocTypeCheckAuthorityFactory.SERVICE_MAP.get(docType))) {
                    TwException twException = businessDocTypeCheckAuthorityService.checkAuthority(docId);
                    if (null != twException) {
                        throw twException;
                    }
                    TwException twException1 = businessDocTypeCheckAuthorityService.checkAuthority(docId, docType);
                    if (null != twException1) {
                        throw twException1;
                    }
                    TwException twException2 = businessDocTypeCheckAuthorityService.checkAuthority(userId, orgId, roleList, docId, docType, businessDocTypeConfigVO.getId());
                    if (null != twException2) {
                        throw twException2;
                    }
                }
            }
        }
    }

    private static void checkYeedocInfoQuery(Long docId, String docType, Long configId, String createFolderName) {
        if (ObjectUtils.isEmpty((Object)docType)) {
            throw TwException.error("", "docType \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (docId == null) {
            throw TwException.error("", "docId \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (configId == null) {
            throw TwException.error("", "configId \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)createFolderName)) {
            log.error("\u901a\u7528\u6587\u6863\u7ba1\u7406\u5f02\u5e38\uff0c\u521b\u5efa\u6587\u4ef6\u5939\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            throw TwException.error("", "createFolderName \u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private BusinessDocTypeConfigRuleVO getBusinessDocTypeConfigRuleVO(Long docId, Long configId, String tableName, List<BusinessTableFieldsVO> businessTableFieldsVOS) {
        if (ObjectUtils.isEmpty((Object)docId)) {
            throw TwException.error("", "docId \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)configId)) {
            throw TwException.error("", "configId \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)tableName)) {
            tableName = "nullTable";
        }
        BusinessDocTypeConfigRuleQuery query = new BusinessDocTypeConfigRuleQuery();
        query.setConfigId(configId);
        List<BusinessDocTypeConfigRuleVO> configRuleVOS = this.businessDocTypeConfigRuleDAO.queryListDynamic(query);
        if (CollectionUtils.isEmpty(configRuleVOS)) {
            throw TwException.error("DOC_TYPE_CONFIG_NOT_FOUND", "\u6682\u672a\u914d\u7f6e\u6587\u6863\u5b58\u50a8\u8def\u5f84\uff0c\u8bf7\u5148\u4e3a\u4e1a\u52a1\u5bf9\u8c61\u8fdb\u884c\u914d\u7f6e");
        }
        BusinessDocTypeConfigRuleVO ruleResult = null;
        ArrayList<BusinessDocTypeConfigRuleVO> notFieldRuleVOS = new ArrayList<BusinessDocTypeConfigRuleVO>();
        for (BusinessDocTypeConfigRuleVO configRuleVO : configRuleVOS) {
            if (ObjectUtils.isEmpty((Object)configRuleVO.getConditionsValue())) {
                log.warn("\u901a\u7528\u6587\u6863\u7ba1\u7406\u5f02\u5e38\uff1a\u6761\u4ef6\u503c\u3010conditionsValue\u3011\u4e3a\u7a7a");
                if (!ObjectUtils.isEmpty((Object)configRuleVO.getFieldId())) continue;
                log.warn("\u901a\u7528\u6587\u6863\u7ba1\u7406\uff1a\u6761\u4ef6\u503c\u3010conditionsValue\u3011\u3001\u4e1a\u52a1\u5bf9\u8c61\u5b57\u6bb5\u660e\u7ec6\u4e3b\u952e\u3010fieldId\u3011 \u4e3a\u7a7a\uff1b\u5c5e\u4e8e\u7edf\u4e00\u8def\u5f84\u7684\u5b58\u50a8\u914d\u7f6e\u573a\u666f");
                notFieldRuleVOS.add(configRuleVO);
                continue;
            }
            if (ObjectUtils.isEmpty((Object)configRuleVO.getFieldId())) {
                log.error("\u901a\u7528\u6587\u6863\u7ba1\u7406\u5f02\u5e38\uff1a\u4e1a\u52a1\u5bf9\u8c61\u5b57\u6bb5\u660e\u7ec6\u4e3b\u952e\u3010fieldId\u3011\u4e3a\u7a7a");
                continue;
            }
            if (ObjectUtils.isEmpty((Object)configRuleVO.getConditions())) {
                log.error("\u901a\u7528\u6587\u6863\u7ba1\u7406\u5f02\u5e38\uff1a\u6761\u4ef6\u3010conditions\u3011\u4e3a\u7a7a");
                configRuleVO.setConditions(BusinessDocTypeRuleConditionEnum.EQ.getCode());
            }
            StringBuffer sql = new StringBuffer();
            sql.append("select count(1)  from " + tableName);
            sql.append(" where id = " + docId);
            sql.append(" and delete_flag = 0 ");
            String conditions = configRuleVO.getConditions();
            Optional<BusinessTableFieldsVO> fieldsVOOptional = businessTableFieldsVOS.stream().filter(businessTableFieldsVO -> businessTableFieldsVO.getId().equals(configRuleVO.getFieldId())).findFirst();
            if (fieldsVOOptional.isPresent()) {
                BusinessTableFieldsVO fieldsVO = fieldsVOOptional.get();
                sql.append(" and " + fieldsVO.getField() + " " + conditions);
                if (conditions.equals(BusinessDocTypeRuleConditionEnum.IN.getCode()) || conditions.equals(BusinessDocTypeRuleConditionEnum.NOT_IN.getCode())) {
                    if (configRuleVO.getConditionsValue().contains(",")) {
                        Object[] conditionsValues = configRuleVO.getConditionsValue().split(",");
                        configRuleVO.setConditionsValue("(" + org.apache.commons.lang3.StringUtils.join((Object[])conditionsValues, (String)"','") + ")");
                    } else {
                        configRuleVO.setConditionsValue("('" + configRuleVO.getConditionsValue() + "')");
                    }
                    sql.append(" " + configRuleVO.getConditionsValue() + " ");
                } else {
                    sql.append(" '" + configRuleVO.getConditionsValue() + "'");
                }
            } else {
                log.error("\u901a\u7528\u6587\u6863\u7ba1\u7406\u5f02\u5e38\uff1a\u4e1a\u52a1\u5bf9\u8c61\u5b57\u6bb5\u660e\u7ec6\u4e0d\u5b58\u5728! fieldId:{}", (Object)configRuleVO.getFieldId());
                throw TwException.error("", "\u4e1a\u52a1\u5bf9\u8c61\u5b57\u6bb5\u660e\u7ec6\u4e0d\u5b58\u5728");
            }
            log.info("\u901a\u7528\u6587\u6863\u7ba1\u7406 \u5339\u914d\u89c4\u5219 sql:{}", (Object)sql.toString());
            Query querySql = this.em.createNativeQuery(sql.toString());
            BigInteger singleResult = (BigInteger)querySql.getSingleResult();
            int countResult = singleResult.intValue();
            if (countResult <= 0) continue;
            ruleResult = configRuleVO;
            break;
        }
        if (null == ruleResult && !CollectionUtils.isEmpty(notFieldRuleVOS)) {
            if (notFieldRuleVOS.size() > 1) {
                log.error("\u901a\u7528\u6587\u6863\u7ba1\u7406\u5f02\u5e38\uff1a\u5339\u914d\u5230\u591a\u4e2a\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u89c4\u5219\u662f\u5426\u6709\u91cd\u590d");
                throw TwException.error("", "\u5339\u914d\u5230\u591a\u4e2a\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u89c4\u5219\u662f\u5426\u6709\u91cd\u590d");
            }
            return (BusinessDocTypeConfigRuleVO)notFieldRuleVOS.get(0);
        }
        return ruleResult;
    }

    private Result createFolder(String createFolderName, String itemId, String libraryId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<Object> pathArry = new ArrayList<Object>();
        if (createFolderName.startsWith("/")) {
            pathArry.add(createFolderName);
        } else {
            pathArry.add("/" + createFolderName);
        }
        if (StringUtils.hasText((String)itemId)) {
            map.put("ItemId", itemId);
        }
        map.put("PathArry", pathArry);
        map.put("LibraryId", libraryId);
        String resultStr = this.yeedocService.createFolder(map);
        if (ObjectUtils.isEmpty((Object)resultStr)) {
            log.error("\u901a\u7528\u6587\u6863\u7ba1\u7406\u5f02\u5e38[\u8c03\u7528\u6613\u9053\u58f3\u521b\u5efa\u6587\u4ef6\u5939]-map:{}", (Object)JSONObject.toJSONString(map));
            log.error("\u901a\u7528\u6587\u6863\u7ba1\u7406\u5f02\u5e38[\u8c03\u7528\u6613\u9053\u58f3\u521b\u5efa\u6587\u4ef6\u5939]-resultStr:{}", (Object)resultStr);
            throw TwException.error("DOC_TYPE_CONFIG_YEEDOC_CREATE_FLODER_ERROR", "\u6613\u9053\u58f3\u521b\u5efa\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        JSONObject resultJson = JSONObject.parseObject((String)resultStr);
        Object data = resultJson.get((Object)"Data");
        if (ObjectUtils.isEmpty((Object)data)) {
            log.error("\u901a\u7528\u6587\u6863\u7ba1\u7406\u5f02\u5e38[\u8c03\u7528\u6613\u9053\u58f3\u521b\u5efa\u6587\u4ef6\u5939]-resultJson:{}", (Object)resultJson);
            throw TwException.error("DOC_TYPE_CONFIG_YEEDOC_CREATE_FLODER_ERROR", "\u6613\u9053\u58f3\u521b\u5efa\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        JSONArray dataArray = JSONArray.parseArray((String)data.toString());
        if (ObjectUtils.isEmpty((Object)dataArray)) {
            log.error("\u901a\u7528\u6587\u6863\u7ba1\u7406\u5f02\u5e38[\u8c03\u7528\u6613\u9053\u58f3\u521b\u5efa\u6587\u4ef6\u5939]-resultJson:{}", (Object)resultJson);
            throw TwException.error("DOC_TYPE_CONFIG_YEEDOC_CREATE_FLODER_ERROR", "\u6613\u9053\u58f3\u521b\u5efa\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        String floderId = (String)JSONObject.parseObject((String)String.valueOf(dataArray.get(0))).get((Object)"FolderId");
        String floderName = (String)JSONObject.parseObject((String)String.valueOf(dataArray.get(0))).get((Object)"LeafName");
        Result result = new Result(floderId, floderName);
        return result;
    }

    public BusinessDocTypeConfigServiceImpl(BusinessDocTypeConfigRepo businessDocTypeConfigRepo, BusinessDocTypeConfigDAO businessDocTypeConfigDAO, BusinessTableService businessTableService, BusinessTableFieldsService businessTableFieldsService, BusinessDocTypeConfigRuleDAO businessDocTypeConfigRuleDAO, BusinessDocTypeRefService businessDocTypeRefService, CacheUtil cacheUtil, YeedocService yeedocService, BusinessDocTypePermissionPrevRecordService businessDocTypePermissionPrevRecordService, BusinessDocTypeConfigAllowRoleService businessDocTypeConfigAllowRoleService, BusinessDocTypeConfigRoleRefService businessDocTypeConfigRoleRefService, FunConfigProperties funConfigProperties, YeedocProperties yeedocProperties) {
        this.businessDocTypeConfigRepo = businessDocTypeConfigRepo;
        this.businessDocTypeConfigDAO = businessDocTypeConfigDAO;
        this.businessTableService = businessTableService;
        this.businessTableFieldsService = businessTableFieldsService;
        this.businessDocTypeConfigRuleDAO = businessDocTypeConfigRuleDAO;
        this.businessDocTypeRefService = businessDocTypeRefService;
        this.cacheUtil = cacheUtil;
        this.yeedocService = yeedocService;
        this.businessDocTypePermissionPrevRecordService = businessDocTypePermissionPrevRecordService;
        this.businessDocTypeConfigAllowRoleService = businessDocTypeConfigAllowRoleService;
        this.businessDocTypeConfigRoleRefService = businessDocTypeConfigRoleRefService;
        this.funConfigProperties = funConfigProperties;
        this.yeedocProperties = yeedocProperties;
    }

    private record Result(String floderId, String floderName) {
    }
}

