/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.common.util;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectCalendarPayload;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectCalendarService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectCalendarVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsRelyVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.ProjectWbsTypeEnum;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class AutoScheduling {
    private static final Logger log = LoggerFactory.getLogger(AutoScheduling.class);
    private PmsProjectCalendarService calendarService;
    private List<PmsProjectWbsVO> pmsProjectWbsVOS;
    private List<PmsProjectWbsRelyVO> pmsProjectWbsRelyVOS;
    private LocalDate startDate;
    private Long projectId;

    public AutoScheduling(List<PmsProjectWbsVO> pmsProjectWbsVOS, List<PmsProjectWbsRelyVO> pmsProjectWbsRelyVOS, LocalDate startDate, PmsProjectCalendarService calendarService, Long projectId) {
        this.pmsProjectWbsVOS = pmsProjectWbsVOS;
        this.pmsProjectWbsRelyVOS = pmsProjectWbsRelyVOS;
        this.startDate = startDate;
        this.calendarService = calendarService;
        this.projectId = projectId;
    }

    public List<PmsProjectWbsVO> startScheduling() {
        if (ObjectUtils.isEmpty(this.pmsProjectWbsRelyVOS) || ObjectUtils.isEmpty(this.pmsProjectWbsVOS)) {
            throw TwException.error("wbs-101", "\u672a\u8bc6\u522b\u5230\u5173\u7cfb\u7f51\u7edc\uff0c\u8bf7\u4e3a\u6d3b\u52a8\u3001\u91cc\u7a0b\u7891\u4e4b\u95f4\u5efa\u7acb\u4f9d\u8d56\u5173\u7cfb\u4ee5\u7ec4\u6210\u5173\u7cfb\u7f51\u7edc");
        }
        List wbsIds = this.pmsProjectWbsRelyVOS.stream().map(PmsProjectWbsRelyVO::getWbsId).distinct().collect(Collectors.toList());
        List relyWbsIds = this.pmsProjectWbsRelyVOS.stream().map(PmsProjectWbsRelyVO::getWbsRelyId).distinct().collect(Collectors.toList());
        this.pmsProjectWbsVOS = this.pmsProjectWbsVOS.stream().filter(wbsVO -> wbsIds.contains(wbsVO.getId()) || relyWbsIds.contains(wbsVO.getId())).collect(Collectors.toList());
        this.initializeData();
        List<PmsProjectWbsVO> startWbsVOS = this.pmsProjectWbsVOS.stream().filter(wbsVO -> !wbsIds.contains(wbsVO.getId())).collect(Collectors.toList());
        if (ObjectUtils.isEmpty(startWbsVOS)) {
            throw TwException.error("wbs-102", "\u65e0\u6cd5\u83b7\u53d6\u8d77\u59cb\u5f00\u53e3\u6570\u636e\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        List<PmsProjectWbsVO> endWbsVOS = this.pmsProjectWbsVOS.stream().filter(wbsVO -> !relyWbsIds.contains(wbsVO.getId())).collect(Collectors.toList());
        if (ObjectUtils.isEmpty(endWbsVOS)) {
            throw TwException.error("wbs-102", "\u65e0\u6cd5\u83b7\u53d6\u7ed3\u5c3e\u5f00\u53e3\u6570\u636e\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        List allWbsIds = this.pmsProjectWbsVOS.stream().map(BaseViewModel::getId).collect(Collectors.toList());
        this.calendarService.handleCalendarCache(allWbsIds, ProjectWbsTypeEnum.WBS.getCode(), "save", this.projectId);
        startWbsVOS.forEach(startWbsVO -> {
            PmsProjectCalendarVO byDurationDays = this.getCalendarPayload(startWbsVO.getId(), startWbsVO.getPreDurationDay().intValue(), this.startDate, null);
            if (byDurationDays != null) {
                startWbsVO.setEarlyStartDate(byDurationDays.getStartDate());
                startWbsVO.setEarlyEndDate(byDurationDays.getEndDate());
                if (startWbsVO.getWbsType().equals(ProjectWbsTypeEnum.MS.getCode())) {
                    startWbsVO.setEarlyEndDate(byDurationDays.getStartDate());
                }
            } else {
                throw TwException.error("", "\u83b7\u53d6\u65e5\u671f\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            }
            this.sequentialMethod((PmsProjectWbsVO)startWbsVO);
        });
        PmsProjectWbsVO pmsProjectWbsVO = endWbsVOS.stream().max(Comparator.comparing(PmsProjectWbsVO::getEarlyEndDate)).get();
        LocalDate earlyEndDate = pmsProjectWbsVO.getEarlyEndDate();
        endWbsVOS.forEach(endWbsVO -> {
            PmsProjectCalendarVO byDurationDays = this.getCalendarPayload(endWbsVO.getId(), endWbsVO.getPreDurationDay().intValue(), null, earlyEndDate);
            if (byDurationDays != null) {
                endWbsVO.setLateStartDate(byDurationDays.getStartDate());
                endWbsVO.setLateEndDate(byDurationDays.getEndDate());
                if (endWbsVO.getWbsType().equals(ProjectWbsTypeEnum.MS.getCode())) {
                    endWbsVO.setLateStartDate(byDurationDays.getEndDate());
                }
            } else {
                throw TwException.error("", "\u83b7\u53d6\u65e5\u671f\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            }
            this.inverseMethod((PmsProjectWbsVO)endWbsVO);
        });
        this.pmsProjectWbsVOS.forEach(wbsVO1 -> {
            PmsProjectCalendarVO byDurationDays0;
            int TF0;
            PmsProjectCalendarVO byDurationDays = this.getCalendarPayload(wbsVO1.getId(), null, wbsVO1.getEarlyStartDate(), wbsVO1.getLateStartDate());
            int TF = byDurationDays.getDurationDays() - 1;
            if (TF == (TF0 = (byDurationDays0 = this.getCalendarPayload(wbsVO1.getId(), null, wbsVO1.getEarlyEndDate(), wbsVO1.getLateEndDate())).getDurationDays() - 1)) {
                wbsVO1.setTotalFloat(new BigDecimal(TF));
                wbsVO1.setIsKeyNode(Integer.valueOf(0));
                if (TF == 0) {
                    wbsVO1.setIsKeyNode(Integer.valueOf(1));
                }
            } else {
                System.out.println("wbsVO:::" + wbsVO1.toString());
                throw TwException.error("", "\u65e5\u671f\u63a7\u4ef6\u8ba1\u7b97\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            }
            Integer FF = null;
            List afterVOs = this.pmsProjectWbsRelyVOS.stream().filter(wbsRelyVO -> wbsRelyVO.getWbsRelyId().equals(wbsVO1.getId())).collect(Collectors.toList());
            for (PmsProjectWbsRelyVO afterVO : afterVOs) {
                PmsProjectCalendarVO durationDays;
                PmsProjectWbsVO first = this.pmsProjectWbsVOS.stream().filter(wbsVO -> wbsVO.getId().equals(afterVO.getWbsId())).findFirst().get();
                int localDay = 999999;
                if (afterVO.getRelyType().equals("FS")) {
                    durationDays = this.getCalendarPayload(wbsVO1.getId(), null, wbsVO1.getEarlyEndDate(), first.getEarlyStartDate());
                    localDay = durationDays.getDurationDays() - 2;
                }
                if (afterVO.getRelyType().equals("SS")) {
                    durationDays = this.getCalendarPayload(wbsVO1.getId(), null, wbsVO1.getEarlyStartDate(), first.getEarlyStartDate());
                    localDay = durationDays.getDurationDays() - 1;
                }
                if (afterVO.getRelyType().equals("FF")) {
                    durationDays = this.getCalendarPayload(wbsVO1.getId(), null, wbsVO1.getEarlyEndDate(), first.getEarlyEndDate());
                    localDay = durationDays.getDurationDays() - 1;
                }
                if (localDay == 999999) {
                    throw TwException.error("", "\u81ea\u7531\u6d6e\u65f6\u8ba1\u7b97\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
                }
                if (FF == null) {
                    FF = localDay;
                    continue;
                }
                if (FF <= localDay) continue;
                FF = localDay;
            }
            wbsVO1.setFreeFloat(FF == null ? null : BigDecimal.valueOf(FF.intValue()));
            wbsVO1.setAutoScheduling(Integer.valueOf(1));
            wbsVO1.setPreEndDate(wbsVO1.getEarlyEndDate());
            wbsVO1.setPreStartDate(wbsVO1.getEarlyStartDate());
        });
        this.calendarService.handleCalendarCache(allWbsIds, ProjectWbsTypeEnum.WBS.getCode(), "clean", this.projectId);
        return this.pmsProjectWbsVOS;
    }

    void inverseMethod(PmsProjectWbsVO afterVO) {
        List<PmsProjectWbsRelyVO> frontVOs = this.pmsProjectWbsRelyVOS.stream().filter(wbsRelyVO -> wbsRelyVO.getWbsId().equals(afterVO.getId())).collect(Collectors.toList());
        if (!ObjectUtils.isEmpty(frontVOs)) {
            frontVOs.forEach(frontVO -> {
                PmsProjectWbsVO pmsProjectWbsVO;
                Optional<PmsProjectWbsVO> first = this.pmsProjectWbsVOS.stream().filter(wbsVO -> wbsVO.getId().equals(frontVO.getWbsRelyId())).findFirst();
                if (first.isPresent()) {
                    pmsProjectWbsVO = first.get();
                    LocalDate lateEndDate = pmsProjectWbsVO.getLateEndDate();
                    LocalDate localLateEndDate = null;
                    LocalDate localLateStartDate = null;
                    LocalDate lateStartDate = pmsProjectWbsVO.getLateStartDate();
                    if (pmsProjectWbsVO.getWbsType().equals(ProjectWbsTypeEnum.MS.getCode())) {
                        if (frontVO.getRelyType().equals("FS")) {
                            localLateEndDate = afterVO.getLateStartDate();
                        }
                        if (frontVO.getRelyType().equals("FF")) {
                            localLateEndDate = afterVO.getLateEndDate();
                        }
                    } else {
                        PmsProjectCalendarVO byDurationDays;
                        Boolean isStartDate = false;
                        if (frontVO.getRelyType().equals("FS")) {
                            localLateEndDate = afterVO.getLateStartDate().minusDays(1L);
                        }
                        if (frontVO.getRelyType().equals("SS")) {
                            localLateStartDate = afterVO.getLateStartDate();
                            byDurationDays = this.getCalendarPayload(pmsProjectWbsVO.getId(), pmsProjectWbsVO.getPreDurationDay().intValue(), afterVO.getLateStartDate(), null);
                            localLateEndDate = byDurationDays.getEndDate();
                            isStartDate = true;
                        }
                        if (frontVO.getRelyType().equals("FF")) {
                            localLateEndDate = afterVO.getLateEndDate();
                        }
                        if (!isStartDate.booleanValue()) {
                            byDurationDays = this.getCalendarPayload(pmsProjectWbsVO.getId(), pmsProjectWbsVO.getPreDurationDay().intValue(), null, localLateEndDate);
                            localLateStartDate = byDurationDays.getStartDate();
                            localLateEndDate = byDurationDays.getEndDate();
                        }
                    }
                    if (lateEndDate == null) {
                        lateEndDate = localLateEndDate;
                        lateStartDate = localLateStartDate;
                    } else if (localLateEndDate.isBefore(lateEndDate)) {
                        lateEndDate = localLateEndDate;
                        lateStartDate = localLateStartDate;
                    }
                    pmsProjectWbsVO.setLateEndDate(lateEndDate);
                    pmsProjectWbsVO.setLateStartDate(lateStartDate);
                    if (pmsProjectWbsVO.getWbsType().equals(ProjectWbsTypeEnum.MS.getCode())) {
                        pmsProjectWbsVO.setLateStartDate(lateEndDate);
                    }
                } else {
                    throw TwException.error("", "\u5b58\u5728\u65e0\u6548\u7684\u5173\u8054\u7f51\u7edc\u3010" + frontVO.getWbsRelyName() + "-" + frontVO.getWbsName() + "\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
                }
                this.inverseMethod(pmsProjectWbsVO);
            });
        }
    }

    void sequentialMethod(PmsProjectWbsVO frontVO) {
        List<PmsProjectWbsRelyVO> afterRelyVOs = this.pmsProjectWbsRelyVOS.stream().filter(wbsRelyVO -> wbsRelyVO.getWbsRelyId().equals(frontVO.getId())).collect(Collectors.toList());
        if (!ObjectUtils.isEmpty(afterRelyVOs)) {
            afterRelyVOs.forEach(afterRelyVO -> {
                Optional<PmsProjectWbsVO> first = this.pmsProjectWbsVOS.stream().filter(wbsVO -> wbsVO.getId().equals(afterRelyVO.getWbsId())).findFirst();
                if (!first.isPresent()) throw TwException.error("", "\u5b58\u5728\u65e0\u6548\u7684\u5173\u8054\u7f51\u7edc\u3010" + afterRelyVO.getWbsRelyName() + "-" + afterRelyVO.getWbsName() + "\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
                PmsProjectWbsVO pmsProjectWbsVO = first.get();
                this.checkLoop(frontVO, pmsProjectWbsVO, (PmsProjectWbsRelyVO)afterRelyVO);
                LocalDate earlyStartDate = pmsProjectWbsVO.getEarlyStartDate();
                LocalDate localEarlyStartDate = null;
                LocalDate localEarlyEndDate = null;
                LocalDate earlyEndDate = pmsProjectWbsVO.getEarlyEndDate();
                if (pmsProjectWbsVO.getWbsType().equals(ProjectWbsTypeEnum.MS.getCode())) {
                    if (!afterRelyVO.getRelyType().equals("FF")) throw TwException.error("", "\u5b58\u5728\u65e0\u6548\u7684\u5173\u8054\u7f51\u7edc\u3010" + afterRelyVO.getWbsRelyName() + "-" + afterRelyVO.getWbsName() + "\uff0c\u8bf7\u6838\u9a8c\uff01");
                    localEarlyEndDate = localEarlyStartDate = frontVO.getEarlyEndDate();
                } else {
                    PmsProjectCalendarVO byDurationDays;
                    Boolean isEndDate = false;
                    if (afterRelyVO.getRelyType().equals("FS")) {
                        localEarlyStartDate = frontVO.getEarlyEndDate().plusDays(1L);
                    }
                    if (afterRelyVO.getRelyType().equals("SS")) {
                        localEarlyStartDate = frontVO.getEarlyStartDate();
                    }
                    if (afterRelyVO.getRelyType().equals("FF")) {
                        localEarlyEndDate = frontVO.getEarlyEndDate();
                        byDurationDays = this.getCalendarPayload(pmsProjectWbsVO.getId(), pmsProjectWbsVO.getPreDurationDay().intValue(), null, frontVO.getEarlyEndDate());
                        localEarlyStartDate = byDurationDays.getStartDate();
                        isEndDate = true;
                    }
                    if (!isEndDate.booleanValue()) {
                        byDurationDays = this.getCalendarPayload(pmsProjectWbsVO.getId(), pmsProjectWbsVO.getPreDurationDay().intValue(), localEarlyStartDate, null);
                        localEarlyEndDate = byDurationDays.getEndDate();
                        localEarlyStartDate = byDurationDays.getStartDate();
                    }
                }
                if (earlyStartDate == null) {
                    earlyStartDate = localEarlyStartDate;
                    earlyEndDate = localEarlyEndDate;
                } else if (earlyStartDate.isBefore(localEarlyStartDate)) {
                    earlyStartDate = localEarlyStartDate;
                    earlyEndDate = localEarlyEndDate;
                }
                pmsProjectWbsVO.setEarlyStartDate(earlyStartDate);
                pmsProjectWbsVO.setEarlyEndDate(earlyEndDate);
                if (pmsProjectWbsVO.getWbsType().equals(ProjectWbsTypeEnum.MS.getCode())) {
                    pmsProjectWbsVO.setEarlyEndDate(earlyStartDate);
                }
                this.sequentialMethod(pmsProjectWbsVO);
            });
        }
    }

    void checkLoop(PmsProjectWbsVO frontVO, PmsProjectWbsVO pmsProjectWbsVO, PmsProjectWbsRelyVO relyVO) {
        Object frontIds = "";
        if (StringUtils.hasText((String)frontVO.getFrontWbsIds())) {
            frontIds = (String)frontIds + frontVO.getFrontWbsIds() + ",";
        }
        frontIds = (String)frontIds + frontVO.getId();
        Object frontRelyIds = "";
        if (StringUtils.hasText((String)frontVO.getFrontRelyIds())) {
            frontRelyIds = (String)frontRelyIds + frontVO.getFrontRelyIds() + ",";
        }
        frontRelyIds = (String)frontRelyIds + relyVO.getId();
        pmsProjectWbsVO.setFrontWbsIds((String)frontIds);
        pmsProjectWbsVO.setFrontRelyIds((String)frontRelyIds);
        if (pmsProjectWbsVO.getFrontWbsIds().indexOf("" + pmsProjectWbsVO.getId()) >= 0) {
            Object[] splitWbsIds = ((String)frontIds).split(",");
            int index = Arrays.binarySearch(splitWbsIds, "" + pmsProjectWbsVO.getId());
            String[] splitRelyIds = ((String)frontRelyIds).split(",");
            ArrayList<PmsProjectWbsRelyVO> relyVOS = new ArrayList<PmsProjectWbsRelyVO>();
            for (int i = index; i < splitRelyIds.length; ++i) {
                Long relyId = Long.valueOf(splitRelyIds[i]);
                PmsProjectWbsRelyVO pmsProjectWbsRelyVO = this.pmsProjectWbsRelyVOS.stream().filter(relyVO1 -> relyVO1.getId().equals(relyId)).findFirst().get();
                PmsProjectWbsVO pmsProjectWbsVO1 = this.pmsProjectWbsVOS.stream().filter(wbsVO -> wbsVO.getId().equals(pmsProjectWbsRelyVO.getWbsId())).findFirst().get();
                PmsProjectWbsVO pmsProjectWbsVO2 = this.pmsProjectWbsVOS.stream().filter(wbsVO -> wbsVO.getId().equals(pmsProjectWbsRelyVO.getWbsRelyId())).findFirst().get();
                pmsProjectWbsRelyVO.setNodeCode(pmsProjectWbsVO1.getNodeCode());
                pmsProjectWbsRelyVO.setWbsName(pmsProjectWbsVO1.getWbsName());
                pmsProjectWbsRelyVO.setNodeRelyCode(pmsProjectWbsVO2.getNodeCode());
                pmsProjectWbsRelyVO.setWbsRelyName(pmsProjectWbsVO2.getWbsName());
                relyVOS.add(pmsProjectWbsRelyVO);
            }
            throw TwException.error("wbs-102", "", "\u5b58\u5728\u7f51\u7edc\u56de\u8def\uff0c\u8bf7\u6838\u9a8c\uff01", relyVOS);
        }
    }

    PmsProjectCalendarVO getCalendarPayload(long wbsId, Integer durationDays, LocalDate startDate, LocalDate endDate) {
        PmsProjectCalendarPayload calendarPayload = new PmsProjectCalendarPayload();
        calendarPayload.setSourceId(Long.valueOf(wbsId));
        calendarPayload.setSourceType(ProjectWbsTypeEnum.WBS.getCode());
        calendarPayload.setStartDate(startDate);
        calendarPayload.setEndDate(endDate);
        calendarPayload.setDurationDays(durationDays);
        calendarPayload.setFromCacheFlag(Boolean.valueOf(true));
        calendarPayload.setProjectId(this.projectId);
        PmsProjectCalendarVO byDurationDays = this.calendarService.findBySource(calendarPayload);
        if (byDurationDays == null) {
            throw TwException.error("", "\u65e5\u671f\u63a7\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        if (byDurationDays.getStartDate() == null || byDurationDays.getEndDate() == null) {
            throw TwException.error("", "\u65e5\u671f\u63a7\u4ef6\u6570\u636e\u8fd4\u56de\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        return byDurationDays;
    }

    void initializeData() {
        this.pmsProjectWbsVOS.forEach(pmsProjectWbsVO -> {
            if (pmsProjectWbsVO.getPreDurationDay() == null) {
                throw TwException.error("", "\u9884\u8ba1\u5de5\u671f\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            pmsProjectWbsVO.setEarlyStartDate(null);
            pmsProjectWbsVO.setEarlyEndDate(null);
            pmsProjectWbsVO.setLateStartDate(null);
            pmsProjectWbsVO.setLateEndDate(null);
            pmsProjectWbsVO.setFreeFloat(null);
            pmsProjectWbsVO.setTotalFloat(null);
            pmsProjectWbsVO.setDelayLag(null);
        });
    }

    public AutoScheduling() {
    }
}

