/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.common.workFlow;

import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.workFlow.CommonWorkflowCheck;
import com.elitesland.tw.tw5.server.common.workFlow.CommonWorkflowEvent;
import com.elitesland.tw.tw5.server.common.workFlow.TwWorkflowCheckAnnotation;
import com.elitesland.tw.tw5.server.common.workFlow.TwWorkflowEventAnnotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/workflow"})
public class WorkflowController {
    private static final Logger log = LoggerFactory.getLogger(WorkflowController.class);
    @Autowired
    private Map<String, CommonWorkflowEvent> workflowEventMap;
    @Autowired
    private Map<String, CommonWorkflowCheck> workflowCheckMap;
    private final List<EventInfo> eventList = new ArrayList<EventInfo>();
    private final List<CheckInfo> checkList = new ArrayList<CheckInfo>();

    @PostConstruct
    private void initList() {
        this.workflowEventMap.forEach((key, value) -> {
            TwWorkflowEventAnnotation annotation = value.getClass().getAnnotation(TwWorkflowEventAnnotation.class);
            this.eventList.add(new EventInfo(annotation.name(), annotation.code(), annotation.scope(), annotation.tableName(), annotation.params(), annotation.description(), annotation.enabled()));
        });
        this.workflowCheckMap.forEach((key, value) -> {
            TwWorkflowCheckAnnotation annotation = value.getClass().getAnnotation(TwWorkflowCheckAnnotation.class);
            this.checkList.add(new CheckInfo(annotation.name(), annotation.code(), annotation.scope(), annotation.tableName(), annotation.params(), annotation.description(), annotation.enabled()));
        });
    }

    @GetMapping(value={"/event/list"})
    public TwOutputUtil eventList(String scope, String tableName, boolean allFlag) {
        List result = this.eventList.stream().filter(eventInfo -> {
            boolean bool = true;
            if (scope != null && !scope.equals(eventInfo.getScope())) {
                bool = false;
            }
            if (tableName != null && !tableName.equals(eventInfo.getTableName())) {
                bool = false;
            }
            if (!allFlag && !eventInfo.enabled) {
                bool = false;
            }
            return bool;
        }).collect(Collectors.toList());
        return TwOutputUtil.ok(result);
    }

    @GetMapping(value={"/check/list"})
    public TwOutputUtil checkList(String scope, String tableName, boolean allFlag) {
        List result = this.checkList.stream().filter(eventInfo -> {
            boolean bool = true;
            if (scope != null && !scope.equals(eventInfo.getScope())) {
                bool = false;
            }
            if (tableName != null && !tableName.equals(eventInfo.getTableName())) {
                bool = false;
            }
            if (!eventInfo.enabled) {
                bool = false;
            }
            return bool;
        }).collect(Collectors.toList());
        return TwOutputUtil.ok(result);
    }

    public static class CheckInfo {
        private final String name;
        private final String code;
        private final String scope;
        private final String tableName;
        private final String params;
        private final String description;
        private final boolean enabled;

        public CheckInfo(String name, String code, String scope, String tableName, String params, String description, boolean enabled) {
            this.name = name;
            this.code = code;
            this.scope = scope;
            this.tableName = tableName;
            this.params = params;
            this.description = description;
            this.enabled = enabled;
        }

        public String getName() {
            return this.name;
        }

        public String getCode() {
            return this.code;
        }

        public String getScope() {
            return this.scope;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String getParams() {
            return this.params;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }

    public static class EventInfo {
        private final String name;
        private final String code;
        private final String scope;
        private final String tableName;
        private final String params;
        private final String description;
        private final boolean enabled;

        public EventInfo(String name, String code, String scope, String tableName, String params, String description, boolean enabled) {
            this.name = name;
            this.code = code;
            this.scope = scope;
            this.tableName = tableName;
            this.params = params;
            this.description = description;
            this.enabled = enabled;
        }

        public String getName() {
            return this.name;
        }

        public String getCode() {
            return this.code;
        }

        public String getScope() {
            return this.scope;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String getParams() {
            return this.params;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }
}

