/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.cal.service;

import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.FieldOp;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.util.FieldFns;
import cn.zhxu.bs.util.MapBuilder;
import cn.zhxu.bs.util.MapUtils;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalTaskSettleDetailPayload;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalTaskSettlePayload;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalTaskSettleWithdrawPayload;
import com.elitesland.tw.tw5.api.prd.cal.query.CalTaskSettleDetailQuery;
import com.elitesland.tw.tw5.api.prd.cal.query.CalTaskSettleQuery;
import com.elitesland.tw.tw5.api.prd.cal.service.CalResourceService;
import com.elitesland.tw.tw5.api.prd.cal.service.CalTaskSettleDetailService;
import com.elitesland.tw.tw5.api.prd.cal.service.CalTaskSettleService;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalAccountVO;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalTaskSettleDetailVO;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalTaskSettleVO;
import com.elitesland.tw.tw5.api.prd.task.payload.TaskSettleTimesheetPayload;
import com.elitesland.tw.tw5.api.prd.task.query.TaskInfoQuery;
import com.elitesland.tw.tw5.api.prd.task.query.TaskPackageQuery;
import com.elitesland.tw.tw5.api.prd.task.query.TaskSettleTimesheetQuery;
import com.elitesland.tw.tw5.api.prd.task.service.TaskInfoService;
import com.elitesland.tw.tw5.api.prd.task.service.TaskPackageService;
import com.elitesland.tw.tw5.api.prd.task.service.TaskSettleTimesheetService;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskInfoVO;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskPackageVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.permission.PermissionBeanSearcherFactory;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.util.DateUtil;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.cal.convert.CalTaskSettleConvert;
import com.elitesland.tw.tw5.server.prd.cal.dao.CalTaskSettleDAO;
import com.elitesland.tw.tw5.server.prd.cal.entity.CalTaskSettleDO;
import com.elitesland.tw.tw5.server.prd.cal.repo.CalTaskSettleRepo;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CalAccTypeEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CalSettleStatusEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CalTaskSettleTypeEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.TaskSourceTypeEnum;
import com.elitesland.tw.tw5.server.prd.task.common.PricingMethodEnum;
import com.elitesland.tw.tw5.server.prd.task.convert.TaskSettleTimesheetConvert;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.google.common.collect.Lists;
import com.xxl.job.core.log.XxlJobLogger;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class CalTaskSettleServiceImpl
extends BaseServiceImpl
implements CalTaskSettleService {
    private static final Logger log = LoggerFactory.getLogger(CalTaskSettleServiceImpl.class);
    private final CalTaskSettleRepo calTaskSettleRepo;
    private final CalTaskSettleDAO calTaskSettleDAO;
    private final CalTaskSettleDetailService calTaskSettleDetailService;
    private final CacheUtil cacheUtil;
    private final WorkflowUtil workflowUtil;
    private final TransactionUtilService transactionUtilService;
    private final CalResourceService calResourceService;
    private final TaskPackageService taskPackageService;
    private final TaskInfoService taskInfoService;
    private final FileUtil fileUtil;
    private final TaskSettleTimesheetService taskSettleTimesheetService;
    private BeanSearcher beanSearcher;

    @Autowired
    public void setBeanSearcher(PermissionBeanSearcherFactory permissionBeanSearcherFactory) {
        this.beanSearcher = permissionBeanSearcherFactory.getBeanSearcherService(PermissionDomainEnum.TASK_SETTLE);
    }

    @Transactional(rollbackFor={Exception.class})
    public void taskSettleJobHandler(List<Long> userIds) {
        log.info("\u5b9a\u65f6\u4efb\u52a1\u7ed3\u7b97\u5f00\u59cb\u3002\u3002\u3002\u3002\u3002");
        XxlJobLogger.log((String)("\u5b9a\u65f6\u4efb\u52a1\u7ed3\u7b97\u5f00\u59cb localDateTime\uff1a" + LocalDateTime.now()), (Object[])new Object[0]);
        TaskInfoQuery taskInfoQuery = new TaskInfoQuery();
        taskInfoQuery.setTaskStatuss(this.taskInfoService.getEffectiveTaskStatus());
        taskInfoQuery.setTaskResIds(userIds);
        List taskInfoVOS = this.taskInfoService.queryTaskSettleList(taskInfoQuery);
        if (!ObjectUtils.isEmpty((Object)taskInfoVOS)) {
            Map<Long, List<TaskInfoVO>> maps = taskInfoVOS.stream().collect(Collectors.groupingBy(TaskInfoVO::getTaskPackageId));
            TaskPackageQuery taskPackageQuery = new TaskPackageQuery();
            taskPackageQuery.setIds(new ArrayList<Long>(maps.keySet()));
            taskPackageQuery.setPricingMethod(PricingMethodEnum.SINGLE.getCode());
            List taskPackageVOS = this.taskPackageService.taskPackageList(taskPackageQuery);
            if (!ObjectUtils.isEmpty((Object)taskPackageVOS)) {
                List<CalTaskSettleDetailPayload> detailPayloads = this.taskAutoSettle(maps, taskPackageVOS, !ObjectUtils.isEmpty(userIds));
                HashMap<Long, Long> taskSettleIdMap = new HashMap<Long, Long>();
                detailPayloads.forEach(detailPayload -> {
                    this.taskInfoService.updateSettledEqva(detailPayload.getTaskId(), detailPayload.getApproveSettleEqva());
                    taskSettleIdMap.put(detailPayload.getTaskId(), detailPayload.getSettleId());
                });
                this.saveTaskTaskSettleTimesheet(taskSettleIdMap);
            }
        }
        log.info("\u5b9a\u65f6\u4efb\u52a1\u7ed3\u7b97\u7ed3\u675f....");
        XxlJobLogger.log((String)("\u5b9a\u65f6\u4efb\u52a1\u7ed3\u7b97\u7ed3\u675f localDateTime\uff1a" + LocalDateTime.now()), (Object[])new Object[0]);
    }

    public List<CalTaskSettleDetailPayload> taskAutoSettle(Map<Long, List<TaskInfoVO>> taskInfoMaps, List<TaskPackageVO> taskPackageVOS, Boolean isNew) {
        log.info("\u81ea\u52a8\u7ed3\u7b97\u6267\u884c\u5f00\u59cb....");
        LocalDate currentDate = isNew == false ? DateUtil.getMinusMonth(LocalDate.now()) : LocalDate.now();
        LocalDate lastMonthEndDate = currentDate;
        ArrayList<CalTaskSettlePayload> payloads = new ArrayList<CalTaskSettlePayload>();
        taskPackageVOS.forEach(taskPackageVO -> {
            List taskInfoVOS1 = (List)taskInfoMaps.get(taskPackageVO.getId());
            taskPackageVO.setTaskInfoVOS(taskInfoVOS1);
            CalTaskSettlePayload payload = new CalTaskSettlePayload();
            payload.setTaskId(taskPackageVO.getId());
            payload.setSettleDate(lastMonthEndDate);
            ArrayList detailPayloads = new ArrayList();
            taskInfoVOS1.forEach(taskInfoVO -> {
                BigDecimal usedEqva;
                BigDecimal settledEqva = taskInfoVO.getSettledEqva() == null ? BigDecimal.ZERO : taskInfoVO.getSettledEqva();
                BigDecimal approvedEqva = taskInfoVO.getApprovedEqva() == null ? BigDecimal.ZERO : taskInfoVO.getApprovedEqva();
                BigDecimal bigDecimal = usedEqva = taskInfoVO.getUsedEqva() == null ? BigDecimal.ZERO : taskInfoVO.getUsedEqva();
                if (approvedEqva.compareTo(usedEqva) > 0) {
                    approvedEqva = usedEqva;
                }
                BigDecimal applySettleEqva = approvedEqva.subtract(settledEqva);
                if (taskInfoVO.getTotalEqva().subtract(settledEqva).compareTo(applySettleEqva) < 0) {
                    applySettleEqva = taskInfoVO.getTotalEqva().subtract(settledEqva);
                }
                if (applySettleEqva.compareTo(BigDecimal.ZERO) > 0) {
                    CalTaskSettleDetailPayload payloadDetail = new CalTaskSettleDetailPayload();
                    payloadDetail.setTaskId(taskInfoVO.getId());
                    payloadDetail.setApplySettleEqva(applySettleEqva);
                    detailPayloads.add(payloadDetail);
                }
            });
            if (detailPayloads.size() > 0) {
                payload.setSettleDetailPayloads(detailPayloads);
                String code = this.generateSeqNum("CAL_TASK_SETTLE", new String[0]);
                payload.setSettleNo(code);
                payload.setSettleStatus(CalSettleStatusEnum.FINISH.getCode());
                this.initData(payload, (TaskPackageVO)taskPackageVO);
                payloads.add(payload);
            }
        });
        ArrayList<CalTaskSettleDetailPayload> detailPayloads = new ArrayList<CalTaskSettleDetailPayload>();
        if (payloads.size() > 0) {
            log.info("\u7ed3\u7b97\u5355\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(payloads));
            List<CalTaskSettleDO> calTaskSettleDOS = CalTaskSettleConvert.INSTANCE.toDos(payloads);
            List<CalTaskSettleDO> calTaskSettleDOS1 = this.calTaskSettleDAO.saveAll(calTaskSettleDOS);
            payloads.forEach(payload -> {
                CalTaskSettleDO calTaskSettleDO = calTaskSettleDOS1.stream().filter(settleDO -> settleDO.getTaskId().equals(payload.getTaskId())).findFirst().get();
                payload.setId(calTaskSettleDO.getId());
                payload.getSettleDetailPayloads().forEach(act -> act.setSettleId(calTaskSettleDO.getId()));
                detailPayloads.addAll(payload.getSettleDetailPayloads());
            });
            this.calTaskSettleDetailService.bacthInsert(detailPayloads);
            List<CalTaskSettleVO> calTaskSettleVOS = CalTaskSettleConvert.INSTANCE.toVos(payloads);
            this.calResourceService.taskSettleTurnover(calTaskSettleVOS);
            log.info("taskInfoVO::1" + detailPayloads.size());
        }
        log.info("\u4efb\u52a1\u81ea\u52a8\u7ed3\u7b97\u6267\u884c\u5b8c\u6bd5....");
        return detailPayloads;
    }

    public void saveTaskTaskSettleTimesheet(Map<Long, Long> taskSettleIdMap) {
        if (!taskSettleIdMap.isEmpty()) {
            TaskSettleTimesheetQuery query = new TaskSettleTimesheetQuery();
            query.setTaskIds(new ArrayList<Long>(taskSettleIdMap.keySet()));
            query.setSettleFlag(Integer.valueOf(0));
            List taskSettleTimesheetVOS = this.taskSettleTimesheetService.queryListDynamic(query);
            List<TaskSettleTimesheetPayload> taskSettleTimesheetPayloadS = TaskSettleTimesheetConvert.INSTANCE.toPayloads(taskSettleTimesheetVOS);
            taskSettleTimesheetPayloadS.forEach(timesheetPayload -> {
                if (timesheetPayload.getSettleId() == null) {
                    timesheetPayload.setSettleId((Long)taskSettleIdMap.get(timesheetPayload.getTaskId()));
                }
                timesheetPayload.setSettleFlag(Integer.valueOf(1));
            });
            this.taskSettleTimesheetService.batchInsert(taskSettleTimesheetPayloadS);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void reverseTaskSettle(String taskNo, BigDecimal eqvaNum, String message) {
        if (eqvaNum == null || eqvaNum.compareTo(BigDecimal.ZERO) >= 0) {
            throw TwException.error("", "\u53cd\u5411\u7ed3\u7b97\u6570\u636e\u4e0d\u5408\u89c4");
        }
        Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode()));
        if (!rolePermission.booleanValue()) {
            throw TwException.error("", "\u65e0\u64cd\u4f5c\u4efb\u52a1\u53cd\u5411\u7ed3\u7b97\u7684\u6743\u9650\uff01");
        }
        TaskInfoVO infoVO = this.taskInfoService.queryByTaskNo(taskNo);
        if (infoVO == null) {
            throw TwException.error("", "\u64cd\u4f5c\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        if (infoVO.getSettledEqva() == null) {
            throw TwException.error("", "\u8be5\u4efb\u52a1\u672a\u4ea7\u751f\u7ed3\u7b97\u6570\u636e\u4e0d\u53ef\u53cd\u5411\u7ed3\u7b97");
        }
        BigDecimal resEqva = infoVO.getSettledEqva().add(eqvaNum);
        if (resEqva.compareTo(BigDecimal.ZERO) < 0) {
            throw TwException.error("", "\u53cd\u5411\u7ed3\u7b97\u540e\u4efb\u52a1\u7ed3\u7b97\u5f53\u91cf\u4e3a\u8d1f\uff0c\u4e0d\u5408\u89c4");
        }
        TaskPackageQuery taskPackageQuery = new TaskPackageQuery();
        taskPackageQuery.setId(infoVO.getTaskPackageId());
        List taskPackageVOS = this.taskPackageService.taskPackageList(taskPackageQuery);
        if (ObjectUtils.isEmpty((Object)taskPackageVOS)) {
            throw TwException.error("", "\u5173\u8054\u4efb\u52a1\u5305\u6570\u636e\u4e0d\u5b58\u5728");
        }
        TaskPackageVO taskPackageVO = (TaskPackageVO)taskPackageVOS.get(0);
        taskPackageVO.setTaskInfoVOS(Arrays.asList(infoVO));
        CalTaskSettlePayload payload = new CalTaskSettlePayload();
        payload.setTaskId(infoVO.getTaskPackageId());
        payload.setSettleDate(LocalDate.now());
        CalTaskSettleDetailPayload payloadDetail = new CalTaskSettleDetailPayload();
        payloadDetail.setTaskId(infoVO.getId());
        payloadDetail.setApplySettleEqva(eqvaNum);
        List<CalTaskSettleDetailPayload> detailPayloads = Arrays.asList(payloadDetail);
        payload.setSettleDetailPayloads(detailPayloads);
        String code = this.generateSeqNum("CAL_TASK_SETTLE", new String[0]);
        payload.setSettleNo(code);
        payload.setSettleStatus(CalSettleStatusEnum.FINISH.getCode());
        String remark = "\u7cfb\u7edf\u7ba1\u7406\u5458\u53cd\u5411\u7ed3\u7b97\uff0c\u7ed3\u7b97\u5355\u5f02\u5e38\u7ea2\u51b2";
        if (StringUtils.hasText((String)message)) {
            remark = message;
        }
        payload.setRemark(remark);
        this.initData(payload, taskPackageVO);
        CalTaskSettleDO calTaskSettleDO = CalTaskSettleConvert.INSTANCE.toDo(payload);
        CalTaskSettleDO save = this.calTaskSettleDAO.save(calTaskSettleDO);
        payloadDetail.setSettleId(save.getId());
        this.calTaskSettleDetailService.bacthInsert(detailPayloads);
        CalTaskSettleVO calTaskSettleVO = CalTaskSettleConvert.INSTANCE.toVo(save);
        this.calResourceService.taskSettleTurnover(Arrays.asList(calTaskSettleVO));
        this.taskInfoService.updateSettledEqva(payloadDetail.getTaskId(), payloadDetail.getApproveSettleEqva());
    }

    @Transactional(rollbackFor={Exception.class})
    public CalTaskSettleVO insertOrUpdate(CalTaskSettlePayload payload) {
        TaskPackageVO taskPackageVO = this.checkData(payload);
        this.initData(payload, taskPackageVO);
        String auType = taskPackageVO.getReasonType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode()) ? CalAccTypeEnum.PROJ.getCode() : (taskPackageVO.getReasonType().equals(PmsReasonTypeEnum.PROJ_OPPO.getCode()) ? CalAccTypeEnum.OPP.getCode() : CalAccTypeEnum.BU_PROJ.getCode());
        CalAccountVO calAccountVO = this.calResourceService.queryAccount(auType, taskPackageVO.getReasonId());
        this.checkAccount(payload, calAccountVO);
        CalAccountVO calAccountVO1 = this.calResourceService.queryAccount(CalAccTypeEnum.RES.getCode(), taskPackageVO.getReceiverResId());
        String procInstId = null;
        if (payload.getId() == null) {
            String code = this.generateSeqNum("CAL_TASK_SETTLE", new String[0]);
            payload.setSettleNo(code);
        } else {
            CalTaskSettleVO calTaskSettleVO = this.calTaskSettleDAO.queryByKey(payload.getId());
            if (calTaskSettleVO == null) {
                throw TwException.error("", "\u7f16\u8f91\u6570\u636e\u4e0d\u5b58\u5728");
            }
            if (!calTaskSettleVO.getSettleStatus().equals(CalSettleStatusEnum.CREATE.getCode()) && !calTaskSettleVO.getSettleStatus().equals(CalSettleStatusEnum.REJECTED.getCode())) {
                throw TwException.error("", "\u4e0d\u652f\u6301\u6570\u636e\u4fee\u6539");
            }
            procInstId = calTaskSettleVO.getProcInstId();
            payload.setProcInstId(calTaskSettleVO.getProcInstId());
            payload.setCreateTime(calTaskSettleVO.getCreateTime());
        }
        payload.setSettleStatus(CalSettleStatusEnum.IN_PROCESS.getCode());
        payload.setApplyResId(GlobalUtil.getLoginUserId());
        CalTaskSettleDO entityDo = CalTaskSettleConvert.INSTANCE.toDo(payload);
        CalTaskSettleDO save = (CalTaskSettleDO)this.calTaskSettleRepo.save(entityDo);
        if (payload.getId() != null) {
            this.calTaskSettleDetailService.deleteSoftBySettleId(List.of(payload.getId()));
        }
        payload.getSettleDetailPayloads().forEach(act -> act.setSettleId(save.getId()));
        this.calTaskSettleDetailService.bacthInsert(payload.getSettleDetailPayloads());
        if (procInstId == null) {
            HashMap<String, ArrayList> batchMap = new HashMap<String, ArrayList>();
            batchMap.put("Activity_0joomyk", Lists.newArrayList((Object[])new Long[]{taskPackageVO.getAcceptorId()}));
            String procName = "S01." + payload.getTaskName() + "-\u5f53\u91cf\u7ed3\u7b97\u7533\u8bf7\uff08" + this.cacheUtil.getUserName(payload.getIncomeResId()) + "\uff09";
            ProcessInfo processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)"CAL_TASK_SETTLE", (String)procName, (String)("" + entityDo.getId()), batchMap), new Long[0]);
            procInstId = processInfo.getProcInstId();
            String apprStatus = processInfo.getProcInstStatus().name();
            String settleStatus = CalSettleStatusEnum.IN_PROCESS.getCode();
            if (apprStatus.equals(ProcInstStatus.APPROVED.name())) {
                settleStatus = CalSettleStatusEnum.FINISH.getCode();
                procInstId = null;
            }
            CalTaskSettlePayload payload0 = new CalTaskSettlePayload();
            payload0.setId(entityDo.getId());
            payload0.setProcInstId(procInstId);
            payload0.setApprStatus(apprStatus);
            payload0.setSettleStatus(settleStatus);
            payload.setNullFields(List.of("procInstId"));
            this.transactionUtilService.executeWithRunnable(() -> this.calTaskSettleDAO.updateByKeyDynamic(payload0));
        }
        return CalTaskSettleConvert.INSTANCE.toVo(entityDo);
    }

    TaskPackageVO checkData(CalTaskSettlePayload payload) {
        if (payload.getTaskId() == null) {
            throw TwException.error("", "\u4efb\u52a1\u5305\u6570\u636e\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (payload.getSettleDate() == null) {
            throw TwException.error("", "\u7ed3\u7b97\u671f\u95f4\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)payload.getSettleDetailPayloads())) {
            throw TwException.error("", "\u7ed3\u7b97\u660e\u7ec6\u4e0d\u53ef\u4e3a\u7a7a");
        }
        List taskIds = payload.getSettleDetailPayloads().stream().map(CalTaskSettleDetailPayload::getTaskId).distinct().collect(Collectors.toList());
        if (taskIds.size() != payload.getSettleDetailPayloads().size()) {
            throw TwException.error("", "\u7ed3\u7b97\u660e\u7ec6\u4efb\u52a1id\u4e0d\u53ef\u4e3a\u7a7a");
        }
        List collect = payload.getSettleDetailPayloads().stream().filter(payloadDetail -> payloadDetail.getApplySettleEqva() == null || payloadDetail.getApplySettleEqva().compareTo(BigDecimal.ZERO) <= 0).collect(Collectors.toList());
        if (!ObjectUtils.isEmpty(collect)) {
            throw TwException.error("", "\u7533\u8bf7\u7ed3\u7b97\u5f53\u91cf\u4e0d\u5408\u89c4");
        }
        CalTaskSettleQuery query = new CalTaskSettleQuery();
        query.setTaskId(payload.getTaskId());
        query.setSettleStatus(CalSettleStatusEnum.IN_PROCESS.getCode());
        List<CalTaskSettleVO> calTaskSettleVOS = this.calTaskSettleDAO.queryListDynamic(query);
        if (!ObjectUtils.isEmpty(calTaskSettleVOS)) {
            CalTaskSettleVO calTaskSettleVO = calTaskSettleVOS.get(0);
            CalTaskSettleDetailQuery queryDetail = new CalTaskSettleDetailQuery();
            queryDetail.setSettleId(calTaskSettleVO.getId());
            List calTaskSettleDetailVOS = this.calTaskSettleDetailService.queryListDynamic(queryDetail);
            calTaskSettleDetailVOS.forEach(detailVO -> {
                if (taskIds.contains(detailVO.getTaskId())) {
                    throw TwException.error("", "\u7ed3\u7b97\u660e\u7ec6\u4efb\u52a1\u3010" + detailVO.getTaskName() + "\u3011\u5904\u4e8e\u7ed3\u7b97\u4e2d\uff0c\u7ed3\u7b97\u5355\u53f7\u3010" + calTaskSettleVO.getSettleNo() + "\u3011,\u4e0d\u53ef\u518d\u6b21\u53d1\u8d77\u7533\u8bf7");
                }
            });
        }
        TaskPackageVO taskPackageVO = this.taskPackageService.queryByKey(payload.getTaskId(), Boolean.valueOf(true));
        log.info("\u4efb\u52a1\u5305\u6570\u636e\uff1a{}" + taskPackageVO.toString());
        if (taskPackageVO == null) {
            throw TwException.error("", "\u7ed3\u7b97\u4efb\u52a1\u5305\u4e0d\u5b58\u5728");
        }
        if (!taskPackageVO.getPricingMethod().equals(PricingMethodEnum.TOTAL.getCode())) {
            throw TwException.error("", "\u4ec5\u652f\u6301\u603b\u4ef7\u7ed3\u7b97");
        }
        Long loginUserId = GlobalUtil.getLoginUserId();
        if (taskPackageVO.getReceiverResId() == null || !taskPackageVO.getReceiverResId().equals(loginUserId)) {
            throw TwException.error("", "\u4efb\u52a1\u5305\u63a5\u6536\u4eba\u53ef\u53d1\u8d77\u7ed3\u7b97\u7533\u8bf7");
        }
        if (taskPackageVO.getDisterResId() == null) {
            throw TwException.error("", "\u4efb\u52a1\u5305\u53d1\u5305\u4eba\u4e0d\u53ef\u4e3a\u7a7a");
        }
        List taskInfoVOS = taskPackageVO.getTaskInfoVOS();
        List settleTaskVOS = taskInfoVOS.stream().filter(vo -> taskIds.contains(vo.getId())).collect(Collectors.toList());
        if (settleTaskVOS.size() != taskIds.size()) {
            throw TwException.error("", "\u7ed3\u7b97\u660e\u7ec6\u4efb\u52a1\u5b58\u5728\u975e\u8be5\u4efb\u52a1\u5305\u4e0b\u6570\u636e");
        }
        return taskPackageVO;
    }

    void initData(CalTaskSettlePayload payload, TaskPackageVO taskPackageVO) {
        if (taskPackageVO.getIncomePrice() == null || taskPackageVO.getSettlePrice() == null) {
            throw TwException.error("", "\u4efb\u52a1\u5305\u7ed3\u7b97\u4ef7\u6216\u6536\u5165\u4ef7\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (taskPackageVO.getReceiverBuId() == null || taskPackageVO.getReceiverResId() == null) {
            throw TwException.error("", "\u4efb\u52a1\u5305\u63a5\u6536\u8d44\u6e90\u6216\u63a5\u6536\u8d44\u6e90BU\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)taskPackageVO.getReasonType()) || taskPackageVO.getReasonId() == null) {
            throw TwException.error("", "\u4efb\u52a1\u5305\u4e8b\u7531\u7c7b\u578b\u548c\u4e8b\u7531id\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (taskPackageVO.getGuaranteeRate() != null && (taskPackageVO.getGuaranteeRate().compareTo(BigDecimal.ZERO) < 0 || taskPackageVO.getGuaranteeRate().compareTo(BigDecimal.ONE) >= 0)) {
            throw TwException.error("", "\u8d28\u4fdd\u6bd4\u4f8b\u8303\u56f4\u4e3a\u30100-100\u3011");
        }
        payload.setSettlePrice(taskPackageVO.getSettlePrice());
        payload.setEqvaSalary(taskPackageVO.getIncomePrice());
        payload.setIncomeResId(taskPackageVO.getReceiverResId());
        payload.setResBuId(taskPackageVO.getReceiverBuId());
        payload.setDisterResId(taskPackageVO.getDisterResId());
        payload.setReasonType(taskPackageVO.getReasonType());
        payload.setProjId(taskPackageVO.getReasonId());
        payload.setProjName(taskPackageVO.getReasonName());
        payload.setGuaranteeRate(taskPackageVO.getGuaranteeRate());
        payload.setTaskName(taskPackageVO.getTaskPackageName());
        payload.setOperateFlag(Integer.valueOf(0));
        String settleType = taskPackageVO.getPricingMethod().equals(PricingMethodEnum.TOTAL.getCode()) ? CalTaskSettleTypeEnum.TOTAL_PRICE.getCode() : CalTaskSettleTypeEnum.UNIT_PRICE.getCode();
        payload.setSettleType(settleType);
        BigDecimal applySettleEqva = BigDecimal.ZERO;
        for (CalTaskSettleDetailPayload detail : payload.getSettleDetailPayloads()) {
            Optional<TaskInfoVO> first = taskPackageVO.getTaskInfoVOS().stream().filter(vo -> vo.getId().equals(detail.getTaskId())).findFirst();
            if (!first.isPresent()) {
                throw TwException.error("", "\u7ed3\u7b97\u660e\u7ec6\u4efb\u52a1\u4e0d\u5b58\u5728");
            }
            TaskInfoVO taskInfoVO = first.get();
            if (!(StringUtils.hasText((String)taskInfoVO.getSourceType()) && taskInfoVO.getSourceType().equals(TaskSourceTypeEnum.REWARD.getCode()) || this.taskInfoService.getEffectiveTaskStatus().contains(taskInfoVO.getTaskStatus()))) {
                throw TwException.error("", taskInfoVO.getTaskName() + "-\u4e0d\u53ef\u53d1\u8d77\u7ed3\u7b97");
            }
            detail.setDistedEqva(taskInfoVO.getTotalEqva());
            detail.setSettledEqva(taskInfoVO.getSettledEqva());
            detail.setTaskStatus(taskInfoVO.getTaskStatus());
            detail.setTaskName(taskInfoVO.getTaskName());
            detail.setProjId(payload.getProjId());
            detail.setPlanStartDate(taskInfoVO.getPlanStartDate());
            detail.setPlanEndDate(taskInfoVO.getPlanEndDate());
            detail.setSsCompPercent(taskInfoVO.getTaskProgress());
            BigDecimal subtract = detail.getDistedEqva().subtract(detail.getSettledEqva() == null ? BigDecimal.ZERO : detail.getSettledEqva());
            if (detail.getApplySettleEqva() == null || subtract.subtract(detail.getApplySettleEqva()).compareTo(BigDecimal.ZERO) < 0) {
                throw TwException.error("", "\u7ed3\u7b97\u660e\u7ec6-\u7533\u8bf7\u7ed3\u7b97\u5f53\u91cf[0, " + subtract + "]");
            }
            applySettleEqva = applySettleEqva.add(detail.getApplySettleEqva());
            detail.setApplySettleAmt(detail.getApplySettleEqva().multiply(payload.getSettlePrice()));
            detail.setApproveSettleEqva(detail.getApplySettleEqva());
            detail.setApproveSettleAmt(detail.getApproveSettleEqva().multiply(payload.getSettlePrice()));
        }
        BigDecimal applySettleAmt = applySettleEqva.multiply(payload.getSettlePrice());
        BigDecimal applyIncomeAmt = applySettleEqva.multiply(payload.getEqvaSalary());
        BigDecimal graranteeEqva = applySettleEqva.multiply(payload.getGuaranteeRate());
        BigDecimal graranteeAmt = graranteeEqva.multiply(payload.getEqvaSalary());
        payload.setApplySettleEqva(applySettleEqva);
        payload.setApplySettleAmt(applySettleAmt);
        payload.setApplyIncomeAmt(applyIncomeAmt);
        payload.setApproveSettleEqva(applySettleEqva);
        payload.setApproveSettleAmt(applySettleAmt);
        payload.setApproveIncomeAmt(applyIncomeAmt);
        payload.setGraranteeEqva(graranteeEqva);
        payload.setGraranteeAmt(graranteeAmt);
        payload.setAvalQty(applySettleEqva.subtract(graranteeEqva));
        log.info("\u521d\u59cb\u5316\u540e\u7684\u7ed3\u7b97\u7533\u8bf7payload\uff1a{}", (Object)payload.toString());
    }

    void checkAccount(CalTaskSettlePayload payload, CalAccountVO calAccountVO) {
        BigDecimal avalQty = calAccountVO.getAvalQty() == null ? BigDecimal.ZERO : calAccountVO.getAvalQty();
        BigDecimal avalAmt = calAccountVO.getAvalAmt() == null ? BigDecimal.ZERO : calAccountVO.getAvalAmt();
        calAccountVO.setAvalQty(avalQty.subtract(payload.getApplySettleEqva()));
        calAccountVO.setAvalAmt(avalAmt.subtract(payload.getApplySettleAmt()));
        this.calResourceService.checkAccount(calAccountVO);
    }

    public PagingVO<CalTaskSettleVO> queryPaging(CalTaskSettleQuery query) {
        MapBuilder mapBuilder;
        Number totalNum;
        long total;
        Long loginUserId = GlobalUtil.getLoginUserId();
        if (query.getSearchType() != null && query.getSearchType() == 1) {
            query.setIncomeResId(loginUserId);
            query.setSettleStatus(CalSettleStatusEnum.FINISH.getCode());
        }
        if ((total = ((Long)(totalNum = this.beanSearcher.searchCount(CalTaskSettleVO.class, (mapBuilder = this.pageWhereBuilder(query)).build()))).longValue()) == 0L) {
            return PagingVO.empty();
        }
        List calTaskSettleVOS = this.beanSearcher.searchList(CalTaskSettleVO.class, mapBuilder.build());
        calTaskSettleVOS.forEach(vo -> vo.setAvalAmt(vo.getAvalQty().multiply(vo.getEqvaSalary())));
        return PagingVO.builder().records(calTaskSettleVOS).total(total).build();
    }

    private MapBuilder pageWhereBuilder(CalTaskSettleQuery query) {
        MapBuilder builder = MapUtils.builder();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            ((MapBuilder)builder.field(CalTaskSettleVO::getId, new Object[]{query.getId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getSettleNo())) {
            ((MapBuilder)builder.field(CalTaskSettleVO::getSettleNo, new Object[]{query.getSettleNo()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getSettleStatus())) {
            ((MapBuilder)builder.field(CalTaskSettleVO::getSettleStatus, new Object[]{query.getSettleStatus()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getSettleStatusList())) {
            ((MapBuilder)builder.field(CalTaskSettleVO::getSettleStatus, (Collection)query.getSettleStatusList())).op((FieldOp)FieldOps.InList);
        }
        if (!ObjectUtils.isEmpty((Object)query.getApprStatus())) {
            ((MapBuilder)builder.field(CalTaskSettleVO::getApprStatus, new Object[]{query.getApprStatus()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getProcInstId())) {
            ((MapBuilder)builder.field(CalTaskSettleVO::getProcInstId, new Object[]{query.getProcInstId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getSettleType())) {
            ((MapBuilder)builder.field(CalTaskSettleVO::getSettleType, new Object[]{query.getSettleType()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getSettleDate())) {
            ((MapBuilder)builder.field(CalTaskSettleVO::getSettleDate, new Object[]{query.getSettleDate()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getSettleStartDate()) && !ObjectUtils.isEmpty((Object)query.getSettleEndDate())) {
            ((MapBuilder)builder.field(CalTaskSettleVO::getSettleDate, new FieldFns.FieldFn[0])).sql(" $1 >= ? and $1 <= ?", new Object[]{query.getSettleStartDate(), query.getSettleEndDate()});
        } else {
            if (!ObjectUtils.isEmpty((Object)query.getSettleStartDate())) {
                ((MapBuilder)builder.field(CalTaskSettleVO::getSettleDate, new Object[]{query.getSettleStartDate()})).op((FieldOp)FieldOps.GreaterEqual);
            }
            if (!ObjectUtils.isEmpty((Object)query.getSettleEndDate())) {
                ((MapBuilder)builder.field(CalTaskSettleVO::getSettleDate, new Object[]{query.getSettleEndDate()})).op((FieldOp)FieldOps.LessEqual);
            }
        }
        if (!ObjectUtils.isEmpty((Object)query.getFinPeriodId())) {
            ((MapBuilder)builder.field(CalTaskSettleVO::getFinPeriodId, new Object[]{query.getFinPeriodId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getAcceptMethod())) {
            ((MapBuilder)builder.field(CalTaskSettleVO::getAcceptMethod, new Object[]{query.getAcceptMethod()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjId())) {
            ((MapBuilder)builder.field(CalTaskSettleVO::getProjId, new Object[]{query.getProjId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getTaskId())) {
            ((MapBuilder)builder.field(CalTaskSettleVO::getTaskId, new Object[]{query.getTaskId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getExpenseBuId())) {
            ((MapBuilder)builder.field(CalTaskSettleVO::getExpenseBuId, new Object[]{query.getExpenseBuId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getIncomeResId())) {
            ((MapBuilder)builder.field(CalTaskSettleVO::getIncomeResId, new Object[]{query.getIncomeResId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getResBuId())) {
            ((MapBuilder)builder.field(CalTaskSettleVO::getResBuId, new Object[]{query.getResBuId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getEqvaRatio())) {
            ((MapBuilder)builder.field(CalTaskSettleVO::getEqvaRatio, new Object[]{query.getEqvaRatio()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getEqvaSalary())) {
            ((MapBuilder)builder.field(CalTaskSettleVO::getEqvaSalary, new Object[]{query.getEqvaSalary()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getApplySettleEqva())) {
            ((MapBuilder)builder.field(CalTaskSettleVO::getApplySettleEqva, new Object[]{query.getApplySettleEqva()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getApplySettleAmt())) {
            ((MapBuilder)builder.field(CalTaskSettleVO::getApplySettleAmt, new Object[]{query.getApplySettleAmt()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getSettlePrice())) {
            ((MapBuilder)builder.field(CalTaskSettleVO::getSettlePrice, new Object[]{query.getSettlePrice()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getApproveSettleEqva())) {
            ((MapBuilder)builder.field(CalTaskSettleVO::getApproveSettleEqva, new Object[]{query.getApproveSettleEqva()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getApproveSettleAmt())) {
            ((MapBuilder)builder.field(CalTaskSettleVO::getApproveSettleAmt, new Object[]{query.getApproveSettleAmt()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getCurrCode())) {
            ((MapBuilder)builder.field(CalTaskSettleVO::getCurrCode, new Object[]{query.getCurrCode()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getGuaranteeRate())) {
            ((MapBuilder)builder.field(CalTaskSettleVO::getGuaranteeRate, new Object[]{query.getGuaranteeRate()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getGraranteeEqva())) {
            ((MapBuilder)builder.field(CalTaskSettleVO::getGraranteeEqva, new Object[]{query.getGraranteeEqva()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getApplyResId())) {
            ((MapBuilder)builder.field(CalTaskSettleVO::getApplyResId, new Object[]{query.getApplyResId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getEvalStatus())) {
            ((MapBuilder)builder.field(CalTaskSettleVO::getEvalStatus, new Object[]{query.getEvalStatus()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getWithdrawEqva())) {
            ((MapBuilder)builder.field(CalTaskSettleVO::getWithdrawEqva, new Object[]{query.getWithdrawEqva()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getBuWithdrawEqva())) {
            ((MapBuilder)builder.field(CalTaskSettleVO::getBuWithdrawEqva, new Object[]{query.getBuWithdrawEqva()})).op((FieldOp)FieldOps.Equal);
        }
        if (query.getSearchType() != null && query.getSearchType() == 1) {
            ((MapBuilder)builder.field(CalTaskSettleVO::getAvalQty, new Object[]{BigDecimal.ZERO})).op((FieldOp)FieldOps.GreaterThan);
            ((MapBuilder)builder.field(CalTaskSettleVO::getOperateFlag, new Object[]{0})).op((FieldOp)FieldOps.Equal);
        }
        SqlUtil.handleBS(builder, (TwQueryParam)query);
        return builder;
    }

    public List<CalTaskSettleVO> queryListDynamic(CalTaskSettleQuery query) {
        List<CalTaskSettleVO> calTaskSettleVOS = this.calTaskSettleDAO.queryListDynamic(query);
        calTaskSettleVOS.forEach(vo -> {
            if (vo.getAvalQty() == null || vo.getEqvaSalary() == null) {
                vo.setAvalAmt(BigDecimal.ZERO);
            } else {
                vo.setAvalAmt(vo.getAvalQty().multiply(vo.getEqvaSalary()));
            }
        });
        return calTaskSettleVOS;
    }

    public CalTaskSettleVO queryByKey(Long key) {
        CalTaskSettleVO calTaskSettleVO = this.calTaskSettleDAO.queryByKey(key);
        calTaskSettleVO.setFileDatas(this.fileUtil.getFileDatas(calTaskSettleVO.getFileCodes()));
        CalTaskSettleDetailQuery query = new CalTaskSettleDetailQuery();
        query.setSettleId(calTaskSettleVO.getId());
        List calTaskSettleDetailVOS = this.calTaskSettleDetailService.queryListDynamic(query);
        calTaskSettleVO.setSettleDetailVOs(calTaskSettleDetailVOS);
        calTaskSettleVO.setAvalAmt(calTaskSettleVO.getAvalQty().multiply(calTaskSettleVO.getEqvaSalary()));
        return calTaskSettleVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateFlow(CalTaskSettlePayload payload) {
        if (payload.getId() == null) {
            throw TwException.error("", "\u7f16\u8f91\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (ObjectUtils.isEmpty((Object)payload.getSettleDetailPayloads())) {
            throw TwException.error("", "\u7ed3\u7b97\u660e\u7ec6\u4e0d\u53ef\u4e3a\u7a7a");
        }
        CalTaskSettleVO calTaskSettleVO = this.queryByKey(payload.getId());
        if (calTaskSettleVO == null) {
            throw TwException.error("", "\u7f16\u8f91\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (!calTaskSettleVO.getSettleStatus().equals(CalSettleStatusEnum.IN_PROCESS.getCode())) {
            throw TwException.error("", "\u4e0d\u652f\u6301\u7684\u72b6\u6001\u4fee\u6539");
        }
        List settleDetailVOs = calTaskSettleVO.getSettleDetailVOs();
        BigDecimal approveSettleEqva = BigDecimal.ZERO;
        ArrayList<CalTaskSettleDetailPayload> detailPayloads = new ArrayList<CalTaskSettleDetailPayload>();
        for (CalTaskSettleDetailPayload detail : payload.getSettleDetailPayloads()) {
            Optional<CalTaskSettleDetailVO> first = settleDetailVOs.stream().filter(vo -> vo.getId().equals(detail.getId())).findFirst();
            if (!first.isPresent()) {
                throw TwException.error("", "\u53d8\u66f4\u7ed3\u7b97\u660e\u7ec6\u4e0d\u5b58\u5728");
            }
            CalTaskSettleDetailVO calTaskSettleDetailVO = first.get();
            if (detail.getApproveSettleEqva().compareTo(calTaskSettleDetailVO.getApplySettleEqva()) > 0) {
                throw TwException.error("", "\u6279\u51c6\u7ed3\u7b97\u5f53\u91cf\u4e0d\u53ef\u5927\u4e8e\u7533\u8bf7\u7ed3\u7b97\u5f53\u91cf");
            }
            approveSettleEqva = approveSettleEqva.add(detail.getApproveSettleEqva());
            if (detail.getApproveSettleEqva().equals(calTaskSettleDetailVO.getApplySettleEqva())) continue;
            CalTaskSettleDetailPayload detailPayload = new CalTaskSettleDetailPayload();
            detailPayload.setId(detail.getId());
            detailPayload.setApproveSettleEqva(detail.getApproveSettleEqva());
            detailPayload.setApproveSettleAmt(detail.getApproveSettleEqva().multiply(calTaskSettleVO.getSettlePrice()));
            detailPayloads.add(detailPayload);
        }
        BigDecimal approveSettleAmt = approveSettleEqva.multiply(calTaskSettleVO.getSettlePrice());
        BigDecimal approveIncomeAmt = approveSettleEqva.multiply(calTaskSettleVO.getEqvaSalary());
        BigDecimal graranteeEqva = approveSettleEqva.multiply(calTaskSettleVO.getGuaranteeRate());
        BigDecimal graranteeAmt = graranteeEqva.multiply(calTaskSettleVO.getEqvaSalary());
        CalTaskSettlePayload payload0 = new CalTaskSettlePayload();
        payload0.setId(payload.getId());
        payload0.setApproveSettleEqva(approveSettleEqva);
        payload0.setApproveSettleAmt(approveSettleAmt);
        payload0.setApproveIncomeAmt(approveIncomeAmt);
        payload0.setGraranteeEqva(graranteeEqva);
        payload0.setGraranteeAmt(graranteeAmt);
        payload0.setAvalQty(approveSettleEqva.subtract(graranteeEqva));
        payload0.setRemark(payload.getRemark());
        this.updateByKeyDynamic(payload0);
        if (detailPayloads.size() > 0) {
            this.transactionUtilService.executeWithRunnable(() -> detailPayloads.forEach(detail -> this.calTaskSettleDetailService.updateByKeyDynamic(detail)));
        }
        return 0L;
    }

    public long updateByKeyDynamic(CalTaskSettlePayload payload) {
        long result = this.calTaskSettleDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            List collect;
            List<CalTaskSettleVO> calTaskSettleVOs = this.calTaskSettleDAO.queryByKeys(keys);
            if (calTaskSettleVOs.size() > 0 && (collect = calTaskSettleVOs.stream().filter(vo -> !vo.getSettleStatus().equals(CalSettleStatusEnum.CREATE.getCode()) && !vo.getSettleStatus().equals(CalSettleStatusEnum.REJECTED.getCode())).collect(Collectors.toList())).size() > 0) {
                throw TwException.error("", "\u4ec5\u652f\u6301\u65b0\u5efa\u6216\u7ed3\u7b97\u672a\u901a\u8fc7\u72b6\u6001\u5220\u9664");
            }
            this.calTaskSettleDAO.deleteSoft(keys);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void processStatusChange(ProcessStatusChangePayload payload) {
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        CalTaskSettleVO calTaskSettleVO = this.calTaskSettleDAO.queryByKey(Long.valueOf(businessKey));
        if (calTaskSettleVO != null) {
            CalTaskSettlePayload taskSettlePayload = new CalTaskSettlePayload();
            taskSettlePayload.setId(Long.valueOf(Long.parseLong(businessKey)));
            taskSettlePayload.setApprStatus(procInstStatus.name());
            boolean rejectType = false;
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    taskSettlePayload.setSettleStatus(CalSettleStatusEnum.CREATE.getCode());
                    break;
                }
                case INTERRUPT: {
                    taskSettlePayload.setProcInstId(null);
                    taskSettlePayload.setNullFields(List.of("procInstId"));
                    taskSettlePayload.setSettleStatus(CalSettleStatusEnum.CREATE.getCode());
                    break;
                }
                case INVALID: {
                    taskSettlePayload.setDeleteFlag(Integer.valueOf(1));
                    taskSettlePayload.setSettleStatus(CalSettleStatusEnum.CREATE.getCode());
                    break;
                }
                case REJECTED: {
                    taskSettlePayload.setSettleStatus(CalSettleStatusEnum.REJECTED.getCode());
                    break;
                }
                case APPROVED: {
                    taskSettlePayload.setSettleStatus(CalSettleStatusEnum.FINISH.getCode());
                    break;
                }
                case APPROVING: {
                    taskSettlePayload.setSettleStatus(CalSettleStatusEnum.IN_PROCESS.getCode());
                }
            }
            this.updateByKeyDynamic(taskSettlePayload);
            if (taskSettlePayload.getSettleStatus().equals(CalSettleStatusEnum.FINISH.getCode())) {
                this.calResourceService.taskSettleTurnover(Arrays.asList(calTaskSettleVO));
                this.updateTaskSettleEqva(calTaskSettleVO.getId());
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateSettleDate(List<Long> keys, LocalDate settleDate) {
        if (keys.isEmpty()) {
            throw TwException.error("", "\u53d8\u66f4\u4e3b\u952e\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (settleDate == null) {
            throw TwException.error("", "\u53d8\u66f4\u671f\u95f4\u4e0d\u53ef\u4e3a\u7a7a");
        }
        List<CalTaskSettleVO> calTaskSettleVOs = this.calTaskSettleDAO.queryByKeys(keys);
        if (ObjectUtils.isEmpty(calTaskSettleVOs)) {
            throw TwException.error("", "\u53d8\u66f4\u6570\u636e\u4e0d\u5b58\u5728");
        }
        List collect = calTaskSettleVOs.stream().filter(vo -> !vo.getSettleStatus().equals(CalSettleStatusEnum.CREATE.getCode()) && !vo.getSettleStatus().equals(CalSettleStatusEnum.REJECTED.getCode())).collect(Collectors.toList());
        if (collect.size() > 0) {
            throw TwException.error("", "\u4ec5\u652f\u6301\u65b0\u5efa\u6216\u7ed3\u7b97\u672a\u901a\u8fc7\u72b6\u6001\u53d8\u66f4");
        }
        this.calTaskSettleDAO.updateSettleDate(keys, settleDate);
    }

    @Transactional(rollbackFor={Exception.class})
    public void taskSettleWithdraw(CalTaskSettleWithdrawPayload payload) {
        List<CalTaskSettleVO> calTaskSettleVOs = this.checkWithdraw(payload);
        if (payload.getWithdrawStatus().equals("1")) {
            this.calTaskSettleDAO.updateSettleOperate(payload.getSettleIds(), 2);
        }
        if (payload.getWithdrawStatus().equals("2")) {
            calTaskSettleVOs.forEach(vo -> {
                BigDecimal bigDecimal = vo.getWithdrawEqva() == null ? BigDecimal.ZERO : vo.getWithdrawEqva();
                BigDecimal withdrawEqva = bigDecimal.add(vo.getAvalQty());
                CalTaskSettlePayload taskSettlePayload = new CalTaskSettlePayload();
                taskSettlePayload.setId(vo.getId());
                taskSettlePayload.setOperateFlag(Integer.valueOf(0));
                taskSettlePayload.setWithdrawEqva(withdrawEqva);
                taskSettlePayload.setAvalQty(BigDecimal.ZERO);
                this.updateByKeyDynamic(taskSettlePayload);
            });
            this.calResourceService.taskSettleWithdrawTurnover(payload);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void unFreezeTaskSettleApply(List<Long> keys) {
        List<CalTaskSettleVO> calTaskSettleVOs = this.calTaskSettleDAO.queryByKeys(keys);
        if (calTaskSettleVOs.size() != keys.size()) {
            throw TwException.error("", "\u89e3\u51bb\u6570\u636e\u5339\u914d\u5f02\u5e38");
        }
        calTaskSettleVOs.forEach(vo -> {
            BigDecimal graranteeEqva = vo.getGraranteeEqva() == null ? BigDecimal.ZERO : vo.getGraranteeEqva();
            BigDecimal avalQty = graranteeEqva.add(vo.getAvalQty());
            CalTaskSettlePayload taskSettlePayload = new CalTaskSettlePayload();
            taskSettlePayload.setId(vo.getId());
            taskSettlePayload.setOperateFlag(Integer.valueOf(0));
            taskSettlePayload.setGraranteeEqva(BigDecimal.ZERO);
            taskSettlePayload.setGraranteeAmt(BigDecimal.ZERO);
            taskSettlePayload.setAvalQty(avalQty);
            this.updateByKeyDynamic(taskSettlePayload);
        });
        this.calResourceService.unFreezeTaskSettle(calTaskSettleVOs);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    List<CalTaskSettleVO> checkWithdraw(CalTaskSettleWithdrawPayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getSettleIds())) {
            throw TwException.error("", "\u63d0\u73b0\u5355\u636eids\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (payload.getWithdrawResId() == null) {
            throw TwException.error("", "\u63d0\u73b0\u8d44\u6e90id\u4e0d\u53ef\u4e3a\u7a7a");
        }
        List<CalTaskSettleVO> calTaskSettleVOs = this.calTaskSettleDAO.queryByKeys(payload.getSettleIds());
        if (calTaskSettleVOs.size() != payload.getSettleIds().size()) {
            throw TwException.error("", "\u63d0\u73b0\u5355\u636e\u6570\u636e\u5339\u914d\u5f02\u5e38");
        }
        if (payload.getWithdrawQty() == null) {
            throw TwException.error("", "\u63d0\u73b0\u5f53\u91cf\u6570\u636e\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (payload.getWithdrawAmt() == null) {
            throw TwException.error("", "\u63d0\u73b0\u91d1\u989d\u6570\u636e\u4e0d\u53ef\u4e3a\u7a7a");
        }
        BigDecimal avalQty = BigDecimal.ZERO;
        int settleType = 0;
        Long projectId = null;
        for (CalTaskSettleVO vo : calTaskSettleVOs) {
            if (vo.getAvalQty() == null || vo.getAvalQty().compareTo(BigDecimal.ZERO) <= 0) {
                throw TwException.error("", "\u53ef\u63d0\u73b0\u5f53\u91cf\u6821\u9a8c\u4e0d\u901a\u8fc7");
            }
            if (vo.getIncomeResId() != null && !vo.getIncomeResId().equals(payload.getWithdrawResId())) {
                throw TwException.error("", "\u63d0\u73b0\u8d44\u6e90\u4e0e\u7ed3\u7b97\u5355\u6536\u5165\u8d44\u6e90\u4e0d\u5339\u914d");
            }
            vo.setIncomeResId(payload.getWithdrawResId());
            if (vo.getEqvaSalary() == null || vo.getEqvaSalary().compareTo(BigDecimal.ZERO) <= 0) {
                if (settleType != 0 && settleType != true) throw TwException.error("", "\u7ed3\u7b97\u5355\u7ed3\u7b97\u65b9\u5f0f\u7c7b\u578b\u4e0d\u5339\u914d");
                settleType = 1;
                if (projectId == null) {
                    projectId = vo.getProjId();
                } else if (projectId.longValue() != vo.getProjId().longValue()) {
                    throw TwException.error("", "\u6708\u7ed3\u63d0\u73b0\u5355\u636e\u7ed3\u7b97\u5355\u5fc5\u987b\u662f\u540c\u9879\u76ee\u4e0b");
                }
            } else {
                if (settleType != 0 && settleType != 2) throw TwException.error("", "\u7ed3\u7b97\u5355\u7ed3\u7b97\u65b9\u5f0f\u7c7b\u578b\u4e0d\u5339\u914d");
                settleType = 2;
            }
            avalQty = avalQty.add(vo.getAvalQty());
        }
        if (settleType != true) return calTaskSettleVOs;
        CalTaskSettleVO calTaskSettleVO = calTaskSettleVOs.get(0);
        CalTaskSettleVO newVo = new CalTaskSettleVO();
        newVo.copy(calTaskSettleVO);
        newVo.setApproveSettleEqva(BigDecimal.ZERO);
        newVo.setApproveSettleAmt(BigDecimal.ZERO);
        newVo.setGraranteeEqva(BigDecimal.ZERO);
        newVo.setApproveIncomeAmt(payload.getWithdrawAmt());
        this.calResourceService.taskSettleTurnover(Arrays.asList(newVo));
        return calTaskSettleVOs;
    }

    void updateTaskSettleEqva(Long settleId) {
        CalTaskSettleDetailQuery query = new CalTaskSettleDetailQuery();
        query.setSettleId(settleId);
        List calTaskSettleDetailVOS = this.calTaskSettleDetailService.queryListDynamic(query);
        calTaskSettleDetailVOS.forEach(vo -> this.taskInfoService.updateSettledEqva(vo.getTaskId(), vo.getApproveSettleEqva()));
    }

    public CalTaskSettleServiceImpl(CalTaskSettleRepo calTaskSettleRepo, CalTaskSettleDAO calTaskSettleDAO, CalTaskSettleDetailService calTaskSettleDetailService, CacheUtil cacheUtil, WorkflowUtil workflowUtil, TransactionUtilService transactionUtilService, CalResourceService calResourceService, TaskPackageService taskPackageService, TaskInfoService taskInfoService, FileUtil fileUtil, TaskSettleTimesheetService taskSettleTimesheetService) {
        this.calTaskSettleRepo = calTaskSettleRepo;
        this.calTaskSettleDAO = calTaskSettleDAO;
        this.calTaskSettleDetailService = calTaskSettleDetailService;
        this.cacheUtil = cacheUtil;
        this.workflowUtil = workflowUtil;
        this.transactionUtilService = transactionUtilService;
        this.calResourceService = calResourceService;
        this.taskPackageService = taskPackageService;
        this.taskInfoService = taskInfoService;
        this.fileUtil = fileUtil;
        this.taskSettleTimesheetService = taskSettleTimesheetService;
    }
}

