/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmActPlanDetailPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmActPlanPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmActPlanQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActPlanDetailVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActPlanVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemWorkTypeVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmActActivityDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmActPlanDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmActPlanDetailDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmActActivityDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmActPlanDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmActPlanDetailDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmActPlanDetailRepo;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmActPlanRepo;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgOrganizationDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemWorkTypeDO;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class CrmActPlanDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final CrmActPlanRepo repo;
    private final CrmActPlanDetailRepo repoDetail;
    private final QCrmActPlanDO qdo = QCrmActPlanDO.crmActPlanDO;
    private final QCrmActPlanDetailDO qdoDetail = QCrmActPlanDetailDO.crmActPlanDetailDO;
    private final QPrdOrgOrganizationDO qdoOrg = QPrdOrgOrganizationDO.prdOrgOrganizationDO;
    private final QPrdSystemWorkTypeDO qdoWorkType = QPrdSystemWorkTypeDO.prdSystemWorkTypeDO;
    private final QCrmActActivityDO qdoActivity = QCrmActActivityDO.crmActActivityDO;
    private final QPrdOrgEmployeeDO qdoEmployee = QPrdOrgEmployeeDO.prdOrgEmployeeDO;

    public CrmActPlanDO save(CrmActPlanDO ado) {
        return (CrmActPlanDO)((Object)this.repo.save((Object)ado));
    }

    public CrmActPlanDetailDO saveDetail(CrmActPlanDetailDO ado) {
        return (CrmActPlanDetailDO)((Object)this.repoDetail.save((Object)ado));
    }

    @Transactional
    public long updateByKeyDynamic(CrmActPlanPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getPlanName() != null) {
            update.set((Path)this.qdo.planName, (Object)payload.getPlanName());
        }
        if (payload.getOrgId() != null) {
            update.set(this.qdo.orgId, (Object)payload.getOrgId());
        }
        if (payload.getPlanYear() != null) {
            update.set((Path)this.qdo.planYear, (Object)payload.getPlanYear());
        }
        if (payload.getPlanYear() != null) {
            update.set((Path)this.qdo.planYear, (Object)payload.getPlanYear());
        }
        if (payload.getBudgetMoney() != null) {
            update.set(this.qdo.budgetMoney, (Object)payload.getBudgetMoney());
        }
        if (payload.getLeadNum() != null) {
            update.set(this.qdo.leadNum, (Object)payload.getLeadNum());
        }
        if (payload.getPipeline() != null) {
            update.set(this.qdo.pipeline, (Object)payload.getPipeline());
        }
        if (payload.getPlanStatus() != null) {
            update.set((Path)this.qdo.planStatus, (Object)payload.getPlanStatus());
        }
        if (payload.getProcInstId() != null) {
            update.set((Path)this.qdo.procInstId, (Object)payload.getProcInstId());
        }
        if (payload.getProcInstStatus() != null) {
            update.set(this.qdo.procInstStatus, (Object)payload.getProcInstStatus());
        }
        if (payload.getSubmitTime() != null) {
            update.set(this.qdo.submitTime, (Object)payload.getSubmitTime());
        }
        if (payload.getApprovedTime() != null) {
            update.set(this.qdo.approvedTime, (Object)payload.getApprovedTime());
        }
        if (payload.getDeleteFlag() != null) {
            update.set(this.qdo.deleteFlag, (Object)payload.getDeleteFlag());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("procInstStatus")) {
                update.setNull(this.qdo.procInstStatus);
            }
            if (nullFields.contains("procInstId")) {
                update.setNull((Path)this.qdo.procInstId);
            }
        }
        return update.execute();
    }

    @Transactional
    public long updateDetailByKeyDynamic(CrmActPlanDetailPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdoDetail).where(new Predicate[]{this.qdoDetail.id.eq((Object)payload.getId())});
        if (payload.getDetailType() != null) {
            update.set((Path)this.qdoDetail.detailType, (Object)payload.getDetailType());
        }
        if (payload.getDetailName() != null) {
            update.set((Path)this.qdoDetail.detailName, (Object)payload.getDetailName());
        }
        if (payload.getPersonMoney() != null) {
            update.set(this.qdoDetail.personMoney, (Object)payload.getPersonMoney());
        }
        if (payload.getPersonSource() != null) {
            update.set((Path)this.qdoDetail.personSource, (Object)payload.getPersonSource());
        }
        if (payload.getClaimMoney() != null) {
            update.set(this.qdoDetail.claimMoney, (Object)payload.getClaimMoney());
        }
        if (payload.getPurchaseMoney() != null) {
            update.set(this.qdoDetail.purchaseMoney, (Object)payload.getPurchaseMoney());
        }
        if (payload.getSundryMoney() != null) {
            update.set(this.qdoDetail.sundryMoney, (Object)payload.getSundryMoney());
        }
        if (payload.getTotalMoney() != null) {
            update.set(this.qdoDetail.totalMoney, (Object)payload.getTotalMoney());
        }
        if (payload.getLeadNum() != null) {
            update.set(this.qdoDetail.leadNum, (Object)payload.getLeadNum());
        }
        if (payload.getPipeline() != null) {
            update.set(this.qdoDetail.pipeline, (Object)payload.getPipeline());
        }
        if (payload.getExtDecimal1() != null) {
            update.set(this.qdoDetail.extDecimal1, (Object)payload.getExtDecimal1());
        }
        if (payload.getExtDecimal2() != null) {
            update.set(this.qdoDetail.extDecimal2, (Object)payload.getExtDecimal2());
        }
        if (payload.getExtString1() != null) {
            update.set((Path)this.qdoDetail.extString1, (Object)payload.getExtString1());
        }
        if (payload.getExtString2() != null) {
            update.set((Path)this.qdoDetail.extString2, (Object)payload.getExtString2());
        }
        if (payload.getExtString3() != null) {
            update.set((Path)this.qdoDetail.extString3, (Object)payload.getExtString3());
        }
        if (payload.getExtString3() != null) {
            update.set((Path)this.qdoDetail.extString3, (Object)payload.getExtString3());
        }
        if (payload.getRemark() != null) {
            update.set((Path)this.qdoDetail.remark, (Object)payload.getRemark());
        }
        if ((nullFields = payload.getNullFields()) == null || nullFields.size() > 0) {
            // empty if block
        }
        return update.execute();
    }

    public long deleteSoft(Long key) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.eq((Object)key)});
        return update.execute();
    }

    public long updateStatus(Long key, String planStatus, String procInstId) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set((Path)this.qdo.planStatus, (Object)planStatus);
        if (!procInstId.equals("")) {
            update.set((Path)this.qdo.procInstId, (Object)procInstId);
        }
        update.where(new Predicate[]{this.qdo.id.eq((Object)key)});
        return update.execute();
    }

    public long deleteDetailSoft(Long planId) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdoDetail).set(this.qdoDetail.deleteFlag, (Object)1).where(new Predicate[]{this.qdoDetail.planId.eq((Object)planId)});
        return update.execute();
    }

    public long deleteDetailSoft(Long planId, Long key) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdoDetail).set(this.qdoDetail.deleteFlag, (Object)1).where(new Predicate[]{this.qdoDetail.planId.eq((Object)planId)}).where(new Predicate[]{this.qdoDetail.id.eq((Object)key)});
        return update.execute();
    }

    private JPAQuery<CrmActPlanVO> getJpaQuerySelect() {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CrmActPlanVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.planNo, this.qdo.planName, this.qdo.orgId, this.qdoOrg.orgName, this.qdo.planYear, this.qdo.procInstId, this.qdo.budgetMoney, this.qdo.leadNum, this.qdo.pipeline, this.qdo.planStatus, this.qdoEmployee.employeeName.as("createUserName"), this.qdo.createUserId, this.qdo.operateReason, this.qdo.creator, this.qdo.createTime, this.qdo.procInstId, this.qdo.procInstStatus, this.qdo.submitTime, this.qdo.approvedTime})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qdoOrg)).on((Predicate)this.qdoOrg.id.longValue().eq((Expression)this.qdo.orgId.longValue()))).leftJoin((EntityPath)this.qdoEmployee)).on((Predicate)this.qdoEmployee.userId.longValue().eq((Expression)this.qdo.createUserId.longValue()));
        return jpaQuery;
    }

    public CrmActPlanDO queryByYearOrOrgId(String year, Long orgId) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo).from((EntityPath)this.qdo);
        jpaQuery.where((Predicate)this.qdo.planYear.eq((Object)year));
        jpaQuery.where((Predicate)this.qdo.orgId.eq((Object)orgId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (CrmActPlanDO)((Object)jpaQuery.fetchFirst());
    }

    public List<CrmActPlanVO> queryList(String year, String status) {
        JPAQuery<CrmActPlanVO> jpaQuery = this.getJpaQuerySelect();
        ((JPAQuery)jpaQuery.where((Predicate)this.qdo.planYear.eq((Object)year))).where((Predicate)this.qdo.planStatus.eq((Object)status));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public CrmActPlanVO queryBykey(Long key) {
        JPAQuery<CrmActPlanVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)key));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (CrmActPlanVO)jpaQuery.fetchFirst();
    }

    public long updatePlanStatus(Long key, String status, String reson) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set((Path)this.qdo.planStatus, (Object)status).set((Path)this.qdo.operateReason, (Object)reson).where(new Predicate[]{this.qdo.id.eq((Object)key)});
        return update.execute();
    }

    private JPAQuery<CrmActPlanVO> getJpaQueryWhere(CrmActPlanQuery query, Long userId, List<Long> orgManageIds) {
        JPAQuery<CrmActPlanVO> jpaQuery = this.getJpaQuerySelect();
        if (!ObjectUtils.isEmpty((Object[])query.getPlanIds())) {
            jpaQuery.where((Predicate)this.qdo.id.in((Object[])query.getPlanIds()));
        }
        if (userId != null) {
            jpaQuery.where((Predicate)this.qdo.createUserId.eq((Object)userId).or((Predicate)this.qdo.orgId.in(orgManageIds)));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPlanName())) {
            jpaQuery.where((Predicate)this.qdo.planName.like(SqlUtil.toSqlLikeString(query.getPlanName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getOrgId())) {
            jpaQuery.where((Predicate)this.qdo.orgId.eq((Object)query.getOrgId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPlanYear())) {
            jpaQuery.where((Predicate)this.qdo.planYear.eq((Object)query.getPlanYear()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPlanStatus())) {
            jpaQuery.where((Predicate)this.qdo.planStatus.eq((Object)query.getPlanStatus()));
        }
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public PagingVO<CrmActPlanVO> queryPaging(CrmActPlanQuery query, Long userId, List<Long> orgManageIds) {
        JPAQuery<CrmActPlanVO> jpaQuery = this.getJpaQueryWhere(query, userId, orgManageIds);
        QueryResults result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetchResults();
        System.out.println(result.getTotal());
        return PagingVO.builder().records(result.getResults()).total(result.getTotal()).build();
    }

    private JPAQuery<PrdSystemWorkTypeVO> getJpaQuerySelectWorkType() {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdSystemWorkTypeVO.class, (Expression[])new Expression[]{this.qdoWorkType.id, this.qdoWorkType.sysType, this.qdoWorkType.sysWork, this.qdoWorkType.sysLevel, this.qdoWorkType.unitPrice})).from((EntityPath)this.qdoWorkType);
        return jpaQuery;
    }

    public List<PrdSystemWorkTypeVO> queryWorkTypes() {
        JPAQuery<PrdSystemWorkTypeVO> jpaQuery = this.getJpaQuerySelectWorkType();
        jpaQuery.where((Predicate)this.qdoWorkType.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    private JPAQuery<CrmActPlanDetailVO> getJpaQuerySelectDetail() {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CrmActPlanDetailVO.class, (Expression[])new Expression[]{this.qdoDetail.id, this.qdoDetail.planId, this.qdoDetail.detailSeason, this.qdoDetail.detailType, this.qdoDetail.detailName, this.qdoDetail.personMoney, this.qdoDetail.personSource, this.qdoDetail.claimMoney, this.qdoDetail.purchaseMoney, this.qdoDetail.sundryMoney, this.qdoDetail.totalMoney, this.qdoDetail.expenditure, this.qdoDetail.leadNum, this.qdoDetail.pipeline, this.qdoDetail.extString1, this.qdoDetail.extString2, this.qdoDetail.extString3, this.qdoDetail.extDecimal1, this.qdoDetail.extDecimal2, this.qdoDetail.remark})).from((EntityPath)this.qdoDetail);
        return jpaQuery;
    }

    public CrmActPlanDetailDO queryDetail(Long planId, String detailSeason, String detailType) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdoDetail).from((EntityPath)this.qdoDetail);
        ((JPAQuery)((JPAQuery)jpaQuery.where((Predicate)this.qdoDetail.planId.eq((Object)planId))).where((Predicate)this.qdoDetail.detailSeason.eq((Object)detailSeason))).where((Predicate)this.qdoDetail.detailType.eq((Object)detailType));
        jpaQuery.where((Predicate)this.qdoDetail.deleteFlag.eq((Object)0));
        return (CrmActPlanDetailDO)((Object)jpaQuery.fetchFirst());
    }

    public CrmActPlanDetailDO queryDetailById(Long id) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdoDetail).from((EntityPath)this.qdoDetail);
        jpaQuery.where((Predicate)this.qdoDetail.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdoDetail.deleteFlag.eq((Object)0));
        return (CrmActPlanDetailDO)((Object)jpaQuery.fetchFirst());
    }

    public List<CrmActPlanDetailVO> queryDetailsByPlanId(Long planId, String ... detailSeason) {
        JPAQuery<CrmActPlanDetailVO> jpaQuery = this.getJpaQuerySelectDetail();
        jpaQuery.where((Predicate)this.qdoDetail.planId.eq((Object)planId));
        if (detailSeason != null && detailSeason.length > 0 && !detailSeason[0].equals("")) {
            jpaQuery.where((Predicate)this.qdoDetail.detailSeason.eq((Object)detailSeason[0]));
        }
        jpaQuery.where((Predicate)this.qdoDetail.deleteFlag.eq((Object)0));
        ArrayList<OrderItem> orderse = new ArrayList<OrderItem>();
        orderse.add(OrderItem.asc((String)"detailSeason"));
        orderse.add(OrderItem.asc((String)"createTime"));
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdoDetail, orderse));
        return jpaQuery.fetch();
    }

    public List<CrmActActivityDO> queryActivityByDetailId(Long detailId) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdoActivity).from((EntityPath)this.qdoActivity);
        jpaQuery.where((Predicate)this.qdoActivity.detailId.eq((Object)detailId));
        jpaQuery.where((Predicate)this.qdoActivity.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public CrmActPlanDAO(JPAQueryFactory jpaQueryFactory, CrmActPlanRepo repo, CrmActPlanDetailRepo repoDetail) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
        this.repoDetail = repoDetail;
    }
}

