/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.service;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityOutCostPayload;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityOutCostService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityOutCostVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.service.TransferUtilServiceImpl;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemLogEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmOpportunityOutCostConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunityDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunityOutCostDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOpportunityOutCostDO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.StartProcessPayload;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class CrmOpportunityOutCostServiceImpl
implements CrmOpportunityOutCostService {
    private static final Logger log = LoggerFactory.getLogger(CrmOpportunityOutCostServiceImpl.class);
    private final CacheUtil cacheUtil;
    private final CrmOpportunityOutCostDAO dao;
    private final PrdSystemLogService logService;
    private final TransferUtilServiceImpl transferUtilService;
    private final HttpUtil httpUtil;
    private final CrmOpportunityService crmOpportunityService;
    private final CrmOpportunityDAO crmOpportunityDAO;
    private final TransactionUtilService transactionUtilService;
    private final PrdOrgEmployeeDAO employeeDAO;
    private final WorkflowUtil workflowUtil;
    @Value(value="${tw4.opportunity.outCost_operation}")
    private String outCost_operation;
    @Value(value="${tw4.opportunity.outCost_del}")
    private String outCost_del;
    @Value(value="${tw5.workflow.enabled}")
    private Boolean workflow_enabled;

    @Transactional(rollbackFor={Exception.class})
    public CrmOpportunityOutCostVO insert(CrmOpportunityOutCostPayload payload) {
        CrmOpportunityOutCostDO ado = CrmOpportunityOutCostConvert.INSTANCE.toDo(payload);
        this.dao.save(ado);
        this.logService.saveNewLog(payload.getOppoId(), PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.ADD.getDesc() + "\u5916\u5305\u8d39\u7528");
        return CrmOpportunityOutCostConvert.INSTANCE.toVo(ado);
    }

    @Transactional(rollbackFor={Exception.class})
    public Long update(CrmOpportunityOutCostPayload payload) {
        CrmOpportunityOutCostDO ado = CrmOpportunityOutCostConvert.INSTANCE.toDo(payload);
        this.dao.save(ado);
        this.logService.saveNewLog(payload.getOppoId(), PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.UPDATE.getDesc() + "\u5916\u5305\u8d39\u7528");
        return 0L;
    }

    public CrmOpportunityOutCostVO queryById(Long id) {
        CrmOpportunityOutCostVO vo = this.dao.queryById(id);
        if (StringUtils.hasText((String)vo.getApprovalStatus())) {
            WorkFlowStatusEnum byCode = WorkFlowStatusEnum.getByCode(vo.getApprovalStatus());
            vo.setApprovalStatusName(null != byCode ? byCode.getDesc() : "");
        }
        return vo;
    }

    public List<CrmOpportunityOutCostVO> queryList(Long oppoId) {
        List<CrmOpportunityOutCostVO> list = this.dao.queryList(oppoId);
        if (!CollectionUtils.isEmpty(list)) {
            for (CrmOpportunityOutCostVO vo : list) {
                if (!StringUtils.hasText((String)vo.getApprovalStatus())) continue;
                WorkFlowStatusEnum byCode = WorkFlowStatusEnum.getByCode(vo.getApprovalStatus());
                vo.setApprovalStatusName(null != byCode ? byCode.getDesc() : "");
            }
        }
        return list;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean deleteSoft(Long oppoId, List<Long> keys) {
        this.dao.deleteSoft(keys);
        this.logService.saveNewLog(oppoId, PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.DELETE.getDesc() + "\u5916\u5305\u8d39\u7528");
        return true;
    }

    public void submit(Long id) {
        CrmOpportunityOutCostVO crmOpportunityOutCostVO = this.dao.queryById(id);
        if (crmOpportunityOutCostVO == null) {
            throw TwException.error("", "\u672a\u627e\u5230\u76f8\u5173\u7684\u6570\u636e");
        }
        if (crmOpportunityOutCostVO.getProcInstStatus() != null && !crmOpportunityOutCostVO.getProcInstStatus().equals((Object)WorkFlowStatusEnum.CREATE_WORK.getCode())) {
            throw TwException.error("", "\u4ec5\u65b0\u589e\u72b6\u6001\u53ef\u64cd\u4f5c");
        }
        this.submitProc(crmOpportunityOutCostVO);
    }

    private void submitProc(CrmOpportunityOutCostVO vo) {
        Long oppoId = vo.getOppoId();
        CrmOpportunityVO crmOpportunityVO = this.crmOpportunityDAO.queryByKey(oppoId);
        ProcessInfo processInfo = new ProcessInfo();
        String status = WorkFlowStatusEnum.APPROVED_WORK.getCode();
        if (this.workflow_enabled.booleanValue()) {
            status = WorkFlowStatusEnum.APPROVING_WORK.getCode();
            HashMap variables = new HashMap();
            processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.OPPO_OUT_COST.name(), (String)(crmOpportunityVO.getProjectName() + "-\u5546\u673a\u5916\u5305\u8d39\u7528\u5ba1\u6279\u6d41\u7a0b"), (String)("" + vo.getId()), variables), new Long[0]);
        }
        CrmOpportunityOutCostPayload payload = new CrmOpportunityOutCostPayload();
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setId(vo.getId());
        payload.setProcInstStatus(processInfo.getProcInstStatus());
        payload.setSubmitTime(LocalDateTime.now());
        payload.setApprovalStatus(status);
        this.transactionUtilService.executeWithRunnable(() -> this.dao.updateByKeyDynamic(payload));
    }

    public CrmOpportunityOutCostServiceImpl(CacheUtil cacheUtil, CrmOpportunityOutCostDAO dao, PrdSystemLogService logService, TransferUtilServiceImpl transferUtilService, HttpUtil httpUtil, CrmOpportunityService crmOpportunityService, CrmOpportunityDAO crmOpportunityDAO, TransactionUtilService transactionUtilService, PrdOrgEmployeeDAO employeeDAO, WorkflowUtil workflowUtil) {
        this.cacheUtil = cacheUtil;
        this.dao = dao;
        this.logService = logService;
        this.transferUtilService = transferUtilService;
        this.httpUtil = httpUtil;
        this.crmOpportunityService = crmOpportunityService;
        this.crmOpportunityDAO = crmOpportunityDAO;
        this.transactionUtilService = transactionUtilService;
        this.employeeDAO = employeeDAO;
        this.workflowUtil = workflowUtil;
    }
}

