/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityScoreConfigPayload;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityScoreConfigService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityScoreConfigVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.crm.constant.CrmOpportunityEnum;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmOpportunityScoreConfigConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunityScoreConfigDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOpportunityScoreConfigDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOpportunityScoreConfigRepo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CrmOpportunityScoreConfigServiceImpl
extends BaseServiceImpl
implements CrmOpportunityScoreConfigService {
    private static final Logger log = LoggerFactory.getLogger(CrmOpportunityScoreConfigServiceImpl.class);
    private final CrmOpportunityScoreConfigRepo crmOpportunityScoreConfigRepo;
    private final CrmOpportunityScoreConfigDAO crmOpportunityScoreConfigDAO;

    @Transactional(rollbackFor={Exception.class})
    public List<CrmOpportunityScoreConfigVO> insertOrUpdate(List<CrmOpportunityScoreConfigPayload> payloads) {
        if (payloads == null) {
            return null;
        }
        ArrayList list = new ArrayList(payloads.size());
        HashMap map = new HashMap(payloads.size());
        payloads.forEach(payload -> map.put(payload.getProbabilityName(), payload));
        payloads.forEach(payload -> {
            BigDecimal scoreMin = payload.getScoreMin();
            BigDecimal scoreMax = payload.getScoreMax();
            if (scoreMin == null || scoreMax == null || scoreMin.compareTo(scoreMax) > 0) {
                throw TwException.error("", "\u6210\u5355\u7387\u5206\u503c\u533a\u95f4\u4e0d\u5408\u6cd5\uff0c\u8bf7\u68c0\u67e5");
            }
            if (((CrmOpportunityScoreConfigPayload)map.get(CrmOpportunityEnum.D.getCode())).getScoreMin().compareTo(BigDecimal.ZERO) != 0) {
                log.error("D-\u56f0\u96be\u7b49\u7ea7\u5206\u6570\u914d\u7f6e\u9700\u4ece0\u5f00\u59cb");
                throw TwException.error("", "D-\u56f0\u96be\u7b49\u7ea7\u5206\u6570\u914d\u7f6e\u9700\u4ece0\u5f00\u59cb");
            }
            if (((CrmOpportunityScoreConfigPayload)map.get(CrmOpportunityEnum.S.getCode())).getScoreMax().compareTo(new BigDecimal("100")) != 0) {
                log.error("S-\u5df2\u9009\u62e9\u7b49\u7ea7\u5206\u6570\u914d\u7f6e\u9700\u4ece100\u7ed3\u675f");
                throw TwException.error("", "S-\u5df2\u9009\u62e9\u7b49\u7ea7\u5206\u6570\u914d\u7f6e\u9700\u4ece100\u7ed3\u675f");
            }
            if (((CrmOpportunityScoreConfigPayload)map.get(CrmOpportunityEnum.C.getCode())).getScoreMin().compareTo(((CrmOpportunityScoreConfigPayload)map.get(CrmOpportunityEnum.D.getCode())).getScoreMax()) != 0) {
                log.error("C-\u6709\u7ade\u4e89\u6027\u7684\u6700\u5c0f\u503c\u5e94\u7b49\u4e8eD-\u56f0\u96be\u7684\u6700\u5927\u503c");
                throw TwException.error("", "C-\u6709\u7ade\u4e89\u6027\u7684\u6700\u5c0f\u503c\u5e94\u7b49\u4e8eD-\u56f0\u96be\u7684\u6700\u5927\u503c");
            }
            if (((CrmOpportunityScoreConfigPayload)map.get(CrmOpportunityEnum.P.getCode())).getScoreMin().compareTo(((CrmOpportunityScoreConfigPayload)map.get(CrmOpportunityEnum.C.getCode())).getScoreMax()) != 0) {
                log.error("P-\u6709\u503e\u5411\u7684\u6700\u5c0f\u503c\u5e94\u7b49\u4e8eC-\u6709\u7ade\u4e89\u6027\u7684\u6700\u5927\u503c");
                throw TwException.error("", "P-\u6709\u503e\u5411\u7684\u6700\u5c0f\u503c\u5e94\u7b49\u4e8eC-\u6709\u7ade\u4e89\u6027\u7684\u6700\u5927\u503c");
            }
            if (((CrmOpportunityScoreConfigPayload)map.get(CrmOpportunityEnum.S.getCode())).getScoreMin().compareTo(((CrmOpportunityScoreConfigPayload)map.get(CrmOpportunityEnum.P.getCode())).getScoreMax()) != 0) {
                log.error("S-\u5df2\u9009\u62e9\u7684\u6700\u5c0f\u503c\u5e94\u7b49\u4e8eP-\u6709\u503e\u5411\u7684\u6700\u5927\u503c");
                throw TwException.error("", "S-\u5df2\u9009\u62e9\u7684\u6700\u5c0f\u503c\u5e94\u7b49\u4e8eP-\u6709\u503e\u5411\u7684\u6700\u5927\u503c");
            }
            CrmOpportunityScoreConfigDO entityDo = CrmOpportunityScoreConfigConvert.INSTANCE.toDo((CrmOpportunityScoreConfigPayload)payload);
            list.add(entityDo);
        });
        List list1 = this.crmOpportunityScoreConfigRepo.saveAll(list);
        ArrayList<CrmOpportunityScoreConfigVO> crmOpportunityScoreConfigVOList = new ArrayList<CrmOpportunityScoreConfigVO>(payloads.size());
        list1.forEach(entityDo -> {
            CrmOpportunityScoreConfigVO crmOpportunityScoreConfigVO = CrmOpportunityScoreConfigConvert.INSTANCE.toVo((CrmOpportunityScoreConfigDO)this.crmOpportunityScoreConfigRepo.save(entityDo));
            crmOpportunityScoreConfigVOList.add(crmOpportunityScoreConfigVO);
        });
        return crmOpportunityScoreConfigVOList;
    }

    public List<CrmOpportunityScoreConfigVO> queryAll() {
        return this.crmOpportunityScoreConfigDAO.queryAll();
    }

    public CrmOpportunityScoreConfigServiceImpl(CrmOpportunityScoreConfigRepo crmOpportunityScoreConfigRepo, CrmOpportunityScoreConfigDAO crmOpportunityScoreConfigDAO) {
        this.crmOpportunityScoreConfigRepo = crmOpportunityScoreConfigRepo;
        this.crmOpportunityScoreConfigDAO = crmOpportunityScoreConfigDAO;
    }
}

