/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.service;

import cn.hutool.extra.spring.SpringUtil;
import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.FieldOp;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.util.FieldFns;
import cn.zhxu.bs.util.MapBuilder;
import cn.zhxu.bs.util.MapUtils;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.budget.service.BudgetCommonService;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetCommonVO;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalAccountPayload;
import com.elitesland.tw.tw5.api.prd.cal.service.CalAccountService;
import com.elitesland.tw.tw5.api.prd.cal.service.CalResourceService;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmFollowPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityExcelExport;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityMilestonePlanQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmFollowService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOppoConversionRateService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityAnalyzeService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityCompetitorService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityMilestonePlanService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityStakeholderService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActProjectVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmFollowVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOppoConversionRateVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOppoDataSourceFieldsVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityListVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityMeasureDVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityMeasureVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityScoreConfigVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityVO;
import com.elitesland.tw.tw5.api.prd.my.service.PrdUserService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgDataRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BusinessPartnerPayload;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerSimpleVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.payload.BusinessCustomerInfoPayload;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessCustomerInfoService;
import com.elitesland.tw.tw5.api.prd.prj.vo.PrjProjectMemberVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchasePaymentDefaultVO;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemLogQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemLogVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSettingVO;
import com.elitesland.tw.tw5.api.prd.task.query.TaskPackageQuery;
import com.elitesland.tw.tw5.api.prd.task.service.TaskCommonService;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskPackageVO;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.permission.PermissionBeanSearcherFactory;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.common.service.TransferUtilServiceImpl;
import com.elitesland.tw.tw5.server.common.util.BeanUtil;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.common.util.ListCompareUtil;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CalAccTypeEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CrmFollowObjectEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemLogEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.crm.constant.CrmOpportunityCheckStatusEnum;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmOpportunityConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmActActivityDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmLeadsDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunityDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOpportunityDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOpportunityRepo;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgOrganizationRefDO;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessInsideOrOutSideEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessPartnerIdentityEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessPartnerStageEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessPartnerStatusEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessPartnerTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.tw.tw5.server.prd.prj.dao.PrjProjectDAO;
import com.elitesland.tw.tw5.server.prd.prj.entity.PrjProjectDO;
import com.elitesland.tw.tw5.server.prd.prj.entity.PrjProjectMemberDO;
import com.elitesland.tw.tw5.server.prd.system.constant.SystemSettingsItemEnum;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import com.elitesland.tw.tw5.server.yeedoc.config.YeedocProperties;
import com.elitesland.tw.tw5.server.yeedoc.service.YeedocService;
import com.elitesland.tw.tw5.server.yeedocref.YeedocUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class CrmOpportunityServiceImpl
extends BaseServiceImpl
implements CrmOpportunityService {
    private static final Logger log = LoggerFactory.getLogger(CrmOpportunityServiceImpl.class);
    private final CacheUtil cacheUtil;
    private final PrjProjectDAO projectDAO;
    private final CrmOpportunityDAO dao;
    private final CrmOpportunityRepo repo;
    private final CrmActActivityDAO activityDAO;
    private final PrdOrgEmployeeDAO employeeDAO;
    private final PrdOrgOrganizationDAO orgOrganizationDAO;
    private final CrmOppoConversionRateService crmOppoConversionRateService;
    private final CrmOpportunityAnalyzeService opportunityAnalyzeService;
    private final CrmOpportunityCompetitorService opportunityCompetitorService;
    private final CrmOpportunityStakeholderService opportunityStakeholderService;
    private final CrmOpportunityMilestonePlanService opportunityMilestonePlanService;
    private final BusinessPartnerService businessPartnerService;
    private final CrmFollowService followService;
    private final PrdSystemLogService logService;
    private final TransferUtilServiceImpl transferUtilService;
    private final HttpUtil httpUtil;
    private final ExcelUtil excelUtil;
    private final PrdSystemRoleDAO systemRoleDAO;
    private final YeedocService yeedocService;
    private final YeedocProperties yeedocProperties;
    private final CrmLeadsDAO leadsDAO;
    private final UdcUtil udcUtil;
    private final ChangeFieldLogUtil changeFieldLogUtil;
    private final CalResourceService calResourceService;
    @Autowired
    private PrdUserService prdUserService;
    private final PrdOrgOrganizationService prdOrgOrganizationService;
    @Value(value="${tw4.opportunity.operation}")
    private String opportunity_operation;
    @Value(value="${tw4.opportunity.operation_close}")
    private String opportunity_operation_close;
    @Value(value="${tw4.opportunity.operation_change_status}")
    private String opportunity_operation_updateStatus;
    private static final String[] sapBuSystemRoleCodes = new String[]{"BD0020", "BD0031", "BD0035", "BD0037", "BD0036", "BD0030", "BD0021", "BD0039", "BD0041"};
    private BeanSearcher beanSearcher;
    private final CalAccountService calAccountService;
    private final TaskCommonService taskCommonService;
    private final YeedocUtils yeedocUtils;
    @Autowired
    @Lazy
    private BudgetCommonService budgetCommonService;

    @Autowired
    public void setBeanSearcher(PermissionBeanSearcherFactory permissionBeanSearcherFactory) {
        this.beanSearcher = permissionBeanSearcherFactory.getBeanSearcherService(PermissionDomainEnum.BUSINESS_OPPORTUNITY);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public CrmOpportunityVO insert(CrmOpportunityPayload payload) {
        if (payload.getIsNeedPartner() == null) {
            payload.setIsNeedPartner(Integer.valueOf(0));
        }
        String code = this.generateSeqNum("OPPORTUNITY", new String[0]);
        payload.setProjectNo(code);
        PrjProjectDO ado = CrmOpportunityConvert.INSTANCE.toProjectDo(payload);
        ado.setProjectStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
        ado.setProjectType(CrmFollowObjectEnum.Opportunity.getCode());
        ado.setProjectNo(code);
        ado = this.projectDAO.save(ado);
        CrmOpportunityDO crmOpportunityDO = CrmOpportunityConvert.INSTANCE.toDo(payload);
        crmOpportunityDO.setProjectId(ado.getId());
        crmOpportunityDO.setCheckStatus(CrmOpportunityCheckStatusEnum.NOT_CHECKED.getCode());
        crmOpportunityDO = this.dao.save(crmOpportunityDO);
        this.logService.saveNewLog(crmOpportunityDO.getId(), PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.CREATE.getDesc() + PrdSystemObjectEnum.Opportunity.getDesc());
        ArrayList<Long> userIds = new ArrayList<Long>();
        userIds.add(ado.getCreateUserId());
        userIds.add(ado.getManageUserId());
        userIds.add(crmOpportunityDO.getPreSaleUserId());
        userIds.add(crmOpportunityDO.getDeliUserId());
        userIds.add(crmOpportunityDO.getCoUserId());
        userIds.add(crmOpportunityDO.getCodeliUserId());
        userIds = userIds.stream().filter(Objects::nonNull).collect(Collectors.toList());
        this.addProjectMember(ado.getId(), userIds);
        CalAccountPayload accountPayload = new CalAccountPayload();
        accountPayload.setAuType(CalAccTypeEnum.OPP.getCode());
        accountPayload.setAuId(ado.getId());
        accountPayload.setLedgerName(ado.getProjectName());
        accountPayload.setLedgerNo(ado.getProjectNo());
        this.calAccountService.insert(accountPayload);
        return CrmOpportunityConvert.INSTANCE.toVo(crmOpportunityDO);
    }

    @Deprecated
    private CrmOpportunityPayload transferV4(CrmOpportunityPayload payload) {
        if (payload.getOrgIdV4() != null) {
            payload.setOrgId(this.orgOrganizationDAO.getOrgIdByV4(payload.getOrgIdV4()));
        }
        if (payload.getManageUserIdV4() != null) {
            payload.setManageUserId(this.employeeDAO.getUserIdByV4(payload.getManageUserIdV4()));
        }
        if (payload.getCoOrgIdV4() != null) {
            payload.setCoOrgId(this.orgOrganizationDAO.getOrgIdByV4(payload.getCodeliOrgIdV4()));
        }
        if (payload.getCoUserIdV4() != null) {
            payload.setCoUserId(this.employeeDAO.getUserIdByV4(payload.getCoUserIdV4()));
        }
        if (payload.getDeliOrgIdV4() != null) {
            payload.setDeliOrgId(this.orgOrganizationDAO.getOrgIdByV4(payload.getDeliOrgIdV4()));
        }
        if (payload.getDeliUserIdV4() != null) {
            payload.setDeliUserId(this.employeeDAO.getUserIdByV4(payload.getDeliUserIdV4()));
        }
        if (payload.getDeliOrgIdV4() != null) {
            payload.setDeliOrgId(this.orgOrganizationDAO.getOrgIdByV4(payload.getDeliOrgIdV4()));
        }
        if (payload.getCodeliOrgIdV4() != null) {
            payload.setCodeliOrgId(this.orgOrganizationDAO.getOrgIdByV4(payload.getCodeliOrgIdV4()));
        }
        if (payload.getCodeliUserIdV4() != null) {
            payload.setCodeliUserId(this.employeeDAO.getUserIdByV4(payload.getCodeliUserIdV4()));
        }
        if (payload.getInternalUserIdV4() != null) {
            payload.setInternalUserId(this.employeeDAO.getUserIdByV4(payload.getInternalUserIdV4()));
        }
        if (payload.getInternalOrgIdV4() != null) {
            payload.setInternalOrgId(this.orgOrganizationDAO.getOrgIdByV4(payload.getInternalOrgIdV4()));
        }
        if (payload.getPreSaleOrgIdV4() != null) {
            payload.setPreSaleOrgId(this.orgOrganizationDAO.getOrgIdByV4(payload.getPreSaleOrgIdV4()));
        }
        if (payload.getPreSaleUserIdV4() != null) {
            payload.setPreSaleUserId(this.employeeDAO.getUserIdByV4(payload.getPreSaleUserIdV4()));
        }
        return payload;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public Long update(CrmOpportunityPayload payload) {
        CrmActProjectVO project = this.dao.queryProjectBykey(payload.getId());
        this.checkUpdate(project);
        Map<String, List<Long>> userMangeIds = this.getUserMangeIds(payload, project);
        List<Long> addIds = userMangeIds.get("addIds");
        List<Long> deleteIds = userMangeIds.get("deleteIds");
        CrmOpportunityVO opportunityVO = this.dao.queryByKey(payload.getId());
        CrmOpportunityVO oldEntity = new CrmOpportunityVO();
        BeanUtils.copyProperties((Object)opportunityVO, (Object)oldEntity);
        CrmOpportunityConvert.INSTANCE.copy(payload, opportunityVO);
        opportunityVO.setProjectId(project.getId());
        opportunityVO.setOppoIdV4(project.getOppoIdV4());
        payload.setProjectId(project.getId());
        payload.setOppoIdV4(project.getOppoIdV4());
        String changeLog = this.changeFieldLogUtil.getFieldsUpdateLog(opportunityVO, oldEntity);
        if (org.springframework.util.StringUtils.hasText((String)changeLog)) {
            this.logService.saveNewLog(opportunityVO.getId(), PrdSystemObjectEnum.Opportunity.getCode(), changeLog);
        }
        this.dao.updateProjectByKeyDynamic(payload, project.getId());
        this.dao.updateByKeyDynamic(payload);
        this.deleteProjectMember(project.getId(), deleteIds, project.getOppoIdV4());
        this.addProjectMember(project.getId(), addIds);
        return 0L;
    }

    @Transactional(rollbackFor={Exception.class})
    public void toggleCheckStatus(List<Long> ids) {
        List doList = this.repo.findAllById(ids);
        for (CrmOpportunityDO oppoDO : doList) {
            CrmOpportunityDO oldEntity = new CrmOpportunityDO();
            BeanUtils.copyProperties((Object)((Object)oppoDO), (Object)((Object)oldEntity));
            String newCheckStatus = this.toggleCheckStatus(oppoDO.getCheckStatus());
            oppoDO.setCheckStatus(newCheckStatus);
            this.repo.save((Object)oppoDO);
            String changeLog = this.changeFieldLogUtil.getFieldsUpdateLog(oppoDO, oldEntity);
            if (!org.springframework.util.StringUtils.hasText((String)changeLog)) continue;
            this.logService.saveNewLog(oppoDO.getId(), PrdSystemObjectEnum.Opportunity.getCode(), changeLog);
        }
    }

    private String toggleCheckStatus(String checkStatus) {
        if (CrmOpportunityCheckStatusEnum.NOT_CHECKED.getCode().equals(checkStatus)) {
            return CrmOpportunityCheckStatusEnum.CHECKED.getCode();
        }
        if (CrmOpportunityCheckStatusEnum.CHECKED.getCode().equals(checkStatus)) {
            return CrmOpportunityCheckStatusEnum.NOT_CHECKED.getCode();
        }
        return checkStatus;
    }

    public PagingVO<CrmOpportunityVO> paging(CrmOpportunityQuery query) {
        BusinessPartnerService businessPartnerService;
        List businessPartnerVOS;
        PagingVO<CrmOpportunityVO> opportunityVO = null;
        Long userId = query.getQueryUserId() == null ? GlobalUtil.getLoginUserId() : query.getQueryUserId();
        List sapPermissionOrgIdList = null;
        List<Long> orgManageIds = this.orgOrganizationDAO.queryByManageIdOrgIds(userId);
        List<Long> oppoUserIds = new ArrayList<Long>();
        List<Long> userIdsByRole = this.systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.SALE_ADMIN.getCode()));
        if (userIdsByRole != null && !userIdsByRole.isEmpty() && userIdsByRole.contains(userId)) {
            oppoUserIds = null;
        } else {
            PrdOrgEmployeeRefVO prdOrgEmployeeRefVO;
            boolean hasSapBuPermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(sapBuSystemRoleCodes));
            if (hasSapBuPermission) {
                List<String> userSystemRoleCodes = this.cacheUtil.getSystemRoleCodes(userId);
                List<String> userSapBuSystemRoleCodes = Arrays.stream(sapBuSystemRoleCodes).filter(s -> userSystemRoleCodes.contains(s)).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(userSapBuSystemRoleCodes)) {
                    sapPermissionOrgIdList = this.orgOrganizationDAO.queryByOrgCode(userSapBuSystemRoleCodes).stream().map(BaseModel::getId).collect(Collectors.toList());
                    Set<Long> childOrgs = this.orgOrganizationDAO.queryAllChildOrgs(sapPermissionOrgIdList.stream().collect(Collectors.toSet()));
                    sapPermissionOrgIdList.addAll(childOrgs);
                }
            }
            if ((prdOrgEmployeeRefVO = this.employeeDAO.queryUserOrgData(userId)) != null && prdOrgEmployeeRefVO.getManageId() != null && userId.equals(prdOrgEmployeeRefVO.getManageId())) {
                Long orgId = prdOrgEmployeeRefVO.getOrgId();
                List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS = this.orgOrganizationDAO.queryEmployeeList(orgId);
                oppoUserIds = prdOrgEmployeeRefVOS.stream().map(e -> e.getUserId()).collect(Collectors.toList());
            } else {
                oppoUserIds = Collections.singletonList(userId);
            }
        }
        opportunityVO = this.dao.queryPaging(query, oppoUserIds, orgManageIds, sapPermissionOrgIdList);
        List opportunitys = opportunityVO.getRecords();
        HashSet<Long> userIds = new HashSet<Long>();
        HashSet<Long> orgIds = new HashSet<Long>();
        HashSet<Long> bookIds = new HashSet<Long>();
        HashSet<Long> formalCustomerIds = new HashSet<Long>();
        for (CrmOpportunityVO vo : opportunitys) {
            this.transferSystemSelection(vo);
            this.getIdDatas(userIds, orgIds, bookIds, formalCustomerIds, vo);
        }
        List<Map<String, Object>> employees = this.dao.queryEmployees(userIds);
        HashMap employeeMap = new HashMap();
        employees.forEach(employee -> employeeMap.put(Long.valueOf("" + employee.get("userId")), (String)employee.get("employeeName")));
        List<Map<String, Object>> orgs = this.dao.queryOrgs(orgIds);
        HashMap orgMap = new HashMap();
        orgs.forEach(org -> orgMap.put(Long.valueOf("" + org.get("id")), (String)org.get("orgName")));
        List<Map<String, Object>> books = this.dao.queryBooks(bookIds);
        HashMap bookMap = new HashMap();
        books.forEach(book -> bookMap.put(Long.valueOf("" + book.get("book_id")), (String)book.get("bookName")));
        Map<Object, Object> customerMapTmp = new HashMap();
        if (!CollectionUtils.isEmpty(formalCustomerIds) && !CollectionUtils.isEmpty((Collection)(businessPartnerVOS = (businessPartnerService = (BusinessPartnerService)SpringUtil.getBean(BusinessPartnerService.class)).queryListByIds(new ArrayList<Long>(formalCustomerIds))))) {
            customerMapTmp = businessPartnerVOS.stream().collect(Collectors.groupingBy(BaseViewModel::getId));
        }
        HashMap customerMap = customerMapTmp;
        opportunitys.forEach(opportunity -> this.transferOpportunityDatas(employeeMap, orgMap, bookMap, customerMap, (CrmOpportunityVO)opportunity));
        return opportunityVO;
    }

    private void allChildrenOrgId(Long parentOrgId, List<Long> childrenOrgIdList) {
        List<PrdOrgOrganizationRefDO> childrenOrgRefList = this.orgOrganizationDAO.queryAllByParentId(parentOrgId);
        if (CollectionUtils.isEmpty(childrenOrgRefList)) {
            return;
        }
        for (PrdOrgOrganizationRefDO orgRef : childrenOrgRefList) {
            childrenOrgIdList.add(orgRef.getOrgId());
            this.allChildrenOrgId(orgRef.getOrgId(), childrenOrgIdList);
        }
    }

    public List<CrmOpportunityListVO> queryList() {
        return this.dao.queryList();
    }

    public List<CrmOpportunityListVO> queryListDynamic(CrmOpportunityQuery query) {
        List<CrmOpportunityListVO> crmOpportunityListVOS = this.dao.queryListDynamic(query);
        return crmOpportunityListVOS;
    }

    public List<CrmOpportunityListVO> querySimpleList(CrmOpportunityQuery query) {
        return this.dao.queryListDynamic(query);
    }

    public CrmOpportunityVO queryByKey(Long key) {
        List<PrjProjectMemberVO> membersVOS;
        BusinessPartnerService businessPartnerService;
        List businessPartnerVOS;
        CrmOpportunityVO vo = this.dao.queryByKey(key);
        HashSet<Long> userIds = new HashSet<Long>();
        HashSet<Long> orgIds = new HashSet<Long>();
        this.transferSystemSelection(vo);
        HashSet<Long> bookIds = new HashSet<Long>();
        HashSet<Long> formalCustomerIds = new HashSet<Long>();
        this.getIdDatas(userIds, orgIds, bookIds, formalCustomerIds, vo);
        List<Map<String, Object>> employees = this.dao.queryEmployees(userIds);
        HashMap<Long, String> employeeMap = new HashMap<Long, String>();
        employees.forEach(employee -> employeeMap.put(Long.valueOf("" + employee.get("userId")), (String)employee.get("employeeName")));
        List<Map<String, Object>> orgs = this.dao.queryOrgs(orgIds);
        HashMap<Long, String> orgMap = new HashMap<Long, String>();
        orgs.forEach(org -> orgMap.put(Long.valueOf("" + org.get("id")), (String)org.get("orgName")));
        List<Map<String, Object>> books = this.dao.queryBooks(bookIds);
        HashMap<Long, String> bookMap = new HashMap<Long, String>();
        books.forEach(book -> bookMap.put(Long.valueOf("" + book.get("book_id")), (String)book.get("bookName")));
        Map<Long, List<BusinessPartnerVO>> customerMap = new HashMap<Long, List<BusinessPartnerVO>>();
        if (!CollectionUtils.isEmpty(formalCustomerIds) && !CollectionUtils.isEmpty((Collection)(businessPartnerVOS = (businessPartnerService = (BusinessPartnerService)SpringUtil.getBean(BusinessPartnerService.class)).queryListByIds(new ArrayList<Long>(formalCustomerIds))))) {
            customerMap = businessPartnerVOS.stream().collect(Collectors.groupingBy(BaseViewModel::getId));
        }
        this.transferOpportunityDatas(employeeMap, orgMap, bookMap, customerMap, vo);
        if (vo.getCreateUserId() != null) {
            PrdOrgEmployeeVO employee2;
            Long defaultOrgIdByUserId = this.cacheUtil.getDefaultOrgIdByUserId(vo.getCreateUserId());
            if (defaultOrgIdByUserId != null) {
                String orgName = this.cacheUtil.getOrgName(defaultOrgIdByUserId);
                vo.setBuName(orgName);
            }
            if ((employee2 = this.cacheUtil.getEmployee(vo.getCreateUserId())) != null) {
                vo.setGrade(employee2.getExtString1());
            }
        }
        if ((membersVOS = this.activityDAO.queryProjectMember(vo.getProjectId())).size() > 0) {
            List resIds = membersVOS.stream().map(PrjProjectMemberVO::getUserId).distinct().collect(Collectors.toList());
            TaskPackageQuery taskPackageQuery = new TaskPackageQuery();
            taskPackageQuery.setReasonType(PmsReasonTypeEnum.PROJ_BU.getCode());
            taskPackageQuery.setReasonId(vo.getProjectId());
            taskPackageQuery.setReceiverResIds(resIds);
            List taskPackageVOS = this.taskCommonService.queryTaskPackageList(taskPackageQuery);
            Map<Long, List<TaskPackageVO>> mapList = taskPackageVOS.stream().collect(Collectors.groupingBy(TaskPackageVO::getReceiverResId));
            membersVOS.forEach(membersVO -> {
                membersVO.setTaskPackageCount(Integer.valueOf(0));
                List taskPackageVOS1 = (List)mapList.get(membersVO.getUserId());
                if (!ObjectUtils.isEmpty((Object)taskPackageVOS1)) {
                    membersVO.setTaskPackageCount(Integer.valueOf(taskPackageVOS1.size()));
                }
            });
        }
        vo.setMemberVOS(membersVOS);
        this.transferMarketChannel(vo);
        if (!ObjectUtils.isEmpty((Object)vo.getDemandProductOrg())) {
            vo.setDemandProductOrgDesc(this.cacheUtil.transferSystemSelection("BU", vo.getDemandProductOrg().toString()));
        }
        if (vo.getOrgId() != null) {
            vo.setSignBuManagerUserId(this.prdOrgOrganizationService.queryManageIdById(vo.getOrgId()));
        }
        Long loginUserId = GlobalUtil.getLoginUserId();
        this.checkPersonPlanAuth(vo, loginUserId);
        return vo;
    }

    public CrmOpportunityVO queryByOppoProjId(Long key) {
        return this.dao.queryByOppoProjId(key);
    }

    @Transactional
    public Map<String, String> caculateProbability(Long key) {
        CrmOpportunityVO vo = this.dao.queryByKey(key);
        HashMap<String, String> result = new HashMap<String, String>();
        CrmOppoConversionRateVO resultVO = this.crmOppoConversionRateService.queryConfig();
        List crmOpportunityMeasureVOS = resultVO.getCrmOpportunityMeasureVOS();
        Boolean isEffective = true;
        Object probabilityHint = "";
        BigDecimal probabilityValue = BigDecimal.ZERO;
        for (CrmOpportunityMeasureVO crmOpportunityMeasureVO : crmOpportunityMeasureVOS) {
            Boolean isEffectiveCheck = false;
            BigDecimal score = BigDecimal.ZERO;
            String oppoTableField = crmOpportunityMeasureVO.getOppoTableFields();
            Object fieldValue = BeanUtil.getAllFieldValueByFieldName(oppoTableField, vo);
            if (ObjectUtils.isEmpty((Object)fieldValue)) {
                probabilityHint = (String)probabilityHint + crmOpportunityMeasureVO.getOppoTableFieldsName() + "\u4fe1\u606f\u7f3a\u5931\uff1b";
                isEffective = false;
                break;
            }
            Long dataSourceFieldsId = crmOpportunityMeasureVO.getDataSourceFieldsId();
            CrmOppoDataSourceFieldsVO crmOppoDataSourceFieldsVO = this.crmOppoConversionRateService.queryDataSourceFieldsById(dataSourceFieldsId);
            List crmOpportunityMeasureDVOS = crmOpportunityMeasureVO.getCrmOpportunityMeasureDVOS();
            if (crmOppoDataSourceFieldsVO.getType().equals("\u9009\u9879\u7c7b\u578b")) {
                for (CrmOpportunityMeasureDVO crmOpportunityMeasureDVO : crmOpportunityMeasureDVOS) {
                    if (!crmOpportunityMeasureDVO.getFieldOptionValue().equals(fieldValue)) continue;
                    score = crmOpportunityMeasureDVO.getScore();
                    isEffectiveCheck = true;
                    break;
                }
                if (!isEffectiveCheck.booleanValue()) {
                    probabilityHint = (String)probabilityHint + crmOpportunityMeasureVO.getOppoTableFieldsName() + "\u65e0\u5339\u914d\u9009\u9879\uff1b";
                }
            } else if (crmOppoDataSourceFieldsVO.getType().equals("\u6570\u503c\u7c7b\u578b")) {
                BigDecimal numericalValue = BigDecimal.ZERO;
                if (!ObjectUtils.isEmpty((Object)fieldValue)) {
                    numericalValue = new BigDecimal(fieldValue.toString());
                }
                for (CrmOpportunityMeasureDVO crmOpportunityMeasureDVO : crmOpportunityMeasureDVOS) {
                    if (crmOpportunityMeasureDVO.getNumericalValueMin().compareTo(numericalValue.divide(BigDecimal.valueOf(10000L))) >= 1 || crmOpportunityMeasureDVO.getNumericalValueMax().compareTo(numericalValue.divide(BigDecimal.valueOf(10000L))) <= -1) continue;
                    score = crmOpportunityMeasureDVO.getScore();
                    isEffectiveCheck = true;
                    break;
                }
                if (!isEffectiveCheck.booleanValue()) {
                    probabilityHint = (String)probabilityHint + crmOpportunityMeasureVO.getOppoTableFieldsName() + "\u8d85\u51fa\u4e86\u6709\u6548\u7684\u6307\u6807\u533a\u95f4\uff1b";
                }
            }
            if (!isEffectiveCheck.booleanValue()) {
                isEffective = false;
                break;
            }
            probabilityValue = probabilityValue.add(score.multiply(crmOpportunityMeasureVO.getWeights().divide(BigDecimal.valueOf(100L))));
        }
        if (!isEffective.booleanValue()) {
            result.put("data", "U");
            result.put("probabilityHint", (String)probabilityHint);
        } else {
            List scoreConfigVOS = resultVO.getScoreConfigVOS();
            for (CrmOpportunityScoreConfigVO scoreConfigVO : scoreConfigVOS) {
                if (scoreConfigVO.getScoreMin().compareTo(probabilityValue) >= 1 || scoreConfigVO.getScoreMax().compareTo(probabilityValue) <= -1) continue;
                result.put("data", scoreConfigVO.getProbabilityName());
            }
        }
        CrmOpportunityPayload opportunityPayload = new CrmOpportunityPayload();
        opportunityPayload.setId(key);
        opportunityPayload.setProbability((String)result.get("data"));
        opportunityPayload.setProbabilityHint((String)result.get("probabilityHint"));
        this.dao.updateByKeyDynamic(opportunityPayload);
        return result;
    }

    @Transactional
    public boolean changeStatus(Long key) {
        Boolean rolePermission;
        CrmActProjectVO project = this.dao.queryProjectBykey(key);
        Long loginUserId = GlobalUtil.getLoginUserId();
        PrdOrgOrganizationVO org = this.cacheUtil.getOrg(project.getOrgId());
        PrdOrgOrganizationVO preSaleOrg = this.cacheUtil.getOrg(project.getPreSaleOrgId());
        if (!(org != null && org.getManageId().longValue() == loginUserId.longValue() || preSaleOrg != null && preSaleOrg.getManageId().longValue() == loginUserId.longValue() || (rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.OPPORTUNITY_CLOSE_OPEN.getCode()))).booleanValue())) {
            throw TwException.error("", "\u65e0\u64cd\u4f5c\u5546\u673a\u72b6\u6001\u53d8\u66f4\u7684\u6743\u9650\uff01");
        }
        String status = "";
        if (project.getProjectStatus().equals(WorkFlowStatusEnum.APPROVED_WORK.getCode())) {
            status = WorkFlowStatusEnum.PENDING_WORK.getCode();
        } else if (project.getProjectStatus().equals(WorkFlowStatusEnum.PENDING_WORK.getCode())) {
            status = WorkFlowStatusEnum.APPROVED_WORK.getCode();
        } else if (project.getProjectStatus().equals(WorkFlowStatusEnum.CLOSED_WORK.getCode())) {
            status = WorkFlowStatusEnum.APPROVED_WORK.getCode();
            CrmOpportunityPayload payload = new CrmOpportunityPayload();
            payload.setNullFields(Arrays.asList("closeReason"));
            this.dao.updateProjectByKeyDynamic(payload, project.getId());
        } else {
            throw TwException.error("", "\u6d3b\u52a8\u72b6\u6001\u4e3a\u6fc0\u6d3b/\u6682\u6302/\u5173\u95ed\u624d\u53ef\u8fdb\u884c\u8be5\u64cd\u4f5c");
        }
        this.logService.saveNewLog(key, PrdSystemObjectEnum.Opportunity.getCode(), this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.SystemStatus.getCode(), status) + PrdSystemObjectEnum.Opportunity.getDesc());
        this.dao.updateStatus(project.getId(), status);
        return true;
    }

    @Transactional
    public boolean closeOpportunity(Long key, String closeReason, String loseReson, String clsoeRemark, Boolean permissionFlag) {
        CrmActProjectVO project = this.dao.queryProjectBykey(key);
        this.checkUpdate(project);
        CrmOpportunityPayload payload = new CrmOpportunityPayload();
        payload.setProjectStatus(WorkFlowStatusEnum.CLOSED_WORK.getCode());
        payload.setCloseReason(closeReason);
        payload.setLoseReason(loseReson);
        payload.setClsoeRemark(clsoeRemark);
        this.dao.updateProjectByKeyDynamic(payload, project.getId());
        this.logService.saveNewLog(key, PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.CLOSE.getDesc() + PrdSystemObjectEnum.Opportunity.getDesc());
        return true;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public List<PrjProjectMemberVO> addMember(Long key, List<Long> userIds) {
        CrmActProjectVO project = this.dao.queryProjectBykey(key);
        this.checkUpdate(project);
        List<Long> updateUserIds = this.getUserMangeIds(project);
        Long userId = GlobalUtil.getLoginUserId();
        if (!updateUserIds.contains(userId)) {
            throw TwException.error("", "\u65e0\u6dfb\u52a0\u56e2\u961f\u6210\u5458\u6743\u9650");
        }
        this.logService.saveNewLog(key, PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemObjectEnum.Opportunity.getDesc() + PrdSystemLogEnum.ADD.getDesc() + "\u56e2\u961f\u6210\u5458");
        this.addProjectMember(project.getId(), userIds);
        return this.activityDAO.queryProjectMember(project.getId());
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void deleteProjectMember(Long projectId, List<Long> userIds, Long tw4Oppid) {
        this.projectDAO.deleteMemberByUserId(projectId, userIds);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void addProjectMember(Long projectId, List<Long> userIds) {
        List<PrjProjectMemberVO> memberVOS = this.activityDAO.queryProjectMember(projectId);
        List<Long> collect = userIds.stream().filter(userId -> memberVOS.stream().noneMatch(memberVO -> memberVO.getUserId().longValue() == userId.longValue())).collect(Collectors.toList());
        List<PrdOrgEmployeeVO> employeeVOS = this.activityDAO.queryEmployee(collect);
        ArrayList<PrjProjectMemberDO> memberDOS = new ArrayList<PrjProjectMemberDO>();
        for (PrdOrgEmployeeVO employeeVO : employeeVOS) {
            PrjProjectMemberDO memberDO = new PrjProjectMemberDO();
            memberDO.setProjectId(projectId);
            memberDO.setUserId(employeeVO.getUserId());
            memberDO.setEmployeeName(employeeVO.getEmployeeName());
            memberDOS.add(memberDO);
        }
        if (memberDOS.size() > 0) {
            this.projectDAO.saveMemberAll(memberDOS);
            PrdSystemSettingVO settingVO = this.cacheUtil.getSystemSetting(SystemSettingsItemEnum.prj_member_init_task.getCode());
            if (settingVO != null && org.springframework.util.StringUtils.hasText((String)settingVO.getSettingValue()) && "true".equals(settingVO.getSettingValue())) {
                this.taskCommonService.batchCreatTaskPackage(PmsReasonTypeEnum.PROJ_OPPO.getCode(), projectId, userIds, null);
            }
        }
    }

    List<Long> getUserMangeIds(CrmActProjectVO project) {
        ArrayList<Long> updateUserIds = new ArrayList<Long>();
        List<Long> userIdsByRole = this.systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode()));
        updateUserIds.addAll(userIdsByRole);
        if (project.getManageUserId() != null) {
            updateUserIds.add(project.getManageUserId());
        }
        if (project.getCodeliUserId() != null) {
            updateUserIds.add(project.getCodeliUserId());
        }
        if (project.getCoUserId() != null) {
            updateUserIds.add(project.getCoUserId());
        }
        if (project.getDeliUserId() != null) {
            updateUserIds.add(project.getDeliUserId());
        }
        if (project.getPreSaleUserId() != null) {
            updateUserIds.add(project.getPreSaleUserId());
        }
        if (project.getCreateUserId() != null) {
            updateUserIds.add(project.getCreateUserId());
        }
        return updateUserIds;
    }

    @Transactional
    public boolean deleteMember(Long oppoId, List<Long> keys) {
        CrmActProjectVO project = this.dao.queryProjectBykey(oppoId);
        this.checkUpdate(project);
        Long userId = GlobalUtil.getLoginUserId();
        List<Long> updateUserIds = this.getUserMangeIds(project);
        if (!updateUserIds.contains(userId)) {
            throw TwException.error("", "\u65e0\u5220\u9664\u56e2\u961f\u6210\u5458\u6743\u9650");
        }
        List<Long> userMemberIds = this.projectDAO.getUserIds(keys);
        if (updateUserIds.size() > 0 && updateUserIds.contains(userMemberIds.get(0))) {
            throw TwException.error("", "\u521b\u5efa\u4eba\u6216\u8d1f\u8d23\u4eba\u4e0d\u53ef\u5220\u9664");
        }
        this.projectDAO.deleteMemberSoft(keys, updateUserIds);
        this.logService.saveNewLog(oppoId, PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemObjectEnum.Opportunity.getDesc() + PrdSystemLogEnum.DELETE.getDesc() + "\u56e2\u961f\u6210\u5458");
        return true;
    }

    public void addFollow(CrmFollowPayload payload) {
        CrmActProjectVO project = this.dao.queryProjectBykey(payload.getObjectId());
        this.checkUpdate(project);
        this.oppoFollowFileHandle(payload, project);
        payload.setFollowObject(CrmFollowObjectEnum.Opportunity.getCode());
        this.followService.addFollow(payload);
        this.logService.saveNewLog(payload.getObjectId(), PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.ADD.getDesc() + PrdSystemLogEnum.FOLLOW.getDesc());
    }

    public void updateFollow(CrmFollowPayload payload) {
        CrmActProjectVO project = this.dao.queryProjectBykey(payload.getObjectId());
        this.checkUpdate(project);
        this.oppoFollowFileHandle(payload, project);
        payload.setFollowObject(CrmFollowObjectEnum.Opportunity.getCode());
        this.followService.updateFollow(payload);
        this.logService.saveNewLog(payload.getObjectId(), PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.UPDATE.getDesc() + PrdSystemLogEnum.FOLLOW.getDesc());
    }

    public List<CrmFollowVO> queryListFollow(Long objectId) {
        return this.followService.queryFollowList(objectId, CrmFollowObjectEnum.Opportunity.name());
    }

    public PagingVO<PrdSystemLogVO> queryLogList(PrdSystemLogQuery query) {
        query.setLogObject(PrdSystemObjectEnum.Opportunity.getCode());
        return this.logService.pageLog(query);
    }

    void checkUpdate(CrmActProjectVO project) {
        if (project.getProjectStatus().equals(WorkFlowStatusEnum.PENDING_WORK.getCode())) {
            throw TwException.error("", "\u8be5\u6d3b\u52a8\u5df2\u6682\u6302");
        }
        if (project.getProjectStatus().equals(WorkFlowStatusEnum.CLOSED_WORK.getCode())) {
            throw TwException.error("", "\u6d3b\u52a8\u5df2\u5173\u95ed");
        }
    }

    private Map<String, List<Long>> getUserMangeIds(CrmOpportunityPayload payload, CrmActProjectVO project) {
        Long manageUserId = project.getManageUserId();
        Long preSaleUserId = project.getPreSaleUserId();
        Long deliUserId = project.getDeliUserId();
        Long coUserId = project.getCoUserId();
        Long codeliUserId = project.getCodeliUserId();
        List existGroupIds = Arrays.asList(manageUserId, preSaleUserId, deliUserId, coUserId, codeliUserId).stream().filter(e -> e != null).collect(Collectors.toList());
        Long manageUserIdNew = payload.getManageUserId();
        Long preSaleUserIdNew = payload.getPreSaleUserId();
        Long deliUserIdNew = payload.getDeliUserId();
        Long coUserIdNew = payload.getCoUserId();
        Long codeliUserIdNew = payload.getCodeliUserId();
        List newGroupIds = Arrays.asList(manageUserIdNew, preSaleUserIdNew, deliUserIdNew, coUserIdNew, codeliUserIdNew).stream().filter(e -> e != null).collect(Collectors.toList());
        List deleteIds = ListCompareUtil.getDeleteList(newGroupIds, existGroupIds);
        List addIds = ListCompareUtil.getInsertList(newGroupIds, existGroupIds);
        HashMap<String, List<Long>> result = new HashMap<String, List<Long>>();
        result.put("addIds", addIds);
        result.put("deleteIds", deleteIds);
        return result;
    }

    void transferOpportunityDatas(Map<Long, String> employeeMap, Map<Long, String> orgMap, Map<Long, String> bookMap, Map<Long, List<BusinessPartnerVO>> customerMap, CrmOpportunityVO vo) {
        vo.setManageUserName(employeeMap.get(vo.getManageUserId()));
        vo.setPreSaleUserName(employeeMap.get(vo.getPreSaleUserId()));
        vo.setDeliUserName(employeeMap.get(vo.getDeliUserId()));
        vo.setCoUserName(employeeMap.get(vo.getCoUserId()));
        vo.setCodeliUserName(employeeMap.get(vo.getCodeliUserId()));
        vo.setInternalUserName(employeeMap.get(vo.getInternalUserId()));
        vo.setCreateUserName(employeeMap.get(vo.getCreateUserId()));
        vo.setOrgName(orgMap.get(vo.getOrgId()));
        vo.setPreSaleOrgName(orgMap.get(vo.getPreSaleOrgId()));
        vo.setDeliOrgName(orgMap.get(vo.getDeliOrgId()));
        vo.setCoOrgName(orgMap.get(vo.getCoOrgId()));
        vo.setCodeliOrgName(orgMap.get(vo.getCodeliOrgId()));
        vo.setInternalOrgName(orgMap.get(vo.getInternalOrgId()));
        if (vo.getIsOldCust() != null && vo.getIsOldCust() == 0 && !ObjectUtils.isEmpty((Object)vo.getCustBookId())) {
            vo.setCustBookName(bookMap.get(vo.getCustBookId()));
        }
        if (vo.getIsNeedPartner() != null && vo.getIsNeedPartner() == 0 && !ObjectUtils.isEmpty((Object)vo.getCoopBookId())) {
            vo.setCoopBookName(bookMap.get(vo.getCoopBookId()));
        }
        this.transferMarketChannel(vo);
        if (!ObjectUtils.isEmpty((Object)vo.getDemandProductOrg())) {
            vo.setDemandProductOrgDesc(this.cacheUtil.transferSystemSelection("BU", vo.getDemandProductOrg().toString()));
        }
        if (vo.getFormalCustomerId() != null && customerMap.containsKey(vo.getFormalCustomerId())) {
            vo.setCustomerStatus(customerMap.get(vo.getFormalCustomerId()).get(0).getCustomerStatus());
        }
    }

    void getIdDatas(Set<Long> userIds, Set<Long> orgIds, Set<Long> bookIds, Set<Long> formalCustomerIds, CrmOpportunityVO vo) {
        HashSet<Long> users = new HashSet<Long>();
        users.add(vo.getManageUserId());
        users.add(vo.getPreSaleUserId());
        users.add(vo.getDeliUserId());
        users.add(vo.getCoUserId());
        users.add(vo.getCodeliUserId());
        users.add(vo.getInternalUserId());
        users.add(vo.getCreateUserId());
        userIds.addAll(users);
        HashSet<Long> orgs = new HashSet<Long>();
        orgs.add(vo.getOrgId());
        orgs.add(vo.getPreSaleOrgId());
        orgs.add(vo.getDeliOrgId());
        orgs.add(vo.getCoOrgId());
        orgs.add(vo.getCodeliOrgId());
        orgs.add(vo.getInternalOrgId());
        orgIds.addAll(orgs);
        HashSet<Long> books = new HashSet<Long>();
        if (vo.getIsOldCust() != null && vo.getIsOldCust() == 0 && !ObjectUtils.isEmpty((Object)vo.getCustBookId())) {
            books.add(vo.getCustBookId());
        }
        if (vo.getIsNeedPartner() != null && vo.getIsNeedPartner() == 0 && !ObjectUtils.isEmpty((Object)vo.getCoopBookId())) {
            books.add(vo.getCoopBookId());
        }
        if (!ObjectUtils.isEmpty((Object)vo.getFormalCustomerId())) {
            formalCustomerIds.add(vo.getFormalCustomerId());
        }
        bookIds.addAll(books);
    }

    void transferSystemSelection(CrmOpportunityVO vo) {
        vo.setProjectStatusName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.FlowStatus.getCode(), vo.getProjectStatus()));
        vo.setCustRegionName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustRegion.getCode(), vo.getCustRegion()));
        vo.setCustPropName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustProp.getCode(), vo.getCustProp()));
        vo.setCustIdstName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustomerIndustry.getCode(), vo.getCustIdst()));
        vo.setCurrCodeName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.SystemCurrCode.getCode(), vo.getCurrCode()));
        vo.setSalePhaseName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmSalePhase.getCode(), vo.getSalePhase()));
        vo.setOppoLevelName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmOppoLevel.getCode(), vo.getOppoLevel()));
        vo.setProjectDifficultName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmOppoDifficult.getCode(), vo.getProjectDifficult()));
        vo.setProjectImportanceName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmOppoImportance.getCode(), vo.getProjectImportance()));
        vo.setSolutionDifficultyName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmOppoDifficult.getCode(), vo.getSolutionDifficulty()));
        vo.setSolutionImportanceName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmOppoImportance.getCode(), vo.getSolutionImportance()));
        vo.setLoseReasonName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmOppoLoseReson.getCode(), vo.getLoseReason()));
        vo.setCloseReasonName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmOppoCloseReson.getCode(), vo.getCloseReason()));
    }

    private void transferMarketChannel(CrmOpportunityVO vo) {
        if (vo.getMarketChannel() != null) {
            String marketChannel = vo.getMarketChannel();
            String[] split = marketChannel.split(",");
            if (split.length < 2) {
                vo.setMarketChannelDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannel.getCode(), split[0]));
            } else {
                String s1 = this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannel.getCode(), split[0]);
                String s2 = "";
                switch (split[0]) {
                    case "baidu": {
                        s2 = this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannelBaidu.getCode(), split[1]);
                        break;
                    }
                    case "sem_360": {
                        s2 = this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannel360.getCode(), split[1]);
                        break;
                    }
                    case "offline_activity": {
                        s2 = this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannelOfflineActivity.getCode(), split[1]);
                        break;
                    }
                    case "thrid_party_data": {
                        s2 = this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannelThirdPartyData.getCode(), split[1]);
                    }
                }
                vo.setMarketChannelDesc((String)(s2.equals("") ? s1 : s1 + "/" + s2));
            }
        }
    }

    public void downloadBatch(HttpServletResponse response, CrmOpportunityQuery query) throws IOException {
        if (query.getProjectStatusType() == null) {
            query.setProjectStatusType("0");
        }
        String sheetName = "\u5546\u673a\u6570\u636e";
        PagingVO<CrmOpportunityVO> paging = this.paging(query);
        List records = paging.getRecords();
        int order = 1;
        for (CrmOpportunityVO record : records) {
            record.setOrder(String.valueOf(order));
            record.setForecastWinDateStr(String.valueOf(record.getForecastWinDate()));
            Integer isNeedPartner = record.getIsNeedPartner();
            String isNeedPartnerStr = isNeedPartner == null ? "\u5426" : (isNeedPartner == 0 ? "\u662f" : "\u5426");
            record.setIsNeedPartnerStr(isNeedPartnerStr);
            record.setSourceType(record.getSourceType() == null ? null : (record.getSourceType().equals("inside") ? "\u5185\u90e8" : "\u5916\u90e8"));
            Integer isOldCust = record.getIsOldCust();
            String isOldCustStr = isOldCust == null ? "\u5426" : (isOldCust == 0 ? "\u662f" : "\u5426");
            record.setIsOldCustStr(isOldCustStr);
            List memberVOS = record.getMemberVOS();
            if (memberVOS != null && !memberVOS.isEmpty()) {
                List collect = memberVOS.stream().map(e -> e.getEmployeeName()).collect(Collectors.toList());
                String members = String.join((CharSequence)",", collect);
                record.setMembers(members);
            }
            ++order;
        }
        List resultList = CrmOpportunityConvert.INSTANCE.voListVoExcelExport(records);
        resultList = this.udcUtil.translateList(resultList);
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
        ExcelWriterSheetBuilder sheet = ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), CrmOpportunityExcelExport.class).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet(sheetName);
        com.elitesland.tw.tw5.server.common.excel.ExcelUtil.excelHelper(sheet, CrmOpportunityExcelExport.class, null);
        sheet.doWrite(resultList);
    }

    public void permissionBatchExport(HttpServletResponse response, CrmOpportunityQuery query) throws IOException {
        if (query.getProjectStatusType() == null) {
            query.setProjectStatusType("0");
        }
        String sheetName = "\u5546\u673a\u6570\u636e";
        PagingVO<CrmOpportunityVO> paging = this.permissionPaging(query);
        List records = paging.getRecords();
        int order = 1;
        for (CrmOpportunityVO record : records) {
            record.setOrder(String.valueOf(order));
            record.setForecastWinDateStr(String.valueOf(record.getForecastWinDate()));
            if (record.getCreateTime() != null) {
                record.setCreateDateStr(record.getCreateTime().toLocalDate().toString());
            }
            ++order;
        }
        records = this.udcUtil.translateList(records);
        List<CrmOpportunityExcelExport> resultList = CrmOpportunityConvert.INSTANCE.voListVoExcelExport(records);
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
        ExcelWriterSheetBuilder sheet = ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), CrmOpportunityExcelExport.class).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet(sheetName);
        com.elitesland.tw.tw5.server.common.excel.ExcelUtil.excelHelper(sheet, CrmOpportunityExcelExport.class, null);
        sheet.doWrite(resultList);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public Map<String, Object> bindCustomer(Long id) {
        Boolean isNewCust = false;
        CrmOpportunityVO crmOpportunityVO = this.dao.queryByKey(id);
        String customerName = crmOpportunityVO.getCustBookName();
        Long custBookId = crmOpportunityVO.getCustBookId();
        Integer isOldCust = crmOpportunityVO.getIsOldCust();
        CrmOpportunityPayload opportunityPayload = new CrmOpportunityPayload();
        opportunityPayload.setId(id);
        BusinessPartnerService businessPartnerService = (BusinessPartnerService)SpringUtil.getBean(BusinessPartnerService.class);
        BusinessPartnerSimpleVO businessPartnerSimpleVO = businessPartnerService.queryByPartnerName(customerName);
        if (businessPartnerSimpleVO != null || isOldCust == 0) {
            BusinessCustomerInfoService businessCustomerInfoService = (BusinessCustomerInfoService)SpringUtil.getBean(BusinessCustomerInfoService.class);
            if (businessPartnerSimpleVO != null) {
                if (businessPartnerSimpleVO.getCustomerFlag().booleanValue()) {
                    opportunityPayload.setFormalCustomerId(businessPartnerSimpleVO.getId());
                    opportunityPayload.setCustBookName(businessPartnerSimpleVO.getPartnerName());
                } else {
                    BusinessPartnerPayload businessPartnerPayload = new BusinessPartnerPayload();
                    businessPartnerPayload.setPartnerIdentity(businessPartnerSimpleVO.getPartnerIdentity() + "," + BusinessPartnerIdentityEnum.CUSTOMER.getCode());
                    businessPartnerPayload.setId(businessPartnerSimpleVO.getId());
                    businessPartnerPayload.setCustomerFlag(Boolean.valueOf(true));
                    businessPartnerService.update(businessPartnerPayload);
                    BusinessCustomerInfoPayload businessCustomerInfoPayload = new BusinessCustomerInfoPayload();
                    businessCustomerInfoPayload.setPartnerId(businessPartnerSimpleVO.getId());
                    businessCustomerInfoPayload.setCustomerStatus(BusinessPartnerStatusEnum.CREATE.getCode());
                    businessCustomerInfoPayload.setConfirmFlag(Boolean.valueOf(false));
                    businessCustomerInfoPayload.setCustomerStage(BusinessPartnerStageEnum.POTENTIAL.getCode());
                    businessCustomerInfoService.insert(businessCustomerInfoPayload);
                    opportunityPayload.setFormalCustomerId(businessPartnerSimpleVO.getId());
                    opportunityPayload.setCustBookName(businessPartnerSimpleVO.getPartnerName());
                    isNewCust = true;
                }
            } else {
                List businessPartnerVOS = businessPartnerService.queryByBookId(custBookId);
                if (CollectionUtils.isNotEmpty((Collection)businessPartnerVOS)) {
                    BusinessPartnerVO businessPartnerVO = (BusinessPartnerVO)businessPartnerVOS.get(0);
                    if (businessPartnerVO.getCustomerFlag().booleanValue()) {
                        opportunityPayload.setFormalCustomerId(businessPartnerVO.getId());
                        opportunityPayload.setCustBookName(businessPartnerVO.getPartnerName());
                    } else {
                        BusinessPartnerPayload businessPartnerPayload = new BusinessPartnerPayload();
                        businessPartnerPayload.setPartnerIdentity(businessPartnerVO.getPartnerIdentity() + "," + BusinessPartnerIdentityEnum.CUSTOMER.getCode());
                        businessPartnerPayload.setId(businessPartnerVO.getId());
                        businessPartnerPayload.setCustomerFlag(Boolean.valueOf(true));
                        businessPartnerService.update(businessPartnerPayload);
                        BusinessCustomerInfoPayload businessCustomerInfoPayload = new BusinessCustomerInfoPayload();
                        businessCustomerInfoPayload.setPartnerId(businessPartnerVO.getId());
                        businessCustomerInfoPayload.setCustomerStatus(BusinessPartnerStatusEnum.CREATE.getCode());
                        businessCustomerInfoPayload.setConfirmFlag(Boolean.valueOf(false));
                        businessCustomerInfoPayload.setCustomerStage(BusinessPartnerStageEnum.POTENTIAL.getCode());
                        businessCustomerInfoService.insert(businessCustomerInfoPayload);
                        opportunityPayload.setFormalCustomerId(businessPartnerVO.getId());
                        opportunityPayload.setCustBookName(businessPartnerVO.getPartnerName());
                        isNewCust = true;
                    }
                } else {
                    BusinessPartnerPayload businessPartnerPayload = new BusinessPartnerPayload();
                    businessPartnerPayload.setPartnerIdentity(BusinessPartnerIdentityEnum.CUSTOMER.getCode());
                    businessPartnerPayload.setCustomerFlag(Boolean.valueOf(true));
                    businessPartnerPayload.setPartnerNature(crmOpportunityVO.getCustProp());
                    businessPartnerPayload.setPartnerName(customerName);
                    businessPartnerPayload.setPartnerType(BusinessPartnerTypeEnum.ORGANIZATION.getCode());
                    businessPartnerPayload.setPartnerIndustry(crmOpportunityVO.getCustIdst());
                    businessPartnerPayload.setContactsPhone(crmOpportunityVO.getContactPhone());
                    businessPartnerPayload.setContactsName(crmOpportunityVO.getContactName());
                    businessPartnerPayload.setContactsPosition(crmOpportunityVO.getContactPosition());
                    businessPartnerPayload.setContactsDepartment(crmOpportunityVO.getContactDept());
                    businessPartnerPayload.setInsideOrOutSide(BusinessInsideOrOutSideEnum.OUTSIDE.getCode());
                    BusinessPartnerVO businessPartnerVO = businessPartnerService.insert(businessPartnerPayload);
                    opportunityPayload.setFormalCustomerId(businessPartnerVO.getId());
                    opportunityPayload.setCustBookName(businessPartnerVO.getPartnerName());
                    isNewCust = true;
                }
            }
        } else {
            BusinessPartnerPayload businessPartnerPayload = new BusinessPartnerPayload();
            businessPartnerPayload.setPartnerIdentity(BusinessPartnerIdentityEnum.CUSTOMER.getCode());
            businessPartnerPayload.setCustomerFlag(Boolean.valueOf(true));
            businessPartnerPayload.setPartnerName(customerName);
            businessPartnerPayload.setPartnerNature(crmOpportunityVO.getCustProp());
            businessPartnerPayload.setPartnerType(BusinessPartnerTypeEnum.ORGANIZATION.getCode());
            businessPartnerPayload.setPartnerIndustry(crmOpportunityVO.getCustIdst());
            businessPartnerPayload.setContactsPhone(crmOpportunityVO.getContactPhone());
            businessPartnerPayload.setContactsName(crmOpportunityVO.getContactName());
            businessPartnerPayload.setContactsPosition(crmOpportunityVO.getContactPosition());
            businessPartnerPayload.setContactsDepartment(crmOpportunityVO.getContactDept());
            businessPartnerPayload.setInsideOrOutSide(BusinessInsideOrOutSideEnum.OUTSIDE.getCode());
            BusinessPartnerVO businessPartnerVO = businessPartnerService.insert(businessPartnerPayload);
            opportunityPayload.setCustBookId(businessPartnerVO.getBookId());
            opportunityPayload.setFormalCustomerId(businessPartnerVO.getId());
            opportunityPayload.setCustBookName(businessPartnerVO.getPartnerName());
            isNewCust = true;
        }
        if (opportunityPayload.getFormalCustomerId() != null) {
            this.dao.updateByKeyDynamic(opportunityPayload);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("isNewCust", isNewCust);
        return result;
    }

    public Map<String, Object> bindCustomers() {
        List<Long> notBindOppos = this.dao.findNotBindOppos();
        int i = 0;
        for (Long notBindOppo : notBindOppos) {
            if (++i > 1000) break;
            this.bindCustomer(notBindOppo);
        }
        List<Long> notBindOppos1 = this.dao.findNotBindOppos();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("restNum", notBindOppos1 == null ? 0 : notBindOppos1.size());
        return new HashMap<String, Object>();
    }

    public Long getIdByV4(Long oppoIdV4) {
        return this.dao.getIdByV4(oppoIdV4);
    }

    private String getItemId(String resultStr) {
        Object data = null;
        try {
            JSONObject resultJson = JSONObject.parseObject((String)resultStr);
            data = resultJson.get((Object)"data");
        }
        catch (Exception e) {
            log.error("\u6613\u9053\u58f3\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25!resultStr = {" + resultStr + "}", (Throwable)e);
        }
        if (ObjectUtils.isEmpty((Object)data)) {
            throw TwException.error("", "\u6613\u9053\u58f3\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25\uff01");
        }
        JSONArray arrayDate = JSONArray.parseArray((String)data.toString());
        String itemId = "";
        for (int i = 0; i < arrayDate.size(); ++i) {
            JSONObject jsonObject = JSONObject.parseObject((String)arrayDate.get(i).toString());
            itemId = (String)jsonObject.get((Object)"itemId");
        }
        return itemId;
    }

    @Transactional
    public void deleteSoft(Long id) {
        this.dao.deleteSoft(id);
    }

    public Map<Long, Long> getV4AndV5OppoIds() {
        HashMap<Long, Long> oppoMap = new HashMap<Long, Long>();
        List<Map<String, Object>> v4AndV5OppoIds = this.dao.getV4AndV5OppoIds();
        for (Map<String, Object> v4AndV5OppoId : v4AndV5OppoIds) {
            Long oppoId = (Long)v4AndV5OppoId.get("oppoId");
            Long oppoIdV4 = (Long)v4AndV5OppoId.get("oppoIdV4");
            oppoMap.put(oppoIdV4, oppoId);
        }
        return oppoMap;
    }

    @Transactional
    public Boolean checkIntegrity(Long oppoId) {
        Boolean flag = true;
        List crmOpportunityAnalyzeVOS = this.opportunityAnalyzeService.queryList(oppoId);
        if (CollectionUtils.isEmpty((Collection)crmOpportunityAnalyzeVOS)) {
            flag = false;
        } else {
            List crmOpportunityCompetitorVOS = this.opportunityCompetitorService.queryList(oppoId);
            if (CollectionUtils.isEmpty((Collection)crmOpportunityCompetitorVOS)) {
                flag = false;
            } else {
                List crmOpportunityStakeholderVOS = this.opportunityStakeholderService.queryList(oppoId);
                if (CollectionUtils.isEmpty((Collection)crmOpportunityStakeholderVOS)) {
                    flag = false;
                } else {
                    CrmOpportunityMilestonePlanQuery query = new CrmOpportunityMilestonePlanQuery();
                    query.setOppoId(oppoId);
                    List crmOpportunityMilestonePlanVOS = this.opportunityMilestonePlanService.queryListDynamic(query);
                    if (CollectionUtils.isEmpty((Collection)crmOpportunityMilestonePlanVOS)) {
                        flag = false;
                    }
                }
            }
        }
        this.dao.updateCheckStatus(oppoId, flag);
        return flag;
    }

    public long count(CrmOpportunityQuery query) {
        PagingVO<CrmOpportunityVO> opportunityVO = this.pagingCommon(query);
        return opportunityVO.getTotal();
    }

    public List<CrmActProjectVO> queryListByCustomId(Long customId) {
        return this.dao.queryListByCustomId(customId);
    }

    private PagingVO<CrmOpportunityVO> pagingCommon(CrmOpportunityQuery query) {
        PagingVO<CrmOpportunityVO> opportunityVO = null;
        Long userId = GlobalUtil.getLoginUserId();
        List sapPermissionOrgIdList = null;
        List<Long> orgManageIds = this.orgOrganizationDAO.queryByManageIdOrgIds(userId);
        List<Long> oppoUserIds = new ArrayList<Long>();
        List<Long> userIdsByRole = this.systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.SALE_ADMIN.getCode()));
        if (userIdsByRole != null && !userIdsByRole.isEmpty() && userIdsByRole.contains(userId)) {
            oppoUserIds = null;
        } else {
            PrdOrgEmployeeRefVO prdOrgEmployeeRefVO;
            boolean hasSapBuPermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(sapBuSystemRoleCodes));
            if (hasSapBuPermission) {
                List<String> userSystemRoleCodes = this.cacheUtil.getSystemRoleCodes(userId);
                List<String> userSapBuSystemRoleCodes = Arrays.stream(sapBuSystemRoleCodes).filter(s -> userSystemRoleCodes.contains(s)).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(userSapBuSystemRoleCodes)) {
                    sapPermissionOrgIdList = this.orgOrganizationDAO.queryByOrgCode(userSapBuSystemRoleCodes).stream().map(BaseModel::getId).collect(Collectors.toList());
                }
            }
            if ((prdOrgEmployeeRefVO = this.employeeDAO.queryUserOrgData(userId)) != null && prdOrgEmployeeRefVO.getManageId() != null && userId.equals(prdOrgEmployeeRefVO.getManageId())) {
                Long orgId = prdOrgEmployeeRefVO.getOrgId();
                List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS = this.orgOrganizationDAO.queryEmployeeList(orgId);
                oppoUserIds = prdOrgEmployeeRefVOS.stream().map(e -> e.getUserId()).collect(Collectors.toList());
            } else {
                oppoUserIds = Collections.singletonList(userId);
            }
        }
        opportunityVO = this.dao.queryPaging(query, oppoUserIds, orgManageIds, sapPermissionOrgIdList);
        return opportunityVO;
    }

    public PagingVO<CrmOpportunityVO> permissionPaging(CrmOpportunityQuery query) {
        BusinessPartnerService businessPartnerService;
        List businessPartnerVOS;
        MapBuilder mapBuilder = this.pageWhereBuilder(query).selectExclude(new FieldFns.FieldFn[]{CrmOpportunityVO::getActName, CrmOpportunityVO::getCheckStatus});
        List opportunitys = this.beanSearcher.searchList(CrmOpportunityVO.class, mapBuilder.build());
        Number totalNum = this.beanSearcher.searchCount(CrmOpportunityVO.class, mapBuilder.build());
        if (totalNum.longValue() == 0L) {
            return PagingVO.builder().records(opportunitys).total(((Long)totalNum).longValue()).build();
        }
        HashSet<Long> userIds = new HashSet<Long>();
        HashSet<Long> orgIds = new HashSet<Long>();
        HashSet<Long> bookIds = new HashSet<Long>();
        HashSet<Long> formalCustomerIds = new HashSet<Long>();
        Long loginUserId = GlobalUtil.getLoginUserId();
        for (CrmOpportunityVO vo : opportunitys) {
            this.transferSystemSelection(vo);
            this.checkPersonPlanAuth(vo, loginUserId);
            this.getIdDatas(userIds, orgIds, bookIds, formalCustomerIds, vo);
        }
        List<Map<String, Object>> employees = this.dao.queryEmployees(userIds);
        HashMap employeeMap = new HashMap();
        employees.forEach(employee -> employeeMap.put(Long.valueOf("" + employee.get("userId")), (String)employee.get("employeeName")));
        List<Map<String, Object>> orgs = this.dao.queryOrgs(orgIds);
        HashMap orgMap = new HashMap();
        orgs.forEach(org -> orgMap.put(Long.valueOf("" + org.get("id")), (String)org.get("orgName")));
        List<Map<String, Object>> books = this.dao.queryBooks(bookIds);
        HashMap bookMap = new HashMap();
        books.forEach(book -> bookMap.put(Long.valueOf("" + book.get("book_id")), (String)book.get("bookName")));
        Map<Object, Object> customerMapTmp = new HashMap();
        if (!CollectionUtils.isEmpty(formalCustomerIds) && !CollectionUtils.isEmpty((Collection)(businessPartnerVOS = (businessPartnerService = (BusinessPartnerService)SpringUtil.getBean(BusinessPartnerService.class)).queryListByIds(new ArrayList<Long>(formalCustomerIds))))) {
            customerMapTmp = businessPartnerVOS.stream().collect(Collectors.groupingBy(BaseViewModel::getId));
        }
        HashMap customerMap = customerMapTmp;
        opportunitys.forEach(opportunity -> this.transferOpportunityDatas(employeeMap, orgMap, bookMap, customerMap, (CrmOpportunityVO)opportunity));
        ArrayList<String> reasonTypes = new ArrayList<String>();
        List projectIds = opportunitys.stream().map(x -> x.getProjectId()).collect(Collectors.toList());
        for (Long projectId : projectIds) {
            reasonTypes.add(PmsReasonTypeEnum.PROJ_OPPO.getCode());
        }
        List budgetCommonVOS = this.budgetCommonService.queryBudgetEqvaAndAmts(reasonTypes, projectIds);
        Map reasonMap = budgetCommonVOS.stream().collect(Collectors.toMap(BudgetCommonVO::getReasonId, Function.identity(), (v1, v2) -> v1));
        for (CrmOpportunityVO opportunity2 : opportunitys) {
            BudgetCommonVO budgetCommonVO = (BudgetCommonVO)reasonMap.get(opportunity2.getProjectId());
            if (null == budgetCommonVO) continue;
            BigDecimal usedEqva = budgetCommonVO.getUsedEqva().add(budgetCommonVO.getOccupyEqva());
            opportunity2.setUsedEqva(usedEqva);
            BigDecimal usedAmt = budgetCommonVO.getUsedAmt().add(budgetCommonVO.getOccupyAmt());
            opportunity2.setUsedAmt(usedAmt);
        }
        return PagingVO.builder().records(opportunitys).total(((Long)totalNum).longValue()).build();
    }

    private MapBuilder pageWhereBuilder(CrmOpportunityQuery query) {
        MapBuilder builder = MapUtils.builder();
        if (!ObjectUtils.isEmpty((Object)query.getCreateTimeBetween())) {
            ((MapBuilder)builder.field(CrmOpportunityVO::getCreateTime, new Object[]{query.getCreateTimeBetween().get(0), query.getCreateTimeBetween().get(1)})).op((FieldOp)FieldOps.Between);
        }
        if (!ObjectUtils.isEmpty((Object)query.getOrgId())) {
            ((MapBuilder)builder.field(CrmOpportunityVO::getOrgId, new Object[]{query.getOrgId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getManageUserId())) {
            ((MapBuilder)builder.field(CrmOpportunityVO::getManageUserId, new Object[]{query.getManageUserId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getCreateUserId())) {
            ((MapBuilder)builder.field(CrmOpportunityVO::getCreateUserId, new Object[]{query.getCreateUserId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjectNameOrNo())) {
            String likeStr = "%" + query.getProjectNameOrNo() + "%";
            ((MapBuilder)builder.field(CrmOpportunityVO::getProjectName, new FieldFns.FieldFn[]{CrmOpportunityVO::getProjectNo})).sql("$1 like ? or $2 like ?", new Object[]{likeStr, likeStr});
        }
        if (!ObjectUtils.isEmpty((Object)query.getForecastWinDateRange())) {
            LocalDate startDate = null;
            LocalDate endDate = null;
            if ("0".equals(query.getForecastWinDateRange())) {
                endDate = LocalDate.now().plusMonths(3L);
            }
            if ("1".equals(query.getForecastWinDateRange())) {
                startDate = LocalDate.now().plusMonths(3L);
            }
            if ("2".equals(query.getForecastWinDateRange())) {
                startDate = LocalDate.now().plusMonths(6L);
            }
            if (startDate != null) {
                ((MapBuilder)builder.field(CrmOpportunityVO::getForecastWinDate, new Object[]{startDate})).op((FieldOp)FieldOps.GreaterEqual);
            }
            if (endDate != null) {
                ((MapBuilder)builder.field(CrmOpportunityVO::getForecastWinDate, new Object[]{endDate})).op((FieldOp)FieldOps.LessEqual);
            }
        }
        if (!ObjectUtils.isEmpty((Object)query.getPreSaleOrgId())) {
            ((MapBuilder)builder.field(CrmOpportunityVO::getPreSaleOrgId, new Object[]{query.getPreSaleOrgId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getPreSaleUserId())) {
            ((MapBuilder)builder.field(CrmOpportunityVO::getPreSaleUserId, new Object[]{query.getPreSaleUserId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getDeliOrgId())) {
            ((MapBuilder)builder.field(CrmOpportunityVO::getDeliOrgId, new Object[]{query.getDeliOrgId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getForecastAmountStart()) && !ObjectUtils.isEmpty((Object)query.getForecastAmountEnd())) {
            ((MapBuilder)builder.field(CrmOpportunityVO::getForecastAmount, new Object[]{query.getForecastAmountStart(), query.getForecastAmountEnd()})).op((FieldOp)FieldOps.Between);
        } else {
            if (!ObjectUtils.isEmpty((Object)query.getForecastAmountStart())) {
                ((MapBuilder)builder.field(CrmOpportunityVO::getForecastAmount, new Object[]{query.getForecastAmountStart()})).op((FieldOp)FieldOps.GreaterEqual);
            }
            if (!ObjectUtils.isEmpty((Object)query.getForecastAmountEnd())) {
                ((MapBuilder)builder.field(CrmOpportunityVO::getForecastAmount, new Object[]{query.getForecastAmountEnd()})).op((FieldOp)FieldOps.LessEqual);
            }
        }
        if (!ObjectUtils.isEmpty((Object)query.getDeliUserId())) {
            ((MapBuilder)builder.field(CrmOpportunityVO::getDeliUserId, new Object[]{query.getDeliUserId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustRegion())) {
            ((MapBuilder)builder.field(CrmOpportunityVO::getCustRegion, new Object[]{query.getCustRegion()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjectStatus())) {
            if ("0".equals(query.getProjectStatusType())) {
                ((MapBuilder)builder.field(CrmOpportunityVO::getProjectStatus, new Object[]{query.getProjectStatus()})).op((FieldOp)FieldOps.Equal);
            } else {
                ((MapBuilder)builder.field(CrmOpportunityVO::getProjectStatus, new Object[]{query.getProjectStatus()})).op((FieldOp)FieldOps.NotEqual);
            }
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustBookName())) {
            ((MapBuilder)builder.field(CrmOpportunityVO::getCustBookName, new Object[]{query.getCustBookName()})).op((FieldOp)FieldOps.Contain);
        }
        if (!ObjectUtils.isEmpty((Object)query.getOppoLevel())) {
            ((MapBuilder)builder.field(CrmOpportunityVO::getOppoLevel, new Object[]{query.getOppoLevel()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getOppoLevels())) {
            ((MapBuilder)builder.field(CrmOpportunityVO::getOppoLevel, (Collection)query.getOppoLevels())).op((FieldOp)FieldOps.InList);
        }
        if (!ObjectUtils.isEmpty((Object)query.getLeadsId())) {
            ((MapBuilder)builder.field(CrmOpportunityVO::getLeadsId, new Object[]{query.getLeadsId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getCoopBookId())) {
            ((MapBuilder)builder.field(CrmOpportunityVO::getCoopBookId, new Object[]{query.getCoopBookId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getCoopBookName())) {
            ((MapBuilder)builder.field(CrmOpportunityVO::getCoopBookName, new Object[]{query.getCoopBookName()})).op((FieldOp)FieldOps.Contain);
        }
        if (!ObjectUtils.isEmpty((Object)query.getCoOrgId())) {
            ((MapBuilder)builder.field(CrmOpportunityVO::getCoOrgId, new Object[]{query.getCoOrgId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getCodeliOrgId())) {
            ((MapBuilder)builder.field(CrmOpportunityVO::getCodeliOrgId, new Object[]{query.getCodeliOrgId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getInternalOrgId())) {
            ((MapBuilder)builder.field(CrmOpportunityVO::getInternalOrgId, new Object[]{query.getInternalOrgId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getInternalUserId())) {
            ((MapBuilder)builder.field(CrmOpportunityVO::getInternalUserId, new Object[]{query.getInternalUserId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustIdst())) {
            ((MapBuilder)builder.field(CrmOpportunityVO::getCustIdst, new Object[]{query.getCustIdst()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getFormalCustomerId())) {
            ((MapBuilder)builder.field(CrmOpportunityVO::getFormalCustomerId, new Object[]{query.getFormalCustomerId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object[])query.getOppoIds())) {
            ((MapBuilder)builder.field(CrmOpportunityVO::getId, List.of(query.getOppoIds()))).op((FieldOp)FieldOps.InList);
        }
        if (!ObjectUtils.isEmpty((Object)query.getOppoIdsV4())) {
            ((MapBuilder)builder.field(CrmOpportunityVO::getOppoIdV4, (Collection)query.getOppoIdsV4())).op((FieldOp)FieldOps.InList);
        }
        if (!ObjectUtils.isEmpty((Object)query.getSourceType())) {
            ((MapBuilder)builder.field(CrmOpportunityVO::getSourceType, new Object[]{query.getSourceType()})).op((FieldOp)FieldOps.Equal);
        }
        if (StringUtils.isNotBlank((CharSequence)query.getCheckStatus())) {
            ((MapBuilder)builder.field(CrmOpportunityVO::getCheckStatus, new Object[]{query.getCheckStatus()})).op((FieldOp)FieldOps.Equal);
        }
        if (org.springframework.util.StringUtils.hasText((String)query.getSalePhase())) {
            ((MapBuilder)builder.field(CrmOpportunityVO::getSalePhase, new Object[]{query.getSalePhase()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getSalePhases())) {
            ((MapBuilder)builder.field(CrmOpportunityVO::getSalePhase, (Collection)query.getSalePhases())).op((FieldOp)FieldOps.InList);
        }
        if (!ObjectUtils.isEmpty((Object)query.getSaleProduct())) {
            ((MapBuilder)builder.field(CrmOpportunityVO::getSaleProduct, new Object[]{query.getSaleProduct()})).op((FieldOp)FieldOps.Equal);
        }
        if (org.springframework.util.StringUtils.hasText((String)query.getPlanType())) {
            ((MapBuilder)builder.field(CrmOpportunityVO::getPlanType, new Object[]{query.getPlanType()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getPersonPlanFlag())) {
            if (query.getPersonPlanFlag().booleanValue()) {
                ((MapBuilder)builder.field(CrmOpportunityVO::getPersonPlanFlag, new FieldFns.FieldFn[0])).sql("$1 is not null");
            } else {
                ((MapBuilder)builder.field(CrmOpportunityVO::getPersonPlanFlag, new FieldFns.FieldFn[0])).sql("$1 is null");
            }
        }
        builder.put("groupBy", (Object)"pp.id");
        ((MapBuilder)builder.field(CrmOpportunityVO::getDeleteFlag, new Object[]{0})).op((FieldOp)FieldOps.Equal);
        SqlUtil.handleBS(builder, (TwQueryParam)query);
        return builder;
    }

    public PurchasePaymentDefaultVO findPaymentDefaultByDocNo(String docNo) {
        PurchasePaymentDefaultVO paymentDefaultVO = new PurchasePaymentDefaultVO();
        CrmOpportunityVO crmOpportunityVO = this.dao.queryByProjectNo(docNo);
        paymentDefaultVO.setCurrCode(crmOpportunityVO.getCurrCode());
        paymentDefaultVO.setDocId(crmOpportunityVO.getId());
        paymentDefaultVO.setDocNo(crmOpportunityVO.getProjectNo());
        paymentDefaultVO.setDocName(crmOpportunityVO.getProjectName());
        paymentDefaultVO.setDocNo(docNo);
        return paymentDefaultVO;
    }

    public List<CrmOpportunityVO> selectOpportunityListByUserBu() {
        List<Long> orgIds = this.prdUserService.queryOrgList().stream().map(PrdOrgDataRefVO::getOrgId).toList();
        return this.dao.findByOrgIdIn(orgIds);
    }

    public List<CrmOpportunityVO> findByMemberIdIdEq(Long userId) {
        if (null == userId) {
            userId = GlobalUtil.getLoginUserId();
        }
        return this.dao.findByMemberIdIdEq(userId);
    }

    public Long findOrgIdByDocNo(String docNo) {
        return this.dao.findOrgIdByDocNo(docNo);
    }

    private void checkPersonPlanAuth(CrmOpportunityVO crmOpportunityVO, Long loginUserId) {
        PrdOrgOrganizationVO org;
        Boolean personPlanAuth = false;
        Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.PLAT_ALL_PIC.getCode(), RoleEnum.PLAT_BUSINESS_PIC.getCode(), RoleEnum.PLAT_RESOURCE_DIRECTOR.getCode(), RoleEnum.SYS.getCode()));
        if (rolePermission.booleanValue()) {
            personPlanAuth = true;
        }
        if (crmOpportunityVO.getDeliOrgId() != null && (org = this.cacheUtil.getOrg(crmOpportunityVO.getDeliOrgId())) != null && loginUserId.equals(org.getManageId())) {
            personPlanAuth = true;
        }
        crmOpportunityVO.setPersonPlanAuth(personPlanAuth);
    }

    private void oppoFollowFileHandle(CrmFollowPayload payload, CrmActProjectVO project) {
        Map<String, Object> context = BeanUtil.beanToMap(project);
        String fileCodesStr = this.yeedocUtils.saveYeedocFileByFieldConfig(context, payload.getFileCodes());
        payload.setFileCodes(fileCodesStr);
    }

    public CrmOpportunityServiceImpl(CacheUtil cacheUtil, PrjProjectDAO projectDAO, CrmOpportunityDAO dao, CrmOpportunityRepo repo, CrmActActivityDAO activityDAO, PrdOrgEmployeeDAO employeeDAO, PrdOrgOrganizationDAO orgOrganizationDAO, CrmOppoConversionRateService crmOppoConversionRateService, CrmOpportunityAnalyzeService opportunityAnalyzeService, CrmOpportunityCompetitorService opportunityCompetitorService, CrmOpportunityStakeholderService opportunityStakeholderService, CrmOpportunityMilestonePlanService opportunityMilestonePlanService, BusinessPartnerService businessPartnerService, CrmFollowService followService, PrdSystemLogService logService, TransferUtilServiceImpl transferUtilService, HttpUtil httpUtil, ExcelUtil excelUtil, PrdSystemRoleDAO systemRoleDAO, YeedocService yeedocService, YeedocProperties yeedocProperties, CrmLeadsDAO leadsDAO, UdcUtil udcUtil, ChangeFieldLogUtil changeFieldLogUtil, CalResourceService calResourceService, PrdOrgOrganizationService prdOrgOrganizationService, CalAccountService calAccountService, TaskCommonService taskCommonService, YeedocUtils yeedocUtils) {
        this.cacheUtil = cacheUtil;
        this.projectDAO = projectDAO;
        this.dao = dao;
        this.repo = repo;
        this.activityDAO = activityDAO;
        this.employeeDAO = employeeDAO;
        this.orgOrganizationDAO = orgOrganizationDAO;
        this.crmOppoConversionRateService = crmOppoConversionRateService;
        this.opportunityAnalyzeService = opportunityAnalyzeService;
        this.opportunityCompetitorService = opportunityCompetitorService;
        this.opportunityStakeholderService = opportunityStakeholderService;
        this.opportunityMilestonePlanService = opportunityMilestonePlanService;
        this.businessPartnerService = businessPartnerService;
        this.followService = followService;
        this.logService = logService;
        this.transferUtilService = transferUtilService;
        this.httpUtil = httpUtil;
        this.excelUtil = excelUtil;
        this.systemRoleDAO = systemRoleDAO;
        this.yeedocService = yeedocService;
        this.yeedocProperties = yeedocProperties;
        this.leadsDAO = leadsDAO;
        this.udcUtil = udcUtil;
        this.changeFieldLogUtil = changeFieldLogUtil;
        this.calResourceService = calResourceService;
        this.prdOrgOrganizationService = prdOrgOrganizationService;
        this.calAccountService = calAccountService;
        this.taskCommonService = taskCommonService;
        this.yeedocUtils = yeedocUtils;
    }
}

