/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.humanresources.base;

import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdBaseBuChangePayload;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdBaseBuChangeService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdBaseBuChangeVO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/workflow/BASE_TEMP/callBack"})
@Transactional
public class PrdBaseTempCallback
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(PrdBaseTempCallback.class);
    public final PrdBaseBuChangeService prdBaseBuChangeService;

    @PostMapping(value={"/taskAssignee"})
    public WorkflowResult<ArrayList<String>> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("\u52a8\u6001\u6307\u5b9a\u4efb\u52a1\u8d1f\u8d23\u4eba\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCreated"})
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCompleted"})
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/processStatusChange"})
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        String businessKey = payload.getBusinessKey();
        if (StringUtils.isBlank((CharSequence)businessKey)) {
            throw new BusinessException("\u83b7\u53d6\u7684businessKey\u4e3a\u7a7a");
        }
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        Long id = Long.valueOf(businessKey);
        PrdBaseBuChangeVO prdBaseBuChangeVO = this.prdBaseBuChangeService.get(id);
        PrdBaseBuChangePayload prdBaseBuChangePayload = new PrdBaseBuChangePayload();
        prdBaseBuChangePayload.setId(id);
        if (prdBaseBuChangeVO != null) {
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    prdBaseBuChangePayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    break;
                }
                case INTERRUPT: 
                case INVALID: {
                    prdBaseBuChangePayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                    break;
                }
                case REJECTED: {
                    prdBaseBuChangePayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    break;
                }
                case APPROVED: {
                    prdBaseBuChangePayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    prdBaseBuChangePayload.setApprovedTime(LocalDateTime.now());
                    break;
                }
                case APPROVING: {
                    prdBaseBuChangePayload.setProcInstStatus(ProcInstStatus.APPROVING);
                }
            }
            this.prdBaseBuChangeService.updateByCondition(prdBaseBuChangePayload);
        }
        return WorkflowResult.success(null);
    }

    public PrdBaseTempCallback(PrdBaseBuChangeService prdBaseBuChangeService) {
        this.prdBaseBuChangeService = prdBaseBuChangeService;
    }
}

