/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.humanresources.resource.service;

import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.query.ResourcePlanQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.ResourcePlanQueryService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PlanItemVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.ResourcePlanQueryVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.TaskItemVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.WorkPlanVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.WorkingCalendarPlanVO;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetPlanQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TimesheetPlanService;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetPlanVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.personplan.query.PersonPlanDtlQuery;
import com.elitesland.tw.tw5.api.prd.personplan.query.PersonPlanQuery;
import com.elitesland.tw.tw5.api.prd.personplan.service.PersonPlanDtlService;
import com.elitesland.tw.tw5.api.prd.personplan.service.PersonPlanService;
import com.elitesland.tw.tw5.api.prd.personplan.vo.DayJsonVO;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PersonPlanDtlVO;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PersonPlanVO;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsResourcePlanRoleService;
import com.elitesland.tw.tw5.api.prd.task.query.TaskInfoQuery;
import com.elitesland.tw.tw5.api.prd.task.service.TaskInfoService;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskInfoVO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.dao.ResourcePlanQueryDAO;
import com.elitesland.tw.tw5.server.prd.my.repo.VacationRepo;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgPersonDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgPersonDO;
import com.elitesland.tw.tw5.server.prd.personplan.constants.PersonPlanTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.StateFlowStateEnum;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class ResourcePlanQueryServiceImpl
implements ResourcePlanQueryService {
    private static final Logger log = LoggerFactory.getLogger(ResourcePlanQueryServiceImpl.class);
    private final PmsResourcePlanRoleService resourcePlanRoleService;
    private final TimesheetPlanService timesheetPlanService;
    private final ResourcePlanQueryDAO resourcePlanQueryDAO;
    private final CacheUtil cacheUtil;
    private final TaskInfoService taskInfoService;
    private final PrdOrgPersonDAO prdOrgPersonDAO;
    private final PrdOrgEmployeeDAO employeeDAO;
    private final PersonPlanDtlService personPlanDtlService;
    private final PersonPlanService personPlanService;
    private final VacationRepo vacationRepo;

    public PagingVO<ResourcePlanQueryVO> query(ResourcePlanQuery query) {
        ArrayList<ResourcePlanQueryVO> resourcePlanQueryVOList = new ArrayList<ResourcePlanQueryVO>();
        long resCount = 0L;
        PagingVO<PrdOrgEmployeeVO> resPage = this.resourcePlanQueryDAO.listResIds(query);
        resCount = resPage.getTotal();
        List<Object> workDays = new ArrayList();
        if (query.getPlanStartDate() != null && query.getPlanEndDate() != null) {
            workDays = this.vacationRepo.selectWorkDaysByDays(query.getPlanStartDate(), query.getPlanEndDate());
        }
        List resList = resPage.getRecords();
        for (PrdOrgEmployeeVO res : resList) {
            HashSet<LocalDate> dateSet = new HashSet<LocalDate>();
            Long resId = res.getUserId();
            Long orgId = res.getOrgId();
            ResourcePlanQueryVO resourcePlanQueryVO = new ResourcePlanQueryVO();
            PrdOrgEmployeeVO employeeVO = this.cacheUtil.getEmployee(resId);
            PrdOrgPersonDO prdOrgPersonDO = this.employeeDAO.queryPersonById(employeeVO.getPersonId());
            String orgName = this.cacheUtil.getOrgName(orgId);
            resourcePlanQueryVO.setEmployeeName(prdOrgPersonDO.getPersonName());
            resourcePlanQueryVO.setRoleName(employeeVO.getRoleName());
            resourcePlanQueryVO.setUserId(employeeVO.getUserId());
            resourcePlanQueryVO.setOrgName(orgName);
            LocalDate planStartDate = query.getPlanStartDate();
            LocalDate planEndDate = query.getPlanEndDate();
            List<String> yearWeekList = ResourcePlanQueryServiceImpl.getWeeks(planStartDate, planEndDate);
            ArrayList<WorkingCalendarPlanVO> workingCalendarPlanVOList = new ArrayList<WorkingCalendarPlanVO>();
            List taskInfoVOList = new ArrayList();
            if (query.getShowItems() != null && query.getShowItems().contains("tasks")) {
                TaskInfoQuery taskInfoQuery = new TaskInfoQuery();
                if (query.getProjectId() != null) {
                    taskInfoQuery.setReasonId(query.getProjectId());
                    taskInfoQuery.setReasonType(PmsReasonTypeEnum.PROJ_CONTRACT.getCode());
                }
                taskInfoQuery.setTaskResId(resId);
                taskInfoVOList = this.taskInfoService.queryList(taskInfoQuery);
            }
            List pmsResourcePlanRoleVOList = new ArrayList();
            if (query.getShowItems() != null && query.getShowItems().contains("projectResPlans")) {
                PersonPlanDtlQuery planRoleQuery = new PersonPlanDtlQuery();
                planRoleQuery.setResId(resId);
                pmsResourcePlanRoleVOList = this.personPlanDtlService.getList(planRoleQuery);
            }
            List timesheetPlanVOList = new ArrayList();
            if (query.getShowItems() != null && query.getShowItems().contains("workPlans")) {
                TimesheetPlanQuery timesheetPlanQuery = new TimesheetPlanQuery();
                timesheetPlanQuery.setTsUserId(resId);
                timesheetPlanVOList = this.timesheetPlanService.queryList(timesheetPlanQuery);
            }
            for (String yearWeek : yearWeekList) {
                WorkingCalendarPlanVO workingCalendarPlanVO = new WorkingCalendarPlanVO();
                LocalDate[] weekStartEndList = ResourcePlanQueryServiceImpl.getWeekStartEndDate(yearWeek);
                workingCalendarPlanVO.setYearWeek(yearWeek);
                LocalDate weekStartDate = weekStartEndList[0];
                LocalDate weekEndDate = weekStartEndList[1];
                ArrayList<TaskItemVO> taskItemVOList = new ArrayList<TaskItemVO>();
                ArrayList<WorkPlanVO> workPlanVOList = new ArrayList<WorkPlanVO>();
                ArrayList planItemVOList = new ArrayList();
                ArrayList planOppoViews = new ArrayList();
                if (!ObjectUtils.isEmpty(timesheetPlanVOList)) {
                    List collect = timesheetPlanVOList.stream().filter(v -> !v.getWorkDate().isBefore(weekStartDate) && !v.getWorkDate().isAfter(weekEndDate)).collect(Collectors.toList());
                    for (TimesheetPlanVO timesheetPlanVO : collect) {
                        WorkPlanVO workPlanVO = new WorkPlanVO();
                        workPlanVO.setDateFrom(timesheetPlanVO.getWorkDate());
                        workPlanVO.setDateTo(timesheetPlanVO.getWorkDate());
                        workPlanVO.setPlanType(timesheetPlanVO.getType());
                        workPlanVO.setTaskName(timesheetPlanVO.getTaskName());
                        workPlanVO.setId(timesheetPlanVO.getId());
                        workPlanVO.setPlanStatus(timesheetPlanVO.getApprStatus());
                        workPlanVOList.add(workPlanVO);
                    }
                }
                if (!ObjectUtils.isEmpty(pmsResourcePlanRoleVOList)) {
                    List planIds = pmsResourcePlanRoleVOList.stream().map(PersonPlanDtlVO::getPlanId).distinct().collect(Collectors.toList());
                    PersonPlanQuery personPlanQuery = new PersonPlanQuery();
                    personPlanQuery.setIds(planIds);
                    List list = this.personPlanService.getList(personPlanQuery);
                    pmsResourcePlanRoleVOList.forEach(vo -> {
                        Optional<PersonPlanVO> personPlan = personPlanList.stream().filter(plan -> plan.getId().equals(vo.getPlanId())).findFirst();
                        if (personPlan.isPresent()) {
                            PlanItemVO planItemVO = new PlanItemVO();
                            String planType = personPlan.get().getPlanType();
                            if (StringUtils.hasText((String)planType) && (planType.equals(PersonPlanTypeEnum.PRE_SALES.getCode()) || planType.equals(PersonPlanTypeEnum.DELIVERY.getCode()))) {
                                planOppoViews.add(planItemVO);
                            } else {
                                planItemVOList.add(planItemVO);
                            }
                            planItemVO.setProjName(personPlan.get().getObjName());
                            planItemVO.setProjdays(BigDecimal.ZERO);
                            ArrayList<LocalDate> planDays = new ArrayList<LocalDate>();
                            if (StringUtils.hasText((String)vo.getDaysJson())) {
                                List dayJsonVOS = JSON.parseArray((String)vo.getDaysJson(), DayJsonVO.class);
                                for (DayJsonVO dayJsonVO : dayJsonVOS) {
                                    LocalDate date = LocalDate.parse(dayJsonVO.getDate(), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                                    if (date.isBefore(weekStartDate) || date.isAfter(weekEndDate)) continue;
                                    planDays.add(date);
                                    planItemVO.setProjdays(planItemVO.getProjdays().add(dayJsonVO.getDay()));
                                }
                            }
                            planItemVO.setPlanDays(planDays);
                            if (!ObjectUtils.isEmpty(planDays)) {
                                LocalDate min = (LocalDate)Collections.min(planDays);
                                LocalDate max = (LocalDate)Collections.max(planDays);
                                planItemVO.setPlanStartDate(min);
                                planItemVO.setPlanEndDate(max);
                            }
                        }
                    });
                }
                if (!ObjectUtils.isEmpty(taskInfoVOList)) {
                    for (TaskInfoVO taskInfoVO : taskInfoVOList) {
                        LocalDate overlapEnd;
                        LocalDate localDate;
                        if (taskInfoVO.getPlanStartDate() == null || taskInfoVO.getPlanEndDate() == null || taskInfoVO.getPlanEndDate().isBefore(weekStartDate) || taskInfoVO.getPlanStartDate().isAfter(weekEndDate) || (localDate = weekStartDate.isAfter(taskInfoVO.getPlanStartDate()) ? weekStartDate : taskInfoVO.getPlanStartDate()).isAfter(overlapEnd = weekEndDate.isBefore(taskInfoVO.getPlanEndDate()) ? weekEndDate : taskInfoVO.getPlanEndDate())) continue;
                        TaskItemVO taskItemVO = new TaskItemVO();
                        if (taskInfoVO.getState().intValue() != StateFlowStateEnum.THREE.getCode() && taskInfoVO.getCompletedDate() != null && taskInfoVO.getCompletedDate().compareTo(taskInfoVO.getPlanEndDate()) <= 1) {
                            taskItemVO.setOverDueFlag("\u5426");
                        } else {
                            taskItemVO.setOverDueFlag("\u662f");
                        }
                        taskItemVO.setTaskName(taskInfoVO.getTaskName());
                        taskItemVO.setPlanStartDate(localDate);
                        taskItemVO.setPlanEndDate(overlapEnd);
                        taskItemVO.setTaskState(taskInfoVO.getState());
                        ArrayList<LocalDate> dateList = new ArrayList<LocalDate>();
                        LocalDate currentDate = localDate;
                        while (!currentDate.isAfter(overlapEnd)) {
                            dateList.add(currentDate);
                            currentDate = currentDate.plusDays(1L);
                            dateSet.add(currentDate);
                        }
                        taskItemVO.setPlanDays(dateList);
                        taskItemVOList.add(taskItemVO);
                    }
                    if (!CollectionUtils.isEmpty(dateSet) && !CollectionUtils.isEmpty(workDays)) {
                        int projectWorkDays = 0;
                        for (LocalDate localDate : workDays) {
                            if (!dateSet.contains(localDate)) continue;
                            ++projectWorkDays;
                        }
                        resourcePlanQueryVO.setWorkDays(Integer.valueOf(workDays.size()));
                        resourcePlanQueryVO.setProjectWorkDays(Integer.valueOf(projectWorkDays));
                        resourcePlanQueryVO.setSaturation(BigDecimal.valueOf(projectWorkDays).multiply(BigDecimal.valueOf(100L)).divide(BigDecimal.valueOf(workDays.size()), 1, RoundingMode.HALF_UP));
                    }
                }
                workingCalendarPlanVO.setPlanViews(workPlanVOList);
                workingCalendarPlanVO.setPlanItemVies(planItemVOList);
                workingCalendarPlanVO.setTaskViews(taskItemVOList);
                workingCalendarPlanVO.setPlanOppoVies(planOppoViews);
                workingCalendarPlanVOList.add(workingCalendarPlanVO);
            }
            resourcePlanQueryVO.setWorkingCalendarPlan(workingCalendarPlanVOList);
            resourcePlanQueryVOList.add(resourcePlanQueryVO);
        }
        return PagingVO.builder().records(resourcePlanQueryVOList).total(resCount).build();
    }

    public static List<String> getWeeks(LocalDate startDate, LocalDate endDate) {
        if (startDate == null || endDate == null || startDate.isAfter(endDate)) {
            return null;
        }
        ArrayList<String> weeks = new ArrayList<String>();
        LocalDate mondayS = startDate.with(DayOfWeek.MONDAY);
        LocalDate mondayE = endDate.with(DayOfWeek.MONDAY);
        String week = ResourcePlanQueryServiceImpl.dateToYearWeek(mondayS);
        weeks.add(week);
        while (!mondayS.isEqual(mondayE)) {
            mondayS = mondayS.plusWeeks(1L);
            week = ResourcePlanQueryServiceImpl.dateToYearWeek(mondayS);
            weeks.add(week);
        }
        return weeks;
    }

    public static String dateToYearWeek(LocalDate date) {
        if (date == null) {
            return "";
        }
        int weekBaseYear = date.get(WeekFields.ISO.weekBasedYear());
        int weeks = date.get(WeekFields.ISO.weekOfWeekBasedYear());
        String week = weeks < 10 ? "0" + weeks : "" + weeks;
        return weekBaseYear + week;
    }

    public static LocalDate[] getWeekStartEndDate(String yearWeek) {
        if (yearWeek == null || yearWeek.length() != 6) {
            log.info("\u53c2\u6570\u53c2\u6570\u975e\u6cd5\uff0c\u9700\u8981yyyyww\u683c\u5f0f\u7684\u6570\u636e\uff01\u975e\u6cd5\u53c2\u6570\uff1a{}", (Object)yearWeek);
            return null;
        }
        int year = -1;
        int week = -1;
        try {
            year = Integer.parseInt(yearWeek.substring(0, 4));
            week = Integer.parseInt(yearWeek.substring(4, 6));
        }
        catch (NumberFormatException e) {
            log.info("\u5b57\u7b26\u4e32\u8f6c\u6362\u6570\u636e\u9519\u8bef\uff1a{}", (Throwable)e);
            return null;
        }
        int max = LocalDate.of(year, 12, 31).get(WeekFields.ISO.weekOfWeekBasedYear());
        if (max == 1) {
            max = LocalDate.of(year, 12, 31).minusWeeks(1L).get(WeekFields.ISO.weekOfWeekBasedYear());
        }
        if (week > max) {
            log.info(String.format("\u67e5\u8be2\u6307\u5b9a\u5468\u6570\u7684\u65e5\u671f\u5931\u8d25\uff0c\u67e5\u8be2\u5468\u6570(%d)\u8d85\u8fc7\u6307\u5b9a\u5e74\u4efd(%d\u5e74)\u7684\u6700\u5927\u5468\u6570(%d)", week, year, max));
        }
        LocalDate monday = null;
        LocalDate sunday = null;
        LocalDate firstDayOfYear = LocalDate.of(year, 1, 1);
        LocalDate firstMonday = firstDayOfYear.with(DayOfWeek.MONDAY);
        LocalDate firstSunday = firstDayOfYear.with(DayOfWeek.SUNDAY);
        int firstDayWeek = firstDayOfYear.get(WeekFields.ISO.weekOfWeekBasedYear());
        if (firstDayWeek > 1) {
            monday = firstMonday.plusWeeks(week);
            sunday = firstSunday.plusWeeks(week);
        } else {
            monday = firstMonday.plusWeeks(week - 1);
            sunday = firstSunday.plusWeeks(week - 1);
        }
        return new LocalDate[]{monday, sunday};
    }

    public ResourcePlanQueryServiceImpl(PmsResourcePlanRoleService resourcePlanRoleService, TimesheetPlanService timesheetPlanService, ResourcePlanQueryDAO resourcePlanQueryDAO, CacheUtil cacheUtil, TaskInfoService taskInfoService, PrdOrgPersonDAO prdOrgPersonDAO, PrdOrgEmployeeDAO employeeDAO, PersonPlanDtlService personPlanDtlService, PersonPlanService personPlanService, VacationRepo vacationRepo) {
        this.resourcePlanRoleService = resourcePlanRoleService;
        this.timesheetPlanService = timesheetPlanService;
        this.resourcePlanQueryDAO = resourcePlanQueryDAO;
        this.cacheUtil = cacheUtil;
        this.taskInfoService = taskInfoService;
        this.prdOrgPersonDAO = prdOrgPersonDAO;
        this.employeeDAO = employeeDAO;
        this.personPlanDtlService = personPlanDtlService;
        this.personPlanService = personPlanService;
        this.vacationRepo = vacationRepo;
    }
}

